/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.server.messagecustomer;

import kd.bos.context.OperationContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.schedule.api.ErrorJobInfo;
import kd.bos.schedule.api.JobDao;
import kd.bos.schedule.api.JobDispatcher;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.server.JobDispatcherProxy;
import kd.bos.schedule.server.ScheduleService;
import kd.bos.schedule.utils.ErrorProcessUtils;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class AsynJobMessageDispatcher
implements MessageConsumer {
    private static final Log log = LogFactory.getLog(AsynJobMessageDispatcher.class);
    private JobDispatcher jobDispatcher = new JobDispatcherProxy();
    private static AsynJobMessageDispatcher INS = new AsynJobMessageDispatcher();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object body, String messageId, boolean resend, MessageAcker acker) {
        JobInfo jobInfo = null;
        Exception throwable = null;
        try {
            jobInfo = (JobInfo)SerializationUtils.fromJsonString((String)((String)body), JobInfo.class);
        }
        catch (Exception e) {
            log.error("Schedule***\u629b\u5f03-\u5f02\u5e38\u683c\u5f0f-\u6d88\u606f \uff1a" + body, (Throwable)e);
            acker.discard(messageId);
            return;
        }
        try (TraceSpan tracer = Tracer.create((String)"schedule", (String)"AsynJobMessageDispatcher");){
            OperationContext oc = new OperationContext();
            oc.setAppId(jobInfo.getAppId());
            oc.setFormId(jobInfo.getNumber());
            oc.setFormName(jobInfo.getTaskClassname());
            OperationContext.set((OperationContext)oc);
            this.jobDispatcher.dispatch(jobInfo);
            log.info("Schedule***jobClient-\u5f02\u6b65\u5206\u53d1\u4f5c\u4e1a-task:{},jobNumber={}", (Object)jobInfo.getTaskId(), (Object)jobInfo.getNumber());
        }
        catch (Exception e) {
            log.error("Schedule***jobClient-\u5f02\u6b65\u5206\u53d1\u4f5c\u4e1a-\u5931\u8d25:" + body, (Throwable)e);
            throwable = e;
        }
        if (throwable == null) {
            acker.ack(messageId);
        } else {
            boolean isRetryAgain = false;
            try {
                int retryTime = ErrorProcessUtils.getJobInfoRetryTime((JobInfo)jobInfo);
                boolean bl = isRetryAgain = retryTime <= ZkConfig.getJobFailRetryTime();
                if (isRetryAgain) {
                    ErrorProcessUtils.updateFailRetryTime((JobInfo)jobInfo, (int)retryTime);
                } else {
                    ErrorJobInfo errorJobInfo = ErrorProcessUtils.buildErrorJobInfo((JobInfo)jobInfo, (Throwable)throwable);
                    JobDao jobDao = ScheduleService.getInstance().getObjectFactory().getJobDao();
                    jobDao.writeErrorJobInfo(errorJobInfo);
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
            finally {
                if (isRetryAgain) {
                    acker.deny(messageId);
                } else {
                    acker.discard(messageId);
                }
            }
        }
    }

    public static void onMessage(String body) {
        INS.onMessage(body, null, false, new FakeMessageAcker(body));
    }

    static class FakeMessageAcker
    implements MessageAcker {
        private final String body;

        public FakeMessageAcker(String body) {
            this.body = body;
        }

        public void ack(String s) {
        }

        public void deny(String s) {
            log.warn("schedule***deny,body is {}", (Object)this.body);
        }

        public void discard(String s) {
            log.warn("schedule***discard,body is {}", (Object)this.body);
        }
    }
}

