/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.server.messagecustomer;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.ScheduleInfo;
import kd.bos.schedule.api.ScheduleTypeNextEnums;
import kd.bos.schedule.api.TaskResult;
import kd.bos.schedule.api.TaskStatusConstant;
import kd.bos.schedule.server.ExecutorResourceManager;
import kd.bos.schedule.server.ExecutorServerStatistic;
import kd.bos.schedule.server.ScheduleService;

public class TaskStatusMessageCustomer
implements MessageConsumer {
    private static final Log log = LogFactory.getLog(TaskStatusMessageCustomer.class);
    private static TaskStatusMessageCustomer INS = new TaskStatusMessageCustomer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object body, String messageId, boolean resend, MessageAcker acker) {
        try {
            MessageInfo info = (MessageInfo)SerializationUtils.fromJsonString((String)((String)body), MessageInfo.class);
            this.processDelayOrDectectTask(info);
            if (log.isDebugEnabled()) {
                log.debug("Schedule***delay or detect-task:{}", (Object)info);
            }
        }
        catch (Exception e) {
            log.error("Schedule***\u6d88\u606f\u5904\u7406\u5931\u8d25,\u6b64\u901a\u9053\u5df2\u7ecf\u4e0d\u5728\u5904\u7406\u72b6\u6001\u6539\u53d8\u6d88\u606f,\u53ea\u505a\u5ef6\u65f6\u4efb\u52a1\u6216\u8005\u63a2\u6d4b\u4efb\u52a1\u5904\u7406", (Throwable)e);
        }
        finally {
            if (acker != null) {
                acker.ack(messageId);
            }
        }
    }

    protected void createContext(ScheduleInfo message) {
        RequestContext rc = RequestContext.create((boolean)true);
        rc.setClient("batch");
        rc.setRequestId(UUID.randomUUID().toString());
        rc.setTenantId(message.getTenantId());
        rc.setAccountId(message.getAccountId());
    }

    public void processDelayOrDectectTask(MessageInfo message) {
        this.createContext(message);
        this.delayOrDectectTaskHandle(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delayOrDectectTaskHandle(MessageInfo message) {
        JobInfo job = message.fetchJobInfo();
        ScheduleInfo scheduleInfo = new ScheduleInfo();
        switch (job.getJobType()) {
            case DETECT: {
                ZonedDateTime peekTime = ZonedDateTime.now();
                scheduleInfo.getPointOfTime().add(peekTime.plusSeconds(5L));
                scheduleInfo.setScheduleType(ScheduleTypeNextEnums.Detect);
                scheduleInfo.setJobInfo(job);
                scheduleInfo.setJobId(job.getId());
                scheduleInfo.setTenantId(message.getTenantId());
                scheduleInfo.setAccountId(message.getAccountId());
                scheduleInfo.setId(job.getScheduleId());
                break;
            }
            case DELAY: {
                scheduleInfo.setScheduleType(ScheduleTypeNextEnums.Delay);
                scheduleInfo.setJobInfo(job);
            }
        }
        ConcurrentHashMap<String, Map<String, List<ScheduleInfo>>> triggerSchedule = ScheduleService.getInstance().getTrigger().getSchedules();
        Map<String, List<ScheduleInfo>> target = triggerSchedule.get(scheduleInfo.getScheduleType().name());
        if (target == null) {
            ConcurrentHashMap<String, Map<String, List<ScheduleInfo>>> concurrentHashMap = triggerSchedule;
            synchronized (concurrentHashMap) {
                target = triggerSchedule.get(scheduleInfo.getScheduleType().name());
                if (target == null) {
                    target = new HashMap<String, List<ScheduleInfo>>(8);
                    ArrayList list = new ArrayList();
                    target.put("cron", list);
                    triggerSchedule.put(scheduleInfo.getScheduleType().name(), target);
                }
            }
        }
        target.get("cron").add(scheduleInfo);
    }

    protected void createContext(MessageInfo message) {
        RequestContext rc = RequestContext.create((boolean)true);
        rc.setClient("batch");
        rc.setRequestId(UUID.randomUUID().toString());
        rc.setTenantId(message.getTenantId());
        rc.setAccountId(message.getAccountId());
    }

    public static boolean isScheduleService() {
        return ScheduleService.getInstance() != null && ScheduleService.getInstance().isStarted();
    }

    public void processTaskStatus(MessageInfo message) {
        this.createContext(message);
        this.statistical(message);
    }

    public void statistical(MessageInfo message) {
        if ("TASK_STATUS".equals(message.getTitle())) {
            TaskResult taskResult = message.fectchTaskResult();
            String status = taskResult.getStatus();
            ExecutorServerStatistic exeServerInfo = ScheduleService.getInstance().getExecutorResourceManager().getInfoByName(message.getTarget());
            if (exeServerInfo == null) {
                log.error("Schedule***\u8c03\u5ea6\u76d1\u63a7\u7edf\u8ba1\u672a\u627e\u5230\u5bf9\u5e94\u8282\u70b9\u3002serverName\uff1a" + message.getTarget());
                try {
                    ExecutorResourceManager.getInstance().initServerList();
                }
                catch (Throwable t) {
                    log.error(t);
                }
                return;
            }
            if (status.equals("BEGIN")) {
                exeServerInfo.decrScheduled();
                exeServerInfo.incrRunning();
            }
            if (TaskStatusConstant.isEnd((String)status)) {
                exeServerInfo.decrRunning();
                if (status.equals("ABORTED")) {
                    exeServerInfo.incrAborted();
                } else if (status.equals("COMPLETED")) {
                    exeServerInfo.incrCompleted();
                } else if (status.equals("FAILED")) {
                    exeServerInfo.incrFailed();
                }
            }
            if (exeServerInfo != null) {
                exeServerInfo.writeZk();
            }
        }
    }

    public static void onMessage(String body) {
        INS.onMessage(body, null, false, null);
    }
}

