/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.server.next;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.next.observable.model.TimerPulse;
import kd.bos.schedule.server.ScheduleJobDispatchWorker;
import kd.bos.schedule.server.schedulecreator.ScheduleVisitor;
import kd.bos.threads.ThreadPools;

public class ScheduleJobNextDispatchManager {
    private static final Log logger = LogFactory.getLog(ScheduleJobNextDispatchManager.class);
    private ScheduleVisitor scheduleVisitor;
    private static ExecutorService executor = null;

    public ScheduleJobNextDispatchManager(ScheduleVisitor scheduleVisitor) {
        this.scheduleVisitor = scheduleVisitor;
        int size = Integer.getInteger("schedule.server.queue.size", 1);
        if (executor == null) {
            executor = ThreadPools.newCachedExecutorService((String)"BOSSchedule-Dispatch-Pool", (int)size, (int)size);
        }
    }

    public void start() {
        int size = Integer.getInteger("schedule.server.queue.size", 1);
        for (int i = 0; i < size; ++i) {
            executor.submit(new ScheduleJobDispatchWorker(this.scheduleVisitor.getServerQueues().get(i), i + ""));
            logger.info("Schedule***\u670d\u52a1\u7aef\u53d1\u9001\u7ebf\u7a0b\u542f\u52a8" + i);
        }
    }

    public void stop() {
        if (executor != null) {
            int size = Integer.getInteger("schedule.server.queue.size", 1);
            for (int i = 0; i < size; ++i) {
                LinkedBlockingQueue queue = this.scheduleVisitor.getServerQueues().get(i);
                try {
                    queue.put(TimerPulse.getInsStop());
                    continue;
                }
                catch (InterruptedException e) {
                    logger.error((Throwable)e);
                }
            }
            logger.error("zk\u91cd\u65b0\u9009\u4e3e\u89e6\u53d1\u4e86\u7ebf\u7a0b\u6c60\u5173\u95ed");
        }
    }
}

