/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.server.next;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextThreadBinder;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dc.api.model.Account;
import kd.bos.instance.Instance;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.JobDao;
import kd.bos.schedule.api.JobDispatcher;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.RouteMode;
import kd.bos.schedule.api.ScheduleDao;
import kd.bos.schedule.api.ScheduleInfo;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.ScheduleMsgInfo;
import kd.bos.schedule.api.ScheduleTypeNextEnums;
import kd.bos.schedule.dao.dbImpl.DbJobOperation;
import kd.bos.schedule.message.AbstractService;
import kd.bos.schedule.next.observable.ObservableLogHandler;
import kd.bos.schedule.next.observable.model.ObservableModel;
import kd.bos.schedule.next.observable.model.TimerPulse;
import kd.bos.schedule.next.observable.util.SchObservableCollectData;
import kd.bos.schedule.server.JobDispatcherProxy;
import kd.bos.schedule.server.ScheduleService;
import kd.bos.schedule.server.next.IScheduleMonitorAspect;
import kd.bos.schedule.server.next.TimeNextUtils;
import kd.bos.schedule.server.queueManager.IScheduleMqRoute;
import kd.bos.schedule.server.schedulecreator.SchVisitorStatus;
import kd.bos.schedule.server.schedulecreator.ScheduleVisitor;
import kd.bos.schedule.utils.RequestContextUtils;
import kd.bos.schedule.utils.ScheduleAccountUtils;
import kd.bos.schedule.zk.ActiveKeyValueStore;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPools;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;

public class ScheduleNextMonitor
implements Runnable,
ScheduleManager {
    private static final Log logger = LogFactory.getLog(ScheduleNextMonitor.class);
    private static final String BOS_SCHEDULE_CORE = "bos-schedule-core";
    private static IScheduleMqRoute mqroute = new IScheduleMqRoute(){};
    private static final DBRoute Sch_Route = DBRoute.basedata;
    private static final String READED = "readed";
    private static final String FCLASSNAME = "fclassname";
    private static final String FOVERTIME = "fovertime";
    private static final String FJOBMSGRECEIVER = "fjobmsgreceiver";
    private static final String FJOBPRINCIPAL = "fjobprincipal";
    private volatile boolean isStop = false;
    private static final String FPARAMS = "fparams";
    private static final String FTASK_CLASSNAME = "ftaskclassname";
    private static final String FCONCURRENT = "fconcurrent";
    private static final String FFAIL_NOTIFY = "ffailnotify";
    private static final String FSUCCESS_NOTIFY = "fsuccessnotify";
    private static final String FMSGCONTENT = "fmsgcontent";
    private static final String FNOTIFY_TYPE = "fnotifytype";
    private static final String FCAPTION = "fcaption";
    private static final String FJOB_TYPE = "fjobtype";
    private static final String FRUN_BY_USERID = "frunbyuserid";
    private static final String FNUMBER = "fnumber";
    private static final String FRUN_BY_ORGID = "frunbyorgid";
    private static final String FRUN_BY_LANG = "frunbylang";
    private static final String FSTRATEGY = "fstrategy";
    private static final String FAPPID = "fappid";
    private static final String FRUNMODE = "frunmode";
    public static final String FTASKCLASS = "ftaskclass";
    private static final String SHAREPARAMS = "SHAREPARAMS";
    private JobDispatcher jobDispatcher = new JobDispatcherProxy();
    private static boolean checkAccount = Boolean.parseBoolean(System.getProperty("Schedule.monitor.check.removedaccount", "true"));
    private ScheduleVisitor scheduleVisitor;
    private Map<String, String> cloudMapping;
    private Map<String, ZonedDateTime> timeIntervalMap = new HashMap<String, ZonedDateTime>();
    protected ActiveKeyValueStore zkStore = null;
    private PathChildrenCache scheduleChangeListener;
    private PathChildrenCache jobChangeListener;
    private Integer timeInterval = 15;
    private static AtomicBoolean isRunning = new AtomicBoolean(false);
    private Map<String, Account> accountMap = new HashMap<String, Account>();
    private IScheduleMonitorAspect monitorAspect = () -> Collections.emptySet();
    private Map<String, Set<String>> disabledAppNumMap = new ConcurrentHashMap<String, Set<String>>(6);

    public ScheduleNextMonitor(ScheduleVisitor scheduleVisitor) {
        this.scheduleVisitor = scheduleVisitor;
        try {
            this.monitorAspect = (IScheduleMonitorAspect)Class.forName("kd.bos.schedule.aspect.ScheduleNextMonitorAspect").newInstance();
        }
        catch (Throwable t) {
            this.logerr("Schedule***error", t);
        }
    }

    public static IScheduleMqRoute getMqroute() {
        return mqroute;
    }

    public static void registerMqroute(IScheduleMqRoute mqroute) {
        ScheduleNextMonitor.mqroute = mqroute;
    }

    public void registerSchedule(ScheduleInfo schInfo) {
        this.pushLastExecuteTime(schInfo);
        ArrayList<String> schIds = new ArrayList<String>();
        schIds.add(schInfo.getId());
        this.afterDeleteJobWithScheduleIds(schInfo.getJobId(), schIds);
        Map<String, List<ScheduleInfo>> sub = this.scheduleVisitor.getSchedules().get(schInfo.getScheduleType().name());
        List<ScheduleInfo> sublist = null;
        StringBuilder log = new StringBuilder();
        if (sub == null) {
            sub = new HashMap<String, List<ScheduleInfo>>();
            sublist = new ArrayList<ScheduleInfo>();
            sub.put(schInfo.getPlan(), sublist);
            this.scheduleVisitor.getSchedules().put(schInfo.getScheduleType().name(), sub);
            log.append("---Register schedule plan 1---");
        }
        if ((sublist = sub.get(schInfo.getPlan())) == null) {
            sublist = new ArrayList<ScheduleInfo>();
            sub.put(schInfo.getPlan(), sublist);
            log.append("---Register schedule plan 2---");
        }
        sub.get(schInfo.getPlan()).add(schInfo);
        logger.info("Schedule***Register plan{},{},planId:{},jobNumber={}", new Object[]{log, schInfo.getId(), schInfo.getPlan(), schInfo.getJobInfo().getNumber()});
        ObservableModel model = new ObservableModel(schInfo.getTenantId(), schInfo.getAccountId(), "Server", "Register", (Object)schInfo);
        ObservableLogHandler.collectData((ObservableModel)model);
    }

    public void oneCycle() throws InterruptedException {
        if (this.scheduleVisitor.getStatus() == SchVisitorStatus.Paused) {
            return;
        }
        List accounts = ScheduleAccountUtils.getAllAccountsOfCurrentEnv((boolean)false);
        for (Account account : accounts) {
            this.accountMap.put(account.getAccountId(), account);
        }
        if (!isRunning.get()) {
            ZonedDateTime cur = ZonedDateTime.now();
            this.timeIntervalMap.put(ScheduleTypeNextEnums.Seconds.name(), cur.truncatedTo(ChronoUnit.SECONDS));
            this.timeIntervalMap.put(ScheduleTypeNextEnums.Minutes.name(), cur.truncatedTo(ChronoUnit.SECONDS));
            this.timeIntervalMap.put(ScheduleTypeNextEnums.Hours.name(), cur.truncatedTo(ChronoUnit.SECONDS));
            this.timeIntervalMap.put(ScheduleTypeNextEnums.Days.name(), cur.truncatedTo(ChronoUnit.SECONDS));
            this.timeIntervalMap.put(ScheduleTypeNextEnums.Weeks.name(), cur.truncatedTo(ChronoUnit.SECONDS));
            this.timeIntervalMap.put(ScheduleTypeNextEnums.Months.name(), cur.truncatedTo(ChronoUnit.SECONDS));
            this.timeIntervalMap.put(ScheduleTypeNextEnums.Years.name(), cur.truncatedTo(ChronoUnit.SECONDS));
            this.timeIntervalMap.put(ScheduleTypeNextEnums.Other.name(), cur.truncatedTo(ChronoUnit.SECONDS));
            this.timeIntervalMap.put(ScheduleTypeNextEnums.NoRepeat.name(), cur.truncatedTo(ChronoUnit.SECONDS));
            this.timeIntervalMap.put(ScheduleTypeNextEnums.Delay.name(), cur.truncatedTo(ChronoUnit.SECONDS));
            this.timeIntervalMap.put(ScheduleTypeNextEnums.Detect.name(), cur.truncatedTo(ChronoUnit.SECONDS));
            for (Map.Entry<String, Account> row : this.accountMap.entrySet()) {
                Account account = row.getValue();
                this.scanPlan(account);
                logger.info("Schedule***Acccount run successfully!accountId:{},accountName:{},accountNumber:{},tenantId:{}", new Object[]{account.getAccountId(), account.getAccountName(), account.getAccountNumber(), account.getTenantId()});
            }
            isRunning.set(true);
            logger.info("Schedule***Monitor thread run successfully!");
        }
        this.fireSchedule(ScheduleTypeNextEnums.Seconds);
        this.fireSchedule(ScheduleTypeNextEnums.Minutes);
        this.fireSchedule(ScheduleTypeNextEnums.Hours);
        this.fireSchedule(ScheduleTypeNextEnums.Days);
        this.fireSchedule(ScheduleTypeNextEnums.Weeks);
        this.fireSchedule(ScheduleTypeNextEnums.Months);
        this.fireSchedule(ScheduleTypeNextEnums.Years);
        this.fireSchedule(ScheduleTypeNextEnums.Other);
        this.fireSchedule(ScheduleTypeNextEnums.Delay);
        this.fireSchedule(ScheduleTypeNextEnums.Detect);
        this.fireSchedule(ScheduleTypeNextEnums.NoRepeat);
    }

    public void scanPlan(Account account) {
        block23: {
            String tenantId = account.getTenantId();
            String accountId = account.getAccountId();
            if (this.isStop) {
                logger.info("Schedule***ScheduleNextmonitor isStop");
                return;
            }
            RequestContextUtils.createRequestContext((String)tenantId, (String)accountId, null);
            ThreadPools.executeOnce((String)"BOSSchedule-initDisableApp-Thread", () -> {
                logger.info("Schedule***BOSSchedule-initDisableApp begin");
                Set<String> appNums = this.monitorAspect.getDisabledAppNum();
                this.registerDisableApps(appNums);
                if (!appNums.isEmpty()) {
                    StringBuilder strSQL = new StringBuilder("SELECT a.FID FROM T_SCH_JOB a left join T_SCH_TASKDEFINE b on a.ftaskdefineid = b.fid  WHERE a.FSTATUS = '1' and a.FJOBTYPE = 'BIZ' and b.FAPPID in (");
                    ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(appNums.size());
                    for (String appNum : appNums) {
                        params.add(new SqlParameter(":FAPPID", 12, (Object)appNum));
                        strSQL.append(" ?,");
                    }
                    strSQL.deleteCharAt(strSQL.length() - 1).append(")");
                    List jobIds = (List)DB.query((DBRoute)Sch_Route, (String)strSQL.toString(), (Object[])params.toArray(), rs -> {
                        ArrayList<String> ids = new ArrayList<String>(10);
                        while (rs.next()) {
                            ids.add(rs.getString("fid"));
                        }
                        return ids;
                    });
                    for (String jobId : jobIds) {
                        this.afterDeleteJob(jobId);
                    }
                    logger.info("Schedule***BOSSchedule-initDisableApp end,appNum : {}, jobIds : {}", appNums, (Object)jobIds);
                }
            });
            logger.info("Schedule***Background transaction has started scanning account:{} generated schedule plan", (Object)account.getAccountName());
            try (TXHandle h = TX.requiresNew((String)this.getClass().getName());){
                List<ScheduleInfo> enableScheduleInfos = this.genScheduleInfos(null);
                logger.info("Schedule***{},{}:The total of plan:{}", new Object[]{tenantId, accountId, enableScheduleInfos.size()});
                for (ScheduleInfo info : enableScheduleInfos) {
                    if (this.isStop) break;
                    try {
                        this.registerSchedule(info);
                    }
                    catch (Exception e) {
                        this.logerr("Error:Schedule***An error occurred while generating plan:{},jobNumber={},tenantId:{},accountId:{}", info.getId(), info.getJobInfo().getNumber(), tenantId, accountId, e);
                    }
                    catch (Throwable throwable) {
                        this.logerr("Error:Schedule***An error occurred while generating plan:{},jobNumber={},tenantId:{},accountId:{}", info.getId(), info.getJobInfo().getNumber(), tenantId, accountId, throwable);
                        throw throwable;
                    }
                }
                StringBuilder tmp = new StringBuilder();
                Map<String, List<ScheduleInfo>> mp = null;
                if (this.scheduleVisitor.getSchedules() != null) {
                    for (Map.Entry<String, Map<String, List<ScheduleInfo>>> entry : this.scheduleVisitor.getSchedules().entrySet()) {
                        mp = entry.getValue();
                        tmp.append(entry.getKey()).append(":");
                        if (mp != null) {
                            for (Map.Entry<String, List<ScheduleInfo>> sub : mp.entrySet()) {
                                tmp.append(sub.getKey()).append(":").append(sub.getValue().size()).append(",");
                            }
                            continue;
                        }
                        tmp.append(entry.getKey()).append(":").append("0,");
                    }
                    logger.info("Schedule***Plan assignment:{},tenantId:{},account:{}", new Object[]{tmp, tenantId, accountId});
                    break block23;
                }
                logger.info("Schedule***Schdule is empty,not execute!,tenantId:{},accountId:{}", (Object)tenantId, (Object)accountId);
            }
            catch (Exception e) {
                this.logerr("Error:Schedule***Background transaction has started scanning account\uff1a{} an error occurred", accountId, e);
            }
        }
    }

    public void startToListenScheduleChange() {
        this.zkStore = ActiveKeyValueStore.create();
        if (ZkConfig.isSupportZk()) {
            this.scheduleChangeListener = new PathChildrenCache(this.zkStore.getCuratorFramework(), ZkConfig.getScheduleChangedMessagePath(), true);
            this.jobChangeListener = new PathChildrenCache(this.zkStore.getCuratorFramework(), ZkConfig.getJobChangedMessagePath(), true);
            PathChildrenCacheListener listener = (client, event) -> {
                if (event.getType() == PathChildrenCacheEvent.Type.CHILD_ADDED || event.getType() == PathChildrenCacheEvent.Type.CHILD_UPDATED) {
                    List children = this.zkStore.getChildren(ZkConfig.getScheduleChangedMessagePath());
                    this.scheduleProcessChanged(children);
                }
            };
            PathChildrenCacheListener jobListener = (client, event) -> {
                if (event.getType() == PathChildrenCacheEvent.Type.CHILD_ADDED) {
                    List children = this.zkStore.getChildren(ZkConfig.getJobChangedMessagePath());
                    this.jobProcessChanged(children);
                }
            };
            this.scheduleChangeListener.getListenable().addListener((Object)listener);
            this.jobChangeListener.getListenable().addListener((Object)jobListener);
            try {
                this.scheduleChangeListener.start();
                this.jobChangeListener.start();
            }
            catch (Exception e) {
                this.logerr("Error:Schedule***Plan change listener startup failed", e);
            }
        }
    }

    private void pushLastExecuteTime(ScheduleInfo schInfo) {
        switch (schInfo.getScheduleType()) {
            case Seconds: {
                schInfo.setLastExecuteTime(ZonedDateTime.now().plusSeconds(schInfo.getRepeatNum()));
                break;
            }
            case Minutes: {
                schInfo.setLastExecuteTime(ZonedDateTime.now().plusMinutes(schInfo.getRepeatNum()));
                break;
            }
            case Hours: {
                schInfo.setLastExecuteTime(ZonedDateTime.now().plusHours(schInfo.getRepeatNum()));
                break;
            }
            case Days: {
                schInfo.setLastExecuteTime(ZonedDateTime.now().plusDays(schInfo.getRepeatNum()));
                break;
            }
            case Weeks: {
                schInfo.setLastExecuteTime(ZonedDateTime.now().plusWeeks(schInfo.getRepeatNum()));
                break;
            }
            case Months: {
                schInfo.setLastExecuteTime(ZonedDateTime.now().plusYears(schInfo.getRepeatNum()));
                break;
            }
            case Years: {
                schInfo.setLastExecuteTime(ZonedDateTime.now().plusYears(1L));
            }
        }
    }

    private void scheduleProcessChanged(List<String> changeMsgList) {
        for (String changeNode : changeMsgList) {
            String changePath = ZkConfig.getScheduleChangedMessagePath() + "/" + changeNode;
            String message = this.zkStore.read(changePath, null);
            if (READED.equals(message)) continue;
            this.zkStore.write(changePath, READED);
            this.scheduleProcessChanged(message);
            try {
                this.zkStore.delete(changePath);
            }
            catch (Exception e) {
                this.logerr("Error:Schedule***scheduleProcessChange error!", e);
            }
        }
        for (String changeNode : changeMsgList) {
            this.zkStore.delete(ZkConfig.getScheduleChangedMessagePath() + "/" + changeNode);
        }
    }

    public void scheduleProcessChanged(String message) {
        Map changeMsgMap = (Map)SerializationUtils.fromJsonString((String)message, Map.class);
        logger.info("Schedule***processChanged : {}", (Object)message);
        String flag = (String)changeMsgMap.get("flag");
        String tenantId = (String)changeMsgMap.get("tenantId");
        String accountId = (String)changeMsgMap.get("accountId");
        String userId = (String)changeMsgMap.get("userId");
        String jobIds = (String)changeMsgMap.get("jobIds");
        List<Object> jobIdList = StringUtils.isNotBlank((CharSequence)jobIds) ? Arrays.asList(jobIds.split(",")) : new ArrayList(1);
        ThreadPools.executeOnce((String)"BOSSchedule-ScheduleChangeExecute", () -> {
            RequestContextUtils.createRequestContext((String)tenantId, (String)accountId, (String)userId);
            String scheduleId = (String)changeMsgMap.get("scheduleId");
            if ("Add".equals(flag)) {
                this.afterAddSchedule(scheduleId);
            } else if ("Update".equals(flag)) {
                this.afterUpdateSchedule(scheduleId, jobIdList);
            } else if ("Delete".equals(flag)) {
                this.afterDeleteSchedule(scheduleId);
            } else if ("Disable".equals(flag)) {
                this.disableSchedule(scheduleId);
            } else if ("Enable".equals(flag)) {
                this.enableSchedule(scheduleId);
            } else if ("Refresh".equals(flag)) {
                Account ac = new Account();
                ac.setAccountId(accountId);
                ac.setTenantId(tenantId);
                this.scanPlan(ac);
                logger.info("Schedule***\u8d26\u5957\u8c03\u5ea6\u5237\u65b0\u6210\u529f!{}", (Object)(accountId + ":" + tenantId));
            }
        });
    }

    private void jobProcessChanged(List<String> changeMsgList) {
        for (String changeNode : changeMsgList) {
            String changePath = ZkConfig.getJobChangedMessagePath() + "/" + changeNode;
            String message = this.zkStore.read(changePath, null);
            if (!READED.equals(message)) {
                this.zkStore.write(changePath, READED);
                this.jobProcessChanged(message);
                try {
                    this.zkStore.delete(changePath);
                }
                catch (Exception e) {
                    this.logerr("Error:Schedule***zkStore.delete error!", e);
                }
                continue;
            }
            try {
                this.zkStore.delete(changePath);
            }
            catch (Exception e) {
                this.logerr("Error:Schedule***zkStore.delete error!", e);
            }
        }
    }

    public void jobProcessChanged(String message) {
        Map changeMsgMap = (Map)SerializationUtils.fromJsonString((String)message, Map.class);
        logger.info("Schedule***jobProcessChanged : {}", (Object)message);
        String flag = (String)changeMsgMap.get("flag");
        String tenantId = (String)changeMsgMap.get("tenantId");
        String accountId = (String)changeMsgMap.get("accountId");
        String userId = (String)changeMsgMap.get("userId");
        String scheduleIds = (String)changeMsgMap.get("scheduleIds");
        List scheduleIdList = StringUtils.isNotBlank((CharSequence)scheduleIds) ? SerializationUtils.fromJsonStringToList((String)scheduleIds, String.class) : new ArrayList(1);
        ThreadPools.executeOnce((String)"BOSSchedule-SchedulejobChangeExecute", () -> {
            RequestContextUtils.createRequestContext((String)tenantId, (String)accountId, (String)userId);
            String jobId = (String)changeMsgMap.get("jobId");
            String jobIdStr = (String)changeMsgMap.get("jobIds");
            List jobIds = StringUtils.isNotBlank((CharSequence)jobIdStr) ? SerializationUtils.fromJsonStringToList((String)jobIdStr, String.class) : Collections.emptyList();
            switch (flag) {
                case "Disable": {
                    if (scheduleIdList.isEmpty()) {
                        this.disableJob(jobId);
                        break;
                    }
                    this.afterDisableJobWithScheduleIds(jobId, scheduleIdList);
                    break;
                }
                case "Enable": {
                    this.enableJob(jobId);
                    break;
                }
                case "Update": {
                    this.afterUpdateJob(jobId);
                    break;
                }
                case "Delete": {
                    if (scheduleIdList.isEmpty()) {
                        this.afterDeleteJob(jobId);
                        break;
                    }
                    this.afterDeleteJobWithScheduleIds(jobId, scheduleIdList);
                    break;
                }
                case "batchUpdateJob": {
                    if (CollectionUtils.isEmpty((Collection)jobIds)) break;
                    this.batchUpdateJob(jobIds);
                    break;
                }
            }
        });
    }

    private void fireSchedule_Inner(ScheduleTypeNextEnums sch, Long scg, ZonedDateTime currentTime) throws InterruptedException {
        Map<String, List<ScheduleInfo>> sub = null;
        Object sList = null;
        if (sch == ScheduleTypeNextEnums.Seconds && scg >= 60L) {
            this.timeIntervalMap.put(sch.name(), currentTime.truncatedTo(ChronoUnit.SECONDS));
        } else if (sch == ScheduleTypeNextEnums.Minutes && scg >= 60L) {
            this.timeIntervalMap.put(sch.name(), currentTime.truncatedTo(ChronoUnit.SECONDS));
        } else if (sch == ScheduleTypeNextEnums.Hours && scg >= 24L) {
            this.timeIntervalMap.put(sch.name(), currentTime.truncatedTo(ChronoUnit.SECONDS));
        } else if (sch == ScheduleTypeNextEnums.Days && scg >= 28L) {
            this.timeIntervalMap.put(sch.name(), currentTime.truncatedTo(ChronoUnit.SECONDS));
        } else if (sch == ScheduleTypeNextEnums.Weeks && scg >= 4L) {
            this.timeIntervalMap.put(sch.name(), currentTime.truncatedTo(ChronoUnit.SECONDS));
        } else if (sch == ScheduleTypeNextEnums.Months && scg >= 12L) {
            this.timeIntervalMap.put(sch.name(), currentTime.truncatedTo(ChronoUnit.SECONDS));
        } else if (sch == ScheduleTypeNextEnums.Years && scg >= 1L) {
            this.timeIntervalMap.put(sch.name(), currentTime.truncatedTo(ChronoUnit.SECONDS));
        } else if (sch == ScheduleTypeNextEnums.NoRepeat) {
            this.timeIntervalMap.put(sch.name(), currentTime.truncatedTo(ChronoUnit.SECONDS));
        }
        sub = this.scheduleVisitor.getSchedules().get(sch.name());
        if (sub == null) {
            logger.debug("Schedule***\u8be5\u523b\u5ea6\u4e0a\u672a\u6ce8\u518c\u8c03\u5ea6\u8ba1\u5212:{}", (Object)sch.name());
            return;
        }
        logger.debug("Schedule***\u8be5\u523b\u5ea6\u4e0a\u5df2\u6ce8\u518c\u8c03\u5ea6\u8ba1\u5212:{},size:{}", (Object)sch.name(), (Object)sub.size());
        for (Map.Entry<String, List<ScheduleInfo>> entry : sub.entrySet()) {
            Iterator<ScheduleInfo> it = entry.getValue().iterator();
            while (it.hasNext()) {
                ScheduleInfo info = it.next();
                try {
                    if (info.getPointOfTime().size() < 2 && info.getScheduleType() != ScheduleTypeNextEnums.Detect && info.getScheduleType() != ScheduleTypeNextEnums.Delay) {
                        this.genSchedule(info, false);
                        ObservableModel model = new ObservableModel(info.getTenantId(), info.getAccountId(), "Server", "GenTimes", (Object)info);
                        ObservableLogHandler.collectData((ObservableModel)model);
                    }
                    if (info.getPointOfTime().isEmpty()) {
                        it.remove();
                        logger.info("Schedule***schedule has no PointOfTime and remove:{},{},{}", new Object[]{info.getId(), info.getJobId(), info.getPlan()});
                        continue;
                    }
                    if (!this.allowExecute(currentTime, info)) continue;
                    RequestContextUtils.createRequestContext((String)info.getTenantId(), (String)info.getAccountId(), null);
                    TimerPulse timerPulse = new TimerPulse(this.generateTaskId(info), info);
                    SchObservableCollectData.collectData((String)info.getTenantId(), (String)info.getAccountId(), (String)"Server", (String)"generateTime", (Object)timerPulse);
                    if (checkAccount && !this.accountMap.containsKey(info.getAccountId())) {
                        logger.info("Schedule***\u6570\u636e\u4e2d\u5fc3\u5df2\u79fb\u9664 accountId = {},scheduleId = {},jobNumber={}", new Object[]{info.getAccountId(), info.getId(), info.getJobInfo().getNumber()});
                        SchObservableCollectData.collectData((String)info.getTenantId(), (String)info.getAccountId(), (String)"Server", (String)"accountNotExist", (Object)timerPulse);
                        continue;
                    }
                    if (this.scheduleVisitor.getStatus() == SchVisitorStatus.Paused) {
                        logger.info("Schedule***\u670d\u52a1\u5904\u4e8e\u505c\u6b62\u72b6\u6001\uff0c\u4e0d\u53d1\u5e03\u65b0\u4efb\u52a1 accountId = {},scheduleId = {},jobNumber={}", new Object[]{info.getAccountId(), info.getId(), info.getJobInfo().getNumber()});
                        SchObservableCollectData.collectData((String)info.getTenantId(), (String)info.getAccountId(), (String)"Server", (String)"scheduleVisitorPaused", (Object)timerPulse);
                        continue;
                    }
                    JobInfo jobInfo = info.getJobInfo();
                    jobInfo.setFromScheduler(true);
                    long groupId = 0L;
                    jobInfo.setGroupId(groupId);
                    jobInfo.setExecuteTime(1);
                    if (jobInfo.getRetryTime() > 0 || jobInfo.getRouteMode() != RouteMode.RAMDOM) {
                        groupId = DbJobOperation.getGroupMax();
                        jobInfo.setGroupId(groupId);
                    }
                    this.pushJob(timerPulse);
                    this.deleteDelayOrDetectSchedule(it, info);
                }
                catch (Throwable t) {
                    this.logerr("Error:Schedule*** fireSchedule_Inner fail,schedule : [{}]", info, t);
                }
            }
        }
    }

    private String generateTaskId(ScheduleInfo info) {
        String taskId = "";
        taskId = info.getScheduleType() != ScheduleTypeNextEnums.Detect ? String.valueOf(DB.genLongId((String)"T_SCH_TASK")) : info.getJobInfo().getTaskId();
        return taskId;
    }

    private void deleteDelayOrDetectSchedule(Iterator<ScheduleInfo> it, ScheduleInfo info) {
        switch (info.getScheduleType()) {
            case Delay: 
            case Detect: {
                it.remove();
            }
        }
    }

    private void handleNoRepeatTask(Map<String, List<ScheduleInfo>> sub) {
    }

    private void pushBeforeJob(TimerPulse timerPulse) throws InterruptedException {
        Boolean allower = Boolean.getBoolean("schedule.server.beforesend");
        ScheduleInfo info = timerPulse.getInfo();
        if (!allower.booleanValue()) {
            logger.debug("Schedule***{} \u672a\u5f00\u542f\u8865\u507f\u6a21\u5f0f{}", (Object)info.getId(), (Object)allower);
            return;
        }
        ZonedDateTime runtime = (ZonedDateTime)info.getPointOfTime().peek();
        while (runtime != null && this.canRun(runtime)) {
            ZonedDateTime po = (ZonedDateTime)info.getPointOfTime().poll();
            logger.debug("Schedule***{} \u8865\u507f\u53d1\u9001:{}", (Object)info.getId(), (Object)po.toString());
            info.setLastExecuteTime(po);
            this.cherryPickQueue(timerPulse);
            runtime = (ZonedDateTime)info.getPointOfTime().peek();
        }
    }

    private void cherryPickQueue(TimerPulse timerPulse) throws InterruptedException {
        ScheduleInfo info = timerPulse.getInfo();
        int size = this.scheduleVisitor.getServerQueues().size();
        int queueIndex = 0;
        int taskSize = Integer.MAX_VALUE;
        for (int i = 0; i < size; ++i) {
            if (this.scheduleVisitor.getServerQueues().get(i).size() == 0) {
                queueIndex = i;
                break;
            }
            if (this.scheduleVisitor.getServerQueues().get(i).size() >= taskSize) continue;
            taskSize = this.scheduleVisitor.getServerQueues().get(i).size();
            queueIndex = i;
        }
        this.scheduleVisitor.getServerQueues().get(queueIndex).put(timerPulse);
        logger.debug("Schedule***cherryPickQueue :{},scheduleId : {},jobNumber={},accountid={}", new Object[]{queueIndex, info.getId(), info.getJobInfo().getNumber(), info.getAccountId()});
        SchObservableCollectData.collectData((String)info.getTenantId(), (String)info.getAccountId(), (String)"Server", (String)"pushLocalQueue", (Object)timerPulse);
    }

    private void pushJob(TimerPulse timerPulse) throws InterruptedException {
        this.cherryPickQueue(timerPulse);
    }

    private boolean canRun(ZonedDateTime theTime) {
        ZonedDateTime mTime;
        ZonedDateTime now = ZonedDateTime.now().truncatedTo(ChronoUnit.SECONDS);
        return now.isAfter(mTime = theTime.truncatedTo(ChronoUnit.SECONDS)) || now.isEqual(mTime);
    }

    private ZonedDateTime queryLastExeTime(ScheduleInfo info) {
        String disTime = null;
        String sql = "SELECT  top 1 A.FDISPATCHTIME         FROM t_sch_task A         WHERE A.FJOBID = ? AND A.fscheduleid = ?         ORDER BY A.FDISPATCHTIME DESC";
        Object[] params = new SqlParameter[]{new SqlParameter(":FJOBID", 12, (Object)info.getJobId()), new SqlParameter(":fscheduleid", 12, (Object)info.getId())};
        RequestContextUtils.createRequestContext((String)info.getTenantId(), (String)info.getAccountId(), null);
        try {
            disTime = (String)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<String>(){

                public String handle(ResultSet rs) throws Exception {
                    String dispatchTime = null;
                    if (rs.next()) {
                        dispatchTime = rs.getString("FDISPATCHTIME");
                    }
                    return dispatchTime;
                }
            });
            if (StringUtils.isNotBlank((CharSequence)disTime)) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault());
                if (StringUtils.isBlank((CharSequence)disTime)) {
                    return null;
                }
                ZonedDateTime zonedDateTime = ZonedDateTime.parse(disTime.length() >= 19 ? disTime.substring(0, 19) : disTime, formatter);
                return zonedDateTime;
            }
            return null;
        }
        catch (Exception e) {
            this.logerr("Error:Schedule***queryLastExeTime error:", e);
            return null;
        }
    }

    private void genSchedule(ScheduleInfo info, boolean isRefresh) {
        logger.debug("Schedule***\u5f00\u59cb\u751f\u6210\u65f6\u95f4\u70b9\uff0cschId={}\uff0cjobId={}", (Object)info.getId(), (Object)info.getJobInfo().getId());
        ZonedDateTime lastExeTime = null;
        ZonedDateTime endTime = null;
        ZoneId zoneId = TimeNextUtils.getZoneId(info.getTimeZoneId());
        endTime = ZonedDateTime.now(zoneId).plusHours(Integer.parseInt(System.getProperty("Schedule.monitor.generateNextTime", "6"))).plusMinutes(1L);
        if (info.getPointOfTime().size() == 0) {
            lastExeTime = ZonedDateTime.now(zoneId).truncatedTo(ChronoUnit.SECONDS).minusSeconds(5L);
            logger.debug("Schedule***\u83b7\u53d6\u5f53\u524d\u65f6\u95f4\u4e3a\u8d77\u59cb\u70b9:{},schId={},jobId={}", new Object[]{lastExeTime.toString(), info.getId(), info.getJobInfo().getId()});
        } else if (isRefresh) {
            info.getPointOfTime().clear();
            lastExeTime = info.getLastExecuteTime();
        } else {
            lastExeTime = (ZonedDateTime)info.getPointOfTime().toArray()[info.getPointOfTime().size() - 1];
            lastExeTime = lastExeTime.plusSeconds(5L);
            logger.debug("Schedule***{}---\u83b7\u53d6\u5f53\u524d\u8ba1\u5212\u6302\u8f7d\u7684\u6700\u540e\u4e00\u6b21\u65f6\u95f4\u70b9lastExeTime:{},pointOfTime.size={},schId={},jobId={}", new Object[]{lastExeTime.toString(), info.getPointOfTime().size(), info.getId(), info.getJobInfo().getId()});
        }
        TimeNextUtils.genScheduleEx(info, lastExeTime, endTime);
        logger.info("Schedule***{}---\u751f\u6210\u65f6\u95f4\u70b9\u540e\uff1apointOfTime.size={},lastExeTime:{},schId={},jobId={}", new Object[]{info.getPointOfTime().size(), lastExeTime == null ? "NULL" : lastExeTime.toString(), info.getId(), info.getJobInfo().getId()});
    }

    private void handleExpirePointOfTime(ScheduleInfo info) {
        if (System.getProperty("Schedule.monitor.generateExpire") == null) {
            ZonedDateTime curtime = null;
            ZonedDateTime nexttime = null;
            while (info.getPointOfTime().size() > 1) {
                curtime = (ZonedDateTime)info.getPointOfTime().toArray()[0];
                nexttime = (ZonedDateTime)info.getPointOfTime().toArray()[1];
                if (!this.canRun(nexttime)) break;
                info.getPointOfTime().remove(curtime);
            }
        }
    }

    private boolean allowExecute(ZonedDateTime currentTime, ScheduleInfo info) {
        Long seconds = 0L;
        if (info.getLastExecuteTime() == null) {
            info.setLastExecuteTime(currentTime);
            return false;
        }
        ZonedDateTime runtime = (ZonedDateTime)info.getPointOfTime().peek();
        if (runtime == null) {
            return false;
        }
        if (this.canRun(runtime)) {
            ZonedDateTime po = (ZonedDateTime)info.getPointOfTime().poll();
            info.setLastExecuteTime(po);
            ObservableModel model = new ObservableModel(info.getTenantId(), info.getAccountId(), "Server", "allowFire", (Object)info);
            ObservableLogHandler.collectData((ObservableModel)model);
            return true;
        }
        if (runtime.isAfter(currentTime)) {
            ObservableModel model = new ObservableModel(info.getTenantId(), info.getAccountId(), "Server", "noAllowFire", (Object)info);
            ObservableLogHandler.collectData((ObservableModel)model);
        } else {
            info.getPointOfTime().poll();
            ObservableModel model = new ObservableModel(info.getTenantId(), info.getAccountId(), "Server", "timeIsExpire", (Object)info);
            ObservableLogHandler.collectData((ObservableModel)model);
        }
        return false;
    }

    private void fireSchedule(ScheduleTypeNextEnums schEnum) throws InterruptedException {
        try {
            ZonedDateTime lastRunTime = this.timeIntervalMap.get(schEnum.name());
            ZonedDateTime currentTime = ZonedDateTime.now().truncatedTo(ChronoUnit.SECONDS);
            Long between = this.fireScheduleCalcInterval(schEnum, lastRunTime, currentTime);
            this.fireSchedule_Inner(schEnum, between, currentTime);
        }
        catch (Exception e) {
            this.logerr("Error:Schedule:{}", schEnum.name(), e);
        }
    }

    private Long fireScheduleCalcInterval(ScheduleTypeNextEnums schEnum, ZonedDateTime lastRunTime, ZonedDateTime currentTime) {
        Long result = 0L;
        switch (schEnum) {
            case Seconds: 
            case Delay: 
            case Detect: 
            case Other: {
                return ChronoUnit.SECONDS.between(lastRunTime, currentTime);
            }
            case Minutes: {
                return ChronoUnit.MINUTES.between(lastRunTime, currentTime);
            }
            case Hours: {
                return ChronoUnit.HOURS.between(lastRunTime, currentTime);
            }
            case Days: {
                return ChronoUnit.DAYS.between(lastRunTime, currentTime);
            }
            case Weeks: {
                return ChronoUnit.WEEKS.between(lastRunTime, currentTime);
            }
            case Months: {
                return ChronoUnit.MONTHS.between(lastRunTime, currentTime);
            }
            case Years: {
                return ChronoUnit.YEARS.between(lastRunTime, currentTime);
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            logger.info("Schedule***oneCycle break!0");
            RequestContext rc = RequestContext.get();
            while (true) {
                long begintime = System.currentTimeMillis();
                try {
                    ThreadLifeCycleManager.start();
                    RequestContextThreadBinder.bind((RequestContext)rc);
                    if (this.isStop) {
                        logger.info("Schedule***oneCycle break!");
                        break;
                    }
                    logger.info("Schedule***oneCycle break!1");
                    this.oneCycle();
                }
                catch (Throwable exp) {
                    this.logerr("Error:Schedule***oneCycle error!", exp);
                }
                finally {
                    ThreadLifeCycleManager.end();
                }
                long INTERVAL_MS = this.timeInterval * 1000;
                long sleeptimes = INTERVAL_MS - (System.currentTimeMillis() - begintime);
                logger.info("Schedule***ScheduleNextMonitor\u76d1\u63a7\u7ebf\u7a0b\u89e6\u53d1\u6210\u529f!\uff0csleeptimes:{}", (Object)sleeptimes);
                if (sleeptimes <= 0L) continue;
                try {
                    Thread.sleep(INTERVAL_MS);
                }
                catch (InterruptedException e) {
                    this.logerr("Error:Schedule***Thread.sleep error", e);
                }
            }
        }
        finally {
            isRunning.set(Boolean.FALSE);
            logger.info("Schedule***ScheduleNextMonitor finish.");
        }
    }

    private void logerr(String errStr, Throwable exp) {
        logger.error(errStr, exp);
    }

    private void logerr(String var1, Object ... var2) {
        logger.error(var1, var2);
    }

    public static void main(String[] args) {
    }

    public void afterAddSchedule(String id) {
        this.afterUpdateSchedule(id);
    }

    public void afterUpdateSchedule(String scheduleId) {
        this.afterDeleteSchedule(scheduleId);
        logger.info("Schedule***afterUpdateSchedule1 delete schedule:{}", (Object)scheduleId);
        List<ScheduleInfo> genScheduleInfos = this.genScheduleInfos(scheduleId);
        for (ScheduleInfo scheduleInfo : genScheduleInfos) {
            this.registerSchedule(scheduleInfo);
        }
    }

    public void afterUpdateSchedule(String scheduleId, List<String> jobIds) {
        this.afterDeleteSchedule(scheduleId);
        logger.info("Schedule***afterUpdateSchedule2 delete schedule:{]", (Object)scheduleId);
        List<ScheduleInfo> genScheduleInfos = this.genScheduleInfos(scheduleId);
        for (ScheduleInfo scheduleInfo : genScheduleInfos) {
            this.registerSchedule(scheduleInfo);
        }
    }

    public void afterDeleteSchedule(String scheduleId) {
        try {
            this.innerRemove(scheduleId);
        }
        catch (Throwable t) {
            this.logerr("ERROR Schedule***afterDeleteSchedule error!", t);
        }
    }

    private void innerRemove(String scheduleId) {
        this.innerRemove(scheduleId, null);
    }

    private void innerRemove(String scheduleId, String jobId) {
        this.innerRemoveDetail(scheduleId, jobId, this.scheduleVisitor.getSchedules().get(ScheduleTypeNextEnums.Months.name()));
        this.innerRemoveDetail(scheduleId, jobId, this.scheduleVisitor.getSchedules().get(ScheduleTypeNextEnums.Hours.name()));
        this.innerRemoveDetail(scheduleId, jobId, this.scheduleVisitor.getSchedules().get(ScheduleTypeNextEnums.Minutes.name()));
        this.innerRemoveDetail(scheduleId, jobId, this.scheduleVisitor.getSchedules().get(ScheduleTypeNextEnums.Other.name()));
        this.innerRemoveDetail(scheduleId, jobId, this.scheduleVisitor.getSchedules().get(ScheduleTypeNextEnums.Days.name()));
        this.innerRemoveDetail(scheduleId, jobId, this.scheduleVisitor.getSchedules().get(ScheduleTypeNextEnums.Weeks.name()));
        this.innerRemoveDetail(scheduleId, jobId, this.scheduleVisitor.getSchedules().get(ScheduleTypeNextEnums.Years.name()));
        this.innerRemoveDetail(scheduleId, jobId, this.scheduleVisitor.getSchedules().get(ScheduleTypeNextEnums.NoRepeat.name()));
    }

    private void innerRemoveDetail(String scheduleId, Map<String, List<ScheduleInfo>> sub) {
        this.innerRemoveDetail(scheduleId, null, sub);
    }

    private void innerRemoveDetail(String scheduleId, String jobId, Map<String, List<ScheduleInfo>> sub) {
        ScheduleInfo removeInfo = null;
        if (sub == null) {
            return;
        }
        RequestContext rc = RequestContext.get();
        Iterator<Map.Entry<String, List<ScheduleInfo>>> entryIterator = sub.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<String, List<ScheduleInfo>> entry = entryIterator.next();
            List<ScheduleInfo> scheduleInfos = entry.getValue();
            Iterator<ScheduleInfo> it = entry.getValue().iterator();
            while (it.hasNext()) {
                removeInfo = it.next();
                if (!StringUtils.equals((CharSequence)rc.getAccountId(), (CharSequence)removeInfo.getAccountId()) || !StringUtils.equals((CharSequence)rc.getTenantId(), (CharSequence)removeInfo.getTenantId()) || !removeInfo.getId().equalsIgnoreCase(scheduleId)) continue;
                if (StringUtils.isNotEmpty((CharSequence)jobId)) {
                    if (scheduleInfos.size() == 1) {
                        if (!jobId.equals(removeInfo.getJobId())) continue;
                        logger.info("Schedule***innerRemoveDetail1:{},{},{}", new Object[]{removeInfo.getId(), removeInfo.getJobId(), removeInfo.getPlan()});
                        it.remove();
                        entryIterator.remove();
                        continue;
                    }
                    if (!jobId.equals(removeInfo.getJobId())) continue;
                    logger.info("Schedule***innerRemoveDetail2:{},{},{}", new Object[]{removeInfo.getId(), removeInfo.getJobId(), removeInfo.getPlan()});
                    it.remove();
                    continue;
                }
                if (scheduleInfos.size() == 1) {
                    logger.info("Schedule***innerRemoveDetail1:{},{}", (Object)removeInfo.getId(), (Object)removeInfo.getPlan());
                    it.remove();
                    entryIterator.remove();
                    continue;
                }
                logger.info("Schedule***innerRemoveDetail2:{},{}", (Object)removeInfo.getId(), (Object)removeInfo.getPlan());
                it.remove();
            }
        }
    }

    public void enableSchedule(String scheduleId) {
        ScheduleDao scheduleDao = ScheduleService.getInstance().getObjectFactory().getScheduleDao();
        scheduleDao.enableSchedule(scheduleId);
        this.afterUpdateSchedule(scheduleId);
    }

    public void disableSchedule(String scheduleId) {
        ScheduleDao scheduleDao = ScheduleService.getInstance().getObjectFactory().getScheduleDao();
        scheduleDao.disableSchedule(scheduleId);
        this.afterDeleteSchedule(scheduleId);
    }

    public void enableJob(String jobId) {
        if (!StringUtils.isNotBlank((CharSequence)jobId)) {
            return;
        }
        this.enableJob(jobId, true);
    }

    private void enableJob(String jobId, boolean writeDb) {
        if (writeDb) {
            JobDao jobDao = ScheduleService.getInstance().getObjectFactory().getJobDao();
            jobDao.enableJob(jobId);
        }
        this.afterUpdateJob(jobId);
    }

    public void disableJob(String jobId) {
        if (!StringUtils.isNotBlank((CharSequence)jobId)) {
            return;
        }
        this.disableJob(jobId, true);
    }

    private void disableJob(String jobId, boolean writeDb) {
        if (writeDb) {
            JobDao jobDao = ScheduleService.getInstance().getObjectFactory().getJobDao();
            jobDao.disableJob(jobId);
        }
        this.afterDeleteJob(jobId);
    }

    private void batchUpdateJobs(List<String> jobIds) {
        for (String jobId : jobIds) {
            this.afterUpdateJob(jobId);
        }
    }

    public void batchUpdateJob(List<String> jobIds) {
        for (String jobId : jobIds) {
            this.afterUpdateJob(jobId);
        }
    }

    public void afterUpdateJob(String jobId) {
        List<String> ids = this.getScheduleIdByJob(jobId);
        if (ids == null || ids.isEmpty()) {
            return;
        }
        for (String scheduleId : ids) {
            this.afterUpdateSchedule(scheduleId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterDeleteJob(String jobId) {
        List<String> ids = this.getScheduleIdByJob(jobId);
        if (ids == null || ids.isEmpty()) {
            return;
        }
        for (String scheduleId : ids) {
            ScheduleVisitor scheduleVisitor = this.scheduleVisitor;
            synchronized (scheduleVisitor) {
                this.innerRemove(scheduleId, jobId);
            }
        }
    }

    private List<String> getScheduleIdByJob(String jobId) {
        List<String> scheduleIds = this.getScheduleIdByEntry(jobId);
        if (scheduleIds.size() > 0) {
            return scheduleIds;
        }
        String strSQL = "SELECT FID FROM T_SCH_SCHEDULE WHERE FJOBID= ? ";
        Object[] params = new SqlParameter[]{new SqlParameter(":FJOBID", 12, (Object)jobId)};
        ArrayList<String> list = new ArrayList();
        list = (List)DB.query((DBRoute)Sch_Route, (String)strSQL, (Object[])params, rs -> {
            ArrayList<String> ids = new ArrayList<String>(10);
            while (rs.next()) {
                ids.add(rs.getString("fid"));
            }
            return ids;
        });
        return list;
    }

    private List<String> getScheduleIdByEntry(String jobId) {
        String strSQL = "SELECT t1.FID FROM T_SCH_SCHEDULE t1 LEFT JOIN T_SCH_SCHEDULE_ENTRY t2 ON t1.FID = t2.FID WHERE t2.FJOBNUMBER = ? ";
        Object[] params = new SqlParameter[]{new SqlParameter(":FJOBNUMBER", 12, (Object)jobId)};
        ArrayList<String> list = new ArrayList();
        list = (List)DB.query((DBRoute)Sch_Route, (String)strSQL, (Object[])params, rs -> {
            ArrayList<String> ids = new ArrayList<String>(10);
            while (rs.next()) {
                ids.add(rs.getString("fid"));
            }
            return ids;
        });
        return list;
    }

    private void afterDisableJobWithScheduleIds(String jobId, List<String> scheduleIds) {
        if (StringUtils.isBlank((CharSequence)jobId)) {
            return;
        }
        JobDao jobDao = ScheduleService.getInstance().getObjectFactory().getJobDao();
        jobDao.disableJob(jobId);
        this.afterDeleteJobWithScheduleIds(jobId, scheduleIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterDeleteJobWithScheduleIds(String jobId, List<String> scheduleIds) {
        if (StringUtils.isBlank((CharSequence)jobId)) {
            return;
        }
        for (String scheduleId : scheduleIds) {
            ScheduleVisitor scheduleVisitor = this.scheduleVisitor;
            synchronized (scheduleVisitor) {
                this.innerRemove(scheduleId, jobId);
            }
        }
    }

    private void fillOrgId(ScheduleInfo info) {
        String error;
        JobInfo jobInfo = info.getJobInfo();
        if (jobInfo.getRunByOrgId() != 0L) {
            return;
        }
        long orgId = 0L;
        String sql = "";
        Object[] params = new SqlParameter[]{new SqlParameter(":FUSERID", -5, (Object)jobInfo.getRunByUserId())};
        try {
            sql = "select FORGID from T_BAS_USERDEFAULTORG where FUSERID = ?";
            orgId = (Long)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Long>(){

                public Long handle(ResultSet rs) throws Exception {
                    Long orgId = 0L;
                    if (rs.next()) {
                        orgId = rs.getLong("FORGID");
                        return orgId;
                    }
                    return orgId;
                }
            });
        }
        catch (Exception e) {
            error = String.format("AppName: %1$s,InstanceId: %2$s,scheduleId: %3$s ,errorInfo: %4$s", Instance.getAppName(), Instance.getInstanceId(), info.getId(), e.getMessage());
            this.logerr("Error:Schedule***jobprocessor error:" + error, e);
        }
        if (orgId != 0L) {
            info.getJobInfo().setRunByOrgId(orgId);
            return;
        }
        try {
            sql = "select  FORGID from T_PERM_USERPERM where FUSERID = ?";
            orgId = (Long)DB.query((DBRoute)DBRoute.permission, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Long>(){

                public Long handle(ResultSet rs) throws Exception {
                    Long orgId = 0L;
                    if (rs.next()) {
                        orgId = rs.getLong("FORGID");
                        return orgId;
                    }
                    return orgId;
                }
            });
        }
        catch (Exception e) {
            error = String.format("AppName: %1$s,InstanceId: %2$s,scheduleId: %3$s ,errorInfo: %4$s", Instance.getAppName(), Instance.getInstanceId(), info.getId(), e.getMessage());
            this.logerr("Error:Schedule***jobprocessor error:" + error, e);
        }
        info.getJobInfo().setRunByOrgId(orgId);
    }

    private List<ScheduleInfo> genScheduleInfos(String scheduleId) {
        Set<String> disabledAppNums;
        RequestContext rc = RequestContext.get();
        String tenantId = rc.getTenantId();
        String accountId = rc.getAccountId();
        this.initCloudMapping();
        Calendar crEndtime = Calendar.getInstance();
        crEndtime.add(12, ZkConfig.getDelay4ScheduleGenerate());
        Calendar crStarttime = Calendar.getInstance();
        crStarttime.add(12, ZkConfig.getInterval4ScheduleGenerate() + 1);
        StringBuilder sqlSb = new StringBuilder();
        boolean existTimeZone = DB.existColumn((DBRoute)DBRoute.of((String)"sys"), (String)"t_sch_schedule", (String)"ftimezoneid");
        if (existTimeZone) {
            sqlSb.append("select  j1.fjobid as ftaskjobid, j1.fid,j1.fstarttime,j1.fendtime,j1.fplan,j1.frepeatmode,j1.fcyclenum,j1.fjobid,j1.fsfailnotify,j1.fssuccessnotify,j1.fsnotifytype,j1.fsmsgcontent,j1.fmsgreceiver,j1.fschprincipal,j1.fstimeout,j1.ftimezoneid,t3.fjobtype,t3.ftaskclassname,t3.frunbyuserid,t3.fparams,t3.fnumber,t3.frunbyorgid,t3.frunbylang,t3.fconcurrent,t3.fstatus,t3.fstrategy,t3.frunmode,t3.fretrytime,t3.ftimeout,t3.fcanstop,t3.ftasktrace,").append("t3n.fjobprincipal,t3n.ffailnotify,t3n.fsuccessnotify,t3n.fmsgcontent,t3n.fnotifytype,t3n.fcaption,t3n.fovertime,t3n.fjobmsgreceiver,").append("t4.fappid,t4.fclassname,t4.fclassname as ftaskclass").append(" from ").append("(select case when t2.fjobnumber is null  then  t1.fjobid when t2.fjobnumber = '' then t1.fjobid when t2.fjobnumber = ' ' then t1.fjobid else t2.fjobnumber end as fjobid,t1.fid,t1.fstarttime,t1.fendtime,t1.fplan,t1.ftimezoneid,t1.frepeatmode,t1.fcyclenum,t1.fhost,t1.fstatus,t1n.fsfailnotify,t1n.fssuccessnotify,t1n.fsnotifytype,t1n.fmsgreceiver,t1n.fsmsgcontent,t1n.fschprincipal,t1n.fstimeout from t_sch_schedule as t1 left outer join t_sch_schedule_n as t1n on t1.fid = t1n.fid left join t_sch_schedule_entry t2 on t1.fid = t2.fid) as j1 ").append("left join t_sch_job t3 on j1.fjobid = t3.fid ").append("left outer join t_sch_job_n as t3n on t3.fid = t3n.fid ").append("left outer join t_sch_taskdefine as t4 on t4.fid = t3.ftaskdefineid ").append("where  j1.fendtime >= ? ").append("and j1.fstatus = '1' and t3.fstatus = '1' ");
        } else {
            sqlSb.append("select  j1.fjobid as ftaskjobid, j1.fid,j1.fstarttime,j1.fendtime,j1.fplan,j1.frepeatmode,j1.fcyclenum,j1.fjobid,j1.fsfailnotify,j1.fssuccessnotify,j1.fsnotifytype,j1.fsmsgcontent,j1.fmsgreceiver,j1.fschprincipal,j1.fstimeout,").append("t3.fjobtype,t3.ftaskclassname,t3.frunbyuserid,t3.fparams,t3.fnumber,t3.frunbyorgid,t3.frunbylang,t3.fconcurrent,t3.fstatus,t3.fstrategy,t3.frunmode,t3.fretrytime,t3.ftimeout,t3.fcanstop,t3.ftasktrace,").append("t3n.fjobprincipal,t3n.ffailnotify,t3n.fsuccessnotify,t3n.fmsgcontent,t3n.fnotifytype,t3n.fcaption,t3n.fovertime,t3n.fjobmsgreceiver,").append("t4.fappid,t4.fclassname,t4.fclassname as ftaskclass").append(" from ").append("(select case when t2.fjobnumber is null  then  t1.fjobid when t2.fjobnumber = '' then t1.fjobid when t2.fjobnumber = ' ' then t1.fjobid else t2.fjobnumber end as fjobid,t1.fid,t1.fstarttime,t1.fendtime,t1.fplan,t1.frepeatmode,t1.fcyclenum,t1.fhost,t1.fstatus,t1n.fsfailnotify,t1n.fssuccessnotify,t1n.fsnotifytype,t1n.fmsgreceiver,t1n.fsmsgcontent,t1n.fschprincipal,t1n.fstimeout from t_sch_schedule as t1 left outer join t_sch_schedule_n as t1n on t1.fid = t1n.fid left join t_sch_schedule_entry t2 on t1.fid = t2.fid) as j1 ").append("left join t_sch_job t3 on j1.fjobid = t3.fid ").append("left outer join t_sch_job_n as t3n on t3.fid = t3n.fid ").append("left outer join t_sch_taskdefine as t4 on t4.fid = t3.ftaskdefineid ").append("where  j1.fendtime >= ? ").append("and j1.fstatus = '1' and t3.fstatus = '1' ");
        }
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(6);
        boolean isGenById = StringUtils.isNotBlank((CharSequence)scheduleId);
        params.add(new SqlParameter(":fendtime", 93, (Object)new Timestamp(crEndtime.getTimeInMillis())));
        if (ZkConfig.getRunMode() == AbstractService.RunMode.Dev) {
            String ipAddress = AbstractService.getHostIpAddress();
            params.add(new SqlParameter(":fhost", 12, (Object)ipAddress));
            sqlSb.append(" and j1.fhost = ? ");
            if (isGenById) {
                sqlSb.append(" and j1.fid = ? ");
                params.add(new SqlParameter(":fid", 12, (Object)scheduleId));
            }
        } else if (isGenById) {
            sqlSb.append(" and j1.fid = ? ");
            params.add(new SqlParameter(":fid", 12, (Object)scheduleId));
        }
        if (!isGenById && (disabledAppNums = this.getDisabledAppNumMap()) != null && !disabledAppNums.isEmpty()) {
            sqlSb.append(" and t4.fappid not in (");
            for (String appNum : disabledAppNums) {
                if (StringUtils.isEmpty((CharSequence)appNum)) continue;
                sqlSb.append(" ?,");
                params.add(new SqlParameter(":appid", 12, (Object)appNum));
            }
            sqlSb.deleteCharAt(sqlSb.length() - 1);
            sqlSb.append(" ) ");
            logger.info("Schedule***master genScheduleInfos, and disabledAppNums is {}", disabledAppNums);
        }
        List<Object> listData = new ArrayList<ScheduleInfo>();
        try (TraceSpan tracer = Tracer.create((String)"scheduleMonitor", (String)("onecycle for :" + tenantId));){
            listData = (List)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sqlSb.toString(), (Object[])params.toArray(new SqlParameter[0]), rs -> {
                ArrayList<ScheduleInfo> listData1 = new ArrayList<ScheduleInfo>(10);
                Set<String> disabledApp = null;
                if (isGenById && (disabledApp = this.getDisabledAppNumMap()) != null && !disabledApp.isEmpty()) {
                    logger.info("Schedule***master genScheduleInfos, and disabledApp is {}", disabledApp);
                }
                while (rs.next()) {
                    ScheduleInfo info = this.toInfo(rs, tenantId, accountId, existTimeZone);
                    if (disabledApp != null && disabledApp.contains(info.getJobInfo().getAppId())) continue;
                    listData1.add(info);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Schedule***master,jobNumber={}:genScheduleInfos info : {}", (Object)info.getJobInfo().getNumber(), (Object)info);
                        continue;
                    }
                    logger.info("Schedule***master,jobNumber={}:genScheduleInfos scheduleinfo : [{}]", (Object)info.getJobInfo().getNumber(), (Object)info);
                }
                return listData1;
            });
        }
        catch (Exception e) {
            this.logerr("Error:Schedule***An error has occurred while background transaction scanning account\uff1a{}", accountId, e);
        }
        this.cloudMapping = null;
        return listData;
    }

    private void initCloudMapping() {
        if (this.cloudMapping == null) {
            String sql = "select fappid,fcloudid from t_meta_appruntime";
            try (TXHandle handle = TX.notSupported();){
                this.cloudMapping = (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, null, rs -> {
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    while (rs.next()) {
                        String cloudId = rs.getString("fcloudid");
                        String appnum = rs.getString(FAPPID);
                        map.put(appnum, cloudId);
                    }
                    return map;
                });
            }
        }
    }

    private ScheduleTypeNextEnums getScheduleType(String type) {
        switch (type) {
            case "m": {
                return ScheduleTypeNextEnums.Months;
            }
            case "h": {
                return ScheduleTypeNextEnums.Hours;
            }
            case "mi": {
                return ScheduleTypeNextEnums.Minutes;
            }
            case "def": {
                return ScheduleTypeNextEnums.Other;
            }
            case "d": {
                return ScheduleTypeNextEnums.Days;
            }
            case "w": {
                return ScheduleTypeNextEnums.Weeks;
            }
            case "y": {
                return ScheduleTypeNextEnums.Years;
            }
            case "n": {
                return ScheduleTypeNextEnums.NoRepeat;
            }
        }
        return ScheduleTypeNextEnums.NoRepeat;
    }

    private ScheduleInfo toInfo(ResultSet rs, String tenantId, String accountId, boolean existTimeZone) throws SQLException {
        ScheduleInfo info = new ScheduleInfo();
        String fid = rs.getString("fid");
        info.setId(fid);
        info.setScheduleType(this.getScheduleType(rs.getString("frepeatmode")));
        info.setRepeatNum(rs.getInt("fcyclenum"));
        Timestamp startTime = rs.getTimestamp("fstarttime");
        info.setStartTime(startTime.getTime());
        info.setEndTime(rs.getTimestamp("fendtime").getTime());
        info.setPlan(rs.getString("fplan"));
        JobInfo jobInfo = new JobInfo();
        String newClassName = rs.getString(FCLASSNAME);
        jobInfo.setId(rs.getString("fjobid"));
        if (StringUtils.isNotBlank((CharSequence)newClassName)) {
            jobInfo.setTaskClassname(newClassName);
        } else {
            jobInfo.setTaskClassname(rs.getString(FTASK_CLASSNAME));
        }
        jobInfo.setFailNotify(rs.getBoolean(FFAIL_NOTIFY));
        jobInfo.setSuccessNotify(rs.getBoolean(FSUCCESS_NOTIFY));
        jobInfo.setNotifyType(rs.getString(FNOTIFY_TYPE));
        jobInfo.setJobPrincipal(rs.getLong(FJOBPRINCIPAL));
        jobInfo.setCaption(rs.getString(FCAPTION));
        jobInfo.setJobMsgReceiver(rs.getLong(FJOBMSGRECEIVER));
        jobInfo.setOverTime(rs.getBoolean(FOVERTIME));
        jobInfo.setMsgContent(rs.getString(FMSGCONTENT));
        jobInfo.setRunConcurrently("1".equals(rs.getString(FCONCURRENT)));
        String jobTypeStr = rs.getString(FJOB_TYPE);
        this.setJobType(jobInfo, jobTypeStr);
        String routeMode = rs.getString(FRUNMODE);
        jobInfo.setTimeout(rs.getInt("ftimeout"));
        jobInfo.setRetryTime(rs.getInt("fretrytime"));
        jobInfo.setCanStop(Boolean.valueOf(rs.getBoolean("fcanstop")));
        this.setRouteMode(jobInfo, routeMode);
        jobInfo.setRunByUserId(rs.getLong(FRUN_BY_USERID));
        jobInfo.setRunByOrgId(rs.getLong(FRUN_BY_ORGID));
        String runByLang = rs.getString(FRUN_BY_LANG);
        if (StringUtils.isNotBlank((CharSequence)runByLang)) {
            jobInfo.setRunByLang(Lang.from((String)runByLang));
        }
        jobInfo.setNumber(rs.getString(FNUMBER));
        String fparams = rs.getString(FPARAMS);
        this.setParams(jobInfo, fparams);
        jobInfo.setStrategy(rs.getString(FSTRATEGY));
        jobInfo.setTaskTrace(rs.getBoolean("ftasktrace"));
        String feappid = rs.getString(FAPPID);
        this.setAppId(jobInfo, feappid);
        jobInfo.setScheduleId(info.getId());
        ScheduleMsgInfo smi = new ScheduleMsgInfo();
        smi.setFailNotify(rs.getBoolean("fsfailnotify"));
        smi.setSuccessNotify(rs.getBoolean("fssuccessnotify"));
        smi.setNotifyType(rs.getString("fsnotifytype"));
        smi.setMsgreceiver(rs.getLong("fmsgreceiver"));
        smi.setMsgContent(rs.getString("fsmsgcontent"));
        smi.setSchPrincipal(rs.getLong("fschprincipal"));
        smi.setTimeOut(rs.getBoolean("fstimeout"));
        jobInfo.setScheduleMsgInfo(smi);
        info.setJobInfo(jobInfo);
        info.setJobId(jobInfo.getId());
        info.setTenantId(tenantId);
        info.setAccountId(accountId);
        if (existTimeZone) {
            info.setTimeZoneId(rs.getLong("ftimezoneid"));
        }
        return info;
    }

    private void setJobType(JobInfo jobInfo, String jobTypeStr) {
        if (jobTypeStr == null || jobTypeStr.equalsIgnoreCase("BIZ")) {
            jobInfo.setJobType(JobType.BIZ);
        } else if (jobTypeStr.equalsIgnoreCase("WORKFLOW")) {
            jobInfo.setJobType(JobType.WORKFLOW);
        } else if (jobTypeStr.equalsIgnoreCase("REALTIME")) {
            jobInfo.setJobType(JobType.REALTIME);
        }
    }

    private void setRouteMode(JobInfo jobInfo, String routeMode) {
        if (routeMode == null || routeMode.equalsIgnoreCase("0")) {
            jobInfo.setRouteMode(RouteMode.RAMDOM);
        } else if (routeMode.equalsIgnoreCase("1")) {
            jobInfo.setRouteMode(RouteMode.SHARDINGBROADCAST);
        } else if (routeMode.equalsIgnoreCase("2")) {
            jobInfo.setRouteMode(RouteMode.SHARDINGTASK);
        }
    }

    private void setParams(JobInfo jobInfo, String fparams) {
        if (fparams != null && fparams.trim().length() > 0) {
            try {
                Map params = (Map)SerializationUtils.fromJsonString((String)fparams, Map.class);
                jobInfo.setParams(params);
            }
            catch (Exception exp) {
                logger.info("Schedule***Job parameter error,jobId:{},errorMsg:{}", (Object)jobInfo.getId(), (Object)exp.getMessage());
            }
        }
    }

    private void setAppId(JobInfo jobInfo, String appNum) {
        jobInfo.setAppId(appNum);
    }

    private String getCloudIdByAppNum(String appNum) {
        if (this.cloudMapping == null) {
            this.cloudMapping = this.getCloudMapping();
        }
        return this.cloudMapping.get(appNum);
    }

    private Map<String, String> getCloudMapping() {
        if (this.cloudMapping == null) {
            this.initCloudMapping();
        }
        return this.cloudMapping;
    }

    public synchronized boolean isStoped() {
        return this.isStop;
    }

    public synchronized void stop() {
        logger.info("Schedule***stop");
        isRunning.set(Boolean.FALSE);
        try {
            if (this.scheduleChangeListener != null) {
                this.scheduleChangeListener.close();
            }
            if (this.jobChangeListener != null) {
                this.jobChangeListener.close();
            }
        }
        catch (IOException e) {
            this.logerr("Error:Schedule***stop error!", e);
        }
        this.isStop = true;
    }

    private Set<String> getDisabledAppNumMap() {
        return this.disabledAppNumMap.get(RequestContext.get().getAccountId());
    }

    void registerDisableApps(Set<String> disableApps) {
        this.disabledAppNumMap.put(RequestContext.get().getAccountId(), disableApps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePlan(Account account) {
        ScheduleVisitor scheduleVisitor = this.scheduleVisitor;
        synchronized (scheduleVisitor) {
            this.innerRemove(account);
        }
    }

    private void innerRemove(Account account) {
        logger.info("Schedule***Remove account:{}", (Object)account);
        for (Map<String, List<ScheduleInfo>> scheduleMap : this.scheduleVisitor.getSchedules().values()) {
            if (scheduleMap == null) continue;
            for (List<ScheduleInfo> schedules : scheduleMap.values()) {
                if (schedules == null) continue;
                Iterator<ScheduleInfo> it = schedules.iterator();
                while (it.hasNext()) {
                    ScheduleInfo scheduleInfo = it.next();
                    if (!StringUtils.equals((CharSequence)account.getAccountId(), (CharSequence)scheduleInfo.getAccountId()) || !StringUtils.equals((CharSequence)account.getTenantId(), (CharSequence)scheduleInfo.getTenantId())) continue;
                    it.remove();
                }
            }
        }
    }
}

