/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.server.next;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.OperationContextCreator;
import kd.bos.dataentity.Tuple;
import kd.bos.extension.ExtensionFactory;
import kd.bos.eye.api.appinfo.EyeNodeInfo;
import kd.bos.eye.api.log.LogQueryRequest;
import kd.bos.eye.api.log.LogQueryUtils;
import kd.bos.eye.api.mq.MqMgr;
import kd.bos.eye.api.speedtest.RedisTesterCreator;
import kd.bos.eye.api.speedtest.TestResultInfo;
import kd.bos.eye.api.speedtest.mq.MqTesterCreator;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.support.QueueManager;
import kd.bos.mservice.monitor.healthmanage.cluster.ClusterHealth;
import kd.bos.schedule.api.ExecutorServerInfo;
import kd.bos.schedule.api.SchCheckResult;
import kd.bos.schedule.api.ServerManager;
import kd.bos.schedule.message.rpc.RPCHelper;
import kd.bos.schedule.next.observable.ObservableLogHandler;
import kd.bos.schedule.next.observable.filter.Top5ScheduleTaskNumFilter;
import kd.bos.schedule.next.observable.model.ObservableScheduleInfo;
import kd.bos.schedule.next.observable.model.SchTaskNumInfo;
import kd.bos.schedule.server.next.ScheduleLogQueryCondition;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.service.ServiceFactory;
import kd.bos.threads.ThreadPools;
import kd.bos.util.JSONUtils;
import kd.bos.zk.ZKFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;

public class ServerObservableUtils {
    private static Log logger = LogFactory.getLog(ServerObservableUtils.class);
    private static ExtensionFactory<MqMgr> mqMgrExtensionFactory = ExtensionFactory.getExtensionFacotry(MqMgr.class);
    private static ServerManager sm = (ServerManager)ServiceFactory.getService(ServerManager.class);
    private static final String TRACE_LOG_KEY = "observable-tracelog";
    private static final String EXEMACHINE_KEY = "observable-exemachine";
    private static final String MASTER_SERVER_STATUS_FILTER_KEY = "observable-masterServerStatus";
    private static final DistributeSessionlessCache traceCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("observable-tracelog", new DistributeCacheHAPolicy(true, true));
    private static final DistributeSessionlessCache exeMachineCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("observable-exemachine", new DistributeCacheHAPolicy(true, true));
    private static final DistributeSessionlessCache masterServerRedisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("observable-masterServerStatus", new DistributeCacheHAPolicy(true, true));
    private static final String MASTERSERVERSTATUSFILTERKEY = "MasterServerStatusFilter$";

    public static JSONObject getMasterMachineStatus() {
        JSONObject res = new JSONObject();
        String id = "master";
        int result = ClusterHealth.getHealth((String)id);
        res.put(id, (Object)result);
        return res;
    }

    public static JSONObject getMiddlewareStatus() {
        JSONObject res = new JSONObject();
        List list = (List)ServerObservableUtils.SpeedTest().get("data");
        for (SpeedTestResult result : list) {
            if ("Redis".equals(result.getSubject())) {
                if (res.containsKey((Object)"redis") && res.getInteger("redis") != -1) continue;
                res.put("redis", (Object)result.getStatus());
                continue;
            }
            if (!"Mq".equals(result.getSubject())) continue;
            res.put("mq", (Object)result.getStatus());
        }
        if (ZkConfig.isSupportZk()) {
            String zk = "zk";
            SchCheckResult zkResult = ServerObservableUtils.checkZkConnected();
            int zkRes = zkResult.getCode() != null && zkResult.getCode() == 0 ? 1 : -1;
            res.put(zk, (Object)zkRes);
        }
        return res;
    }

    public static JSONArray getTop5ScheduleTaskNum() {
        if (ObservableLogHandler.getFilters((String)"kd.bos.schedule.server.next.observable.filter.Top5ScheduleTaskNumFilter") != null) {
            JSONArray ary = new JSONArray();
            JSONObject obj = new JSONObject();
            obj.put("name", (Object)"A");
            obj.put("scheduleId", (Object)"aeoso");
            obj.put("nums", (Object)"656");
            ary.add(0, (Object)obj);
            JSONObject obj1 = new JSONObject();
            obj1.put("name", (Object)"A1");
            obj1.put("scheduleId", (Object)"aeoso1");
            obj1.put("nums", (Object)"156");
            ary.add(1, (Object)obj1);
            JSONObject obj2 = new JSONObject();
            obj2.put("name", (Object)"A2");
            obj2.put("scheduleId", (Object)"aeoso2");
            obj2.put("nums", (Object)"2234");
            ary.add(2, (Object)obj2);
            JSONObject obj3 = new JSONObject();
            obj3.put("name", (Object)"A3");
            obj3.put("scheduleId", (Object)"aeoso3");
            obj3.put("nums", (Object)"5762");
            ary.add(3, (Object)obj3);
            JSONObject obj4 = new JSONObject();
            obj4.put("name", (Object)"A4");
            obj4.put("scheduleId", (Object)"aeoso");
            obj4.put("nums", (Object)"765");
            ary.add(4, (Object)obj4);
            JSONObject obj5 = new JSONObject();
            obj5.put("name", (Object)"A5");
            obj5.put("scheduleId", (Object)"aeoso5");
            obj5.put("nums", (Object)"997");
            ary.add(5, (Object)obj5);
            return ary;
        }
        return null;
    }

    public static JSONArray getTop5ExpendTimes() {
        if (ObservableLogHandler.getFilters((String)"kd.bos.schedule.server.next.observable.filter.Top5ScheduleTaskNumFilter") != null) {
            JSONArray ary = new JSONArray();
            JSONObject obj = new JSONObject();
            obj.put("name", (Object)"A");
            obj.put("taskId", (Object)"aeoso");
            obj.put("times", (Object)"53543");
            ary.add(0, (Object)obj);
            JSONObject obj1 = new JSONObject();
            obj1.put("name", (Object)"A1");
            obj1.put("taskId", (Object)"aeoso1");
            obj1.put("times", (Object)"156");
            ary.add(1, (Object)obj1);
            JSONObject obj2 = new JSONObject();
            obj2.put("name", (Object)"A2");
            obj2.put("taskId", (Object)"aeoso2");
            obj2.put("times", (Object)"2234");
            ary.add(2, (Object)obj2);
            JSONObject obj3 = new JSONObject();
            obj3.put("name", (Object)"A3");
            obj3.put("taskId", (Object)"aeoso3");
            obj3.put("times", (Object)"5762");
            ary.add(3, (Object)obj3);
            JSONObject obj4 = new JSONObject();
            obj4.put("name", (Object)"A4");
            obj4.put("taskId", (Object)"aeoso");
            obj4.put("times", (Object)"765");
            ary.add(4, (Object)obj4);
            JSONObject obj5 = new JSONObject();
            obj5.put("name", (Object)"A5");
            obj5.put("taskId", (Object)"aeoso5");
            obj5.put("times", (Object)"997");
            ary.add(5, (Object)obj5);
            return ary;
        }
        return null;
    }

    public static Map getTraceLog(String tenantId, String accountId, String scheduleId) {
        return traceCache.hgetAll(tenantId + "$" + accountId + "$" + scheduleId);
    }

    public static void openTrace(String tenantId, String accountId, String scheduleId, boolean open) {
        if (open) {
            traceCache.remove(tenantId + "$" + accountId + "$" + scheduleId);
            traceCache.hset(tenantId + "$" + accountId + "$" + scheduleId, "ENABLE_TRACE".getBytes(), "OPEN".getBytes(), 180);
        } else {
            traceCache.hset(tenantId + "$" + accountId + "$" + scheduleId, "ENABLE_TRACE".getBytes(), "CLOSE".getBytes(), 180);
        }
    }

    public static boolean schduleServerIsStarted() {
        return sm.schduleServerIsStarted();
    }

    public static List<ExecutorServerInfo> queryExecutorServerStatus() {
        return sm.queryExecutorServerStatus();
    }

    public static List<ExecutorServerInfo> queryExecutorServerStatus(String appId) {
        List clients = sm.queryExecutorServerStatus();
        Iterator itn = clients.iterator();
        while (itn.hasNext()) {
            ExecutorServerInfo info = (ExecutorServerInfo)itn.next();
            if (info.getAppIds().contains(appId)) continue;
            itn.remove();
        }
        return clients;
    }

    public static Map<String, Object> getMasterServerInfo() {
        return sm.getMasterServerInfo();
    }

    public static boolean isScheduleServiceStarted() {
        return sm.isScheduleServiceStarted();
    }

    public static SchCheckResult checkZkConnected() {
        SchCheckResult sr = sm.checkZkConnected();
        if (sr.getCode().intValue() == SchCheckResult.Status.OK.getCode()) {
            try {
                ServerObservableUtils.testZK(ZkConfig.getZkServer());
            }
            catch (Exception e) {
                logger.error("schedule***error", (Throwable)e);
                SchCheckResult.Status status = SchCheckResult.Status.ZKEXCEPTION;
                return SchCheckResult.create((Integer)status.getCode(), (String)(status.getStatus() + e.getMessage()));
            }
        }
        return sr;
    }

    private static void testZK(String url) {
        try {
            CuratorFramework client = ZKFactory.getZKClient((String)url);
            String rootPath = ZkConfig.getScheduleRootPath();
            String path = rootPath + "-zkspeedtest";
            Stat exists = (Stat)client.checkExists().forPath(path);
            if (exists == null) {
                ((ACLBackgroundPathAndBytesable)client.create().withMode(CreateMode.PERSISTENT)).forPath(path);
            }
            client.delete().forPath(path);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static SchCheckResult checkRedisConnected() {
        return sm.checkRedisConnected();
    }

    public static SchCheckResult checkMqConnected() {
        JSONObject jsonObject = ServerObservableUtils.getMiddlewareStatus();
        int mqResult = jsonObject.getInteger("mq");
        if (mqResult == -1) {
            return new SchCheckResult();
        }
        return SchCheckResult.success();
    }

    public static SchCheckResult checkExecutorService() {
        return sm.checkExecutorService();
    }

    public static SchCheckResult checkScheduleService() {
        return sm.checkScheduleService();
    }

    public static Map<String, Map<String, Integer>> getScheduleCycleData() {
        return (Map)RPCHelper.remoteGetScheduleMasterTimeWheel((String)RPCHelper.getMasterRpcIp(), (Object[])new Object[0]);
    }

    public static List<ObservableScheduleInfo> getScheduleDist(String repeatMode, String cron, String cyclePeriod) {
        return (List)RPCHelper.remoteGetScheduleMasterScheduleDist((String)RPCHelper.getMasterRpcIp(), (Object[])new Object[]{repeatMode, cron, cyclePeriod});
    }

    public static JSONArray logQuery(ScheduleLogQueryCondition scheduleLogQueryCondition) {
        SimpleDateFormat sdf = ServerObservableUtils.getLogQuerySimpleDateFormatUTC();
        try {
            LogQueryRequest queryRequest = new LogQueryRequest();
            ArrayList<String> times = new ArrayList<String>();
            if (scheduleLogQueryCondition.getBeginTime() == null) {
                Calendar instance = Calendar.getInstance();
                instance.add(5, -1);
                times.add(sdf.format(instance.getTime()));
            } else {
                times.add(sdf.format(scheduleLogQueryCondition.getBeginTime()));
            }
            if (scheduleLogQueryCondition.getEndTime() != null) {
                times.add(sdf.format(scheduleLogQueryCondition.getEndTime()));
            } else {
                times.add(sdf.format(new Date()));
            }
            queryRequest.setTime(times);
            queryRequest.setKeyword(scheduleLogQueryCondition.getKeyWord());
            logger.info("Schedule***logQuery keyWord : {},queryCount : {},beginTime : {},endTime : {}", new Object[]{scheduleLogQueryCondition.getKeyWord(), scheduleLogQueryCondition.getQueryCount(), scheduleLogQueryCondition.getBeginTime(), scheduleLogQueryCondition.getEndTime()});
            if (scheduleLogQueryCondition.getQueryCount() != null && scheduleLogQueryCondition.getQueryCount() != 0) {
                queryRequest.setSize(scheduleLogQueryCondition.getQueryCount().intValue());
            } else {
                queryRequest.setSize(100);
            }
            return LogQueryUtils.jsonToDataArray((String)LogQueryUtils.query((LogQueryRequest)queryRequest));
        }
        catch (Exception e) {
            logger.error("logquery error ", (Throwable)e);
            return null;
        }
    }

    private static SimpleDateFormat getLogQuerySimpleDateFormatUTC() {
        SimpleDateFormat simpleDateFormat = LogQueryUtils.getSimpleDateFormat();
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat;
    }

    public static Map SpeedTest() {
        List<TestResultInfo> rs = ServerObservableUtils.getTestResult();
        ArrayList resultList = new ArrayList();
        rs.forEach(v -> {
            SpeedTestResult speedTestResult = new SpeedTestResult();
            speedTestResult.setSubject(v.getName());
            speedTestResult.setUrl(v.getUrl());
            speedTestResult.setStatus(v.getStatus());
            String timeStamp = v.getTimestap() >= 0L ? v.getTimestap() + "ms" : "-";
            speedTestResult.setElapsedTime(timeStamp);
            speedTestResult.setDesc(v.getDes());
            speedTestResult.setStatusDesc(v.getStatusDes());
            resultList.add(speedTestResult);
        });
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("code", 0);
        response.put("data", resultList);
        response.put("msg", "success");
        return response;
    }

    private static List<TestResultInfo> getTestResult() {
        ArrayList testls = new ArrayList();
        testls.addAll(new RedisTesterCreator().getTesters());
        testls.addAll(new MqTesterCreator().getTesters());
        ArrayList<TestResultInfo> rs = new ArrayList<TestResultInfo>();
        CountDownLatch latch = new CountDownLatch(testls.size());
        testls.forEach(v -> {
            TestResultInfo tri = new TestResultInfo();
            tri.setName(v.getName());
            tri.setUrl(v.getUrl());
            tri.setTimestap(-1L);
            tri.setStatus(-1);
            tri.setStatusDes(v.getStatusDes());
            rs.add(tri);
            ThreadPools.executeOnce((String)"speedtest", () -> {
                v.getTestResult(tri);
                latch.countDown();
            });
            LockSupport.parkNanos(10000L);
        });
        try {
            boolean await = latch.await(6L, TimeUnit.SECONDS);
            if (!await) {
                OperationContextCreator.getOrCreateForBos();
            }
            return rs;
        }
        catch (InterruptedException var4) {
            return rs;
        }
    }

    public static JSONObject MqManager() {
        String mqType = "";
        Properties prop = new Properties();
        try {
            String property = System.getProperty("mq.server");
            StringReader reader = new StringReader(property);
            prop.load(reader);
            String vhost = prop.getProperty("vhost");
            mqType = QueueManager.getMQType((String)"NotExistRegion##@@!!");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("action", "queues");
            params.put("page", "1");
            params.put("sort", "messages_ready");
            params.put("asc", "des");
            params.put("page_size", "100");
            params.put("name", "schedule");
            params.put("vhost", vhost);
            JSONObject data = ((MqMgr)mqMgrExtensionFactory.getExtension(mqType)).process(params);
            data.put("vhost", (Object)vhost);
            return data;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<EyeNodeInfo> getSortedNodeInfos() {
        ArrayList<EyeNodeInfo> list = new ArrayList<EyeNodeInfo>();
        try {
            String hosts = System.getProperty("configUrl");
            CuratorFramework client = ZKFactory.getZKClient((String)hosts);
            String path = ServerObservableUtils.getRootPath();
            List child = (List)client.getChildren().forPath(path);
            for (String hk : child) {
                String json = new String((byte[])client.getData().forPath(path + "/" + hk), Charset.forName("UTF-8"));
                EyeNodeInfo nodeInfo = (EyeNodeInfo)JSONUtils.cast((String)json, EyeNodeInfo.class, (boolean)true);
                nodeInfo.setAppName(nodeInfo.getShowAppName());
                list.add(nodeInfo);
            }
            Comparator<EyeNodeInfo> byAppName = Comparator.comparing(EyeNodeInfo::getAppName);
            Comparator<EyeNodeInfo> byStartTime = Comparator.comparing(EyeNodeInfo::getStartTimestamp);
            list.sort(byAppName.thenComparing(byStartTime));
        }
        catch (Exception er) {
            throw new RuntimeException("Get monitor node error", er);
        }
        return list;
    }

    private static String getRootPath() {
        String hosts = System.getProperty("configUrl");
        return ZKFactory.getZkRootPath((String)hosts) + Instance.getClusterName() + "/runtime/monitor/nodes";
    }

    public static Map getNodeInfo() {
        List<EyeNodeInfo> serverNodes = ServerObservableUtils.getSortedNodeInfos();
        String clusterName = Instance.getClusterName();
        HashMap<String, Object> data = new HashMap<String, Object>(8);
        data.put("appNameList", serverNodes);
        data.put("clusterName", clusterName);
        return data;
    }

    public static Map<String, Object> getMasterServerStatus() {
        return (Map)RPCHelper.remoteGetScheduleMasterStatus((String)RPCHelper.getMasterRpcIp(), (Object[])new Object[0]);
    }

    public static List<Tuple<String, Integer>> getTop5SchTaskNumListToday() {
        ArrayList<Tuple<String, Integer>> res = new ArrayList<Tuple<String, Integer>>(8);
        List list = Top5ScheduleTaskNumFilter.getSchTaskNumList();
        for (SchTaskNumInfo info : list) {
            Tuple tuple = new Tuple((Object)info.getScheduleId(), (Object)info.getNum());
            res.add((Tuple<String, Integer>)tuple);
        }
        return res;
    }

    private static class SpeedTestResult {
        private String subject;
        private String url;
        private String elapsedTime;
        private String desc;
        private int status;
        private String statusDesc;

        private SpeedTestResult() {
        }

        public String getSubject() {
            return this.subject;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public String getElapsedTime() {
            return this.elapsedTime;
        }

        public void setElapsedTime(String elapsedTime) {
            this.elapsedTime = elapsedTime;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public String getStatusDesc() {
            return this.statusDesc;
        }

        public void setStatusDesc(String statusDesc) {
            this.statusDesc = statusDesc;
        }
    }
}

