/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.server.next.task;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.schedule.api.Task;
import kd.bos.schedule.api.TaskDao;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.server.ScheduleService;
import kd.bos.util.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class SchScheduleStatsTask
implements Task {
    private static final String TYPE_DAY = "DAY";
    private String taskId;

    public void setTaskId(String id) {
        this.taskId = id;
    }

    public void stop() throws KDException {
    }

    public void execute(RequestContext rc, Map<String, Object> param) throws KDException {
        String type = TYPE_DAY;
        Date dateTime = null;
        if (param.containsKey("time") && StringUtils.isNotEmpty((String)((String)param.get("time")))) {
            try {
                dateTime = DateUtils.parseDate((String)((String)param.get("time")), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
            }
            catch (ParseException e) {
                throw new KDException(BosErrorCode.bOS, "param time is illegal,time is " + param.get("time"), (Throwable)e);
            }
        }
        if (dateTime == null) {
            TaskDao taskDao = ScheduleService.getInstance().getObjectFactory().getTaskDao();
            TaskInfo taskInfo = taskDao.get(this.taskId);
            Date dispatchTime = new Date(taskInfo.getDispachTime());
            dateTime = DateUtils.addDays((Date)dispatchTime, (int)-1);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateTime);
        Date startTime = DateUtils.truncate(dateTime, (int)5);
        Date endTime = DateUtils.addDays((Date)startTime, (int)1);
        String sql = "select  tst.fscheduleid,count(1) as totalcount  from t_sch_task tst where fjobtype = 'BIZ' and fscheduleid is not null  and tst.fdispatchtime >= ? and tst.fdispatchtime < ? group by tst.fscheduleid ;";
        Object[] params = new SqlParameter[]{new SqlParameter(":fdispatchtime", 93, (Object)startTime), new SqlParameter(":fdispatchtime", 93, (Object)endTime)};
        Map res = (Map)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, resultSet -> {
            HashMap<String, Integer> result = new HashMap<String, Integer>(16);
            while (resultSet.next()) {
                String fscheduleid = resultSet.getString("fscheduleid");
                int totalcount = resultSet.getInt("totalcount");
                result.put(fscheduleid, totalcount);
            }
            return result;
        });
        String deleteSql = "delete from t_sch_schedulestats where FTYPE = ? and FTIME = ?";
        params = new SqlParameter[]{new SqlParameter(":FTYPE", 12, (Object)type), new SqlParameter(":FTIME", 93, (Object)startTime)};
        DB.execute((DBRoute)DBRoute.basedata, (String)deleteSql, (Object[])params);
        String insertSql = "insert into t_sch_schedulestats (FID,FTYPE,fscheduleid,ftotalcount,FTIME) values (?,?,?,?,?);";
        ArrayList<SqlParameter[]> paramss = new ArrayList<SqlParameter[]>(8);
        for (Map.Entry entry : res.entrySet()) {
            String scheduleId = (String)entry.getKey();
            int totalcount = (Integer)entry.getValue();
            SqlParameter[] param2 = new SqlParameter[]{new SqlParameter(":FID", -5, (Object)DB.genLongId((String)"t_sch_schedulestats")), new SqlParameter(":FTYPE", 12, (Object)type), new SqlParameter(":fscheduleid", 12, (Object)scheduleId), new SqlParameter(":ftotalcount", 4, (Object)totalcount), new SqlParameter(":FTIME", 93, (Object)startTime)};
            paramss.add(param2);
            if (paramss.size() < 2000) continue;
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql, paramss);
            paramss = new ArrayList(8);
        }
        if (!paramss.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql, paramss);
        }
        this.clearHistory(type, dateTime);
    }

    public void clearHistory(String type, Date dateTime) {
        dateTime = DateUtils.truncate((Date)dateTime, (int)2);
        dateTime = DateUtils.addMonths((Date)dateTime, (int)-3);
        String deleteSql = "delete from t_sch_schedulestats where FTIME < ? and FTYPE = ?;";
        Object[] params = new SqlParameter[]{new SqlParameter(":FTIME", 93, (Object)dateTime), new SqlParameter(":FTYPE", 12, (Object)type)};
        DB.execute((DBRoute)DBRoute.basedata, (String)deleteSql, (Object[])params);
    }
}

