/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.server.next.task;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.schedule.api.Task;
import kd.bos.schedule.api.TaskDao;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.server.ScheduleService;
import kd.bos.util.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class SchTaskStatusStatsTask
implements Task {
    private static final String TYPE_DAY = "STATUSDAY";
    private String taskId;

    public void setTaskId(String id) {
        this.taskId = id;
    }

    public void stop() throws KDException {
    }

    public void execute(RequestContext rc, Map<String, Object> param) throws KDException {
        String type = TYPE_DAY;
        Date dateTime = null;
        if (param.containsKey("time") && StringUtils.isNotEmpty((String)((String)param.get("time")))) {
            try {
                dateTime = DateUtils.parseDate((String)((String)param.get("time")), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
            }
            catch (ParseException e) {
                throw new KDException(BosErrorCode.bOS, "param time is illegal,time is " + param.get("time"), (Throwable)e);
            }
        }
        if (dateTime == null) {
            TaskDao taskDao = ScheduleService.getInstance().getObjectFactory().getTaskDao();
            TaskInfo taskInfo = taskDao.get(this.taskId);
            Date dispatchTime = new Date(taskInfo.getDispachTime());
            dateTime = DateUtils.addDays((Date)dispatchTime, (int)-1);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateTime);
        int value = calendar.get(5);
        Date startTime = DateUtils.truncate(dateTime, (int)5);
        Date endTime = DateUtils.addDays((Date)startTime, (int)1);
        String sql = "select count(fstatus) count,fstatus status,fjobtype jobtype from t_sch_task tst where fdispatchtime >= ? and fdispatchtime <= ? and fstatus in (?,?,?,?,?) group by fstatus,fjobtype;";
        Object[] params = new SqlParameter[]{new SqlParameter(":fdispatchtime", 93, (Object)startTime), new SqlParameter(":fdispatchtime", 93, (Object)endTime), new SqlParameter(":fstatus", 12, (Object)"COMPLETED"), new SqlParameter(":fstatus", 12, (Object)"SKIP"), new SqlParameter(":fstatus", 12, (Object)"FAILED"), new SqlParameter(":fstatus", 12, (Object)"ABORTED"), new SqlParameter(":fstatus", 12, (Object)"TIMEOUT")};
        List res = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, resultSet -> {
            ArrayList<ThreeTuple> result = new ArrayList<ThreeTuple>(16);
            while (resultSet.next()) {
                String status = resultSet.getString("status");
                if (StringUtils.isEmpty((String)status)) continue;
                String jobtype = resultSet.getString("jobtype");
                int num = resultSet.getInt("count");
                result.add(new ThreeTuple((Object)status, (Object)jobtype, (Object)num));
            }
            return result;
        });
        String deleteSql = "delete from T_SCH_TASKNUMSTATS where FTYPE = ? and FVALUE = ?;";
        params = new SqlParameter[]{new SqlParameter(":FTYPE", 12, (Object)type), new SqlParameter(":FVALUE", 4, (Object)value)};
        DB.execute((DBRoute)DBRoute.basedata, (String)deleteSql, (Object[])params);
        String insertSql = "insert into T_SCH_TASKNUMSTATS (FID,FTYPE,FVALUE,FCOUNT,FSTATUS,FTIME,FJOBTYPE) values (?,?,?,?,?,?,?);";
        ArrayList<SqlParameter[]> paramss = new ArrayList<SqlParameter[]>(8);
        for (ThreeTuple entry : res) {
            SqlParameter[] param2 = new SqlParameter[]{new SqlParameter(":FID", -5, (Object)DB.genLongId((String)"T_SCH_TASKNUMSTATS")), new SqlParameter(":FTYPE", 12, (Object)type), new SqlParameter(":FVALUE", 4, (Object)value), new SqlParameter(":FCOUNT", 4, entry.item3), new SqlParameter(":FSTATUS", 12, entry.item1), new SqlParameter(":FTIME", 12, (Object)startTime), new SqlParameter(":FJOBTYPE", 12, entry.item2)};
            paramss.add(param2);
        }
        if (!paramss.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql, paramss);
        }
        this.clearHistory(type, dateTime);
    }

    public void clearHistory(String type, Date dateTime) {
        dateTime = DateUtils.truncate((Date)dateTime, (int)2);
        dateTime = DateUtils.addMonths((Date)dateTime, (int)-3);
        String deleteSql = "delete from T_SCH_TASKNUMSTATS where FTIME < ? and FTYPE = ?;";
        Object[] params = new SqlParameter[]{new SqlParameter(":FTIME", 93, (Object)dateTime), new SqlParameter(":FTYPE", 12, (Object)type)};
        DB.execute((DBRoute)DBRoute.basedata, (String)deleteSql, (Object[])params);
    }
}

