/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.server.queueManager;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.MessageType;
import kd.bos.schedule.server.ExecutorResourceManager;
import kd.bos.schedule.server.ExecutorServerStatistic;
import kd.bos.schedule.server.queueManager.DistributeStrategy;
import kd.bos.schedule.server.queueManager.JobQueue;
import kd.bos.schedule.server.queueManager.RandomDistributeStrategy;
import kd.bos.schedule.zk.ActiveKeyValueStore;
import kd.bos.schedule.zk.ZkConfig;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.framework.recipes.cache.TreeCacheListener;

public class JobExecuteQueueManager {
    private static final Log log = LogFactory.getLog(JobExecuteQueueManager.class);
    private volatile boolean isStartFlag;
    private TreeCache queueMonitor;
    private ConcurrentMap<String, JobQueue> jobQueues;
    private ActiveKeyValueStore zkStore;
    private String queueRootPath = ZkConfig.getScheduleRootPath() + "/queues";
    private DistributeStrategy distributeStrategy;
    private static JobExecuteQueueManager instance = new JobExecuteQueueManager();

    private JobExecuteQueueManager() {
    }

    public static JobExecuteQueueManager get() {
        return instance;
    }

    public static JobExecuteQueueManager create() {
        return new JobExecuteQueueManager();
    }

    public void setQueueRootPath(String queueRootPath) {
        this.queueRootPath = queueRootPath;
    }

    public void start() {
        instance = this;
        this.zkStore = ActiveKeyValueStore.create();
        this.distributeStrategy = new RandomDistributeStrategy();
        this.init();
        this.isStartFlag = true;
        log.info("Schedule***JobExecuteQueueManager is starting");
    }

    public void stop() {
        this.queueMonitor.close();
        this.isStartFlag = false;
        log.info("Schedule***JobExecuteQueueManager is stoping");
    }

    public boolean isStart() {
        return this.isStartFlag;
    }

    public JobQueue getJobQueue(String queueName) {
        return (JobQueue)this.jobQueues.get(queueName);
    }

    public String decideJobDispatchQueue(MessageInfo message) {
        ArrayList<JobQueue> tmpJobQueue = new ArrayList<JobQueue>(this.jobQueues.values());
        ArrayList<ExecutorServerStatistic> tmpExecutors = new ArrayList<ExecutorServerStatistic>(ExecutorResourceManager.getInstance().getExecutorServers());
        return this.distributeStrategy.distribute(tmpJobQueue, tmpExecutors, message);
    }

    private void init() {
        this.jobQueues = new ConcurrentHashMap<String, JobQueue>();
        this.zkStore.ensureExisted(this.queueRootPath, null);
        this.queueMonitor = new TreeCache(this.zkStore.getCuratorFramework(), this.queueRootPath);
        TreeCacheListener listener = (client, event) -> {
            if (!(event.getType() != TreeCacheEvent.Type.NODE_ADDED && event.getType() != TreeCacheEvent.Type.NODE_REMOVED || event.getData().getPath().equals(this.queueRootPath))) {
                boolean isAddEvent = event.getType() == TreeCacheEvent.Type.NODE_ADDED;
                String path = event.getData().getPath();
                String afterRootPath = StringUtils.substringAfter((String)path, (String)(this.queueRootPath + "/"));
                String queueName = null;
                String executorName = null;
                if (!afterRootPath.contains("/")) {
                    queueName = afterRootPath;
                    if (isAddEvent) {
                        this.jobQueues.put(queueName, this.findJobQueue(path));
                    } else {
                        this.jobQueues.remove(queueName);
                    }
                } else {
                    queueName = StringUtils.substringBefore((String)afterRootPath, (String)"/");
                    executorName = StringUtils.substringAfterLast((String)afterRootPath, (String)"/");
                    JobQueue jobQueue = (JobQueue)this.jobQueues.get(queueName);
                    if (isAddEvent) {
                        jobQueue.addExecutor(executorName);
                    } else {
                        jobQueue.removeExecutor(executorName);
                    }
                }
            }
        };
        this.queueMonitor.getListenable().addListener((Object)listener);
        try {
            this.queueMonitor.start();
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        this.queueMonitor.getCurrentChildren(this.queueRootPath);
    }

    private JobQueue findJobQueue(String path) {
        List accessMsgTypes = SerializationUtils.fromJsonStringToList((String)this.zkStore.read(path, null), MessageType.class);
        List executor = this.zkStore.getChildren(path);
        return new JobQueue(StringUtils.substringAfterLast((String)path, (String)"/"), accessMsgTypes, executor);
    }
}

