/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.server.realtime;

import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.AbstractJobHandler;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.RouteMode;
import kd.bos.schedule.api.ShardingTask;
import kd.bos.schedule.api.Task;
import kd.bos.schedule.dao.dbImpl.TaskCache;

public class RealtimeJobHandler
extends AbstractJobHandler {
    Log log = LogFactory.getLog((String)"kd.bos.schedule.server.realtime.RealtimeJobHandler");
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));

    public void execute(RequestContext rc, MessageInfo message, JobInfo job) {
        String taskClassName = job.getTaskClassname();
        if (taskClassName == null) {
            ErrorCode ec = new ErrorCode("TASK_NAME_EMPTY", job.getlName() == null ? "" : job.getlName().toString());
            throw new KDException(ec, new Object[0]);
        }
        Class<?> taskClass = null;
        try {
            taskClass = Class.forName(taskClassName.trim());
        }
        catch (ClassNotFoundException e) {
            ErrorCode ec = new ErrorCode("TASK_NAME_EMPTY", taskClassName);
            throw new KDException((Throwable)e, ec, new Object[0]);
        }
        Task task = null;
        try {
            task = (Task)taskClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            ErrorCode ec = new ErrorCode("TASK_CLASS_INIT_FAILED", taskClassName);
            this.log.error("taskid" + message.getTaskId(), (Throwable)e);
            throw new KDException((Throwable)e, ec, new Object[0]);
        }
        task.setTaskId(message.getTaskId());
        task.setMessageHandle((MessageHandler)this);
        if (RouteMode.SHARDINGTASK == job.getRouteMode() && task instanceof ShardingTask) {
            ((ShardingTask)task).execute(rc, job.getParams(), job.getShardingParam());
            return;
        }
        task.execute(rc, job.getParams());
    }

    public static void TimeOut(String taskId) throws KDException {
        ErrorCode ec = new ErrorCode("TASK_TIMEOUT", taskId);
        throw new KDException(ec, new Object[0]);
    }

    public static void stop(String taskId) throws KDException {
        ErrorCode ec = new ErrorCode("TASK_STOPED_BY_USER", taskId);
        throw new KDException(ec, new Object[0]);
    }

    public boolean isStop(String taskId) {
        String type = "TASK";
        String key = RequestContext.get().getAccountId() + "_STOP_" + taskId;
        String stopVal = (String)cache.get(type, key);
        if (stopVal != null && stopVal.length() > 0) {
            return "stop".equalsIgnoreCase(stopVal);
        }
        return TaskCache.getStopStatus((String)taskId);
    }
}

