/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.server.redis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ExecutorServerInfo;
import kd.bos.schedule.redis.RedisConfig;
import kd.bos.schedule.server.ExecutorResourceManager;
import kd.bos.schedule.server.ExecutorServerStatistic;
import kd.bos.schedule.zk.ActiveKeyValueStore;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPools;

public class RedisExecutorResourceManager
extends ExecutorResourceManager {
    private static Log log = LogFactory.getLog(RedisExecutorResourceManager.class);
    private Thread serverMonitor = null;

    @Override
    public void start() {
        if (this.serverMonitor != null && !this.serverMonitor.isInterrupted()) {
            this.serverMonitor.interrupt();
        }
        this.serverMonitor = new Thread(ThreadLifeCycleManager.wrapRunnable(() -> {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    if (this.serverChanged()) {
                        this.doClearUp();
                    }
                    Thread.sleep((long)RedisConfig.getSelfCheck() * 1000L);
                }
                catch (Exception e) {
                    log.error("Schedule***Redis Executor Resource Manager serverMonitor error", (Throwable)e);
                }
            }
        }));
        this.serverMonitor.setDaemon(true);
        this.serverMonitor.setName("BOSSchedule-RedisExecutorRM-serverMonitor");
        this.serverMonitor.start();
        log.info("Schedule***Redis Executor Resource Manager is started.");
    }

    private void doClearUp() {
        ThreadPools.executeOnce((String)"BOSSchedule-RedisExecutorResourceManager-doClearUp", (Runnable)new Runnable(){

            @Override
            public void run() {
                RedisExecutorResourceManager.this.doClearUpJob();
            }
        });
    }

    private boolean serverChanged() {
        String data;
        Map serverMap = this.getStore().getChildrenData(RedisConfig.getExecutorServerPath(), null);
        if (this.executorServerMap.isEmpty()) {
            for (Map.Entry entry : serverMap.entrySet()) {
                String serviceName = (String)entry.getKey();
                String data2 = (String)entry.getValue();
                try {
                    ExecutorServerInfo info = (ExecutorServerInfo)SerializationUtils.fromJsonString((String)data2, ExecutorServerInfo.class);
                    this.newServerJoin(serviceName, info);
                }
                catch (Throwable t) {
                    log.error(String.format("Schedule***Redis Executor Resource Manager error. serviceName %s, data %s", serviceName, data2), t);
                }
            }
            return true;
        }
        for (Map.Entry entry : serverMap.entrySet()) {
            String serviceName = (String)entry.getKey();
            data = (String)entry.getValue();
            try {
                ExecutorServerInfo info = (ExecutorServerInfo)SerializationUtils.fromJsonString((String)data, ExecutorServerInfo.class);
                this.newServerJoin(serviceName, info);
            }
            catch (Throwable t) {
                log.error(String.format("Schedule***Redis Executor Resource Manager error. serviceName %s, data %s", serviceName, data), t);
            }
        }
        ArrayList<String> existedServerList = new ArrayList<String>();
        for (Map.Entry entry : this.executorServerMap.entrySet()) {
            data = (ExecutorServerStatistic)entry.getValue();
            if (System.currentTimeMillis() - data.getLastUpdateTime() <= (long)(RedisConfig.getSelfCheck() * 2) * 1000L) continue;
            existedServerList.add((String)entry.getKey());
        }
        this.executorServersExisted(existedServerList);
        this.buildWorkedAppGroup();
        return !existedServerList.isEmpty();
    }

    private ActiveKeyValueStore getStore() {
        return this.zkStore;
    }

    private void newServerJoin(String serverName, ExecutorServerInfo data) {
        try {
            if (data != null) {
                String group = (String)data.getDetail().get("curAppGroup");
                String appids = (String)data.getDetail().get("appids");
                this.workerAppGroupInfo.putIfAbsent(serverName, new HashMap());
                Map workerGroup = (Map)this.workerAppGroupInfo.get(serverName);
                if (group != null && appids != null) {
                    List appList = SerializationUtils.fromJsonStringToList((String)appids, String.class);
                    workerGroup.put(group, appList);
                }
                this.executorServerMap.put(serverName, ExecutorServerStatistic.fromServerInfo((ExecutorServerInfo)data));
            }
        }
        catch (Throwable t) {
            log.error(String.format("Schedule***Redis Executor Resource Manager newServerJoin error. serverName %s ", serverName), t);
        }
    }

    private void executorServersExisted(List<String> existedServerList) {
        for (String serverName : existedServerList) {
            this.executorServerMap.remove(serverName);
            this.workerAppGroupInfo.remove(serverName);
            this.getStore().deleteChildren(RedisConfig.getExecutorServerPath(), serverName);
            log.info("Schedule***\u6267\u884c\u673a" + serverName + "\u9000\u51fa\u4e86");
        }
    }

    @Override
    public void stop() {
        if (this.serverMonitor != null) {
            this.serverMonitor.interrupt();
        }
        log.info("Schedule***Redis Executor Resource Manager is stopped.");
    }
}

