/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.server.redis;

import java.util.Timer;
import java.util.TimerTask;
import kd.bos.elect.ElectFactory;
import kd.bos.elect.Elector;
import kd.bos.elect.ElectorListener;
import kd.bos.elect.impl.CompeteElector;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.message.AbstractService;
import kd.bos.schedule.redis.RedisConfig;
import kd.bos.schedule.server.ExecutorResourceManager;
import kd.bos.schedule.server.SchElectorWrapper;
import kd.bos.schedule.server.ScheduleService;
import kd.bos.schedule.server.ScheduleServiceWrapper;
import kd.bos.schedule.server.redis.RedisExecutorResourceManager;
import kd.bos.schedule.server.redis.SchRedisElecotrWrapper;
import kd.bos.schedule.zk.ActiveKeyValueStore;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPools;

public class RedisScheduleServiceWrapper
implements ScheduleServiceWrapper {
    private static Log log = LogFactory.getLog(RedisScheduleServiceWrapper.class);
    private final ScheduleService scheduleService;
    private Elector elector = null;
    private Thread keepAliveThread = null;

    public RedisScheduleServiceWrapper(ScheduleService scheduleService) {
        this.scheduleService = scheduleService;
    }

    @Override
    public String getName() {
        return "Redis Schedule Service";
    }

    @Override
    public SchElectorWrapper initElector() {
        String electClusterName = "Schedule.server_elector";
        if (this.isDev()) {
            electClusterName = electClusterName + "_" + RedisConfig.getHostIpAddress();
        }
        this.elector = ElectFactory.getElector((String)electClusterName);
        if (this.elector instanceof CompeteElector) {
            ((CompeteElector)this.elector).setHeartbeatIntervalSeconds(RedisConfig.getSelfCheck());
            ((CompeteElector)this.elector).setHeartbeatTimeOutSeconds(RedisConfig.getSelfCheck() * 4);
        }
        this.elector.registerListener(new ElectorListener(){

            public void notifyLostMaster() {
                if (RedisScheduleServiceWrapper.this.isDev()) {
                    return;
                }
                log.info("Schedule***notifyLostMaster");
                RedisScheduleServiceWrapper.this.scheduleService.stateChanged();
            }

            public void notifyMaster() {
                ThreadPools.executeOnce((String)"BOSSchedule-ScheduleService-Redis", () -> RedisScheduleServiceWrapper.this.innerBeginSchedule());
            }
        });
        return new SchRedisElecotrWrapper(this, this.elector);
    }

    private void innerBeginSchedule() {
        this.scheduleService.takeLeadership();
        if (this.scheduleService.isLeader()) {
            ActiveKeyValueStore redisStore = this.getScheduleService().getZkStore();
            redisStore.write(RedisConfig.getmasterServerBgTimePath(), String.valueOf(this.scheduleService.getMasterStartTime()));
        }
        if (this.keepAliveThread != null && !this.keepAliveThread.isInterrupted()) {
            this.keepAliveThread.interrupt();
        }
        this.keepAliveThread = new Thread(ThreadLifeCycleManager.wrapRunnable(() -> this.scheduleService.keepHeartbeat()));
        this.keepAliveThread.setDaemon(true);
        this.keepAliveThread.setName("BOSSchedule-RedisScheduleService-KeepAlive");
        this.keepAliveThread.start();
    }

    @Override
    public void stop() {
        log.info("Schedule***RedisScheduleService masterLost and retry");
        Timer timer = new Timer("BOSSchedule-RedisScheduleService-masterLost");
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                RedisScheduleServiceWrapper.this.innerBeginSchedule();
            }
        };
        timer.schedule(task, 180000L);
    }

    @Override
    public void stopLeader() {
        if (this.keepAliveThread != null) {
            this.keepAliveThread.interrupt();
        }
    }

    public ScheduleService getScheduleService() {
        return this.scheduleService;
    }

    @Override
    public boolean keepAlive() throws Exception {
        if (Thread.currentThread().isInterrupted()) {
            return false;
        }
        ActiveKeyValueStore redisStore = this.getScheduleService().getZkStore();
        redisStore.write(RedisConfig.getmasterServerBgTimePath(), String.valueOf(this.scheduleService.getMasterStartTime()));
        redisStore.write(RedisConfig.getMasterServerPath(), RedisConfig.getHostIpAddress());
        return true;
    }

    @Override
    public ExecutorResourceManager initExecutorResourceMrg() {
        return new RedisExecutorResourceManager();
    }

    ActiveKeyValueStore getStore() {
        return this.getScheduleService().getZkStore();
    }

    private boolean isDev() {
        return RedisConfig.getRunMode() == AbstractService.RunMode.Dev;
    }
}

