/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.server.schedulecreator;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dc.api.model.Account;
import kd.bos.instance.Instance;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobDao;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.RouteMode;
import kd.bos.schedule.api.ScheduleDao;
import kd.bos.schedule.api.ScheduleInfo;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.ScheduleMsgInfo;
import kd.bos.schedule.message.AbstractService;
import kd.bos.schedule.server.ScheduleService;
import kd.bos.schedule.server.queueManager.IScheduleMqRoute;
import kd.bos.schedule.server.schedulecreator.SchVisitorStatus;
import kd.bos.schedule.server.schedulecreator.ScheduleVisitor;
import kd.bos.schedule.utils.RequestContextUtils;
import kd.bos.schedule.zk.ActiveKeyValueStore;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.threads.ThreadPools;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;

public class ScheduleMonitor
implements Runnable,
ScheduleManager {
    private static final Log logger = LogFactory.getLog(ScheduleMonitor.class);
    private static final DBRoute Sch_Route = DBRoute.basedata;
    private static final String READED = "readed";
    private static final String FCLASSNAME = "fclassname";
    private static final String FOVERTIME = "fovertime";
    private static final String FJOBMSGRECEIVER = "fjobmsgreceiver";
    private static final String FJOBPRINCIPAL = "fjobprincipal";
    private ScheduleVisitor scheduleVisitor;
    protected ActiveKeyValueStore zkStore = null;
    private PathChildrenCache scheduleChangeListener;
    private PathChildrenCache jobChangeListener;
    private static IScheduleMqRoute mqroute = new IScheduleMqRoute(){};
    private Map<String, String> cloudMapping;
    private volatile boolean isStop = false;
    private static final String FPARAMS = "fparams";
    private static final String FTASK_CLASSNAME = "ftaskclassname";
    private static final String FCONCURRENT = "fconcurrent";
    private static final String FFAIL_NOTIFY = "ffailnotify";
    private static final String FSUCCESS_NOTIFY = "fsuccessnotify";
    private static final String FMSGCONTENT = "fmsgcontent";
    private static final String FNOTIFY_TYPE = "fnotifytype";
    private static final String FCAPTION = "fcaption";
    private static final String FJOB_TYPE = "fjobtype";
    private static final String FRUN_BY_USERID = "frunbyuserid";
    private static final String FNUMBER = "fnumber";
    private static final String FRUN_BY_ORGID = "frunbyorgid";
    private static final String FRUN_BY_LANG = "frunbylang";
    private static final String FSTRATEGY = "fstrategy";
    private static final String FAPPID = "fappid";
    private static final String FRUNMODE = "frunmode";
    public static final String FTASKCLASS = "ftaskclass";
    public static final String FABORTED = "faborted";
    private static final String BOS_SCHEDULE_CORE = "bos-schedule-core";

    public ScheduleMonitor(ScheduleVisitor scheduleVisitor) {
        this.scheduleVisitor = scheduleVisitor;
    }

    public static IScheduleMqRoute getMqroute() {
        return mqroute;
    }

    public static void registerMqroute(IScheduleMqRoute mqroute) {
        ScheduleMonitor.mqroute = mqroute;
    }

    public void startToListenScheduleChange() {
        this.zkStore = ActiveKeyValueStore.create();
        this.scheduleChangeListener = new PathChildrenCache(this.zkStore.getCuratorFramework(), ZkConfig.getScheduleChangedMessagePath(), true);
        this.jobChangeListener = new PathChildrenCache(this.zkStore.getCuratorFramework(), ZkConfig.getJobChangedMessagePath(), true);
        PathChildrenCacheListener listener = (client, event) -> {
            if (event.getType() == PathChildrenCacheEvent.Type.CHILD_ADDED || event.getType() == PathChildrenCacheEvent.Type.CHILD_UPDATED) {
                List children = this.zkStore.getChildren(ZkConfig.getScheduleChangedMessagePath());
                this.processChanged(children);
            }
        };
        PathChildrenCacheListener jobListener = (client, event) -> {
            if (event.getType() == PathChildrenCacheEvent.Type.CHILD_ADDED) {
                List children = this.zkStore.getChildren(ZkConfig.getJobChangedMessagePath());
                this.jobProcessChanged(children);
            }
        };
        this.scheduleChangeListener.getListenable().addListener((Object)listener);
        this.jobChangeListener.getListenable().addListener((Object)jobListener);
        try {
            this.scheduleChangeListener.start();
            this.jobChangeListener.start();
        }
        catch (Exception e) {
            logger.error("Schedule***\u8ba1\u5212\u53d8\u66f4\u4fa6\u542c\u5668\u542f\u52a8\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void run() {
        try {
            logger.info("Schedule***ScheduleMonitor begin to run. ");
            this.isStop = false;
            this.execute();
        }
        catch (Throwable t) {
            logger.error("Schedule***ScheduleMonitor error", t);
        }
        finally {
            logger.info("Schedule***ScheduleMonitor stop to run.");
            this.isStop = true;
        }
    }

    private void processChanged(List<String> changeMsgList) {
        for (String changeNode : changeMsgList) {
            String changePath = ZkConfig.getScheduleChangedMessagePath() + "/" + changeNode;
            String message = this.zkStore.read(changePath, null);
            if (READED.equals(message)) continue;
            this.zkStore.write(changePath, READED);
            Map changeMsgMap = (Map)SerializationUtils.fromJsonString((String)message, Map.class);
            logger.info("Schedule***processChanged : " + message);
            String flag = (String)changeMsgMap.get("flag");
            String tenantId = (String)changeMsgMap.get("tenantId");
            String accountId = (String)changeMsgMap.get("accountId");
            String userId = (String)changeMsgMap.get("userId");
            String jobIds = (String)changeMsgMap.get("jobIds");
            List<Object> jobIdList = StringUtils.isNotBlank((CharSequence)jobIds) ? Arrays.asList(jobIds.split(",")) : new ArrayList(1);
            ThreadPools.executeOnce((String)"BOSSchedule-ScheduleChangeExecute", () -> {
                RequestContextUtils.createRequestContext((String)tenantId, (String)accountId, (String)userId);
                String scheduleId = (String)changeMsgMap.get("scheduleId");
                if ("Add".equals(flag)) {
                    this.afterAddSchedule(scheduleId);
                } else if ("Update".equals(flag)) {
                    this.afterUpdateSchedule(scheduleId, jobIdList);
                } else if ("Delete".equals(flag)) {
                    if (jobIdList.isEmpty()) {
                        this.afterDeleteSchedule(scheduleId);
                    } else {
                        this.afterDeleteSchedule(scheduleId, jobIdList);
                    }
                } else if ("Disable".equals(flag)) {
                    if (jobIdList.isEmpty()) {
                        this.disableSchedule(scheduleId);
                    } else {
                        ScheduleDao scheduleDao = ScheduleService.getInstance().getObjectFactory().getScheduleDao();
                        scheduleDao.disableSchedule(scheduleId);
                        this.afterDeleteSchedule(scheduleId, jobIdList);
                    }
                } else if ("Enable".equals(flag)) {
                    this.enableSchedule(scheduleId);
                }
            });
            try {
                this.zkStore.delete(changePath);
            }
            catch (Exception e) {
                logger.error("Schedule***schedulecreate:", (Throwable)e);
            }
        }
        for (String changeNode : changeMsgList) {
            this.zkStore.delete(ZkConfig.getScheduleChangedMessagePath() + "/" + changeNode);
        }
    }

    private void jobProcessChanged(List<String> changeMsgList) {
        for (String changeNode : changeMsgList) {
            String changePath = ZkConfig.getJobChangedMessagePath() + "/" + changeNode;
            String message = this.zkStore.read(changePath, null);
            if (!READED.equals(message)) {
                this.zkStore.write(changePath, READED);
                Map changeMsgMap = (Map)SerializationUtils.fromJsonString((String)message, Map.class);
                logger.info("Schedule***jobProcessChanged : " + message);
                String flag = (String)changeMsgMap.get("flag");
                String tenantId = (String)changeMsgMap.get("tenantId");
                String accountId = (String)changeMsgMap.get("accountId");
                String userId = (String)changeMsgMap.get("userId");
                String scheduleIds = (String)changeMsgMap.get("scheduleIds");
                List scheduleIdList = StringUtils.isNotBlank((CharSequence)scheduleIds) ? SerializationUtils.fromJsonStringToList((String)scheduleIds, String.class) : new ArrayList(1);
                ThreadPools.executeOnce((String)"BOSSchedule-SchedulejobChangeExecute", () -> {
                    RequestContextUtils.createRequestContext((String)tenantId, (String)accountId, (String)userId);
                    String jobId = (String)changeMsgMap.get("jobId");
                    if ("Disable".equals(flag)) {
                        if (scheduleIdList.isEmpty()) {
                            this.disableJob(jobId);
                        } else {
                            this.afterDisableJobWithScheduleIds(jobId, scheduleIdList);
                        }
                    } else if ("Enable".equals(flag)) {
                        this.enableJob(jobId);
                    } else if ("Update".equals(flag)) {
                        this.afterUpdateJob(jobId);
                    } else if ("Delete".equals(flag)) {
                        if (scheduleIdList.isEmpty()) {
                            this.afterDeleteJob(jobId);
                        } else {
                            this.afterDeleteJobWithScheduleIds(jobId, scheduleIdList);
                        }
                    }
                });
                try {
                    this.zkStore.delete(changePath);
                }
                catch (Exception e) {
                    logger.error("Schedule***zkStore.delete error", (Throwable)e);
                }
                continue;
            }
            try {
                this.zkStore.delete(changePath);
            }
            catch (Exception e) {
                logger.error("Schedule***zkStore delete error!", (Throwable)e);
            }
        }
    }

    public void execute() {
        logger.info("Schedule***ScheduleMonitor is running.");
        while (!this.isStop) {
            long beginat = System.currentTimeMillis();
            try {
                this.oneCycle();
            }
            catch (Exception e) {
                logger.error("Schedule***onCycle error", (Throwable)e);
            }
            int INTERVAL_GENERATE_SCHEDULE_MS = ZkConfig.getInterval4ScheduleGenerate() * 60 * 1000;
            long cost = System.currentTimeMillis() - beginat;
            logger.info("Schedule***ScheduleMonitor oneCycle cost " + cost);
            long sleeptime = (long)INTERVAL_GENERATE_SCHEDULE_MS - cost;
            if (sleeptime > 0L) {
                try {
                    Thread.sleep(sleeptime);
                }
                catch (InterruptedException e) {
                    logger.error("Schedule***Thread.sleep error!", (Throwable)e);
                }
                continue;
            }
            logger.error("Schedule***ScheduleMonitor oneCycle exceed INTERVAL_GENERATE_SCHEDULE_MS. there is a risk. cost:{}", (Object)cost);
        }
    }

    public void oneCycle() {
        if (this.scheduleVisitor.getStatus() == SchVisitorStatus.Paused) {
            return;
        }
        ConcurrentMap<String, Account> accounts = this.scheduleVisitor.getElectedAccountsOfCluster();
        for (Map.Entry row : accounts.entrySet()) {
            this.scanPlan((Account)row.getValue());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void scanPlan(Account account) {
        String tenantId = account.getTenantId();
        String accountId = account.getAccountId();
        if (this.isStop) {
            return;
        }
        RequestContextUtils.createRequestContext((String)tenantId, (String)accountId, null);
        logger.info("Schedule***\u540e\u53f0\u4e8b\u52a1\u5f00\u59cb\u626b\u63cf\u5e10\u5957:" + account.getAccountName() + " \u751f\u6210\u8c03\u5ea6\u8ba1\u5212");
        try (TXHandle h = TX.requiresNew((String)this.getClass().getName());){
            List<ScheduleInfo> enableScheduleInfos = this.genScheduleInfos(null);
            for (ScheduleInfo info : enableScheduleInfos) {
                if (this.isStop) {
                    return;
                }
                try {
                    this.genSchedule(info, false);
                }
                catch (Throwable throwable) {
                    logger.error("Schedule***\u751f\u6210\u8c03\u5ea6\u8ba1\u5212\u51fa\u73b0\u5f02\u5e38\uff0caccountId = " + info.getAccountId() + "\uff0cscheduleId = " + info.getId(), throwable);
                    throw throwable;
                    return;
                }
            }
        }
        catch (Throwable t) {
            logger.error("Schedule***\u540e\u53f0\u4e8b\u52a1\u5728\u626b\u63cf\u5e10\u5957\uff1a" + accountId + " \u53d1\u751f\u5f02\u5e38", t);
        }
    }

    private List<ScheduleInfo> genScheduleInfos(String scheduleId) {
        RequestContext rc = RequestContext.get();
        String tenantId = rc.getTenantId();
        String accountId = rc.getAccountId();
        this.initCloudMapping();
        Calendar crEndtime = Calendar.getInstance();
        crEndtime.add(12, ZkConfig.getDelay4ScheduleGenerate());
        Calendar crStarttime = Calendar.getInstance();
        crStarttime.add(12, ZkConfig.getInterval4ScheduleGenerate() + 1);
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("select  j1.fjobid as ftaskjobid, j1.fid,j1.fstarttime,j1.fendtime,j1.fplan,j1.frepeatmode,j1.fcyclenum,j1.fjobid,j1.fsfailnotify,j1.fssuccessnotify,j1.fsnotifytype,j1.fsmsgcontent,j1.fmsgreceiver,j1.fschprincipal,j1.fstimeout,").append("t3.fjobtype,t3.ftaskclassname,t3.frunbyuserid,t3.fparams,t3.fnumber,t3.frunbyorgid,t3.frunbylang,t3.fconcurrent,t3.fstatus,t3.fstrategy,t3.frunmode,t3.fretrytime,t3.ftimeout,t3.fcanstop,t3.ftasktrace,").append("t3n.fjobprincipal,t3n.ffailnotify,t3n.fsuccessnotify,t3n.faborted,t3n.fmsgcontent,t3n.fnotifytype,t3n.fcaption,t3n.fovertime,t3n.fjobmsgreceiver,").append("t4.fappid,t4.fclassname,t4.fclassname as ftaskclass").append(" from ").append("(select case when t2.fjobnumber is null  then  t1.fjobid when t2.fjobnumber = '' then t1.fjobid when t2.fjobnumber = ' ' then t1.fjobid else t2.fjobnumber end as fjobid,t1.fid,t1.fstarttime,t1.fendtime,t1.fplan,t1.frepeatmode,t1.fcyclenum,t1.fhost,t1.fstatus,t1n.fsfailnotify,t1n.fssuccessnotify,t1n.fsnotifytype,t1n.fmsgreceiver,t1n.fsmsgcontent,t1n.fschprincipal,t1n.fstimeout from t_sch_schedule as t1 left outer join t_sch_schedule_n as t1n on t1.fid = t1n.fid left join t_sch_schedule_entry t2 on t1.fid = t2.fid) as j1 ").append("left join t_sch_job t3 on j1.fjobid = t3.fid ").append("left outer join t_sch_job_n as t3n on t3.fid = t3n.fid ").append("left outer join t_sch_taskdefine as t4 on t4.fid = t3.ftaskdefineid ").append("where j1.fstarttime <= ? and j1.fendtime >= ? ").append("and j1.fstatus = '1' and t3.fstatus = '1' ");
        Object[] params = null;
        boolean isGenById = StringUtils.isNotBlank((CharSequence)scheduleId);
        if (ZkConfig.getRunMode() == AbstractService.RunMode.Dev) {
            sqlSb.append(" and j1.fhost = ? ");
            if (isGenById) {
                sqlSb.append(" and j1.fid = ? ");
                params = new SqlParameter[4];
                params[3] = new SqlParameter(":fid", 12, (Object)scheduleId);
            } else {
                params = new SqlParameter[3];
            }
            String ipAddress = AbstractService.getHostIpAddress();
            params[2] = new SqlParameter(":fhost", 12, (Object)ipAddress);
        } else if (isGenById) {
            sqlSb.append(" and j1.fid = ? ");
            params = new SqlParameter[3];
            params[2] = new SqlParameter(":fid", 12, (Object)scheduleId);
        } else {
            params = new SqlParameter[]{new SqlParameter(":fstarttime", 93, (Object)new Timestamp(crStarttime.getTimeInMillis())), new SqlParameter(":fendtime", 93, (Object)new Timestamp(crEndtime.getTimeInMillis()))};
        }
        List<Object> listData = new ArrayList<ScheduleInfo>();
        try (TraceSpan tracer = Tracer.create((String)"scheduleMonitor", (String)("onecycle for :" + tenantId));){
            listData = (List)DB.query((DBRoute)Sch_Route, (String)sqlSb.toString(), (Object[])params, rs -> {
                ArrayList<ScheduleInfo> listData1 = new ArrayList<ScheduleInfo>(10);
                while (rs.next()) {
                    ScheduleInfo info = this.toInfo(rs, tenantId, accountId);
                    listData1.add(info);
                }
                return listData1;
            });
        }
        catch (Exception e) {
            logger.error("Schedule***\u540e\u53f0\u4e8b\u52a1\u5728\u626b\u63cf\u5e10\u5957\uff1a" + accountId + " \u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        this.cloudMapping = null;
        return listData;
    }

    private ScheduleInfo toInfo(ResultSet rs, String tenantId, String accountId) throws SQLException {
        ScheduleInfo info = new ScheduleInfo();
        String fid = rs.getString("fid");
        info.setId(fid);
        Timestamp startTime = rs.getTimestamp("fstarttime");
        info.setStartTime(startTime.getTime());
        info.setEndTime(rs.getTimestamp("fendtime").getTime());
        info.setPlan(rs.getString("fplan"));
        JobInfo jobInfo = new JobInfo();
        String newClassName = rs.getString(FCLASSNAME);
        jobInfo.setId(rs.getString("fjobid"));
        if (StringUtils.isNotBlank((CharSequence)newClassName)) {
            jobInfo.setTaskClassname(newClassName);
        } else {
            jobInfo.setTaskClassname(rs.getString(FTASK_CLASSNAME));
        }
        jobInfo.setFailNotify(rs.getBoolean(FFAIL_NOTIFY));
        jobInfo.setSuccessNotify(rs.getBoolean(FSUCCESS_NOTIFY));
        jobInfo.setNotifyType(rs.getString(FNOTIFY_TYPE));
        jobInfo.setJobPrincipal(rs.getLong(FJOBPRINCIPAL));
        jobInfo.setCaption(rs.getString(FCAPTION));
        jobInfo.setJobMsgReceiver(rs.getLong(FJOBMSGRECEIVER));
        jobInfo.setOverTime(rs.getBoolean(FOVERTIME));
        jobInfo.setAborted(rs.getBoolean(FABORTED));
        jobInfo.setMsgContent(rs.getString(FMSGCONTENT));
        jobInfo.setRunConcurrently("1".equals(rs.getString(FCONCURRENT)));
        String jobTypeStr = rs.getString(FJOB_TYPE);
        this.setJobType(jobInfo, jobTypeStr);
        String routeMode = rs.getString(FRUNMODE);
        jobInfo.setTimeout(rs.getInt("ftimeout"));
        jobInfo.setRetryTime(rs.getInt("fretrytime"));
        jobInfo.setCanStop(Boolean.valueOf(rs.getBoolean("fcanstop")));
        this.setRouteMode(jobInfo, routeMode);
        jobInfo.setRunByUserId(rs.getLong(FRUN_BY_USERID));
        jobInfo.setRunByOrgId(rs.getLong(FRUN_BY_ORGID));
        String runByLang = rs.getString("FRUNBYLANG");
        if (StringUtils.isNotEmpty((CharSequence)runByLang)) {
            jobInfo.setRunByLang(Lang.from((String)runByLang));
        }
        jobInfo.setNumber(rs.getString(FNUMBER));
        String fparams = rs.getString(FPARAMS);
        this.setParams(jobInfo, fparams);
        jobInfo.setStrategy(rs.getString(FSTRATEGY));
        String feappid = rs.getString(FAPPID);
        this.setAppId(jobInfo, feappid);
        jobInfo.setScheduleId(info.getId());
        ScheduleMsgInfo smi = new ScheduleMsgInfo();
        smi.setFailNotify(rs.getBoolean("fsfailnotify"));
        smi.setSuccessNotify(rs.getBoolean("fssuccessnotify"));
        smi.setNotifyType(rs.getString("fsnotifytype"));
        smi.setMsgreceiver(rs.getLong("fmsgreceiver"));
        smi.setMsgContent(rs.getString("fsmsgcontent"));
        smi.setSchPrincipal(rs.getLong("fschprincipal"));
        smi.setTimeOut(rs.getBoolean("fstimeout"));
        smi.setAborted(rs.getBoolean(FABORTED));
        jobInfo.setScheduleMsgInfo(smi);
        info.setJobInfo(jobInfo);
        info.setJobId(jobInfo.getId());
        info.setTenantId(tenantId);
        info.setAccountId(accountId);
        return info;
    }

    private void setAppId(JobInfo jobInfo, String appNum) {
        if (mqroute == null) {
            ScheduleMonitor.registerMqroute(new IScheduleMqRoute(){});
        }
        if (StringUtils.isBlank((CharSequence)appNum) || mqroute.isBosCloud(this.getCloudIdByAppNum(appNum))) {
            jobInfo.setAppId("bos");
        } else {
            jobInfo.setAppId(appNum);
        }
    }

    private void setParams(JobInfo jobInfo, String fparams) {
        if (fparams != null && fparams.trim().length() > 0) {
            try {
                Map params = (Map)SerializationUtils.fromJsonString((String)fparams, Map.class);
                jobInfo.setParams(params);
            }
            catch (Exception exp) {
                logger.info("Schedule***job \u53c2\u6570\u9519\u8bef" + exp.getMessage());
            }
        }
    }

    private void setJobType(JobInfo jobInfo, String jobTypeStr) {
        if (jobTypeStr == null || jobTypeStr.equalsIgnoreCase("BIZ")) {
            jobInfo.setJobType(JobType.BIZ);
        } else if (jobTypeStr.equalsIgnoreCase("WORKFLOW")) {
            jobInfo.setJobType(JobType.WORKFLOW);
        } else if (jobTypeStr.equalsIgnoreCase("REALTIME")) {
            jobInfo.setJobType(JobType.REALTIME);
        }
    }

    private void setRouteMode(JobInfo jobInfo, String routeMode) {
        if (routeMode == null || routeMode.equalsIgnoreCase("0")) {
            jobInfo.setRouteMode(RouteMode.RAMDOM);
        } else if (routeMode.equalsIgnoreCase("1")) {
            jobInfo.setRouteMode(RouteMode.SHARDINGBROADCAST);
        } else if (routeMode.equalsIgnoreCase("2")) {
            jobInfo.setRouteMode(RouteMode.SHARDINGTASK);
        }
    }

    private void initCloudMapping() {
        if (this.cloudMapping == null) {
            String sql = "select fappid,fcloudid from t_meta_appruntime";
            try (TXHandle handle = TX.notSupported();){
                this.cloudMapping = (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, null, rs -> {
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    while (rs.next()) {
                        String cloudId = rs.getString("fcloudid");
                        String appnum = rs.getString(FAPPID);
                        map.put(appnum, cloudId);
                    }
                    return map;
                });
            }
        }
    }

    private Map<String, String> getCloudMapping() {
        if (this.cloudMapping == null) {
            this.initCloudMapping();
        }
        return this.cloudMapping;
    }

    private String getCloudIdByAppNum(String appNum) {
        if (this.cloudMapping == null) {
            this.cloudMapping = this.getCloudMapping();
        }
        return this.cloudMapping.get(appNum);
    }

    private void fillOrgId(ScheduleInfo info) {
        String error;
        JobInfo jobInfo = info.getJobInfo();
        if (jobInfo.getRunByOrgId() != 0L) {
            return;
        }
        long orgId = 0L;
        String sql = "";
        Object[] params = new SqlParameter[]{new SqlParameter(":FUSERID", -5, (Object)jobInfo.getRunByUserId())};
        try {
            sql = "select FORGID from T_BAS_USERDEFAULTORG where FUSERID = ?";
            orgId = (Long)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Long>(){

                public Long handle(ResultSet rs) throws Exception {
                    Long orgId = 0L;
                    if (rs.next()) {
                        orgId = rs.getLong("FORGID");
                        return orgId;
                    }
                    return orgId;
                }
            });
        }
        catch (Exception e) {
            error = String.format(ResManager.loadKDString((String)"\u540e\u53f0\u4e8b\u52a1\u5f02\u5e38,AppName: %1$s,InstanceId: %2$s,scheduleId: %3$s ,errorInfo: %4$s", (String)"ScheduleMonitor_0", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]), Instance.getAppName(), Instance.getInstanceId(), info.getId(), e.getMessage());
            logger.error("Schedule***jobprocessor error:" + error);
        }
        if (orgId != 0L) {
            info.getJobInfo().setRunByOrgId(orgId);
            return;
        }
        try {
            sql = "select  FORGID from T_PERM_USERPERM where FUSERID = ?";
            orgId = (Long)DB.query((DBRoute)DBRoute.permission, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Long>(){

                public Long handle(ResultSet rs) throws Exception {
                    Long orgId = 0L;
                    if (rs.next()) {
                        orgId = rs.getLong("FORGID");
                        return orgId;
                    }
                    return orgId;
                }
            });
        }
        catch (Exception e) {
            error = String.format(ResManager.loadKDString((String)"\u540e\u53f0\u4e8b\u52a1\u5f02\u5e38,AppName: %1$s,InstanceId: %2$s,scheduleId: %3$s ,errorInfo: %4$s", (String)"ScheduleMonitor_0", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]), Instance.getAppName(), Instance.getInstanceId(), info.getId(), e.getMessage());
            logger.error("Schedule***jobprocessor error:" + error);
        }
        info.getJobInfo().setRunByOrgId(orgId);
    }

    private void genSchedule(ScheduleInfo info, boolean isRefresh) {
        if (this.scheduleVisitor.getStatus() == SchVisitorStatus.Paused) {
            return;
        }
    }

    public void afterAddSchedule(String id) {
        this.afterUpdateSchedule(id);
    }

    public void afterDeleteSchedule(String scheduleId) {
        ScheduleDao scheduleDao = ScheduleService.getInstance().getObjectFactory().getScheduleDao();
        List jobIds = scheduleDao.getJobIdByScheduleId(scheduleId);
        this.afterDeleteSchedule(scheduleId, jobIds);
    }

    public void afterUpdateSchedule(String scheduleId) {
        this.afterDeleteSchedule(scheduleId);
        List<ScheduleInfo> genScheduleInfos = this.genScheduleInfos(scheduleId);
        for (ScheduleInfo scheduleInfo : genScheduleInfos) {
            this.genSchedule(scheduleInfo, true);
        }
    }

    public synchronized boolean isStoped() {
        return this.isStop;
    }

    public synchronized void stop() {
        try {
            this.scheduleChangeListener.close();
            this.jobChangeListener.close();
        }
        catch (IOException e) {
            logger.error("Schedule***stop error!", (Throwable)e);
        }
        this.isStop = true;
        logger.info("Schedule***ScheduleMonitor.stop() stop to run.", (Object)new Exception());
    }

    public void enableSchedule(String scheduleId) {
        ScheduleDao scheduleDao = ScheduleService.getInstance().getObjectFactory().getScheduleDao();
        scheduleDao.enableSchedule(scheduleId);
        this.afterUpdateSchedule(scheduleId);
    }

    public void disableSchedule(String scheduleId) {
        ScheduleDao scheduleDao = ScheduleService.getInstance().getObjectFactory().getScheduleDao();
        scheduleDao.disableSchedule(scheduleId);
        this.afterDeleteSchedule(scheduleId);
    }

    public void enableJob(String jobId) {
        if (!StringUtils.isNotBlank((CharSequence)jobId)) {
            return;
        }
        this.enableJob(jobId, true);
    }

    public void disableJob(String jobId) {
        if (!StringUtils.isNotBlank((CharSequence)jobId)) {
            return;
        }
        this.disableJob(jobId, true);
    }

    public void afterDeleteJob(String jobId) {
        List<String> ids = this.getScheduleIdByJob(jobId);
        if (ids == null || ids.isEmpty()) {
            return;
        }
        for (String scheduleId : ids) {
            ScheduleInfo info = new ScheduleInfo();
            info.setId(scheduleId);
            info.setTenantId(RequestContext.get().getTenantId());
            info.setAccountId(RequestContext.get().getAccountId());
            info.setJobId(jobId);
        }
    }

    private void afterDisableJobWithScheduleIds(String jobId, List<String> scheduleIds) {
        if (StringUtils.isBlank((CharSequence)jobId)) {
            return;
        }
        JobDao jobDao = ScheduleService.getInstance().getObjectFactory().getJobDao();
        jobDao.disableJob(jobId);
        this.afterDeleteJobWithScheduleIds(jobId, scheduleIds);
    }

    private void afterDeleteJobWithScheduleIds(String jobId, List<String> scheduleIds) {
        if (StringUtils.isBlank((CharSequence)jobId)) {
            return;
        }
        for (String scheduleId : scheduleIds) {
            ScheduleInfo info = new ScheduleInfo();
            info.setId(scheduleId);
            info.setTenantId(RequestContext.get().getTenantId());
            info.setAccountId(RequestContext.get().getAccountId());
            info.setJobId(jobId);
        }
    }

    public void afterUpdateJob(String jobId) {
        List<String> ids = this.getScheduleIdByJob(jobId);
        if (ids == null || ids.isEmpty()) {
            return;
        }
        for (String scheduleId : ids) {
            this.afterUpdateSchedule(scheduleId);
        }
    }

    private List<String> getScheduleIdByJob(String jobId) {
        List<String> scheduleIds = this.getScheduleIdByEntry(jobId);
        if (scheduleIds.size() > 0) {
            return scheduleIds;
        }
        String strSQL = "SELECT FID FROM T_SCH_SCHEDULE WHERE FJOBID= ? ";
        Object[] params = new SqlParameter[]{new SqlParameter(":FJOBID", 12, (Object)jobId)};
        ArrayList<String> list = new ArrayList();
        list = (List)DB.query((DBRoute)Sch_Route, (String)strSQL, (Object[])params, rs -> {
            ArrayList<String> ids = new ArrayList<String>(10);
            while (rs.next()) {
                ids.add(rs.getString("fid"));
            }
            return ids;
        });
        return list;
    }

    private List<String> getScheduleIdByEntry(String jobId) {
        String strSQL = "SELECT t1.FID FROM T_SCH_SCHEDULE t1 LEFT JOIN T_SCH_SCHEDULE_ENTRY t2 ON t1.FID = t2.FID WHERE t2.FJOBNUMBER = ? ";
        Object[] params = new SqlParameter[]{new SqlParameter(":FJOBNUMBER", 12, (Object)jobId)};
        ArrayList<String> list = new ArrayList();
        list = (List)DB.query((DBRoute)Sch_Route, (String)strSQL, (Object[])params, rs -> {
            ArrayList<String> ids = new ArrayList<String>(10);
            while (rs.next()) {
                ids.add(rs.getString("fid"));
            }
            return ids;
        });
        return list;
    }

    private void disableJob(String jobId, boolean writeDb) {
        if (writeDb) {
            JobDao jobDao = ScheduleService.getInstance().getObjectFactory().getJobDao();
            jobDao.disableJob(jobId);
        }
        this.afterDeleteJob(jobId);
    }

    private void enableJob(String jobId, boolean writeDb) {
        if (writeDb) {
            JobDao jobDao = ScheduleService.getInstance().getObjectFactory().getJobDao();
            jobDao.enableJob(jobId);
        }
        this.afterUpdateJob(jobId);
    }

    private boolean isJSONValid(String msgContent) {
        try {
            JSONObject.parseObject((String)msgContent);
        }
        catch (JSONException ex) {
            try {
                JSONObject.parseArray((String)msgContent);
            }
            catch (JSONException ex1) {
                return false;
            }
        }
        return true;
    }

    public void afterUpdateSchedule(String scheduleId, List<String> jobIds) {
        this.afterDeleteSchedule(scheduleId, jobIds);
        List<ScheduleInfo> genScheduleInfos = this.genScheduleInfos(scheduleId);
        for (ScheduleInfo scheduleInfo : genScheduleInfos) {
            this.genSchedule(scheduleInfo, true);
        }
    }

    private void afterDeleteSchedule(String scheduleId, List<String> jobIds) {
        for (String jobId : jobIds) {
            ScheduleInfo info = new ScheduleInfo();
            info.setId(scheduleId);
            info.setTenantId(RequestContext.get().getTenantId());
            info.setAccountId(RequestContext.get().getAccountId());
            info.setJobId(jobId);
        }
    }

    public void scheduleProcessChanged(String message) {
    }

    public void jobProcessChanged(String message) {
    }
}

