/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.server.schedulecreator;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import java.sql.Timestamp;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import kd.bos.schedule.api.ScheduleInfo;

public abstract class TimeUtils {
    private static CronParser parser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));

    public static ZonedDateTime createDate(long times) {
        Timestamp ts = new Timestamp(times);
        return ts.toInstant().atZone(Clock.systemDefaultZone().getZone());
    }

    public static ConcurrentLinkedQueue<ZonedDateTime> genSchedule(ScheduleInfo info, ZonedDateTime lastRunTime, ZonedDateTime endTime) {
        Optional opt;
        if (!TimeUtils.checkInfo(info) || lastRunTime == null || endTime == null) {
            return null;
        }
        if (lastRunTime.isAfter(endTime)) {
            return null;
        }
        ZonedDateTime scheduleStratTime = TimeUtils.createDate(info.getStartTime());
        ZonedDateTime scheduleEndTime = TimeUtils.createDate(info.getEndTime());
        scheduleStratTime = scheduleStratTime.truncatedTo(ChronoUnit.MINUTES);
        scheduleEndTime = scheduleEndTime.truncatedTo(ChronoUnit.MINUTES);
        lastRunTime = lastRunTime.truncatedTo(ChronoUnit.MINUTES);
        CronParser cronParser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)cronParser.parse(info.getPlan()));
        ConcurrentLinkedQueue<ZonedDateTime> linkedQ = new ConcurrentLinkedQueue<ZonedDateTime>();
        if (lastRunTime.isBefore(scheduleStratTime)) {
            lastRunTime = scheduleStratTime.minusMinutes(1L);
        }
        ZonedDateTime nextTime = null;
        while (lastRunTime.isBefore(endTime) && (opt = executionTime.nextExecution(lastRunTime)).isPresent() && (nextTime = (ZonedDateTime)opt.get()).isBefore(scheduleEndTime) && nextTime.isBefore(endTime)) {
            linkedQ.add(nextTime);
            lastRunTime = nextTime.plusSeconds(30L);
        }
        return linkedQ;
    }

    private static boolean checkInfo(ScheduleInfo info) {
        return info != null && info.getPlan() != null && info.getPlan().trim().length() != 0 && info.getStartTime() != 0L && info.getEndTime() != 0L;
    }

    public static ZonedDateTime genNextTime(ScheduleInfo info) {
        if (!TimeUtils.checkInfo(info)) {
            return null;
        }
        ZonedDateTime nextTime = null;
        ZonedDateTime now = ZonedDateTime.now().truncatedTo(ChronoUnit.MINUTES);
        ZonedDateTime scheduleStratTime = TimeUtils.createDate(info.getStartTime());
        ZonedDateTime lastRunTime = scheduleStratTime.isAfter(now) ? scheduleStratTime : now;
        ZonedDateTime scheduleEndTime = TimeUtils.createDate(info.getEndTime());
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)parser.parse(info.getPlan()));
        Optional opt = executionTime.nextExecution(lastRunTime);
        if (opt.isPresent() && (nextTime = (ZonedDateTime)opt.get()).isAfter(scheduleEndTime)) {
            nextTime = null;
        }
        return nextTime;
    }
}

