/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mutex.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.AutoReleaseLock;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.LockType;
import kd.bos.mutex.impl.FunctionMutexImpl;
import kd.bos.mutex.impl.Mutex;
import kd.bos.mutex.lock.DataStoreAdapter;
import kd.bos.mutex.lock.ZkStore;

public class AutoReleaseLockImpl
implements AutoReleaseLock {
    private static final Log log = LogFactory.getLog(AutoReleaseLockImpl.class);
    private static final String ZK_PATH_PATTERN = "%s/%s";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("MUTEX", new DistributeCacheHAPolicy(true, true));
    private static final long LOCK_KEEP_TIME_MS = Long.parseLong(System.getProperty("mutex.maxkeeptime_h", "8")) * 60L * 60L * 1000L;
    private static final int CACHE_KEEP_TIME_S = Integer.parseInt(System.getProperty("mutex.cachetimeout_h", "24")) * 60 * 60;

    @Override
    public void register(String dataObjId, String entityKey, String operationKey) {
        String lockInfoStr = this.buidLockInfo(dataObjId, entityKey, operationKey);
        cache.addToSet(this.buildKey(), new String[]{lockInfoStr}, CACHE_KEEP_TIME_S);
    }

    @Override
    public void unRegister(String dataObjId, String entityKey, String operationKey) {
        String lockInfoStr = this.buidLockInfo(dataObjId, entityKey, operationKey);
        cache.removeSetValues(this.buildKey(), new String[]{lockInfoStr});
    }

    @Override
    public void registerFuncMutex(LockType lockType, String path) {
        long currTime = System.currentTimeMillis();
        String key = this.buildFuncRegisterKey(lockType);
        cache.put(key, (Object)String.valueOf(currTime));
    }

    @Override
    public void unRegisterFuncMutex(LockType lockType, String path) {
    }

    @Override
    public void updateSessionTime() {
    }

    @Override
    public void clearLoseLock() {
        DataMutex dataMutex = DataMutex.create();
        try {
            dataMutex.releaseTimeoutLock();
        }
        catch (Exception e) {
            log.error("\u6e05\u7406\u8d85\u65f6\u9501\u5931\u8d25 : " + e.getMessage());
        }
        this.releaseLoseFuncLock();
    }

    @Override
    public void clearLoseLock(String sessionId) {
        if (StringUtils.equals((CharSequence)((CharSequence)cache.get(this.buildKey(sessionId) + ":executed")), (CharSequence)"true")) {
            log.info("AutoReleaseLockImpl clearLoseLock do not repeat");
            return;
        }
        String[] locksArray = cache.getSetValues(this.buildKey(sessionId));
        List<String> locks = Arrays.asList(locksArray);
        if (locks == null || locks.isEmpty()) {
            return;
        }
        String dataObjId = null;
        String entityKey = null;
        String operationKey = null;
        ArrayList<Map<String, Object>> releaseRequires = new ArrayList<Map<String, Object>>();
        for (String lock : locks) {
            if (!StringUtils.isNotBlank((CharSequence)lock)) continue;
            JSONObject lockInfo = JSON.parseObject((String)lock);
            dataObjId = String.valueOf(lockInfo.get("dataObjId"));
            entityKey = String.valueOf(lockInfo.get("entityKey"));
            operationKey = String.valueOf(lockInfo.get("operationKey"));
            HashMap<String, Object> releaseRequire = new HashMap<String, Object>();
            releaseRequire.put("dataObjId", dataObjId);
            releaseRequire.put("entityKey", entityKey);
            releaseRequire.put("operationKey", operationKey);
            releaseRequire.put("isStrict", Boolean.TRUE);
            releaseRequires.add(releaseRequire);
        }
        try (DataMutex mutex = DataMutex.create();){
            cache.put(this.buildKey(sessionId) + ":executed", (Object)"true", 900);
            mutex.batchRelease(releaseRequires);
            log.info("AutoReleaseLockImpl clearLoseLock success");
        }
        catch (Exception e) {
            log.error("\u5728session\u6ce8\u9500\u7684\u65f6\u5019\uff0c\u7f51\u7edc\u4e92\u65a5\u91ca\u653e\u5931\u8d25\uff0c\u53c2\u6570\u4e3a\uff1a" + sessionId, (Throwable)e);
        }
        cache.remove(this.buildKey(sessionId));
    }

    private String buidLockInfo(String dataObjId, String entityKey, String operationKey) {
        HashMap<String, String> lockInfoMap = new HashMap<String, String>();
        lockInfoMap.put("dataObjId", dataObjId);
        lockInfoMap.put("entityKey", entityKey);
        lockInfoMap.put("operationKey", operationKey);
        return JSON.toJSONString(lockInfoMap);
    }

    private void releaseLoseFuncLock() {
        FunctionMutexImpl functionMutex = new FunctionMutexImpl();
        RequestContext rc = RequestContext.get();
        String mutexRootPath = String.format(ZK_PATH_PATTERN, Mutex.MUTEX_LOCK_PATH, rc.getAccountId());
        String funcLockRootPath = String.format(ZK_PATH_PATTERN, mutexRootPath, functionMutex.getLockType());
        this.releaseLoseDBFuncLock(funcLockRootPath);
        this.releaseLoseZKFuncLock(funcLockRootPath);
    }

    private void releaseLoseDBFuncLock(String funcLockRootPath) {
        try {
            DataStoreAdapter dataStoreAdapter = DataStoreAdapter.createInstance(LockType.DB);
            dataStoreAdapter.clearLoseLock(funcLockRootPath);
        }
        catch (RuntimeException exp) {
            log.error((Throwable)exp);
        }
    }

    private void releaseLoseZKFuncLock(String funcLockRootPath) {
        try {
            String cacheKey = this.buildFuncRegisterKey(LockType.ZK);
            String cacheValue = (String)cache.get(cacheKey);
            if (cacheValue != null) {
                long lastTime = Long.parseLong(cacheValue);
                if (System.currentTimeMillis() - lastTime <= LOCK_KEEP_TIME_MS) {
                    List<String> funcLocks = ZkStore.getChildren(funcLockRootPath);
                    for (String lockPath : funcLocks) {
                        this.releaseFuncLockIfTimeout(String.format(ZK_PATH_PATTERN, funcLockRootPath, lockPath));
                    }
                }
            }
        }
        catch (RuntimeException exp) {
            log.error((Throwable)exp);
        }
    }

    private void releaseFuncLockIfTimeout(String lockPath) {
        try {
            Map lockInfo;
            String lockedTimeStr;
            String data = ZkStore.read(lockPath, null);
            if (StringUtils.isNotBlank((CharSequence)data) && StringUtils.isNotBlank((CharSequence)(lockedTimeStr = (String)(lockInfo = (Map)JSON.parseObject((String)data, Map.class)).get("lockedTime"))) && System.currentTimeMillis() - Long.parseLong(lockedTimeStr) > LOCK_KEEP_TIME_MS) {
                ZkStore.deleteAll(lockPath);
            }
        }
        catch (Exception e) {
            log.error("\u540e\u53f0\u4e8b\u52a1\u91ca\u653e\u4e0a\u529f\u80fd\u9501\u8d85\u8fc78\u5c0f\u65f6\u7684\u9501\u5931\u8d25 \u8def\u5f84\u4e3a\uff1a" + lockPath, (Throwable)e);
        }
    }

    private String buildKey() {
        RequestContext rc = RequestContext.get();
        return String.format("MUTEX:LOCKS:%s:%s", rc.getAccountId(), rc.getGlobalSessionId());
    }

    private String buildKey(String sessionId) {
        RequestContext rc = RequestContext.get();
        return String.format("MUTEX:LOCKS:%s:%s", rc.getAccountId(), sessionId);
    }

    private String buildFuncRegisterKey(LockType lockType) {
        RequestContext rc = RequestContext.get();
        return String.format("MUTEX:FUNC:REGISTER:%s:LASTTIME:%s", lockType.toString(), rc.getAccountId());
    }
}

