/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mutex.impl;

import com.alibaba.fastjson.JSON;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.LockType;
import kd.bos.mutex.lock.DataStoreAdapter;
import kd.bos.mutex.lock.LockListener;
import kd.bos.mutex.lock.WriteLock;
import kd.bos.mutex.lock.WriteLockAdapter;
import kd.bos.mutex.lock.WriteLock_Redis;
import kd.bos.mutex.lock.ZkStore;
import kd.bos.zk.ZKFactory;
import org.apache.zookeeper.ZooKeeper;

public class Mutex
implements Closeable {
    protected static Log log = LogFactory.getLog((String)"kd.bos.mutex.impl.DataMutexImpl");
    public static final String CONNECT_ZOOKEEPER_FAILED = "CONNECT_ZOOKEEPER_FAILED";
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final String MUTEX_ROOT = ZKFactory.getZkRootPath((String)ZkStore.ZK_ADDRESS) + "MUTEX";
    public static final String MUTEX_LOCK_PATH = MUTEX_ROOT + "/LOCKS";
    protected static final String GLOBALSESSION_KEY = "GLOBALSESSION";
    private static final String KEYS = " key[";
    @Deprecated
    protected ZooKeeper zkClient = null;
    @Deprecated
    protected WriteLock writeLock = null;
    @Deprecated
    protected WriteLock_Redis writeLock_redis = null;
    @Deprecated
    protected Map<String, WriteLock> writeLocks = new HashMap<String, WriteLock>();
    private WriteLockAdapter wLock = null;
    private Map<String, WriteLockAdapter> wLocks = new HashMap<String, WriteLockAdapter>(8);
    private DataStoreAdapter dataStore = null;
    protected String lockObjKey = null;
    protected boolean locked = false;
    private String basePath = null;
    protected String lockPath = null;
    protected byte[] data = "NODATA".getBytes(UTF_8);
    protected final long maxKeeptime;
    protected long keeptime = this.maxKeeptime = Long.parseLong(System.getProperty("mutex.maxkeeptime_h", "8")) * 60L * 60L;
    private static AtomicBoolean isEnsureBaseLockPath = new AtomicBoolean(false);
    private AtomicBoolean isPrepared = new AtomicBoolean(false);
    private static ConcurrentMap<String, String> accountBasePath = new ConcurrentHashMap<String, String>();

    protected WriteLockAdapter createWriteLock(String dir, LockListener lockListener) {
        return WriteLockAdapter.createInstance(LockType.ZK, dir, lockListener);
    }

    protected WriteLockAdapter getWLock() {
        return this.wLock;
    }

    protected void resetWLock() {
        this.wLock = null;
        this.writeLock = null;
    }

    protected Map<String, WriteLockAdapter> getWLocks() {
        return this.wLocks;
    }

    protected DataStoreAdapter createDataStore() {
        return DataStoreAdapter.createInstance(LockType.ZK);
    }

    protected DataStoreAdapter getDataStore() {
        if (this.dataStore == null) {
            this.dataStore = this.createDataStore();
        }
        return this.dataStore;
    }

    protected String getLockType() {
        return "funs";
    }

    protected String getBasePath() {
        return this.basePath;
    }

    @Override
    public void close() throws IOException {
        this.doClose();
    }

    private void ensureBaseLockPathInZK() {
        try {
            WriteLockAdapter wlock = this.createWriteLock(null, null);
            wlock.ensurePathExists(MUTEX_ROOT);
            wlock.ensurePathExists(MUTEX_LOCK_PATH);
            isEnsureBaseLockPath.set(true);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    protected void createBasePath() {
        String accountId = RequestContext.get().getAccountId();
        String basePathKey = String.format("%s_%s", accountId, this.getLockType());
        if (!accountBasePath.containsKey(basePathKey)) {
            WriteLockAdapter wlock = this.createWriteLock(null, null);
            String accountPath = MUTEX_LOCK_PATH + "/" + accountId;
            wlock.ensurePathExists(accountPath);
            this.basePath = accountPath + "/" + this.getLockType();
            wlock.ensurePathExists(this.basePath);
            accountBasePath.put(basePathKey, this.basePath);
        } else {
            this.basePath = (String)accountBasePath.get(basePathKey);
        }
    }

    protected void prepared() {
        if (!isEnsureBaseLockPath.get()) {
            this.ensureBaseLockPathInZK();
        }
        if (!this.isPrepared.get()) {
            this.createBasePath();
            this.isPrepared.set(true);
        }
    }

    public boolean batchRequire(final String lockObjKey, final String operationKey) {
        if (lockObjKey == null) {
            return false;
        }
        this.prepared();
        final String lockPath = this.getBasePath() + "/" + lockObjKey;
        if (this.wLocks.get(lockPath) == null) {
            WriteLockAdapter wLock = this.createWriteLock(lockPath, new LockListener(){

                @Override
                public void lockAcquired(boolean isSuccess) {
                    Mutex.this.batchAfterLocked(isSuccess, lockObjKey, lockPath, operationKey);
                }

                @Override
                public void lockReleased() {
                    Mutex.this.batchAfterRelease(lockPath);
                }
            });
            this.wLocks.put(lockPath, wLock);
            WriteLock writeLock_zk = wLock.getWriteLock();
            if (writeLock_zk != null) {
                this.writeLocks.put(lockPath, writeLock_zk);
            }
        }
        this.wLocks.get(lockPath).setData(this.data);
        this.locked = this.wLocks.get(lockPath).lock();
        return this.locked;
    }

    public boolean require(String lockObjKey) {
        if (lockObjKey == null) {
            return false;
        }
        this.prepared();
        boolean isNewRequire = this.lockObjKey == null || !lockObjKey.equals(this.lockObjKey);
        this.lockObjKey = lockObjKey;
        this.lockPath = this.basePath + "/" + lockObjKey;
        if (this.wLock == null || isNewRequire) {
            this.wLock = this.createWriteLock(this.lockPath, new LockListener(){

                @Override
                public void lockAcquired(boolean isSuccess) {
                    Mutex.this.afterLocked(isSuccess);
                }

                @Override
                public void lockReleased() {
                    Mutex.this.afterRelease();
                }
            });
            WriteLock writeLock_zk = this.wLock.getWriteLock();
            if (writeLock_zk != null) {
                this.writeLock = writeLock_zk;
            }
        }
        this.wLock.setData(this.data);
        this.locked = this.wLock.lock();
        return this.locked;
    }

    public Map<String, String> getLockInfo() {
        String lockInfoStr = this.getDataStore().read(this.lockPath);
        if (lockInfoStr != null) {
            try {
                Map lockInfo = (Map)JSON.parseObject((String)lockInfoStr, Map.class);
                return lockInfo;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    protected void afterLocked(boolean isSuccess) {
        if (isSuccess) {
            RequestContext rc = RequestContext.get();
            log.info(Thread.currentThread().getName() + KEYS + this.lockObjKey + "]is locked.");
            HashMap<String, String> lockInfo = new HashMap<String, String>();
            lockInfo.put("userid", rc.getUserId());
            lockInfo.put("lockedTime", String.valueOf(System.currentTimeMillis()));
            lockInfo.put("lockObjKey", this.lockObjKey);
            lockInfo.put("data", new String(this.data, UTF_8));
            lockInfo.put("client", rc.getClient());
            lockInfo.put(GLOBALSESSION_KEY, rc.getGlobalSessionId());
            lockInfo.put("keeptime", String.valueOf(this.keeptime));
            String lockInfoStr = JSON.toJSONString(lockInfo);
            this.getDataStore().write(this.lockPath, lockInfoStr);
        } else {
            log.info(Thread.currentThread().getName() + KEYS + this.lockObjKey + "] lock failed.");
        }
    }

    protected int batchAfterLocked(boolean isSuccess, String lockObjKey, String lockPath, String operationKey) {
        if (isSuccess) {
            log.info(Thread.currentThread().getName() + KEYS + lockObjKey + "]is locked.");
            HashMap<String, String> lockInfo = new HashMap<String, String>();
            lockInfo.put("userid", RequestContext.get().getUserId());
            lockInfo.put("lockedTime", String.valueOf(System.currentTimeMillis()));
            lockInfo.put("lockObjKey", lockObjKey);
            lockInfo.put("data", new String(this.data, UTF_8));
            lockInfo.put("client", RequestContext.get().getClient());
            lockInfo.put(GLOBALSESSION_KEY, RequestContext.get().getGlobalSessionId());
            lockInfo.put("keeptime", String.valueOf(this.keeptime));
            String lockInfoStr = JSON.toJSONString(lockInfo);
            this.getDataStore().write(lockPath, lockInfoStr);
            return 1;
        }
        log.info(Thread.currentThread().getName() + KEYS + lockObjKey + "] lock failed.");
        return 0;
    }

    protected void afterRelease() {
        this.getDataStore().delete(this.lockPath);
        if (log.isInfoEnabled()) {
            log.info(Thread.currentThread().getName() + KEYS + this.lockObjKey + "]is released.");
        }
    }

    protected void batchAfterRelease(String lockPath) {
        this.getDataStore().delete(lockPath);
        if (log.isInfoEnabled()) {
            log.info(Thread.currentThread().getName() + KEYS + lockPath + "]is released.");
        }
    }

    public void deleteEmpNode() {
        if (this.wLock != null) {
            this.wLock.deleteEmpNode();
        }
    }

    protected void doClose() {
        if (this.wLock != null) {
            this.wLock.close();
            this.wLock = null;
        }
        if (!this.wLocks.isEmpty()) {
            for (Map.Entry<String, WriteLockAdapter> row : this.wLocks.entrySet()) {
                this.wLocks.get(row.getKey()).close();
            }
            this.wLocks.clear();
        }
    }

    public void release() {
        if (this.wLock != null) {
            this.wLock.unlock();
        }
    }

    protected String processSpecialString(String key) {
        return StringUtils.isNotBlank((CharSequence)key) ? key.replaceAll("/", "_") : "_";
    }
}

