/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mutex.lock;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.lock.ZkStore;
import kd.bos.mutex.lock.ZooKeeperOperation;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.ACL;

public class ProtocolSupport {
    private static Log LOG = LogFactory.getLog((String)"kd.bos.mutex.lock.ProtocolSupport");
    private AtomicBoolean closed = new AtomicBoolean(false);
    private long retryDelayTime = 500L;
    private int retryCount = 10;
    private List<ACL> acl = null;

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.doClose();
        }
    }

    public List<ACL> getAcl() {
        return this.acl;
    }

    public void setAcl(List<ACL> acl) {
        this.acl = acl;
    }

    public long getRetryDelay() {
        return this.retryDelayTime;
    }

    public void setRetryDelay(long retryDelay) {
        this.retryDelayTime = retryDelay;
    }

    protected void doClose() {
    }

    public Object retryOperation(ZooKeeperOperation operation) throws KeeperException, InterruptedException {
        Object exception = null;
        for (int i = 0; i < this.retryCount; ++i) {
            try {
                return operation.execute();
            }
            catch (KeeperException.SessionExpiredException e) {
                LOG.error("Session expired for: zookeeper so reconnecting due to: " + (Object)((Object)e), (Throwable)e);
                throw e;
            }
            catch (KeeperException.ConnectionLossException e) {
                if (exception == null) {
                    exception = e;
                }
                LOG.error("Attempt " + i + " failed with connection loss so attempting to reconnect: " + (Object)((Object)e));
                this.retryDelay(i);
                continue;
            }
        }
        if (exception == null) {
            exception = new KeeperException.SystemErrorException();
        }
        throw exception;
    }

    public void ensurePathExists(String path) {
        this.ensureExists(path, null, this.acl, CreateMode.PERSISTENT);
    }

    public void ensurePathExists(String path, byte[] data) {
        this.ensureExists(path, data, this.acl, CreateMode.PERSISTENT);
    }

    public void ensureExists(String path, byte[] data, List<ACL> acl, CreateMode flags) {
        ZkStore.ensureExisted(path, data, acl, flags);
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public void retryDelay(int attemptCount) {
        if (attemptCount > 0) {
            try {
                Thread.sleep((long)attemptCount * this.retryDelayTime);
            }
            catch (InterruptedException e) {
                LOG.error("Failed to sleep: " + e);
            }
        }
    }
}

