/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mutex.lock;

import java.util.List;
import java.util.TreeSet;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.lock.LockListener;
import kd.bos.mutex.lock.ProtocolSupport;
import kd.bos.mutex.lock.ZNodeName;
import kd.bos.mutex.lock.ZkStore;
import kd.bos.mutex.lock.ZooKeeperOperation;
import kd.bos.util.DisCardUtil;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.ACL;

public class WriteLock
extends ProtocolSupport {
    private static Log LOG = LogFactory.getLog((String)"kd.bos.mutex.lock.WriteLock");
    private final String dir;
    private String id;
    private String ownerId;
    private byte[] data = new byte[]{18, 52};
    private LockListener callback;
    private LockZooKeeperOperation zop;
    private boolean isWatchLockFlag = false;

    public WriteLock(String dir, List<ACL> acl) {
        this.dir = dir;
        if (acl != null) {
            this.setAcl(acl);
        }
        this.zop = new LockZooKeeperOperation();
    }

    public WriteLock(String dir, List<ACL> acl, LockListener callback) {
        this(dir, acl);
        this.callback = callback;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public LockListener getLockListener() {
        return this.callback;
    }

    public void setLockListener(LockListener callback) {
        this.callback = callback;
    }

    @Override
    protected void doClose() {
        super.close();
        this.unlock();
    }

    public synchronized void unlock() throws RuntimeException {
        this.deleteEmpNode();
        if (this.callback != null) {
            this.callback.lockReleased();
        }
    }

    public void deleteEmpNode() {
        if (this.id != null) {
            try {
                ZooKeeperOperation zopdel = () -> {
                    ZkStore.delete(this.id, -1);
                    return false;
                };
                zopdel.execute();
            }
            catch (InterruptedException e) {
                LOG.error("Caught: " + e, (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (KeeperException.NoNodeException e) {
                DisCardUtil.discard();
            }
            catch (KeeperException e) {
                LOG.error("Caught: " + (Object)((Object)e), (Throwable)e);
                throw (RuntimeException)new RuntimeException(e.getMessage()).initCause(e);
            }
            finally {
                this.id = null;
            }
        }
    }

    public synchronized boolean lock() throws KeeperException, InterruptedException {
        if (this.isClosed()) {
            return false;
        }
        this.ensurePathExists(this.dir);
        return (Boolean)this.retryOperation(this.zop);
    }

    public String getDir() {
        return this.dir;
    }

    public boolean isOwner() {
        return this.id != null && this.ownerId != null && this.id.equals(this.ownerId);
    }

    public String getId() {
        return this.id;
    }

    public boolean isWatchLock() {
        return this.isWatchLockFlag;
    }

    public void setWatchLock(boolean isWatchLock) {
        this.isWatchLockFlag = isWatchLock;
    }

    private class LockZooKeeperOperation
    implements ZooKeeperOperation {
        private LockZooKeeperOperation() {
        }

        private void findPrefixInChildren(String prefix, String dir) throws KeeperException, InterruptedException {
            WriteLock.this.id = ZkStore.create(dir + "/" + prefix, WriteLock.this.data, WriteLock.this.getAcl(), CreateMode.EPHEMERAL_SEQUENTIAL);
            if (LOG.isInfoEnabled()) {
                LOG.info(Thread.currentThread().getName() + " Created id: " + WriteLock.this.id);
            }
        }

        @Override
        public boolean execute() throws KeeperException, InterruptedException {
            do {
                if (WriteLock.this.id == null) {
                    String prefix = "x-";
                    this.findPrefixInChildren(prefix, WriteLock.this.dir);
                }
                if (WriteLock.this.id == null) continue;
                List<String> names = ZkStore.getChildren(WriteLock.this.dir);
                if (names.isEmpty()) {
                    LOG.warn("No children in: " + WriteLock.this.dir + " when we've just created one! Lets recreate it...");
                    WriteLock.this.id = null;
                    continue;
                }
                TreeSet<ZNodeName> sortedNames = new TreeSet<ZNodeName>();
                for (String name : names) {
                    sortedNames.add(new ZNodeName(WriteLock.this.dir + "/" + name));
                }
                WriteLock.this.ownerId = ((ZNodeName)sortedNames.first()).getName();
                boolean isSuccess = WriteLock.this.isOwner();
                if (WriteLock.this.callback != null) {
                    WriteLock.this.callback.lockAcquired(isSuccess);
                }
                return isSuccess;
            } while (WriteLock.this.id == null);
            return false;
        }
    }
}

