/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mutex.lock;

import java.nio.charset.StandardCharsets;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.lock.LockListener;
import kd.bos.mutex.lock.WriteLockAdapter;
import kd.bos.mutex.lock.WriteLock_DB;

class WriteLockAdapter_DB
implements WriteLockAdapter {
    private static Log log = LogFactory.getLog(WriteLockAdapter_DB.class);
    private WriteLock_DB writeLock = null;

    public WriteLockAdapter_DB() {
    }

    public WriteLockAdapter_DB(String dir, LockListener lockListener) {
        if (dir != null) {
            this.writeLock = new WriteLock_DB(dir, lockListener);
        }
    }

    @Override
    public void setData(byte[] data) {
        if (this.writeLock != null) {
            this.writeLock.setData(new String(data, StandardCharsets.UTF_8));
        }
    }

    @Override
    public void ensurePathExists(String path) {
        if (this.writeLock != null) {
            this.writeLock.ensurePathExists(path, null);
        } else {
            WriteLock_DB wLock = new WriteLock_DB();
            wLock.ensurePathExists(path, null);
        }
    }

    @Override
    public boolean lock() {
        boolean locked = false;
        try {
            if (this.writeLock != null) {
                locked = this.writeLock.lock();
            }
        }
        catch (RuntimeException e) {
            log.error((Throwable)e);
            locked = false;
        }
        return locked;
    }

    @Override
    public void unlock() {
        if (this.writeLock != null) {
            this.writeLock.unlock();
        }
    }

    @Override
    public void deleteEmpNode() {
        if (this.writeLock != null) {
            this.writeLock.deleteEmpNode();
        }
    }

    @Override
    public void close() {
        if (this.writeLock != null) {
            this.writeLock.close();
        }
    }
}

