/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mutex.lock;

import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.lock.DbStore;
import kd.bos.mutex.lock.LockListener;
import kd.bos.mutex.lock.ZNodeName;

class WriteLock_DB {
    private static Log log = LogFactory.getLog(WriteLock_DB.class);
    private AtomicBoolean closed = new AtomicBoolean(false);
    private long retryDelayTime = 500L;
    private int retryCount = 10;
    private final String dir;
    private String id;
    private String ownerId;
    private String data = null;
    private LockListener callback;
    private LockOperation lockOp;
    private boolean isWatchLockFlag = false;

    public WriteLock_DB() {
        this.dir = null;
    }

    public WriteLock_DB(String dir) {
        this.dir = dir;
        this.lockOp = new LockOperationImpl();
    }

    public WriteLock_DB(String dir, LockListener callback) {
        this(dir);
        this.callback = callback;
    }

    public String getDir() {
        return this.dir;
    }

    public String getId() {
        return this.id;
    }

    public void setData(String data) {
        this.data = data;
    }

    public LockListener getLockListener() {
        return this.callback;
    }

    public void setLockListener(LockListener callback) {
        this.callback = callback;
    }

    public void ensurePathExists(String path, String data) {
        DbStore.ensureExisted(path, data);
    }

    public synchronized boolean lock() {
        if (this.isClosed()) {
            return false;
        }
        this.ensurePathExists(this.dir, this.data);
        return (Boolean)this.retryOperation(this.lockOp);
    }

    public synchronized void unlock() {
        this.deleteEmpNode();
        if (this.callback != null) {
            this.callback.lockReleased();
        }
    }

    public void deleteEmpNode() {
        if (this.id != null) {
            try {
                DbStore.delete(this.id);
            }
            finally {
                this.id = null;
            }
        }
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.doClose();
        }
    }

    protected void doClose() {
        this.unlock();
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public long getRetryDelay() {
        return this.retryDelayTime;
    }

    public void setRetryDelay(long retryDelay) {
        this.retryDelayTime = retryDelay;
    }

    public void retryDelay(int attemptCount) {
        if (attemptCount > 0) {
            try {
                Thread.sleep((long)attemptCount * this.retryDelayTime);
            }
            catch (InterruptedException e) {
                log.error("Failed to sleep: " + e);
            }
        }
    }

    public boolean isOwner() {
        return this.id != null && this.ownerId != null && this.id.equals(this.ownerId);
    }

    protected Object retryOperation(LockOperation operation) {
        KDException exception = null;
        int i = 0;
        if (i < this.retryCount) {
            return operation.execute();
        }
        if (exception == null) {
            exception = new KDException(new ErrorCode("kd.bos.mutex.lock.WriteLock_DB#retryOperation", "lock operate fail."), new Object[0]);
        }
        throw exception;
    }

    private class LockOperationImpl
    implements LockOperation {
        private LockOperationImpl() {
        }

        @Override
        public boolean execute() {
            do {
                if (WriteLock_DB.this.id == null) {
                    String prefix = "x-";
                    this.findPrefixInChildren(prefix, WriteLock_DB.this.dir);
                }
                if (WriteLock_DB.this.id == null) continue;
                List<String> names = DbStore.getChildren(WriteLock_DB.this.dir);
                if (names.isEmpty()) {
                    WriteLock_DB.this.id = null;
                    log.warn("No children in: " + WriteLock_DB.this.dir + " when we've just created one! Lets recreate it...");
                    continue;
                }
                TreeSet<ZNodeName> sortedNames = new TreeSet<ZNodeName>();
                for (String name : names) {
                    sortedNames.add(new ZNodeName(WriteLock_DB.this.dir + "/" + name));
                }
                WriteLock_DB.this.ownerId = ((ZNodeName)sortedNames.first()).getName();
                boolean isSuccess = WriteLock_DB.this.isOwner();
                if (WriteLock_DB.this.callback != null) {
                    WriteLock_DB.this.callback.lockAcquired(isSuccess);
                }
                return isSuccess;
            } while (WriteLock_DB.this.id == null);
            return false;
        }

        private void findPrefixInChildren(String prefix, String dir) {
            WriteLock_DB.this.id = DbStore.createSeqNode(dir, prefix, WriteLock_DB.this.data);
            if (log.isInfoEnabled()) {
                log.info(Thread.currentThread().getName() + " Created id: " + WriteLock_DB.this.id);
            }
        }
    }

    static interface LockOperation {
        public boolean execute();
    }
}

