/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mutex.lock;

import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mutex.lock.LockListener;

public class WriteLock_Redis
implements AutoCloseable {
    private String key;
    private String dataStr;
    private LockListener listener;
    private boolean isLock = false;
    private DLock dLock = null;
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("mutex_batchlockdata", new DistributeCacheHAPolicy(true, true));
    private boolean batch = false;
    private int timeout = Integer.getInteger("mutex.batchdata_cachetimeout_s", 180);
    private int maxRetryTimes = Integer.getInteger("mutex.lock.maxretrytimes", 20);
    private int retryInterval = Integer.getInteger("mutex.lock.retryinterval_ms", 20);

    public WriteLock_Redis(String key, Object data, LockListener acl, boolean batch) {
        this.key = key;
        this.listener = acl;
        this.batch = batch;
        this.dataStr = SerializationUtils.toJsonString((Object)data);
        if (this.maxRetryTimes <= 0 || this.maxRetryTimes > 500) {
            this.maxRetryTimes = 10;
        }
        if (this.retryInterval <= 0 || this.retryInterval > 200) {
            this.retryInterval = 20;
        }
    }

    /*
     * Loose catch block
     */
    public boolean write() throws Exception {
        try {
            try (DLock lock = DLock.create((String)this.key, (String)"");){
                this.dLock = lock;
                if (lock.tryLock((long)(this.maxRetryTimes * this.retryInterval))) {
                    this.isLock = true;
                    if (this.batch) {
                        cache.put(this.key, (Object)this.dataStr, this.timeout);
                    }
                    this.listener.lockAcquired(this.isLock);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.close();
        }
    }

    @Deprecated
    public boolean lock() throws Exception {
        this.dLock = DLock.create((String)this.key, (String)"");
        try {
            if (this.dLock.tryLock(0L)) {
                this.isLock = true;
                if (this.batch) {
                    cache.put(this.key, (Object)this.dataStr, this.timeout);
                }
            }
            this.listener.lockAcquired(this.isLock);
        }
        catch (Exception e) {
            ErrorCode ec = new ErrorCode("MUTEX_REQUIRE_ERROR", ResManager.loadKDString((String)"\u7533\u8bf7\u5206\u5e03\u5f0f\u9501\u5931\u8d25", (String)"WriteLock_Redis_0", (String)"bos-mutex", (Object[])new Object[0]));
            throw new KDException((Throwable)e, ec, new Object[]{e.getMessage()});
        }
        return this.isLock;
    }

    private void retryDelay(int millis) {
        if (millis > 0) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static String getBatchLockedData(String batchKey) {
        return (String)cache.get(batchKey);
    }

    @Override
    public void close() throws Exception {
        try {
            if (this.dLock != null) {
                this.dLock.unlock();
            }
            if (this.isLock && this.batch && StringUtils.isNotBlank((CharSequence)this.key)) {
                cache.remove(this.key);
            }
            this.isLock = false;
            this.batch = false;
            if (this.listener != null) {
                this.listener.lockReleased();
            }
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, new ErrorCode("mutex.error", "mutex close error"), new Object[]{e.getMessage()});
        }
    }
}

