/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.botp;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillView;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.ParameterHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertBill;
import kd.bos.entity.botp.ConvertOpType;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.PushAndDrawUtil;
import kd.bos.entity.botp.helper.AttachmentPanelConvertHelper;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.AttachmentItemInfo;
import kd.bos.entity.botp.runtime.BeforeDrawArgs;
import kd.bos.entity.botp.runtime.BeforeDrawOpResult;
import kd.bos.entity.botp.runtime.ConvertOpParameter;
import kd.bos.entity.botp.runtime.ConvertOpRule;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.DrawArgs;
import kd.bos.entity.botp.runtime.OpInfo;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.BillParam;
import kd.bos.entity.plugin.Plugin;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.DefaultDynamicFormOperate;
import kd.bos.form.operate.botp.Push;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MobileListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.sysparam.SystemParamService;
import kd.bos.mvc.bill.MobileBillView;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.botp.ConvertBillFilterUtil;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.botp.ReleaseConvertDataMutexUtil;
import org.apache.commons.collections4.MapUtils;

public class Draw
extends DefaultDynamicFormOperate
implements ICloseCallBack {
    private static final Log log = LogFactory.getLog(Draw.class);
    public static final String AllRule = "@all";
    private ConvertOpParameter opParameter;
    private boolean duplicateRemove;
    private boolean duplicateEntryRemove;
    private boolean hideDrawForm = false;
    private String defSourceBill = "";
    private String defRuleId = "";
    private String defRuleIdPara = "";
    private List<String> clearEntrys = new ArrayList<String>(0);
    private static final String BOS_FORM_BUSINESS = "bos-botp-business";
    private static SystemParamService systemParamService = (SystemParamService)ServiceFactory.getService(SystemParamService.class);
    private static final String BOTP_MOBILEDRAW_SIMPLIFY_PARAM = "botp_mobiledraw_new_param";
    private static final String BOTP_MOBILE_DRAW = "botp_mobile_draw";
    private static final Log LOG = LogFactory.getLog(Draw.class);
    private static final String BILLPARAMETER_WHOLECONVERT = "wholeconvert";

    public boolean isHideDrawForm() {
        return this.hideDrawForm;
    }

    public void setHideDrawForm(boolean hideDrawForm) {
        this.hideDrawForm = hideDrawForm;
    }

    public boolean isDuplicateRemove() {
        return this.duplicateRemove;
    }

    public void setDuplicateRemove(boolean duplicateRemove) {
        this.duplicateRemove = duplicateRemove;
    }

    public boolean isDuplicateEntryRemove() {
        return this.duplicateEntryRemove;
    }

    public void setDuplicateEntryRemove(boolean duplicateEntryRemove) {
        this.duplicateEntryRemove = duplicateEntryRemove;
    }

    public String getDefSourceBill() {
        return this.defSourceBill;
    }

    public void setDefSourceBill(String defSourceBill) {
        this.defSourceBill = defSourceBill;
    }

    public String getDefRuleId() {
        return this.defRuleId;
    }

    public void setDefRuleId(String defRuleId) {
        this.defRuleId = defRuleId;
    }

    public List<String> getClearEntrys() {
        return this.clearEntrys;
    }

    public void setClearEntrys(List<String> clearEntrys) {
        this.clearEntrys = clearEntrys;
    }

    public void initialize(Map<String, Object> opParameter) {
        super.initialize(opParameter);
        Map parameters = (Map)opParameter.get("parameter");
        if (parameters != null) {
            String entrykeys;
            if (parameters.containsKey("hidedrawform")) {
                this.hideDrawForm = (Boolean)parameters.get("hidedrawform");
            }
            if (parameters.containsKey("duplicateremove")) {
                this.duplicateRemove = (Boolean)parameters.get("duplicateremove");
            }
            if (parameters.containsKey("duplicateentryremove")) {
                this.duplicateEntryRemove = (Boolean)parameters.get("duplicateentryremove");
            }
            if (parameters.containsKey("sourcebill")) {
                this.defSourceBill = (String)parameters.get("sourcebill");
                if (StringUtils.isBlank((CharSequence)this.defSourceBill)) {
                    this.hideDrawForm = false;
                }
            }
            if (parameters.containsKey("ruleid")) {
                this.defRuleId = (String)parameters.get("ruleid");
                this.defRuleIdPara = (String)parameters.get("ruleid");
                if (StringUtils.equalsIgnoreCase((CharSequence)this.defRuleId, (CharSequence)AllRule)) {
                    this.defRuleId = "";
                }
                if (StringUtils.isBlank((CharSequence)this.defRuleId)) {
                    this.hideDrawForm = false;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(entrykeys = (String)parameters.get("clearentrys")))) {
                String[] keys;
                for (String key : keys = entrykeys.split(",")) {
                    if (!StringUtils.isNotBlank((CharSequence)key)) continue;
                    this.clearEntrys.add(key);
                }
            }
        }
    }

    protected boolean beforeInvokeOperation(OperationResult result) {
        if (!super.beforeInvokeOperation(result)) {
            return false;
        }
        if (!(this.getView() instanceof IBillView)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u5728\u5355\u636e\u7ef4\u62a4\u754c\u9762\u4e0a\u6267\u884c\u9009\u5355\u3002", (String)"Draw_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return false;
        }
        IBillView billView = (IBillView)this.getView();
        DynamicObject billObj = billView.getModel().getDataEntity();
        if (!this.clearEntrys.isEmpty() && billObj.getDataEntityState().getFromDatabase()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u7ecf\u4fdd\u5b58\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u8986\u76d6\u5f0f\u9009\u5355\u3002", (String)"Draw_4", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return false;
        }
        this.opParameter = this.buildParameter();
        if (this.hideDrawForm) {
            if (StringUtils.isBlank((CharSequence)this.opParameter.getDefSourceBill()) || StringUtils.isBlank((CharSequence)this.opParameter.getDefRuleId())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u9009\u5355\u64cd\u4f5c\u4e0a\u914d\u7f6e\u597d\u6e90\u5355\u3001\u8f6c\u6362\u89c4\u5219\u3002", (String)"Draw_5", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                return false;
            }
            if (this.opParameter.getBills().isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u5355\u64cd\u4f5c\u4e0a\u6307\u5b9a\u7684\u89c4\u5219\u5df2\u7ecf\u7981\u7528\uff0c\u8bf7\u4fee\u6539\u9009\u5355\u64cd\u4f5c\uff0c\u91cd\u65b0\u6307\u5b9a\u89c4\u5219\u3002", (String)"Draw_6", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                return false;
            }
        }
        if (this.opParameter.getBills().isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u6b63\u5e38\u542f\u7528\u7684\u8f6c\u6362\u8def\u7ebf\u3002", (String)"Draw_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected OperationResult invokeOperation() {
        if (this.hideDrawForm || this.getView() instanceof MobileBillView) {
            this.doBeforeDraw(this.opParameter);
            return null;
        }
        String opParameterJson = SerializationUtils.toJsonString((Object)this.opParameter);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_convertop");
        showParameter.getCustomParams().put("ServiceAppId", this.getView().getFormShowParameter().getServiceAppId());
        showParameter.getCustomParams().put("opinfo", SerializationUtils.toJsonString((Object)this.getOpInfo()));
        showParameter.getCustomParams().put("opparam", opParameterJson);
        showParameter.getCustomParams().put("duplicateremove", this.duplicateRemove);
        showParameter.getCustomParams().put("duplicateentryremove", this.duplicateEntryRemove);
        showParameter.getCustomParams().put("isbillsofplugin", this.getOption().getVariableValue("isbillsofplugin", "false"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u9009\u5355", (String)"Draw_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        this.getView().showForm(showParameter);
        return null;
    }

    private OpInfo getOpInfo() {
        OpInfo opInfo = new OpInfo();
        opInfo.setOpKey(this.getOperateKey());
        opInfo.setOpName(this.getOperateName());
        opInfo.setOpType(this.getType());
        return opInfo;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getView() == null) {
            return;
        }
        this.setView(e.getView());
        if (e.getReturnData() == null) {
            return;
        }
        if (!(e.getReturnData() instanceof ListSelectedRowCollection)) {
            return;
        }
        String actionId = e.getActionId();
        IPageCache pageCache = (IPageCache)e.getView().getService(IPageCache.class);
        String opParameterJson = pageCache.get(actionId);
        if (StringUtils.isBlank((CharSequence)opParameterJson)) {
            return;
        }
        this.opParameter = (ConvertOpParameter)SerializationUtils.fromJsonString((String)opParameterJson, ConvertOpParameter.class);
        ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
        this.doDraw(e.getView(), this.opParameter, rows);
    }

    protected void afterInvokeOperation(OperationResult opResult) {
    }

    protected ConvertOpParameter buildParameter() {
        ConvertOpParameter opParameter = new ConvertOpParameter();
        opParameter.setOpType(ConvertOpType.Draw);
        String entityNumber = this.getEntityId();
        opParameter.setEntityNumber(entityNumber);
        opParameter.setTargetBillPageId(this.getView().getPageId());
        opParameter.setDefSourceBill(this.defSourceBill);
        opParameter.setDefRuleId(this.defRuleId);
        opParameter.setDefRuleIdPara(this.defRuleIdPara);
        opParameter.getClearEntrys().addAll(this.clearEntrys);
        if (this.getView() instanceof MobileBillView) {
            // empty if block
        }
        if (this.hideDrawForm) {
            List<ConvertRuleElement> rules = ConvertBillFilterUtil.loadRulesOfDraw(this.defSourceBill, entityNumber);
            ConvertRuleElement defRule = null;
            for (ConvertRuleElement rule : rules) {
                if (!rule.isNormual() || !StringUtils.equals((CharSequence)rule.getId(), (CharSequence)this.defRuleId)) continue;
                defRule = rule;
                break;
            }
            if (defRule != null) {
                ConvertBill bill = new ConvertBill();
                bill.setEntityNumber(this.defSourceBill);
                bill.setEntityName(this.defSourceBill);
                ConvertOpRule opRule = new ConvertOpRule();
                opRule.setRuleId(defRule.getId());
                bill.getRules().add(opRule);
                opParameter.getBills().add(bill);
            }
        } else {
            List<ConvertBill> bills = this.loadSourceBills(entityNumber);
            if (bills != null) {
                opParameter.getBills().addAll(bills);
            }
        }
        if (this.getOption() != null) {
            opParameter.getCustomParams().putAll(this.getOption().getVariables());
        }
        opParameter.setOpInfo(this.getOpInfo());
        return opParameter;
    }

    private List<ConvertBill> loadSourceBills(String targetEntityNumber) {
        String billsOfDrawPluginArgs = this.getOption().getVariableValue("billsofdrawpluginargs", "");
        if (StringUtils.isNotBlank((CharSequence)billsOfDrawPluginArgs)) {
            return ConvertBillFilterUtil.loadDrawBillsOfPlugin(billsOfDrawPluginArgs);
        }
        DynamicObject targetBillTypeObj = this.getTargetBillTypeObj();
        List<ConvertBill> bills = ConvertMetaServiceHelper.loadConvertBills(targetEntityNumber, ConvertOpType.Draw);
        return ConvertBillFilterUtil.filterConvertBillsOfDraw(targetEntityNumber, targetBillTypeObj, bills, this.hideDrawForm);
    }

    private DynamicObject getTargetBillTypeObj() {
        String billTypeKey;
        if (this.getView() instanceof IBillView && StringUtils.isNotBlank((CharSequence)(billTypeKey = ((BillEntityType)this.getView().getModel().getDataEntityType()).getBillType()))) {
            DynamicObject billTypeObj = (DynamicObject)this.getView().getModel().getValue(billTypeKey);
            return billTypeObj;
        }
        return null;
    }

    private void doBeforeDraw(ConvertOpParameter opParameter) {
        ConvertOperationResult opResult;
        String ruleId = "";
        opParameter.setSrcDefSourceBill(opParameter.getDefSourceBill());
        opParameter.setSrcDefRuleId(opParameter.getDefRuleId());
        if (StringUtils.isNotBlank((CharSequence)opParameter.getDefSourceBill()) && StringUtils.isNotBlank((CharSequence)opParameter.getDefRuleId())) {
            boolean flag = false;
            for (ConvertBill bill : opParameter.getBills()) {
                if (!bill.getEntityNumber().equals(opParameter.getDefSourceBill())) continue;
                for (ConvertOpRule rule : bill.getRules()) {
                    if (!rule.getRuleId().equals(opParameter.getDefRuleId())) continue;
                    flag = true;
                }
            }
            if (!flag) {
                opParameter.setDefRuleId("");
                opParameter.setDefRuleIdPara("");
            }
        }
        if (StringUtils.isBlank((CharSequence)opParameter.getDefSourceBill()) || StringUtils.isBlank((CharSequence)opParameter.getDefRuleId())) {
            List bills = opParameter.getBills();
            if (bills.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u6e90\u5355\u3002", (String)"Draw_7", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            }
            ConvertBill convertBill = (ConvertBill)bills.get(0);
            ruleId = ((ConvertOpRule)convertBill.getRules().get(0)).getRuleId();
            if (StringUtils.isBlank((CharSequence)opParameter.getDefSourceBill())) {
                opParameter.setDefSourceBill(((ConvertBill)bills.get(0)).getEntityNumber());
            }
            opParameter.setDefRuleId(ruleId);
            opParameter.setSrcDefRuleId(ruleId);
        }
        String sourceEntityNumber = opParameter.getDefSourceBill();
        ruleId = opParameter.getDefRuleId();
        BeforeDrawArgs args = new BeforeDrawArgs();
        args.setSourceEntityNumber(sourceEntityNumber);
        args.setTargetEntityNumber(opParameter.getEntityNumber());
        args.setTargetPageId(opParameter.getTargetBillPageId());
        args.setRuleId(ruleId);
        args.setDuplicateRemove(this.duplicateRemove);
        args.setDuplicateEntryRemove(this.duplicateEntryRemove);
        args.getCustomParams().putAll(opParameter.getCustomParams());
        args.setOpInfo(this.getOpInfo());
        try {
            opResult = ConvertServiceHelper.beforeDraw(args);
        }
        catch (KDException e) {
            PushAndDrawUtil.nonMetaNotFound((KDException)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"number\u4e3a%s\uff08\u6e90\u5355\u6807\u8bc6\uff09\u7684\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"PushAndDrawUtil_0", (String)"bos-botp-core", (Object[])new Object[0]), args.getSourceEntityNumber()));
        }
        BeforeDrawOpResult result = (BeforeDrawOpResult)opResult;
        if (!result.isSuccess()) {
            this.getView().showErrorNotification(result.getMessage());
        } else {
            String callBackActionId = DBServiceHelper.genStringId();
            FormShowParameter showParameter = this.buildDrawSourceListParameter(sourceEntityNumber, result, callBackActionId);
            String opParameterJson = SerializationUtils.toJsonString((Object)opParameter);
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            pageCache.put(callBackActionId, opParameterJson);
            CloseCallBack closeCallBack = new CloseCallBack(((Object)((Object)this)).getClass().getName(), callBackActionId);
            showParameter.setCloseCallBack(closeCallBack);
            if (StringUtils.isNotBlank((CharSequence)sourceEntityNumber)) {
                showParameter.setCustomParam("ServiceAppId", (Object)FormMetadataCache.getFormConfig((String)sourceEntityNumber).getAppId());
            }
            this.getView().showForm(showParameter);
        }
    }

    private FormShowParameter buildDrawSourceListParameter(String sourceEntityNumber, BeforeDrawOpResult beforeDrawResult, String callBackActionId) {
        String filter = beforeDrawResult.getDrawFilter();
        String sourceFormId = StringUtils.isNotBlank((CharSequence)beforeDrawResult.getDrawSourceLayout()) ? beforeDrawResult.getDrawSourceLayout() : sourceEntityNumber;
        ListShowParameter listShowParameter = PushAndDrawUtil.tryCreateShowListForm((String)sourceFormId, (String)sourceEntityNumber);
        String errmsg = (String)listShowParameter.getCustomParam("errmsg");
        if (StringUtils.isNotBlank((CharSequence)errmsg)) {
            this.getView().showErrorNotification(errmsg);
        }
        listShowParameter.setShowFullScreen(true);
        listShowParameter.getCustomParams().put("isIgnoreLicense", true);
        listShowParameter.getCustomParams().put("bos_call_source_type", "botp_draw");
        listShowParameter.getListFilterParameter().setQFilter(filter);
        if (beforeDrawResult.getDrawSelectedEntity().size() > 0) {
            String selectEntity = (String)beforeDrawResult.getDrawSelectedEntity().get(beforeDrawResult.getDrawSelectedEntity().size() - 1);
            listShowParameter.getListFilterParameter().setSelectEntity(selectEntity);
            listShowParameter.getCustomParams().put("ismergerows", false);
        }
        if (beforeDrawResult.getSrcMainOrgId() != null) {
            listShowParameter.setIsolationOrg(true);
            listShowParameter.setUseOrgId(beforeDrawResult.getSrcMainOrgId().longValue());
        } else {
            listShowParameter.setIsolationOrg(false);
        }
        if (this.getView() instanceof MobileBillView) {
            return this.buildMobileF7ListParameter(sourceEntityNumber, listShowParameter, callBackActionId);
        }
        return listShowParameter;
    }

    private FormShowParameter buildMobileF7ListParameter(String sourceEntityNumber, ListShowParameter listShowParameter, String callBackActionId) {
        BillParam billParam = ParameterHelper.getBillParam((String)sourceEntityNumber);
        String primaryField = billParam.getMobileListF7Config().getPrimaryField();
        String secondField = billParam.getMobileListF7Config().getSecondField();
        String iconField = billParam.getMobileListF7Config().getIconField();
        boolean showModel = billParam.getMobileListF7Config().isShowModal();
        int pageRow = billParam.getMobileListF7Config().getPageRow();
        if (StringUtils.isBlank((CharSequence)primaryField)) {
            BillEntityType srcMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)sourceEntityNumber);
            primaryField = srcMainType.getBillNo();
            secondField = srcMainType.getMainOrg();
        }
        FormShowParameter createGeneralF7ShowForm = ShowFormHelper.createMobListF7DrawShowForm((String)callBackActionId, (ListShowParameter)listShowParameter, (String)primaryField, (String)secondField, (String)iconField, (boolean)showModel, (int)pageRow, (String)(this.opParameter == null ? "" : SerializationUtils.toJsonString((Object)this.opParameter)));
        createGeneralF7ShowForm.setCustomParam("showFrequent", (Object)false);
        createGeneralF7ShowForm.setCaption(listShowParameter.getCaption());
        createGeneralF7ShowForm.setCustomParam("hideDrawForm", (Object)this.hideDrawForm);
        createGeneralF7ShowForm.setCustomParam("duplicateremove", (Object)this.duplicateRemove);
        createGeneralF7ShowForm.setCustomParam("duplicateentryremove", (Object)this.duplicateEntryRemove);
        Object botpMobiledrawNewParam = systemParamService.loadPublicParameterFromCache(BOTP_MOBILEDRAW_SIMPLIFY_PARAM);
        if (botpMobiledrawNewParam != null && Boolean.parseBoolean(botpMobiledrawNewParam.toString())) {
            MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
            FormConfig formConfig = FormMetadataCache.getMobListFormConfig((String)sourceEntityNumber);
            mobileFormShowParameter.setCaption(formConfig.getCaption().toString());
            mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
            if (showModel) {
                mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            }
            mobileFormShowParameter.setFormId(BOTP_MOBILE_DRAW);
            mobileFormShowParameter.setCustomParam("opparam", (Object)(this.opParameter == null ? "" : SerializationUtils.toJsonString((Object)this.opParameter)));
            mobileFormShowParameter.setCustomParam("callBackActionId", (Object)callBackActionId);
            mobileFormShowParameter.setCustomParam("hideDrawForm", (Object)this.hideDrawForm);
            mobileFormShowParameter.setCustomParam("pageRow", (Object)pageRow);
            mobileFormShowParameter.setCustomParam("primaryField", (Object)primaryField);
            mobileFormShowParameter.setCustomParam("duplicateremove", (Object)this.duplicateRemove);
            mobileFormShowParameter.setCustomParam("duplicateentryremove", (Object)this.duplicateEntryRemove);
            return mobileFormShowParameter;
        }
        return createGeneralF7ShowForm;
    }

    private void doDraw(IFormView targetBillView, ConvertOpParameter opParameter, ListSelectedRowCollection srcRows) {
        if (srcRows == null || srcRows.size() == 0) {
            return;
        }
        String sourceEntityNumber = opParameter.getDefSourceBill();
        String ruleId = opParameter.getDefRuleId();
        DrawArgs args = new DrawArgs();
        args.setSourceEntityNumber(sourceEntityNumber);
        args.setTargetEntityNumber(opParameter.getEntityNumber());
        args.addCustomParam("botp_requiredatamutex", String.valueOf(true));
        args.getSelectedRows().addAll(srcRows);
        args.setTargetPageId(opParameter.getTargetBillPageId());
        args.setRuleId(ruleId);
        args.setBuildConvReport(true);
        args.getClearEntrys().addAll(opParameter.getClearEntrys());
        args.getCustomParams().putAll(opParameter.getCustomParams());
        args.setOpInfo(opParameter.getOpInfo());
        try {
            Map billParameter = SystemParamServiceHelper.loadBillParameterObjectFromCache((String)targetBillView.getEntityId());
            boolean wholeConvert = MapUtils.isNotEmpty((Map)billParameter) && (Boolean)billParameter.get(BILLPARAMETER_WHOLECONVERT) != false;
            args.addCustomParam("botp_pushByBill", String.valueOf(wholeConvert));
            if (wholeConvert) {
                List selectedRows = args.getSelectedRows();
                for (ListSelectedRow selectedRow : selectedRows) {
                    selectedRow.setEntryPrimaryKeyValue(null);
                    selectedRow.setSubEntryPrimaryKeyValue(null);
                }
                args.getSelectedRows().addAll(selectedRows);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        ConvertOperationResult result = ConvertServiceHelper.draw(args);
        if (!result.isSuccess() || result.getCachePageIds().size() == 0) {
            Push.showReport(targetBillView, (AbstractConvertServiceArgs)args, result);
        } else {
            IBillView billView = (IBillView)targetBillView;
            IRefrencedataProvider refProvider = new IRefrencedataProvider(){

                public void fillReferenceData(Object[] dataEntitys, IDataEntityType type) {
                    BusinessDataReader.loadRefence((Object[])dataEntitys, (IDataEntityType)type);
                }
            };
            List dataEntitys = result.loadTargetDataObjects(refProvider, (MainEntityType)((BillEntityType)billView.getModel().getDataEntityType()));
            try {
                this.addReleaseSourceDataMutexPlugin((IFormView)billView, result);
            }
            catch (Exception e) {
                log.info("addReleaseSourceDataMutexPlugin error:" + e);
            }
            ((IBillModel)billView.getModel()).push(dataEntitys.get(0));
            this.bindDrawAttachments(billView, result.getBillAttachmentPanelInfos());
            billView.updateView();
            result.release(refProvider, (MainEntityType)((BillEntityType)billView.getModel().getDataEntityType()));
        }
    }

    private static String serializeListShowParameter(ListShowParameter listShowParameter) {
        ArrayList<IDataEntityType> dataEntityTypes = new ArrayList<IDataEntityType>();
        dataEntityTypes.add(OrmUtils.getDataEntityType(ListShowParameter.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(MobileListShowParameter.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(ListSelectedRowCollection.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(ListSelectedRow.class));
        DcJsonSerializer dcJsonSerializer = new DcJsonSerializer(dataEntityTypes);
        return dcJsonSerializer.serializeToString((Object)listShowParameter, null);
    }

    private void bindDrawAttachments(IBillView billView, Map<Object, Map<String, List<AttachmentItemInfo>>> billAttachmentPanelInfos) {
        if (billAttachmentPanelInfos == null || billAttachmentPanelInfos.size() == 0) {
            return;
        }
        Map attachmentMap = AttachmentPanelConvertHelper.convertBillAttachmentInfosToBillAttachmentInfoMaps(billAttachmentPanelInfos.values().iterator().next());
        attachmentMap.replaceAll((key, value) -> AttachmentPanelConvertHelper.convertAttachmentInfoMapForTempCache((List)value));
        String tempAttCacheKey = "TampAttCache" + billView.getPageId();
        IPageCache cache = billView.getPageCache();
        this.mergeTempAttachments(cache, tempAttCacheKey, attachmentMap);
        for (Map.Entry entry : attachmentMap.entrySet()) {
            AttachmentPanel panel = (AttachmentPanel)billView.getControl((String)entry.getKey());
            if (panel != null) {
                List attachs = panel.getAttachmentData();
                AttachmentPanelConvertHelper.distinctTempAttachmentsForDraw((List)attachs, (List)((List)entry.getValue()));
                continue;
            }
            AttachmentPanelConvertHelper.distinctTempAttachmentsForDraw((List)((List)entry.getValue()));
        }
        cache.put(tempAttCacheKey, SerializationUtils.toJsonString((Object)attachmentMap));
    }

    private void mergeTempAttachments(IPageCache cache, String tempAttCacheKey, Map<String, List<Map<String, Object>>> attachmentMap) {
        String tempCache = cache.get(tempAttCacheKey);
        if (StringUtils.isNotBlank((CharSequence)tempCache)) {
            Map tempCacheAttachmentMap = (Map)SerializationUtils.fromJsonString((String)tempCache, Map.class);
            for (Map.Entry entry : tempCacheAttachmentMap.entrySet()) {
                List<Map<String, Object>> attachs = attachmentMap.get(entry.getKey());
                List tempAttachs = (List)entry.getValue();
                if (attachs == null) {
                    attachmentMap.put((String)entry.getKey(), tempAttachs);
                    continue;
                }
                if (tempAttachs == null || tempAttachs.isEmpty()) continue;
                attachs.addAll(0, tempAttachs);
            }
        }
    }

    private void addReleaseSourceDataMutexPlugin(IFormView billView, ConvertOperationResult drawResult) {
        boolean exist = false;
        String plugInName = "kd.bos.form.plugin.botp.ReleaseConvertDataMutexPlugin";
        for (Plugin plugin : billView.getFormShowParameter().getFormConfig().getPlugins()) {
            if (!StringUtils.equals((CharSequence)plugin.getClassName(), (CharSequence)plugInName)) continue;
            exist = true;
            break;
        }
        if (!exist) {
            billView.getFormShowParameter().addCustPlugin(plugInName);
            billView.cacheFormShowParameter();
        }
        ReleaseConvertDataMutexUtil.addConvertDataMutex(billView, drawResult.getSourceEntityNumber(), drawResult.getDataMutexSrcBillIds());
    }
}

