/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.botp;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.base.MobileBaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.ctbotp.link.CtBillLinkService;
import kd.bos.ctsy.api.CtsyTenant;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertBill;
import kd.bos.entity.botp.ConvertOpType;
import kd.bos.entity.botp.ConvertResultMutex;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.ConvertOpParameter;
import kd.bos.entity.botp.runtime.ConvertOpRule;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.OpInfo;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.botp.runtime.SourceRowReport;
import kd.bos.entity.botp.runtime.args.PushArgsFactory;
import kd.bos.entity.ctbotp.constants.SourceOperateEnum;
import kd.bos.entity.ctbotp.constants.SyncTypeEnum;
import kd.bos.entity.ctbotp.runtime.AbstractCtConvertServiceArgs;
import kd.bos.entity.ctbotp.runtime.CtConvertOpParameter;
import kd.bos.entity.ctbotp.runtime.CtConvertOperationResult;
import kd.bos.entity.ctbotp.runtime.CtOpInfo;
import kd.bos.entity.ctbotp.runtime.CtPushArgs;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.LongProp;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.operate.CtPush;
import kd.bos.form.operate.DefaultDynamicFormOperate;
import kd.bos.form.operate.botp.ThirdPushManage;
import kd.bos.id.ID;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.MobileBillView;
import kd.bos.mvc.list.MobileListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.CtConvertMetaServiceHelper;
import kd.bos.servicehelper.CtConvertServiceHelper;
import kd.bos.servicehelper.basedata.CtsyBaseServiceHelper;
import kd.bos.servicehelper.botp.ConvertBillFilterUtil;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import org.apache.commons.collections4.MapUtils;

public class Push
extends DefaultDynamicFormOperate {
    public static final String AllRule = "@all";
    private MainEntityType srcMainType;
    private ConvertOpParameter opParameter;
    private boolean hidePushForm = false;
    private String defTargetBill = "";
    private String defRuleId = "";
    private String defRuleIdPara = "";
    private boolean hasNewRight = false;
    private boolean mustSelectRule = false;
    private CtConvertOpParameter ctOpParameter;
    private String tTenantCode = "";
    private String tAccountId = "";
    private String syncType = "";
    private boolean ctHidePushForm = false;
    private String defCtTargetBill = "";
    private String defCtRuleId = "";
    private String defCtRuleIdPara = "";
    private String ctControlfield;
    private static final String BOS_FORM_BUSINESS = "bos-botp-business";
    private ThirdPushManage thirdPushManage = null;
    private static final Log LOG = LogFactory.getLog(Push.class);
    private static final String BILLPARAMETER_POPUPSHOWREPORT = "resultfrompopupreport";
    private static Log log = LogFactory.getLog(Push.class);
    private static final String BILLPARAMETER_WHOLECONVERT = "wholeconvert";

    public void initialize(Map<String, Object> arg0) {
        super.initialize(arg0);
        Map parameters = (Map)arg0.get("parameter");
        if (parameters != null) {
            if (parameters.containsKey("hidepushform")) {
                this.hidePushForm = (Boolean)parameters.get("hidepushform");
            }
            if (parameters.containsKey("targetbill")) {
                this.defTargetBill = (String)parameters.get("targetbill");
                if (StringUtils.isBlank((CharSequence)this.defTargetBill)) {
                    this.hidePushForm = false;
                }
            }
            if (parameters.containsKey("ruleid")) {
                this.defRuleId = (String)parameters.get("ruleid");
                this.defRuleIdPara = (String)parameters.get("ruleid");
                if (StringUtils.isBlank((CharSequence)this.defRuleId)) {
                    this.defRuleId = AllRule;
                }
            }
            if (parameters.containsKey("ishasright")) {
                this.hasNewRight = (Boolean)parameters.get("ishasright");
            }
            if (parameters.containsKey("mustselectrule")) {
                this.mustSelectRule = (Boolean)parameters.get("mustselectrule");
            }
            if (parameters.containsKey("ctControlfield")) {
                this.ctControlfield = (String)parameters.get("ctControlfield");
            }
            if (parameters.containsKey("targetTenantCode")) {
                this.tTenantCode = (String)parameters.get("targetTenantCode");
            }
            if (parameters.containsKey("targetAccountId")) {
                this.tAccountId = (String)parameters.get("targetAccountId");
            }
            if (parameters.containsKey("ctTargetBill")) {
                this.defCtTargetBill = (String)parameters.get("ctTargetBill");
                if (StringUtils.isBlank((CharSequence)this.defTargetBill)) {
                    this.ctHidePushForm = false;
                }
            }
            if (parameters.containsKey("syncType")) {
                this.syncType = (String)parameters.get("syncType");
            }
            if (parameters.containsKey("ctRuleId")) {
                this.defCtRuleId = (String)parameters.get("ctRuleId");
                this.defCtRuleIdPara = (String)parameters.get("ctRuleId");
            }
            if (parameters.containsKey("ctHidePushForm")) {
                this.ctHidePushForm = (Boolean)parameters.get("ctHidePushForm");
            }
        }
    }

    public MainEntityType getSrcMainType() {
        if (this.srcMainType == null) {
            this.srcMainType = EntityMetadataCache.getDataEntityType((String)this.getEntityId());
        }
        return this.srcMainType;
    }

    protected boolean beforeInvokeOperation(OperationResult result) {
        List ctTenantData;
        if (!super.beforeInvokeOperation(result)) {
            return false;
        }
        if (this.getView() instanceof IBillView) {
            String pkValue;
            IBillModel billModel = (IBillModel)this.getView().getModel();
            String string = pkValue = billModel.getPKValue() == null ? "" : billModel.getPKValue().toString();
            if (StringUtils.isBlank((CharSequence)pkValue) || pkValue.equals("0")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"Push_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                return false;
            }
        }
        this.thirdPushManage = new ThirdPushManage(this);
        this.thirdPushManage.setThirdPushParams();
        this.opParameter = this.buildParameter();
        this.ctOpParameter = this.buildCtParameter();
        boolean ctFlag = false;
        if (StringUtils.isNotBlank((CharSequence)this.ctControlfield)) {
            long currOrgId;
            CtsyTenant ctsyTenant;
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter(this.getSrcMainType().getPrimaryKey().getName(), "in", (Object)this.opParameter.getSelectedRows().getPrimaryKeyValues()));
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.opParameter.getEntityNumber(), (String)this.ctControlfield, (QFilter[])qFilters.toArray(new QFilter[0]));
            if (dynamicObjects.length > 0 && (ctsyTenant = CtsyBaseServiceHelper.getCtsyTenant((Long)(currOrgId = ((Long)((DynamicObject)dynamicObjects[0].get(this.ctControlfield)).getPkValue()).longValue()))) != null && !RequestContext.get().getTenantCode().equals(ctsyTenant.getTenantId()) && !RequestContext.get().getAccountId().equals(String.valueOf(ctsyTenant.getAccountId()))) {
                ctFlag = true;
            }
        }
        if (!ctFlag && this.opParameter.getBills().isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u6b63\u5e38\u542f\u7528\u7684\u5355\u636e\u8f6c\u6362\u8f6c\u6362\u8def\u7ebf\u3002", (String)"Push_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return false;
        }
        if (ctFlag && ((ctTenantData = CtConvertMetaServiceHelper.loadTenantDatas((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId(), (String)this.getEntityId())) == null || ctTenantData.isEmpty())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u6b63\u5e38\u542f\u7528\u7684\u8de8\u79df\u6237\u8f6c\u6362\u8def\u7ebf\u3002", (String)"Push_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected OperationResult invokeOperation() {
        if (this.opParameter.getSelectedRows() == null || this.opParameter.getSelectedRows().size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u9700\u8981\u4e0b\u63a8\u7684\u6570\u636e", (String)"Push_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return null;
        }
        boolean ctFlag = false;
        if (StringUtils.isNotBlank((CharSequence)this.ctControlfield)) {
            if (this.getView() instanceof IBillView) {
                IBillModel billModel = (IBillModel)this.getView().getModel();
                Long orgId = (Long)((DynamicObject)billModel.getValue(this.ctControlfield)).getPkValue();
                CtsyTenant ctsyTenant = CtsyBaseServiceHelper.getCtsyTenant((Long)orgId);
                if (ctsyTenant != null && !RequestContext.get().getTenantCode().equals(ctsyTenant.getTenantId()) && !RequestContext.get().getAccountId().equals(String.valueOf(ctsyTenant.getAccountId()))) {
                    ctFlag = true;
                }
            } else if (this.getView() instanceof IListView) {
                DynamicObject[] dynamicObjects;
                CtsyTenant tenant = null;
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                qFilters.add(new QFilter(this.getSrcMainType().getPrimaryKey().getName(), "in", (Object)this.opParameter.getSelectedRows().getPrimaryKeyValues()));
                for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)this.opParameter.getEntityNumber(), (String)this.ctControlfield, (QFilter[])qFilters.toArray(new QFilter[0]))) {
                    long currOrgId = (Long)((DynamicObject)dynamicObject.get(this.ctControlfield)).getPkValue();
                    CtsyTenant ctsyTenant = CtsyBaseServiceHelper.getCtsyTenant((Long)currOrgId);
                    if (ctsyTenant != null && !RequestContext.get().getTenantCode().equals(ctsyTenant.getTenantId()) && !RequestContext.get().getAccountId().equals(String.valueOf(ctsyTenant.getAccountId()))) {
                        if (tenant == null) {
                            tenant = ctsyTenant;
                        } else if (!tenant.getTenantId().equals(ctsyTenant.getTenantId()) || !tenant.getAccountId().equals(ctsyTenant.getAccountId())) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5305\u542b\u8de8\u591a\u4e2a\u79df\u6237\u534f\u540c\u7684\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u4e0b\u63a8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"Push_6", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                            return null;
                        }
                        ctFlag = true;
                        continue;
                    }
                    if (tenant != null && ctsyTenant == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5305\u542b\u5355\u636e\u8f6c\u6362\u548c\u8de8\u79df\u6237\u534f\u540c\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u4e0b\u63a8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"Push_7", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                        return null;
                    }
                    if (tenant == null && ctsyTenant == null) break;
                }
            }
        }
        if (!ctFlag) {
            if (!this.hidePushForm) {
                this.showPushForm();
                return null;
            }
            this.doPush();
        } else {
            if (!this.ctHidePushForm) {
                this.showCtPushForm();
                return null;
            }
            this.doCtPush();
        }
        return null;
    }

    protected void afterInvokeOperation(OperationResult opResult) {
    }

    protected ConvertOpParameter buildParameter() {
        ConvertOpParameter opParameter = new ConvertOpParameter();
        opParameter.setOpType(ConvertOpType.Push);
        String appId = this.getOption().getVariableValue("checkRightAppId", "");
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            opParameter.setAppId(appId);
        }
        String entityNumber = this.getEntityId();
        opParameter.setEntityNumber(entityNumber);
        List<ConvertBill> bills = this.loadTargetBills();
        if (bills != null) {
            opParameter.getBills().addAll(bills);
        }
        if (this.getView() instanceof IListView) {
            IListView listView = (IListView)this.getView();
            opParameter.setSelectedRows(listView.getSelectedRows());
        } else if (this.getView() instanceof IBillView) {
            IBillView billView = (IBillView)this.getView();
            IBillModel billModel = (IBillModel)billView.getModel();
            ListSelectedRow row = new ListSelectedRow(billModel.getPKValue(), Boolean.valueOf(billModel.getDataEntityType().getPrimaryKey() instanceof LongProp));
            this.getAndSetBillNo(billModel, row);
            opParameter.setSelectedRows(new ListSelectedRowCollection());
            opParameter.getSelectedRows().add((Object)row);
            opParameter.getCustomParams().put("botp_isstrict", String.valueOf(false));
        }
        opParameter.setDefTargetBill(this.defTargetBill);
        opParameter.setDefRuleId(this.defRuleId);
        opParameter.setHasRight(this.hasNewRight);
        opParameter.setMustSelectRule(this.mustSelectRule);
        opParameter.setDefRuleIdPara(this.defRuleIdPara);
        if (this.getOption() != null) {
            opParameter.getCustomParams().putAll(this.getOption().getVariables());
        }
        opParameter.setOpInfo(this.getOpInfo());
        return opParameter;
    }

    protected CtConvertOpParameter buildCtParameter() {
        CtConvertOpParameter opParameter = new CtConvertOpParameter();
        String appId = this.getOption().getVariableValue("checkRightAppId", "");
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            opParameter.setAppId(appId);
        }
        String entityNumber = this.getEntityId();
        opParameter.setEntityNumber(entityNumber);
        if (this.getView() instanceof IListView) {
            IListView listView = (IListView)this.getView();
            opParameter.setSelectedRows(listView.getSelectedRows());
        } else if (this.getView() instanceof IBillView) {
            IBillView billView = (IBillView)this.getView();
            IBillModel billModel = (IBillModel)billView.getModel();
            ListSelectedRow row = new ListSelectedRow(billModel.getPKValue(), Boolean.valueOf(billModel.getDataEntityType().getPrimaryKey() instanceof LongProp));
            this.getAndSetBillNo(billModel, row);
            opParameter.setSelectedRows(new ListSelectedRowCollection());
            opParameter.getSelectedRows().add((Object)row);
            opParameter.getCustomParams().put("ctbotp_isstrict", String.valueOf(false));
        }
        opParameter.settTenantCode(this.tTenantCode);
        opParameter.settAccountId(this.tAccountId);
        opParameter.setDefTargetBill(this.defTargetBill);
        opParameter.setDefRuleId(this.defRuleId);
        opParameter.setHasRight(this.hasNewRight);
        opParameter.setMustSelectRule(this.mustSelectRule);
        opParameter.setDefRuleIdPara(this.defRuleIdPara);
        if (this.getOption() != null) {
            opParameter.getCustomParams().putAll(this.getOption().getVariables());
        }
        return opParameter;
    }

    private void getAndSetBillNo(IBillModel billModel, ListSelectedRow row) {
        MainEntityType entityType = billModel.getDataEntityType();
        if (entityType instanceof BillEntityType) {
            BillEntityType billEntityType = (BillEntityType)entityType;
            if (StringUtils.isEmpty((CharSequence)billEntityType.getBillNo())) {
                return;
            }
            String billNoValue = (String)billModel.getValue(billEntityType.getBillNo());
            if (StringUtils.isEmpty((CharSequence)billNoValue)) {
                return;
            }
            row.setBillNo(billNoValue);
        }
    }

    private void showPushForm() {
        MobileFormShowParameter showParameter;
        String opParameterJson = SerializationUtils.toJsonString((Object)this.opParameter);
        if (this.getView() instanceof MobileBillView || this.getView() instanceof MobileListView) {
            showParameter = new MobileFormShowParameter();
            showParameter.setFormId("botp_convertop_mobile");
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
        } else {
            showParameter = new FormShowParameter();
            showParameter.setFormId("botp_convertop");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
        }
        showParameter.getCustomParams().put("opinfo", SerializationUtils.toJsonString((Object)this.getOpInfo()));
        showParameter.getCustomParams().put("opparam", opParameterJson);
        showParameter.getCustomParams().put("isbillsofplugin", this.getOption().getVariableValue("isbillsofplugin", "false"));
        this.thirdPushManage.setThirdPushParams((FormShowParameter)showParameter);
        showParameter.setCaption(ResManager.loadKDString((String)"\u4e0b\u63a8", (String)"Push_4", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showCtPushForm() {
        String opParameterJson = SerializationUtils.toJsonString((Object)this.ctOpParameter);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ctbotp_convertop");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().put("opinfo", SerializationUtils.toJsonString((Object)this.getOpInfo()));
        showParameter.getCustomParams().put("opparam", opParameterJson);
        showParameter.setCaption(ResManager.loadKDString((String)"\u6570\u636e\u534f\u540c", (String)"Push_5", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    private OpInfo getOpInfo() {
        OpInfo opInfo = new OpInfo();
        opInfo.setOpKey(this.getOperateKey());
        opInfo.setOpName(this.getOperateName());
        opInfo.setOpType(this.getType());
        return opInfo;
    }

    private CtOpInfo getCtOpInfo() {
        CtOpInfo opInfo = new CtOpInfo();
        opInfo.setOpKey(this.getOperateKey());
        opInfo.setOpName(this.getOperateName());
        opInfo.setOpType(this.getType());
        return opInfo;
    }

    private void doPush() {
        PushArgs pushArgs = PushArgsFactory.newInstances();
        if (StringUtils.isNotBlank((CharSequence)this.opParameter.getAppId())) {
            pushArgs.setAppId(this.opParameter.getAppId());
        } else {
            pushArgs.setAppId(this.getView().getFormShowParameter().getCheckRightAppId());
        }
        pushArgs.setHasRight(this.opParameter.isHasRight());
        if (!Push.isMobileView(this.getView())) {
            pushArgs.addCustomParam("botp_requiredatamutex", String.valueOf(true));
        }
        pushArgs.setSourceEntityNumber(this.opParameter.getEntityNumber());
        pushArgs.setTargetEntityNumber(this.defTargetBill);
        pushArgs.setAutoSave(true);
        for (ConvertBill bill : this.opParameter.getBills()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)this.defTargetBill, (CharSequence)bill.getEntityNumber())) continue;
            for (ConvertOpRule rule : bill.getRules()) {
                pushArgs.getRuleIds().add(rule.getRuleId());
            }
        }
        if (!AllRule.equals(this.defRuleId)) {
            pushArgs.setRuleId(this.defRuleId);
        }
        pushArgs.setSelectedRows((List)this.opParameter.getSelectedRows());
        pushArgs.setBuildConvReport(true);
        pushArgs.getCustomParams().putAll(this.opParameter.getCustomParams());
        pushArgs.setOpInfo(this.getOpInfo());
        Push.addPushByBillOption(this.getView(), (AbstractConvertServiceArgs)pushArgs);
        try {
            if (this.getView() instanceof IListView && !((ListShowParameter)this.getView().getFormShowParameter()).getListUserOption().isMergeRow()) {
                Map billParameter = SystemParamServiceHelper.loadBillParameterObjectFromCache((String)this.getEntityId());
                boolean wholeConvert = MapUtils.isNotEmpty((Map)billParameter) && (Boolean)billParameter.get(BILLPARAMETER_WHOLECONVERT) != false;
                pushArgs.addCustomParam("botp_pushByBill", String.valueOf(wholeConvert));
                if (wholeConvert) {
                    List selectedRows = pushArgs.getSelectedRows();
                    for (ListSelectedRow selectedRow : selectedRows) {
                        selectedRow.setEntryPrimaryKeyValue(null);
                        selectedRow.setSubEntryPrimaryKeyValue(null);
                    }
                    pushArgs.setSelectedRows(selectedRows);
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        ConvertOperationResult convertResult = ConvertServiceHelper.push(pushArgs);
        if (!convertResult.isSuccess() || convertResult.getCachePageIds().size() + convertResult.getTargetBillIds().size() == 0) {
            Push.showReport(this.getView(), (AbstractConvertServiceArgs)pushArgs, convertResult);
        } else if (convertResult.getCachePageIds().size() + convertResult.getTargetBillIds().size() == 1) {
            Push.showTargetBill(this.getView(), pushArgs, convertResult, false);
        } else {
            Push.showMultiTargetBills(this.getView(), pushArgs, convertResult, false);
        }
    }

    private void doCtPush() {
        CtPushArgs pushArgs = new CtPushArgs();
        pushArgs.setHasRight(this.ctOpParameter.isHasRight());
        pushArgs.setSourceEntityNumber(this.ctOpParameter.getEntityNumber());
        pushArgs.setTargetEntityNumber(this.defCtTargetBill);
        pushArgs.setAutoSave(true);
        pushArgs.settTenantCode(this.tTenantCode);
        pushArgs.settAccountId(this.tAccountId);
        pushArgs.setSyncType(this.syncType);
        pushArgs.setSourceOperate(SourceOperateEnum.OPERATE.getValue());
        pushArgs.setRootJobId(Long.valueOf(ID.genLongId()));
        pushArgs.setRuleId(this.defCtRuleId);
        pushArgs.setSelectedRows((List)this.ctOpParameter.getSelectedRows());
        pushArgs.setBuildConvReport(true);
        pushArgs.getCustomParams().putAll(this.ctOpParameter.getCustomParams());
        pushArgs.setOpInfo(this.getCtOpInfo());
        CtPush.addPushByBillOption((IFormView)this.getView(), (AbstractCtConvertServiceArgs)pushArgs);
        if (SyncTypeEnum.REVERSE.getValue().equals(this.syncType)) {
            List ids = pushArgs.getSelectedRows().stream().map(a -> Long.parseLong(a.getPrimaryKeyValue().toString())).collect(Collectors.toList());
            List ctBillLks = CtBillLinkService.getCtBillLks(ids, (String)pushArgs.getSourceEntityNumber());
            pushArgs.setCtBillLks(ctBillLks);
        }
        CtConvertOperationResult ctConvertOperationResult = CtConvertServiceHelper.ctPush((CtPushArgs)pushArgs);
        CtPush.showReport((IFormView)this.getView(), (AbstractCtConvertServiceArgs)pushArgs, (CtConvertOperationResult)ctConvertOperationResult);
    }

    public static void addPushByBillOption(IFormView view, AbstractConvertServiceArgs args) {
        ListShowParameter showParameter;
        if (view instanceof IListView && (showParameter = (ListShowParameter)view.getFormShowParameter()).getListUserOption() != null && showParameter.getListUserOption().isMergeRow()) {
            args.addCustomParam("botp_pushByBill", String.valueOf(true));
        }
    }

    public static void showTargetBill(IFormView view, PushArgs pushArgs, ConvertOperationResult convertResult, boolean showReport) {
        boolean isBasedata;
        Object showParameter = null;
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)pushArgs.getTargetEntityNumber());
        boolean bl = isBasedata = mainType instanceof BasedataEntityType;
        if (Push.isMobileView(view)) {
            Object mShowParameter = null;
            mShowParameter = isBasedata ? new MobileBaseShowParameter() : new MobileBillShowParameter();
            if (StringUtils.isNotBlank((CharSequence)convertResult.getTargetMobFormId())) {
                mShowParameter.setFormId(convertResult.getTargetMobFormId());
            } else {
                mShowParameter.setFormId(pushArgs.getTargetEntityNumber() + "_mob");
            }
            mShowParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter = mShowParameter;
        } else {
            showParameter = isBasedata ? new BaseShowParameter() : new BillShowParameter();
            showParameter.setFormId(convertResult.loadTargetLayoutFormId());
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        }
        if (convertResult.getTargetBillIds().isEmpty()) {
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.setCachePageId((String)convertResult.getCachePageIds().get(0));
        } else {
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setPkId(convertResult.getTargetBillIds().iterator().next());
        }
        showParameter.setHasRight(true);
        showParameter.getCustomParams().put("isIgnoreLicense", true);
        showParameter.getCustomParams().put("botptag_of_datasource", String.valueOf(true));
        showParameter.addCustPlugin("kd.bos.form.plugin.botp.ConvertTrackerEdit");
        showParameter.getCustomParams().put("showreport", String.valueOf(showReport));
        Map billParameter = SystemParamServiceHelper.loadBillParameterObjectFromCache((String)pushArgs.getSourceEntityNumber());
        if (MapUtils.isNotEmpty((Map)billParameter)) {
            boolean popupShowReport = (Boolean)billParameter.get(BILLPARAMETER_POPUPSHOWREPORT);
            showParameter.getCustomParams().put("showreport", String.valueOf(popupShowReport));
        }
        if (StringUtils.isNotBlank((CharSequence)pushArgs.getAppId())) {
            showParameter.getCustomParams().put("checkRightAppId", pushArgs.getAppId());
        }
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        String resultJson = SerializationUtils.toJsonString((Object)convertResult);
        pageCache.put("ConvertOperationResult", resultJson);
        HashSet srcBillIds = new HashSet(convertResult.getDataMutexSrcBillIds());
        ConvertResultMutex convertResultMutex = new ConvertResultMutex(convertResult.getSourceEntityNumber(), srcBillIds);
        showParameter.getCustomParams().put("botp_mutex_message", SerializationUtils.toJsonString((Object)convertResultMutex));
        String simpleResultJson = SerializationUtils.toJsonString((Object)convertResult.createSimpleConvertOperationResult());
        pageCache.put("ConvertOperationResult_Simple", simpleResultJson);
        view.showForm((FormShowParameter)showParameter);
    }

    public static void showMultiTargetBills(IFormView view, PushArgs pushArgs, ConvertOperationResult convertResult, boolean showReport) {
        Push.showMultiTargetBills(view, pushArgs, convertResult, showReport, null);
    }

    public static void showMultiTargetBills(IFormView view, PushArgs pushArgs, ConvertOperationResult convertResult, boolean showReport, Map<String, Object> customParams) {
        MobileFormShowParameter showParameter;
        if (view instanceof IMobileView) {
            showParameter = new MobileFormShowParameter();
            showParameter.setFormId("botp_mobile_convertresult");
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
        } else {
            showParameter = new FormShowParameter();
            showParameter.setFormId("botp_convertresult");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        }
        showParameter.getCustomParams().put("ServiceAppId", Push.getAppNumber(pushArgs.getTargetEntityNumber()));
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        String resultJson = SerializationUtils.toJsonString((Object)convertResult);
        pageCache.put("ConvertOperationResult", resultJson);
        String simpleResultJson = SerializationUtils.toJsonString((Object)convertResult.createSimpleConvertOperationResult());
        pageCache.put("ConvertOperationResult_Simple", simpleResultJson);
        showParameter.getCustomParams().put("targetentitynumber", pushArgs.getTargetEntityNumber());
        showParameter.getCustomParams().put("sourceentitynumber", pushArgs.getSourceEntityNumber());
        showParameter.getCustomParams().put("showreport", String.valueOf(showReport));
        if (customParams != null && !customParams.isEmpty()) {
            showParameter.getCustomParams().putAll(customParams);
        }
        MainEntityType targetEntityType = null;
        try {
            targetEntityType = EntityMetadataCache.getDataEntityType((String)convertResult.getTargetEntityNumber());
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        String caption = ResManager.loadKDString((String)"\u4e0b\u63a8\u7ed3\u679c", (String)"Push_8", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
        if (targetEntityType != null) {
            caption = caption + "-" + targetEntityType.getDisplayName();
        }
        showParameter.setCaption(caption);
        view.showForm((FormShowParameter)showParameter);
    }

    private static String getAppNumber(String entityNumber) {
        return FormMetadataCache.getFormConfig((String)entityNumber).getAppId();
    }

    public static void showReport(IFormView view, AbstractConvertServiceArgs convertArgs, ConvertOperationResult convertResult) {
        if (convertResult.getBillReports().isEmpty()) {
            view.showErrorNotification(convertResult.getMessage());
            return;
        }
        if (Push.isMobileView(view)) {
            Push.showMobileReport(view, convertArgs, convertResult);
            return;
        }
        String resultJson = SerializationUtils.toJsonString((Object)convertResult);
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        pageCache.put("ConvertOperationResult", resultJson);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_convertreport");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getOpenStyle().setInlineStyleCss(new StyleCss());
        showParameter.getOpenStyle().getInlineStyleCss().setHeight("410px");
        showParameter.getOpenStyle().getInlineStyleCss().setWidth("850px");
        showParameter.setShowTitle(true);
        showParameter.getCustomParams().put("convertresultpageid", view.getPageId());
        showParameter.getCustomParams().put("targetentitynumber", convertArgs.getTargetEntityNumber());
        showParameter.getCustomParams().put("releaseresult", String.valueOf(true));
        view.showForm(showParameter);
    }

    private static void showMobileReport(IFormView view, AbstractConvertServiceArgs convertArgs, ConvertOperationResult convertResult) {
        String failMessage = convertResult.getMessage();
        if (!convertResult.getBillReports().isEmpty()) {
            SourceBillReport billReport = (SourceBillReport)convertResult.getBillReports().get(0);
            if (!billReport.getFailMessages().isEmpty()) {
                failMessage = (String)billReport.getFailMessages().get(0);
            } else if (!billReport.getLinkEntityRowReports().isEmpty()) {
                failMessage = ((SourceRowReport)billReport.getLinkEntityRowReports().get(0)).getFailMessage();
            }
        }
        view.showErrorNotification(failMessage);
    }

    public static boolean isMobileView(IFormView view) {
        return view instanceof IMobileView;
    }

    private List<ConvertBill> loadTargetBills() {
        String sourceEntityNumber = this.getEntityId();
        List<ConvertBill> bills = null;
        String billOfPushPluginArgs = this.getOption().getVariableValue("billsofpushpluginargs", "");
        if (this.hidePushForm && StringUtils.isNotBlank((CharSequence)this.defTargetBill)) {
            bills = new ArrayList<ConvertBill>();
            ConvertBill targetBill = new ConvertBill();
            targetBill.setEntityNumber(this.defTargetBill);
            bills.add(targetBill);
        } else {
            if (StringUtils.isNotBlank((CharSequence)billOfPushPluginArgs)) {
                bills = ConvertBillFilterUtil.loadPushBillsOfPlugin(billOfPushPluginArgs);
                return bills;
            }
            bills = ConvertMetaServiceHelper.loadConvertBills(sourceEntityNumber, ConvertOpType.Push);
        }
        Set<Long> srcBillTypeIds = this.getSrcBillTypeIds();
        return ConvertBillFilterUtil.filterConvertBillsOfPush(bills, this.thirdPushManage, this.getEntityId(), this.hidePushForm, srcBillTypeIds);
    }

    public Set<Long> getSrcOrgIds() {
        DynamicObject orgObj;
        String mainOrgKey;
        HashSet<Long> orgIds = new HashSet<Long>();
        if (this.getView() instanceof IListView) {
            for (ListSelectedRow row : this.getListSelectedData()) {
                if (Long.compare(0L, row.getMainOrgId()) == 0) continue;
                orgIds.add(row.getMainOrgId());
            }
        } else if (this.getView() instanceof IBillView && StringUtils.isNotBlank((CharSequence)(mainOrgKey = this.getView().getModel().getDataEntityType().getMainOrg())) && (orgObj = (DynamicObject)this.getView().getModel().getValue(mainOrgKey)) != null) {
            orgIds.add((Long)orgObj.getPkValue());
        }
        return orgIds;
    }

    private Set<Long> getSrcBillTypeIds() {
        DynamicObject billTypeObj;
        String billTypeKey;
        HashSet<Long> billTypeIds = new HashSet<Long>();
        if (this.getView() instanceof IListView) {
            for (ListSelectedRow row : this.getListSelectedData()) {
                if (row.getBillTypeID() == null || Long.compare(0L, row.getBillTypeID()) == 0) continue;
                billTypeIds.add(row.getBillTypeID());
            }
        } else if (this.getView() instanceof IBillView && StringUtils.isNotBlank((CharSequence)(billTypeKey = ((BillEntityType)this.getView().getModel().getDataEntityType()).getBillType())) && (billTypeObj = (DynamicObject)this.getView().getModel().getValue(billTypeKey)) != null) {
            billTypeIds.add((Long)billTypeObj.getPkValue());
        }
        return billTypeIds;
    }
}

