/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.botp;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.ConvertOpProgressCache;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.util.botp.JobFormProgressUtil;

public class PushBigDataTask
extends AbstractTask {
    private PushArgs pushArgs;
    private static final Log log = LogFactory.getLog(PushBigDataTask.class);

    public void execute(RequestContext rc, Map<String, Object> params) throws KDBizException {
        String paramKey = PushArgs.class.getSimpleName();
        Object pushArgsTaskId = params.get(paramKey + "_taskId");
        if (pushArgsTaskId == null) {
            throw new RuntimeException("PushBigDataTask execute error, pushArgs taskId is null");
        }
        String pushArgsStr = ConvertOpProgressCache.getParamAndClear((String)pushArgsTaskId.toString(), (String)paramKey);
        if (StringUtils.isBlank((CharSequence)pushArgsStr)) {
            throw new RuntimeException("PushBigDataTask execute error, pushArgs is null");
        }
        this.pushArgs = (PushArgs)SerializationUtils.fromJsonString((String)pushArgsStr, PushArgs.class);
        this.pushArgs.setJobTaskId(this.taskId);
        rc.setOrgId(this.pushArgs.getCurrentOrgId().longValue());
        RequestContext.copyAndSet((RequestContext)rc);
        ConvertOperationResult result = null;
        try {
            result = ConvertServiceHelper.push(this.pushArgs);
        }
        catch (KDBizException exp) {
            result = new ConvertOperationResult();
            result.setSuccess(false);
            result.setMessage(exp.getMessage());
            log.error("PushBigDataTask-KDBizException", (Throwable)exp);
        }
        catch (Throwable exp) {
            Throwable cause = this.getCause(exp);
            String errMessage = String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u6267\u884c\u9047\u5230\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u9519\u8bef\u65e5\u5fd7: %s", (String)"PushBigDataTask_0", (String)"bos-botp-business", (Object[])new Object[0]), cause.getMessage());
            ConvertOpProgressCache.setError((String)this.pushArgs.getTaskId(), (boolean)true, (String)errMessage);
            log.error(errMessage, exp);
        }
        ConvertOpProgressCache.setFinished((String)this.pushArgs.getTaskId(), (boolean)true);
        JobFormProgressUtil.setFinished(this.pushArgs.getJobTaskId(), pushArgsStr, result);
    }

    private Throwable getCause(Throwable exp) {
        Throwable cause = exp;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }
}

