/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.botp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.LookTrackerArgs;
import kd.bos.entity.botp.ctbotp.CtBotpLinkBill;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.operate.botp.CtTrackUpManage;
import kd.bos.form.operate.botp.TrackUp;
import kd.bos.list.IListView;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;

public class TrackDown
extends TrackUp {
    private static final long serialVersionUID = 804586050693935384L;
    private String targetBill;
    private String checkRightBill;
    private Set<String> targetBills;
    private Set<String> checkRightBills;
    private Set<String> pushBills = new HashSet<String>(4);

    @Override
    public void initialize(Map<String, Object> arg0) {
        super.initialize(arg0);
        Map parameters = (Map)arg0.get("parameter");
        if (parameters != null) {
            if (parameters.containsKey("targetbill")) {
                this.targetBill = (String)parameters.get("targetbill");
            }
            this.checkRightBill = (String)parameters.get("track_checkrightbills");
        }
    }

    public String getCheckRightBill() {
        return this.checkRightBill;
    }

    public void setCheckRightBill(String checkRightBill) {
        this.checkRightBill = checkRightBill;
    }

    private Set<String> getTargetBillsList() {
        if (this.targetBills == null) {
            this.targetBills = this.splitBillsString(this.targetBill);
        }
        return this.targetBills;
    }

    private Set<String> getCheckRightBillsList() {
        if (this.checkRightBills == null) {
            this.checkRightBills = this.splitBillsString(this.checkRightBill);
        }
        return this.checkRightBills;
    }

    private Set<String> splitBillsString(String entityNumbersString) {
        String TargetBillsString = entityNumbersString;
        if (StringUtils.isBlank((CharSequence)TargetBillsString)) {
            return new HashSet<String>(0);
        }
        if (TargetBillsString.startsWith(",")) {
            TargetBillsString = TargetBillsString.substring(1, TargetBillsString.length() - 1);
        }
        String[] bills = TargetBillsString.split(",");
        HashSet<String> targetBills = new HashSet<String>(bills.length);
        for (String bill : bills) {
            if (!StringUtils.isNotBlank((CharSequence)bill)) continue;
            targetBills.add(bill);
        }
        return targetBills;
    }

    @Override
    protected String getLookUpType() {
        return "lookdown";
    }

    @Override
    protected String loadAndSeriLinkNodes() {
        List<BFRowLinkDownNode> nodes = null;
        HashSet<Long> billIds = this.getSelectedBillIds();
        if (!billIds.isEmpty()) {
            nodes = this.getBfRowLinkDownNodes();
        }
        if (nodes == null || nodes.size() == 0) {
            return null;
        }
        if ((nodes = this.filterTargetBill(nodes)).isEmpty()) {
            return null;
        }
        HashSet<Long> successBillIds = new HashSet<Long>(nodes.size());
        for (BFRowLinkDownNode node : nodes) {
            if (node.getTNodes() == null || node.getTNodes().isEmpty()) continue;
            successBillIds.add(node.getRowId().getBillId());
        }
        this.getTrackResult().getSuccessPkIds().addAll(successBillIds);
        String nodesJson = SerializationUtils.serializeToBase64(nodes);
        return nodesJson;
    }

    @Override
    protected List<CtBotpLinkBill> getCtBotpLinkBill(HashSet<Long> billIds) {
        return CtTrackUpManage.getCtBotpLinkBill(false, this.getEntityId(), billIds);
    }

    private List<BFRowLinkDownNode> getBfRowLinkDownNodes() {
        LookTrackerArgs lookTrackerArgs = this.thirdTrackUpManage.getLookTrackParams();
        List<BFRowLinkDownNode> bfRowLinkDownNodes = null;
        if (!this.checkLookTrackParams(lookTrackerArgs, this.isSearchEntry())) {
            return bfRowLinkDownNodes;
        }
        if (this.isSearchEntry() && this.getView() instanceof IListView) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("botp_track_only_dirt_link", String.valueOf(!this.isTrackAll()));
            operateOption.setVariableValue("botp_track_search_entry", String.valueOf(true));
            bfRowLinkDownNodes = BFTrackerServiceHelper.loadLinkDownNodes(lookTrackerArgs.getEntityNumber(), lookTrackerArgs.getEntryKey(), lookTrackerArgs.getBillIds().toArray(new Long[lookTrackerArgs.getBillIds().size()]), lookTrackerArgs.getEntityIds().toArray(new Long[lookTrackerArgs.getEntityIds().size()]), operateOption);
        } else {
            Map<Long, BFRowLinkDownNode> map = BFTrackerServiceHelper.loadBillLinkDownNodes(lookTrackerArgs.getEntityNumber(), lookTrackerArgs.getBillIds().toArray(new Long[lookTrackerArgs.getBillIds().size()]), !this.isTrackAll());
            if (map != null) {
                bfRowLinkDownNodes = new ArrayList<BFRowLinkDownNode>(map.values());
            }
        }
        return bfRowLinkDownNodes;
    }

    private List<BFRowLinkDownNode> filterTargetBill(List<BFRowLinkDownNode> nodes) {
        Set<String> checkRightBills = this.getCheckRightBillsList();
        if (!checkRightBills.isEmpty()) {
            ArrayList allNodes = new ArrayList();
            for (BFRowLinkDownNode bFRowLinkDownNode : nodes) {
                allNodes.addAll(bFRowLinkDownNode.findAllChildNodes());
            }
            HashMap<Long, HashSet<Long>> idsGroup = new HashMap<Long, HashSet<Long>>(allNodes.size());
            for (BFRowLinkDownNode bFRowLinkDownNode : allNodes) {
                HashSet<Long> ids = (HashSet<Long>)idsGroup.get(bFRowLinkDownNode.getRowId().getMainTableId());
                if (ids == null) {
                    ids = new HashSet<Long>();
                    idsGroup.put(bFRowLinkDownNode.getRowId().getMainTableId(), ids);
                }
                ids.add(bFRowLinkDownNode.getRowId().getBillId());
            }
            for (Map.Entry entry : idsGroup.entrySet()) {
                String entityNumber = EntityMetadataCache.loadTableDefine((Long)((Long)entry.getKey())).getEntityNumber();
                if (!this.getCheckRightBillsList().contains(entityNumber)) continue;
                this.batchCheckViewRight(entityNumber, (Set)entry.getValue());
            }
        }
        Iterator<BFRowLinkDownNode> listIt = nodes.iterator();
        while (listIt.hasNext()) {
            BFRowLinkDownNode node = listIt.next();
            Map map = node.getTNodes();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!this.filterTargetBill((BFRowLinkDownNode)entry.getValue())) {
                    iterator.remove();
                    continue;
                }
                this.filterTargetBill(((BFRowLinkDownNode)entry.getValue()).getTNodes());
            }
            if (node.getTNodes().size() != 0) continue;
            listIt.remove();
        }
        this.addNoRightMessages();
        if (nodes.isEmpty() && !this.pushBills.isEmpty() && this.getTrackResult() != null && this.getTrackResult().getAllErrorOrValidateInfo().isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u5728\u9650\u5b9a\u7684\u4e0b\u67e5\u5355\u636e\u8303\u56f4\u5185\uff0c\u6ca1\u6709\u627e\u5230\u5173\u8054\u6570\u636e\u3002", (String)"TrackDown_3", (String)"bos-botp-business", (Object[])new Object[0]);
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
            operateErrorInfo.setLevel(ErrorLevel.Error);
            operateErrorInfo.setMessage(msg);
            this.getTrackResult().addErrorInfo(operateErrorInfo);
        }
        return nodes;
    }

    private Map<BFRowId, BFRowLinkDownNode> filterTargetBill(Map<BFRowId, BFRowLinkDownNode> nodes) {
        Iterator<Map.Entry<BFRowId, BFRowLinkDownNode>> mapIt = nodes.entrySet().iterator();
        while (mapIt.hasNext()) {
            BFRowLinkDownNode node = mapIt.next().getValue();
            if (!this.filterTargetBill(node)) {
                mapIt.remove();
                continue;
            }
            this.filterTargetBill(node.getTNodes());
        }
        return nodes;
    }

    private boolean filterTargetBill(BFRowLinkDownNode node) {
        Long mainTableId = node.getRowId().getMainTableId();
        String entityNumber = EntityMetadataCache.loadTableDefine((Long)mainTableId).getEntityNumber();
        Set<String> targetBills = this.getTargetBillsList();
        Set<String> checkRightBills = this.getCheckRightBillsList();
        if (!targetBills.isEmpty() && !targetBills.contains(entityNumber)) {
            this.pushBills.add(entityNumber);
            return false;
        }
        if (!checkRightBills.contains(entityNumber)) {
            return true;
        }
        return this.checkViewRight(entityNumber, node.getRowId().getBillId());
    }
}

