/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.botp;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.LookTrackerArgs;
import kd.bos.entity.botp.ctbotp.CtBotpLinkBill;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.list.option.ListUserOption;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.ShowType;
import kd.bos.form.operate.DefaultDynamicFormOperate;
import kd.bos.form.operate.OpFieldValueReader;
import kd.bos.form.operate.botp.CtTrackUpManage;
import kd.bos.form.operate.botp.OperateRightChecker;
import kd.bos.form.operate.botp.ThirdTrackUpManage;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.mservice.sysparam.SystemParamService;
import kd.bos.mvc.bill.MobileBillView;
import kd.bos.mvc.list.MobileListView;
import kd.bos.orm.ORM;
import kd.bos.orm.dataentity.ShardingHinter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.xdb.hint.ShardingHintContext;

public class TrackUp
extends DefaultDynamicFormOperate
implements Serializable {
    private static final long serialVersionUID = 6702364513097312980L;
    private String entryKey = "";
    private String subEntryKey = "";
    private boolean trackAll;
    private boolean searchEntry;
    private boolean checkSrcRight;
    private Map<String, String> checkRightAppIds = null;
    private OperateRightChecker rightChecker;
    private OperationResult trackResult = null;
    private Set<Long> selectedBillIds = new HashSet<Long>(1);
    private Set<Long> selectedEntryIds = new HashSet<Long>(1);
    private Set<Long> selectedSubEntryIds = new HashSet<Long>(1);
    public ThirdTrackUpManage thirdTrackUpManage;
    private static final String BOS_FORM_BUSINESS = "bos-botp-business";
    private static SystemParamService systemParamService = (SystemParamService)ServiceFactory.getService(SystemParamService.class);

    protected String getEntryKey() {
        return this.entryKey;
    }

    protected void setEntryKey(String entryKey) {
        this.entryKey = entryKey;
    }

    protected String getSubEntryKey() {
        return this.subEntryKey;
    }

    protected void setSubEntryKey(String subEntryKey) {
        this.subEntryKey = subEntryKey;
    }

    public boolean isCheckSrcRight() {
        return this.checkSrcRight;
    }

    public void setCheckSrcRight(boolean checkSrcRight) {
        this.checkSrcRight = checkSrcRight;
    }

    protected boolean isTrackAll() {
        return this.trackAll;
    }

    protected void setTrackAll(boolean trackAll) {
        this.trackAll = trackAll;
    }

    public boolean isSearchEntry() {
        return this.searchEntry;
    }

    public void setSearchEntry(boolean searchEntry) {
        this.searchEntry = searchEntry;
    }

    protected OperationResult getTrackResult() {
        return this.trackResult;
    }

    public OperateRightChecker getRightChecker() {
        if (this.rightChecker == null) {
            this.rightChecker = new OperateRightChecker();
        }
        return this.rightChecker;
    }

    public void initialize(Map<String, Object> arg0) {
        super.initialize(arg0);
        Map parameters = (Map)arg0.get("parameter");
        if (parameters != null) {
            if (parameters.containsKey("istrackall")) {
                this.setTrackAll((Boolean)parameters.get("istrackall"));
            }
            if (parameters.containsKey("issearchentry")) {
                this.setSearchEntry((Boolean)parameters.get("issearchentry"));
            }
            if (parameters.containsKey("track_checksrcright")) {
                this.checkSrcRight = (Boolean)parameters.get("track_checksrcright");
            }
        }
    }

    public Map<String, String> getCheckRightAppIds() {
        if (this.checkRightAppIds != null) {
            return this.checkRightAppIds;
        }
        String opValue = this.getOption().getVariableValue("track_checkrightappids", "");
        this.checkRightAppIds = StringUtils.isBlank((CharSequence)opValue) ? new HashMap<String, String>(0) : (Map)SerializationUtils.fromJsonString((String)opValue, Map.class);
        return this.checkRightAppIds;
    }

    public void setCheckRightAppIds(Map<String, String> appIds) {
        this.checkRightAppIds.clear();
        if (appIds == null || appIds.isEmpty()) {
            this.getOption().removeVariable("track_checkrightappids");
        } else {
            this.checkRightAppIds.putAll(appIds);
            String opValue = SerializationUtils.toJsonString(appIds);
            this.getOption().setVariableValue("track_checkrightappids", opValue);
        }
    }

    protected boolean beforeInvokeOperation(OperationResult result) {
        if (!super.beforeInvokeOperation(result)) {
            return false;
        }
        if (this.getView() instanceof IBillView) {
            String pkValue;
            IBillModel billModel = (IBillModel)this.getView().getModel();
            String string = pkValue = billModel.getPKValue() == null ? "" : billModel.getPKValue().toString();
            if (StringUtils.isBlank((CharSequence)pkValue) || pkValue.equals("0")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"TrackUp_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                return false;
            }
        }
        this.thirdTrackUpManage = new ThirdTrackUpManage(this);
        this.thirdTrackUpManage.setThirdTrackParams();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OperationResult invokeOperation() {
        String linkNodesJson;
        FormShowParameter showParameter;
        HashSet<Long> billIds = this.getSelectedBillIds();
        HashSet<Long> entryIds = this.getSelectedEntryIds();
        if (!this.checkSearchEntry(entryIds)) {
            return null;
        }
        if (billIds.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u8054\u67e5\u7684\u6570\u636e\u3002", (String)"TrackUp_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return null;
        }
        String ctBotpLinkBillJson = null;
        IDataEntityType dt = ORM.create().getDataEntityType(this.getEntityId());
        ShardingHintContext ctx = ShardingHinter.tryHint((IDataEntityType)dt, (Object[])billIds.toArray());
        if (ctx != null) {
            ctx.set();
        }
        try {
            this.checkTrackByEntry();
            showParameter = new FormShowParameter();
            Object lookUpTrackerUseList = systemParamService.loadPublicParameterFromCache("lookuptracker_use_list");
            String isUseList = lookUpTrackerUseList == null ? String.valueOf(false) : lookUpTrackerUseList.toString();
            showParameter.getCustomParams().put("lookuptracker_use_list", isUseList);
            if (this.getView() instanceof IListView) {
                showParameter.getCustomParams().put("issearchentry", this.isSearchEntry());
            }
            if (this.getView() instanceof MobileBillView || this.getView() instanceof MobileListView) {
                showParameter.setFormId("botp_moblookuptracker");
                showParameter.getOpenStyle().setShowType(ShowType.Floating);
            } else {
                showParameter.setFormId("botp_lookuptracker");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            }
            showParameter.setPageId(this.buildTrackFormPageId());
            showParameter.setCaption(this.buildTrackFormCaption());
            this.trackResult = new OperationResult();
            this.trackResult.setSuccess(true);
            this.trackResult.setBillCount(billIds.size());
            linkNodesJson = this.loadAndSeriLinkNodes();
            List<CtBotpLinkBill> ctBotpLinkBills = this.getCtBotpLinkBill(billIds);
            if (CollectionUtils.isNotEmpty(ctBotpLinkBills)) {
                ctBotpLinkBillJson = SerializationUtils.serializeToBase64(this.getCtBotpLinkBill(billIds));
            }
        }
        finally {
            if (ctx != null) {
                ctx.close();
            }
        }
        if (StringUtils.isBlank((CharSequence)linkNodesJson) && StringUtils.isBlank((CharSequence)ctBotpLinkBillJson)) {
            String msg = ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"TrackUp_8", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
            if (this.isSearchEntry()) {
                msg = ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u5b58\u5728\u5173\u8054\u5173\u7cfb\u7684\u5206\u5f55\u6570\u636e\u3002", (String)"TrackUp_13", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
            }
            if (this.getTrackResult().getAllErrorOrValidateInfo().isEmpty()) {
                this.getView().showTipNotification(msg);
            } else {
                if (StringUtils.isBlank((CharSequence)this.trackResult.getMessage())) {
                    this.trackResult.setMessage(msg);
                }
                this.trackResult.setSuccess(false);
                this.getView().showOperationResult(this.trackResult);
            }
            return null;
        }
        if (!this.trackResult.getAllErrorOrValidateInfo().isEmpty()) {
            this.getView().showOperationResult(this.trackResult);
        }
        showParameter.getCustomParams().put("linknodes", linkNodesJson);
        showParameter.getCustomParams().put("ctbotplinknodes", ctBotpLinkBillJson);
        showParameter.getCustomParams().put("lookuptype", this.getLookUpType());
        showParameter.getCustomParams().put("track_checkrightappids", this.getOption().getVariableValue("track_checkrightappids", ""));
        if (this.getOption().containsVariable("botp_track_edit_status")) {
            showParameter.getCustomParams().put("botp_track_edit_status", this.getOption().getVariableValue("botp_track_edit_status", String.valueOf(false)));
        }
        if (this.getOption().containsVariable("botp_track_cust_plugin")) {
            showParameter.getCustomParams().put("botp_track_cust_plugin", this.getOption().getVariableValue("botp_track_cust_plugin", ""));
        }
        this.getView().showForm(showParameter);
        return null;
    }

    protected List<CtBotpLinkBill> getCtBotpLinkBill(HashSet<Long> billIds) {
        return CtTrackUpManage.getCtBotpLinkBill(true, this.getEntityId(), billIds);
    }

    private boolean checkSearchEntry(HashSet<Long> entryIds) {
        String operateName;
        if (this.getView() instanceof IMobileView || this.getView() instanceof IBillView) {
            this.setSearchEntry(Boolean.FALSE);
            return true;
        }
        if (!"lookup".equals(this.getLookUpType()) && !"lookdown".equals(this.getLookUpType())) {
            return true;
        }
        String string = operateName = "lookdown".equals(this.getLookUpType()) ? ResManager.loadKDString((String)"\u4e0b\u67e5", (String)"TrackUp_4", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0a\u67e5", (String)"TrackUp_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
        if (this.isSearchEntry() && this.checkIsMergeRow()) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5217\u8868%s\u4ec5\u67e5\u8be2\u5173\u8054\u5206\u5f55\u884c\uff0c\u8bf7\u6253\u5f00\u5217\u8868\u9009\u9879 \u201c\u5206\u5f55\u884c\u652f\u6301\u88ab\u9009\u62e9\u201d\u3002", (String)"TrackUp_11", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), operateName));
            return false;
        }
        if (this.isSearchEntry() && !this.checkIsMergeRow() && entryIds.size() == 0) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u6ca1\u6709\u5206\u5f55\u6570\u636e\uff0c\u4e0d\u652f\u6301%s\u5173\u8054\u5173\u7cfb\u5206\u5f55\u3002", (String)"TrackUp_12", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), operateName));
            return false;
        }
        return true;
    }

    private boolean checkIsMergeRow() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)formShowParameter;
            ListUserOption listOption = listShowParameter.getListUserOption();
            if (listOption == null) {
                listOption = new ListUserOption();
            }
            return listOption.isMergeRow();
        }
        return false;
    }

    protected void afterInvokeOperation(OperationResult opResult) {
    }

    protected String getLookUpType() {
        return "lookup";
    }

    protected String loadAndSeriLinkNodes() {
        List<BFRowLinkUpNode> nodes = null;
        HashSet<Long> billIds = this.getSelectedBillIds();
        if (!billIds.isEmpty()) {
            nodes = this.getBfRowLinkUpNodes();
        }
        if (nodes == null || nodes.size() == 0) {
            return null;
        }
        if ((nodes = this.filterSourceBill(nodes)).isEmpty()) {
            return null;
        }
        HashSet<Long> successBillIds = new HashSet<Long>(nodes.size());
        for (BFRowLinkUpNode node : nodes) {
            if (node.getSNodes() == null || node.getSNodes().isEmpty()) continue;
            successBillIds.add(node.getRowId().getBillId());
        }
        this.trackResult.getSuccessPkIds().addAll(successBillIds);
        String nodesJson = SerializationUtils.serializeToBase64(nodes);
        return nodesJson;
    }

    private List<BFRowLinkUpNode> getBfRowLinkUpNodes() {
        LookTrackerArgs lookTrackerArgs = this.thirdTrackUpManage.getLookTrackParams();
        List<BFRowLinkUpNode> bfRowLinkUpNodes = null;
        if (!this.checkLookTrackParams(lookTrackerArgs, this.isSearchEntry())) {
            return bfRowLinkUpNodes;
        }
        if (this.isSearchEntry() && this.getView() instanceof IListView) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("botp_track_only_dirt_link", String.valueOf(!this.isTrackAll()));
            operateOption.setVariableValue("botp_track_search_entry", String.valueOf(true));
            bfRowLinkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes(lookTrackerArgs.getEntityNumber(), lookTrackerArgs.getEntryKey(), lookTrackerArgs.getBillIds().toArray(new Long[lookTrackerArgs.getBillIds().size()]), lookTrackerArgs.getEntityIds().toArray(new Long[lookTrackerArgs.getEntityIds().size()]), operateOption);
        } else {
            Map<Long, BFRowLinkUpNode> map = BFTrackerServiceHelper.loadBillLinkUpNodes(lookTrackerArgs.getEntityNumber(), lookTrackerArgs.getBillIds().toArray(new Long[lookTrackerArgs.getBillIds().size()]), !this.isTrackAll());
            if (map != null) {
                bfRowLinkUpNodes = new ArrayList<BFRowLinkUpNode>(map.values());
            }
        }
        return bfRowLinkUpNodes;
    }

    public boolean checkLookTrackParams(LookTrackerArgs lookTrackerArgs, boolean isSearchEntry) {
        return !(isSearchEntry ? CollectionUtils.isEmpty((Collection)lookTrackerArgs.getBillIds()) || StringUtils.isBlank((CharSequence)lookTrackerArgs.getEntityNumber()) || StringUtils.isBlank((CharSequence)lookTrackerArgs.getEntryKey()) || CollectionUtils.isEmpty((Collection)lookTrackerArgs.getEntityIds()) : CollectionUtils.isEmpty((Collection)lookTrackerArgs.getBillIds()) || StringUtils.isBlank((CharSequence)lookTrackerArgs.getEntityNumber()));
    }

    protected void checkTrackByEntry() {
        if (this.getView() instanceof IListView) {
            IListView listView = (IListView)this.getView();
            ListShowParameter showParameter = (ListShowParameter)this.getView().getFormShowParameter();
            if (showParameter.getListUserOption() != null && showParameter.getListUserOption().isMergeRow()) {
                this.setEntryKey(null);
                this.setSubEntryKey(null);
                return;
            }
            if (listView.getSelectedRows().size() > 0) {
                String subEntryKey;
                ListSelectedRow firstRow = listView.getSelectedRows().get(0);
                String entryKey = firstRow.getEntryEntityKey();
                if (StringUtils.isNotBlank((CharSequence)entryKey)) {
                    this.setEntryKey(entryKey);
                }
                if (StringUtils.isNotBlank((CharSequence)(subEntryKey = firstRow.getSubEntryEntityKey()))) {
                    this.setSubEntryKey(subEntryKey);
                }
            }
        }
    }

    protected HashSet<Long> getSelectedBillIds() {
        IBillView billView;
        IBillModel billModel;
        HashSet<Long> billIds = new HashSet<Long>();
        if (this.getView() instanceof IListView) {
            IListView listView = (IListView)this.getView();
            for (ListSelectedRow row : listView.getSelectedRows()) {
                Long billId;
                if (!(row.getPrimaryKeyValue() instanceof Long) || billIds.contains(billId = (Long)row.getPrimaryKeyValue())) continue;
                billIds.add(billId);
            }
        } else if (this.getView() instanceof IBillView && (billModel = (IBillModel)(billView = (IBillView)this.getView()).getModel()).getPKValue() instanceof Long) {
            Long billId = (Long)billModel.getPKValue();
            billIds.add(billId);
        }
        this.selectedBillIds.addAll(billIds);
        return billIds;
    }

    protected HashSet<Long> getSelectedEntryIds() {
        HashSet<Long> entryIds = new HashSet<Long>();
        if (this.getView() instanceof IBillView) {
            return entryIds;
        }
        if (this.getView() instanceof IListView) {
            IListView listView = (IListView)this.getView();
            for (ListSelectedRow row : listView.getSelectedRows()) {
                Long entryId;
                if (row.getEntryPrimaryKeyValue() == null || !(row.getEntryPrimaryKeyValue() instanceof Long) || (entryId = (Long)row.getEntryPrimaryKeyValue()) == 0L || entryIds.contains(entryId)) continue;
                entryIds.add(entryId);
            }
        }
        this.selectedEntryIds.addAll(entryIds);
        return entryIds;
    }

    protected HashSet<Long> getSelectedSubEntryIds() {
        HashSet<Long> subEntryIds = new HashSet<Long>();
        if (this.getView() instanceof IBillView) {
            return subEntryIds;
        }
        if (this.getView() instanceof IListView) {
            IListView listView = (IListView)this.getView();
            for (ListSelectedRow row : listView.getSelectedRows()) {
                Long subEntryId;
                if (row.getSubEntryPrimaryKeyValue() == null || !(row.getSubEntryPrimaryKeyValue() instanceof Long) || subEntryIds.contains(subEntryId = (Long)row.getSubEntryPrimaryKeyValue())) continue;
                subEntryIds.add(subEntryId);
            }
        }
        this.selectedSubEntryIds.addAll(subEntryIds);
        return subEntryIds;
    }

    protected String buildTrackFormCaption() {
        Long billId;
        OpFieldValueReader fieldValueReader;
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)this.getEntityId());
        String entityName = mainType.getDisplayName().toString();
        String billNo = "";
        int billCount = this.getSelectedBillIds().size();
        if (!this.getSelectedBillIds().isEmpty() && StringUtils.isBlank((CharSequence)(billNo = (fieldValueReader = OpFieldValueReader.get((IFormView)this.getView())).getBillNo((Object)(billId = this.getSelectedBillIds().iterator().next()))))) {
            billNo = this.tryLoadBillno(mainType, billId);
        }
        String simpleClassName = this.getClass().getSimpleName();
        String opName = "";
        opName = this.getOperateName() != null ? this.getOperateName().toString() : (StringUtils.equals((CharSequence)simpleClassName, (CharSequence)"TrackUp") ? ResManager.loadKDString((String)"\u4e0a\u67e5", (String)"TrackUp_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]) : (StringUtils.equals((CharSequence)simpleClassName, (CharSequence)"TrackDown") ? ResManager.loadKDString((String)"\u4e0b\u67e5", (String)"TrackUp_4", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]) : (StringUtils.equals((CharSequence)simpleClassName, (CharSequence)"TrackAll") ? ResManager.loadKDString((String)"\u5168\u6d41\u7a0b", (String)"TrackUp_5", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8054\u67e5", (String)"TrackUp_6", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]))));
        if (billCount <= 1) {
            return MessageFormat.format("{0}({1})-{2}", entityName, billNo, opName);
        }
        return MessageFormat.format(ResManager.loadKDString((String)"{0}({1}\u7b49{2}\u5355)-{3}", (String)"TrackUp_7", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), entityName, billNo, billCount, opName);
    }

    private String tryLoadBillno(MainEntityType mainType, Object billId) {
        String billNoKey;
        DynamicObject billData = BusinessDataServiceHelper.loadSingleFromCache((Object)billId, (DynamicObjectType)mainType);
        if (billData != null && mainType instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)(billNoKey = ((BillEntityType)mainType).getBillNo()))) {
            return billData.getString(billNoKey);
        }
        return null;
    }

    protected String buildTrackFormPageId() {
        ArrayList<Long> dataIds = null;
        if (!this.selectedBillIds.isEmpty()) {
            dataIds = new ArrayList<Long>(this.selectedBillIds);
        } else if (!this.selectedEntryIds.isEmpty()) {
            dataIds = new ArrayList<Long>(this.selectedEntryIds);
        } else if (!this.selectedSubEntryIds.isEmpty()) {
            dataIds = new ArrayList<Long>(this.selectedSubEntryIds);
        }
        if (dataIds == null) {
            return null;
        }
        dataIds.sort(new LongComparator());
        int hashcode = 1;
        for (Long dataId : dataIds) {
            hashcode = 31 * (dataId == null ? 1 : dataId.hashCode());
        }
        return String.format("%s_%s_%s_%s_%s", this.getView().getPageId(), this.getOperateKey(), String.valueOf(dataIds.get(0)), dataIds.size(), hashcode);
    }

    private List<BFRowLinkUpNode> filterSourceBill(List<BFRowLinkUpNode> nodes) {
        if (!this.checkSrcRight) {
            return nodes;
        }
        ArrayList allNodes = new ArrayList();
        for (BFRowLinkUpNode bFRowLinkUpNode : nodes) {
            allNodes.addAll(bFRowLinkUpNode.findAllSourceNodes());
        }
        HashMap<Long, HashSet<Long>> idsGroup = new HashMap<Long, HashSet<Long>>(allNodes.size());
        for (BFRowLinkUpNode bFRowLinkUpNode : allNodes) {
            HashSet<Long> ids = (HashSet<Long>)idsGroup.get(bFRowLinkUpNode.getRowId().getMainTableId());
            if (ids == null) {
                ids = new HashSet<Long>();
                idsGroup.put(bFRowLinkUpNode.getRowId().getMainTableId(), ids);
            }
            ids.add(bFRowLinkUpNode.getRowId().getBillId());
        }
        for (Map.Entry entry : idsGroup.entrySet()) {
            String entityNumber = EntityMetadataCache.loadTableDefine((Long)((Long)entry.getKey())).getEntityNumber();
            this.batchCheckViewRight(entityNumber, (Set)entry.getValue());
        }
        Iterator<BFRowLinkUpNode> iterator = nodes.iterator();
        while (iterator.hasNext()) {
            BFRowLinkUpNode bFRowLinkUpNode = iterator.next();
            Map sourceBillMap = bFRowLinkUpNode.getSNodes();
            Iterator it = sourceBillMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!this.filterSourceBill((BFRowLinkUpNode)entry.getValue())) {
                    it.remove();
                    continue;
                }
                this.filterSourceBill(((BFRowLinkUpNode)entry.getValue()).getSNodes());
            }
            if (bFRowLinkUpNode.getSNodes().size() != 0) continue;
            iterator.remove();
        }
        this.addNoRightMessages();
        return nodes;
    }

    private Map<BFRowId, BFRowLinkUpNode> filterSourceBill(Map<BFRowId, BFRowLinkUpNode> nodes) {
        Iterator<Map.Entry<BFRowId, BFRowLinkUpNode>> mapIt = nodes.entrySet().iterator();
        while (mapIt.hasNext()) {
            BFRowLinkUpNode node = mapIt.next().getValue();
            if (!this.filterSourceBill(node)) {
                mapIt.remove();
                continue;
            }
            this.filterSourceBill(node.getSNodes());
        }
        return nodes;
    }

    private boolean filterSourceBill(BFRowLinkUpNode node) {
        if (!this.checkSrcRight) {
            return true;
        }
        Long mainTableId = node.getRowId().getMainTableId();
        String entityNumber = EntityMetadataCache.loadTableDefine((Long)mainTableId).getEntityNumber();
        return this.checkViewRight(entityNumber, node.getRowId().getBillId());
    }

    protected void batchCheckViewRight(String entityNumber, Set<Long> billIds) {
        String appId = this.getCheckRightAppIds().get(entityNumber);
        this.getRightChecker().checkRight(entityNumber, appId, billIds.toArray());
    }

    protected boolean checkViewRight(String entityNumber, Long billId) {
        String appId = this.getCheckRightAppIds().get(entityNumber);
        return this.getRightChecker().isHasRight(entityNumber, appId, billId);
    }

    protected void addNoRightMessages() {
        for (Map.Entry<String, Boolean> entity : this.getRightChecker().getOperateRights().entrySet()) {
            String entityNumber = entity.getKey();
            if (!entity.getValue().booleanValue()) {
                MainEntityType mainTyp = EntityMetadataCache.getDataEntityType((String)entityNumber);
                String msg = String.format(ResManager.loadKDString((String)"\u641c\u7d22\u5230\u4e86\u5173\u8054\u7684\u3010%s\u3011\uff0c\u4f46\u60a8\u672a\u88ab\u6388\u4e88\u67e5\u770b\u6743\u3002", (String)"TrackUp_9", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), mainTyp.getDisplayName().toString());
                OperateErrorInfo errInfo = new OperateErrorInfo();
                errInfo.setLevel(ErrorLevel.Error);
                errInfo.setMessage(msg);
                this.getTrackResult().addErrorInfo(errInfo);
                continue;
            }
            Map<Object, Boolean> bills = this.rightChecker.getDataRights().get(entityNumber);
            if (bills == null || bills.isEmpty()) continue;
            int count = 0;
            for (Map.Entry entry : bills.entrySet()) {
                if (((Boolean)entry.getValue()).booleanValue()) continue;
                ++count;
            }
            if (count <= 0) continue;
            MainEntityType mainTyp = EntityMetadataCache.getDataEntityType((String)entityNumber);
            String string = String.format(ResManager.loadKDString((String)"\u641c\u7d22\u5230\u5173\u8054\u7684\u3010%1$s\u3011%2$s\u5f20\uff0c\u5176\u4e2d%3$s\u5f20\u65e0\u67e5\u770b\u6743\u3002", (String)"TrackUp_10", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), mainTyp.getDisplayName().toString(), bills.size(), count);
            OperateErrorInfo errInfo = new OperateErrorInfo();
            errInfo.setLevel(ErrorLevel.Error);
            errInfo.setMessage(string);
            this.getTrackResult().addErrorInfo(errInfo);
        }
    }

    static class LongComparator
    implements Comparator<Long> {
        LongComparator() {
        }

        @Override
        public int compare(Long o1, Long o2) {
            return Long.compare(o1, o2);
        }
    }
}

