/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.botp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.botp.BOTPLogService;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.log.BOTPLog;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.service.botp.BFTrackerService;
import kd.bos.servicehelper.DispatchServiceHelper;

public class BOTPLogServiceHelper {
    private BOTPLogServiceHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static void addLogs(String dbRouteKey, BOTPLog[] logs, OperateOption option) {
        BOTPLogService service = new BOTPLogService();
        service.addLogs(dbRouteKey, logs, option);
    }

    public static void updateLogStatus(String dbRouteKey, Long[] logIds, String status, OperateOption option) {
        BOTPLogService service = new BOTPLogService();
        service.updateLogStatus(dbRouteKey, logIds, status, option);
    }

    public static OperationResult retryWriteBack(String dbRouteKey, Long[] wbLogIds, OperateOption option) {
        OperationResult opResult = new OperationResult();
        opResult.setBillCount(wbLogIds.length);
        BOTPLogService dataService = new BOTPLogService();
        BOTPLog[] logs = dataService.loadSimpleLogs(dbRouteKey, wbLogIds);
        if (logs.length != wbLogIds.length) {
            OperateErrorInfo errInfo = new OperateErrorInfo("retrywb.log_exist", ErrorLevel.Error, null);
            errInfo.setMessage(String.format(ResManager.loadKDString((String)"\u91cd\u8bd5\u53cd\u5199\uff0c\u4f20\u5165\u7684\u53cd\u5199\u65e5\u5fd7\u5185\u7801\uff0c\u6709%s\u6761\u5728\u6570\u636e\u5e93\u6ca1\u6709\u53d6\u5230\u65e5\u5fd7\u3002", (String)"BOTPLogServiceHelper_0", (String)"bos-botp-business", (Object[])new Object[0]), wbLogIds.length - logs.length));
            opResult.addErrorInfo(errInfo);
        }
        if (logs.length == 0) {
            return opResult;
        }
        HashMap<Long, List> groupByTT = new HashMap<Long, List>();
        for (BOTPLog log : logs) {
            groupByTT.computeIfAbsent(log.getTTableId(), s -> new ArrayList()).add(log);
        }
        for (Map.Entry entry : groupByTT.entrySet()) {
            if (Long.compare(0L, (Long)entry.getKey()) == 0) {
                OperateErrorInfo errInfo = new OperateErrorInfo("retrywb.ttable_null", ErrorLevel.Error, null);
                errInfo.setMessage(String.format(ResManager.loadKDString((String)"\u91cd\u8bd5\u53cd\u5199\uff0c\u4f20\u5165\u7684\u53cd\u5199\u65e5\u5fd7\uff0c\u6709%s\u6761\u6ca1\u6709\u8bb0\u5f55\u4e0b\u6e38\u5355\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u6267\u884c\u53cd\u5199\u3002", (String)"BOTPLogServiceHelper_1", (String)"bos-botp-business", (Object[])new Object[0]), ((List)entry.getValue()).size()));
                opResult.addErrorInfo(errInfo);
                continue;
            }
            TableDefine tableDefine = EntityMetadataCache.loadTableDefine((Long)((Long)entry.getKey()));
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)tableDefine.getEntityNumber());
            HashSet<Long> ids = new HashSet<Long>(16);
            for (BOTPLog log : logs) {
                ids.add(log.getId());
            }
            String resultStr = (String)DispatchServiceHelper.invokeBOSService((String)dt.getAppId(), (String)BFTrackerService.class.getSimpleName(), (String)"retryWriteBack", (Object[])new Object[]{dbRouteKey, ids.toArray(new Long[0]), option});
            OperationResult result = (OperationResult)DataEntitySerializer.deSerializerFromString((String)resultStr, (IDataEntityType)OrmUtils.getDataEntityType(OperationResult.class));
            opResult.getSuccessPkIds().addAll(result.getSuccessPkIds());
            opResult.getAllErrorInfo().addAll(result.getAllErrorInfo());
        }
        return opResult;
    }
}

