/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.botp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.BillTypeMapParser;
import kd.bos.entity.botp.ConvertBill;
import kd.bos.entity.botp.ConvertRuleCache;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.ConvertRuleKeyPair;
import kd.bos.entity.botp.runtime.ConvertOpRule;
import kd.bos.form.operate.botp.ThirdPushManage;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;

public class ConvertBillFilterUtil {
    public static List<ConvertBill> filterConvertBillsOfPush(List<ConvertBill> bills, ThirdPushManage thirdPushManage, String srcEntityNumber, boolean hidePushForm, Set<Long> srcBillTypeIds) {
        if (CollectionUtils.isEmpty(bills = thirdPushManage.addThirdConvertBills(bills))) {
            return bills;
        }
        ArrayList<ConvertRuleKeyPair> crKeys = new ArrayList<ConvertRuleKeyPair>(bills.size());
        for (ConvertBill bill : bills) {
            ConvertRuleKeyPair crKey = null;
            crKey = Boolean.TRUE.equals(bill.getThirdPush()) ? thirdPushManage.getThirdConvertRuleKeyPair(bill) : new ConvertRuleKeyPair(srcEntityNumber, bill.getEntityNumber());
            crKeys.add(crKey);
        }
        Map allRules = ConvertRuleCache.batchLoadRules(crKeys);
        ArrayList<ConvertBill> list = new ArrayList<ConvertBill>(10);
        for (ConvertBill bill : bills) {
            List<ConvertOpRule> opRules;
            List<ConvertOpRule> list2 = opRules = Boolean.TRUE.equals(bill.getThirdPush()) ? ConvertBillFilterUtil.filterRules(bill, thirdPushManage.getTirdSrcBillTypeIds(bill), allRules, srcEntityNumber, hidePushForm) : ConvertBillFilterUtil.filterRules(bill, srcBillTypeIds, allRules, srcEntityNumber, hidePushForm);
            if (opRules.isEmpty()) continue;
            bill.getRules().addAll(opRules);
            list.add(bill);
        }
        return list;
    }

    private static List<ConvertOpRule> filterRules(ConvertBill bill, Set<Long> srcBillTypeIds, Map<ConvertRuleKeyPair, List<ConvertRuleElement>> allRules, String srcEntityNumber, boolean hidePushForm) {
        ArrayList<ConvertOpRule> opRules = new ArrayList<ConvertOpRule>(10);
        String sourceEntityNumber = Boolean.TRUE.equals(bill.getThirdPush()) ? bill.getSourceEntityNumber() : srcEntityNumber;
        List<ConvertRuleElement> rules = ConvertBillFilterUtil.loadRulesOfPush(sourceEntityNumber, bill.getEntityNumber(), allRules);
        if (rules.isEmpty()) {
            return opRules;
        }
        boolean existBillTypePolicy = false;
        if (srcBillTypeIds != null && !srcBillTypeIds.isEmpty()) {
            for (ConvertRuleElement rule : rules) {
                if (!rule.isNormual() || rule.getBillTypeMapPolicy().getItems().isEmpty()) continue;
                existBillTypePolicy = true;
                break;
            }
        }
        if (existBillTypePolicy) {
            return ConvertBillFilterUtil.filterBillTypeOfPush(bill, rules, srcBillTypeIds, hidePushForm);
        }
        for (ConvertRuleElement rule : rules) {
            if (!rule.isNormual() || !hidePushForm && !rule.isVisibled()) continue;
            ConvertOpRule opRule = new ConvertOpRule(rule.getId(), rule.getName().toString());
            opRule.setVisibled(rule.isVisibled());
            opRules.add(opRule);
        }
        return opRules;
    }

    private static List<ConvertOpRule> filterBillTypeOfPush(ConvertBill bill, List<ConvertRuleElement> rules, Set<Long> srcBillTypeIds, boolean hidePushForm) {
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)bill.getEntityNumber());
        ArrayList<ConvertOpRule> opRules = new ArrayList<ConvertOpRule>();
        IDataEntityProperty targetBillTypeProp = null;
        if (targetMainType instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)((BillEntityType)targetMainType).getBillType())) {
            targetBillTypeProp = targetMainType.findProperty(((BillEntityType)targetMainType).getBillType());
        }
        Map<Object, DynamicObject> objMap = null;
        DynamicObject[] targetBillTypeObjs = null;
        if (targetBillTypeProp != null) {
            objMap = ConvertBillFilterUtil.loadTargetBillTypeObjs(targetMainType.getName());
            targetBillTypeObjs = objMap.values().toArray(new DynamicObject[0]);
        }
        BillTypeMapParser parser = new BillTypeMapParser();
        for (ConvertRuleElement rule : rules) {
            if (!rule.isNormual() || !hidePushForm && !rule.isVisibled()) continue;
            boolean enabled = false;
            ConvertOpRule opRule = new ConvertOpRule(rule.getId(), rule.getName().toString());
            opRule.setVisibled(rule.isVisibled());
            if (srcBillTypeIds.isEmpty() || targetBillTypeProp == null) {
                enabled = true;
            } else {
                for (Long srcBillTypeId : srcBillTypeIds) {
                    parser.tryGetTargetBillTypeIds(rule.getBillTypeMapPolicy(), srcBillTypeId, targetBillTypeObjs);
                    if (parser.isCannotPushAnyOne()) continue;
                    if (parser.isCanPushAll()) {
                        enabled = true;
                        opRule.setAllBillType(true);
                        opRule.getInvalidBillTypeIds().addAll(parser.getOutCannotPushBillTypeIds());
                        opRule.getBillTypeIds().addAll(parser.getOutBillTypeIds());
                        break;
                    }
                    if (parser.getOutBillTypeIds().isEmpty()) continue;
                    enabled = true;
                    opRule.setDefBillType((Long)parser.getOutBillTypeIds().get(0));
                    opRule.getBillTypeIds().addAll(parser.getOutBillTypeIds());
                    break;
                }
            }
            if (!enabled) continue;
            opRules.add(opRule);
        }
        return opRules;
    }

    private static List<ConvertRuleElement> loadRulesOfPush(String sourceEntityNumber, String targetEntityNumber, Map<ConvertRuleKeyPair, List<ConvertRuleElement>> allRules) {
        ConvertRuleKeyPair key = new ConvertRuleKeyPair(sourceEntityNumber, targetEntityNumber);
        List<ConvertRuleElement> rules = allRules.get(key);
        if (rules == null) {
            return new ArrayList<ConvertRuleElement>(0);
        }
        ArrayList<ConvertRuleElement> enableRules = new ArrayList<ConvertRuleElement>();
        for (ConvertRuleElement rule : rules) {
            if (!rule.isNormual()) continue;
            enableRules.add(rule);
        }
        return enableRules;
    }

    private static Map<Object, DynamicObject> loadTargetBillTypeObjs(String entityNumber) {
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return new HashMap<Object, DynamicObject>();
        }
        QFilter[] filters = new QFilter[]{new QFilter("billformid", "=", (Object)entityNumber)};
        return BusinessDataServiceHelper.loadFromCache((String)"bos_billtype", (String)"id, number, name, status, enable, isdefault", (QFilter[])filters);
    }

    public static List<ConvertBill> loadPushBillsOfPlugin(String billsOfPushPluginArgs) {
        if (StringUtils.isBlank((CharSequence)billsOfPushPluginArgs)) {
            return Collections.emptyList();
        }
        return (List)SerializationUtils.fromJsonString((String)billsOfPushPluginArgs, List.class);
    }

    public static List<ConvertBill> filterConvertBillsOfDraw(String targetEntityNumber, DynamicObject targetBillTypeObj, List<ConvertBill> bills, boolean hideDrawForm) {
        ArrayList<ConvertBill> list = new ArrayList<ConvertBill>(10);
        for (ConvertBill bill : bills) {
            List<ConvertOpRule> opRules;
            List<ConvertRuleElement> rules = ConvertBillFilterUtil.loadRulesOfDraw(bill.getEntityNumber(), targetEntityNumber);
            if (rules.isEmpty() || (opRules = ConvertBillFilterUtil.filterBillTypeOfDraw(bill, rules, targetBillTypeObj, hideDrawForm)).isEmpty()) continue;
            bill.getRules().addAll(opRules);
            list.add(bill);
        }
        return list;
    }

    private static List<ConvertOpRule> filterBillTypeOfDraw(ConvertBill bill, List<ConvertRuleElement> rules, DynamicObject targetBillTypeObj, boolean hideDrawForm) {
        ArrayList<ConvertOpRule> opRules = new ArrayList<ConvertOpRule>();
        BillTypeMapParser parser = new BillTypeMapParser();
        for (ConvertRuleElement rule : rules) {
            if (!rule.isNormual() || !hideDrawForm && rule.isVisibledCtrl() && !rule.isDrawVisibled() || !rule.isVisibledCtrl() && !rule.isVisibled()) continue;
            boolean enabled = false;
            ConvertOpRule opRule = new ConvertOpRule(rule.getId(), rule.getName().toString());
            opRule.setVisibled(rule.isVisibled());
            opRule.setVisibledCtrl(rule.isVisibledCtrl());
            opRule.setDrawVisibled(rule.isDrawVisibled());
            parser.tryGetSourceBillTypeIds(rule.getBillTypeMapPolicy(), targetBillTypeObj);
            if (parser.isCannotDrawAnyOne()) continue;
            if (parser.isCanDrawAll()) {
                enabled = true;
                opRule.setAllBillType(true);
                opRule.getInvalidBillTypeIds().addAll(parser.getOutCannotDrawBillTypeIds());
            } else if (!parser.getOutBillTypeIds().isEmpty()) {
                enabled = true;
                opRule.getBillTypeIds().addAll(parser.getOutBillTypeIds());
            }
            if (!enabled) continue;
            opRules.add(opRule);
        }
        return opRules;
    }

    public static List<ConvertRuleElement> loadRulesOfDraw(String sourceEntityNumber, String targetEntityNumber) {
        List rules = ConvertRuleCache.loadRules((String)sourceEntityNumber, (String)targetEntityNumber);
        ArrayList<ConvertRuleElement> enableRules = new ArrayList<ConvertRuleElement>();
        for (ConvertRuleElement rule : rules) {
            if (!rule.isNormual()) continue;
            enableRules.add(rule);
        }
        return enableRules;
    }

    public static List<ConvertBill> loadDrawBillsOfPlugin(String billsOfDrawPluginArgs) {
        if (StringUtils.isBlank((CharSequence)billsOfDrawPluginArgs)) {
            return Collections.emptyList();
        }
        return (List)SerializationUtils.fromJsonString((String)billsOfDrawPluginArgs, List.class);
    }
}

