/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ctbotp;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.ctbotp.CtConvertBill;
import kd.bos.entity.ctbotp.CtConvertPath;
import kd.bos.entity.ctbotp.CtConvertRule;
import kd.bos.entity.ctbotp.CtConvertRuleCache;
import kd.bos.entity.ctbotp.CtConvertRuleElement;
import kd.bos.entity.ctbotp.CtDataCenter;
import kd.bos.entity.ctbotp.CtTenantData;
import kd.bos.entity.ctbotp.runtime.CtConvertOpRule;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;

public class CtConvertDataService {
    private static final String FROMBOTPCONVERTRULE = "FROM T_CTBOTP_CONVERTRULE t0 ";
    private static String KEY_BOS_CTBOTP_TENANTPATH = "bos_ctbotp_tenantpath";
    private static String CTSY_TENANT = "ctsy_tenant";

    public List<CtConvertPath> loadAllConvertPaths() {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("SELECT t0.fsbizappname, t0.FSourceEntityNumber, t0.fsourceentityname, t0.ftbizappname, t0.FTargetEntityNumber, t0.ftargetentityname ");
        sBuilder.append(FROMBOTPCONVERTRULE);
        sBuilder.append("WHERE t0.FType <> '2' ");
        sBuilder.append(" order by fcreatedate desc ");
        ResultSetHandler<Set<CtConvertPath>> action = new ResultSetHandler<Set<CtConvertPath>>(){

            public Set<CtConvertPath> handle(ResultSet rs) throws SQLException {
                HashSet<CtConvertPath> paths = new HashSet<CtConvertPath>(16);
                while (rs.next()) {
                    CtConvertPath path = new CtConvertPath();
                    path.setSourceBizAppName(rs.getString("FSbizAppName"));
                    path.setSourceEntityNumber(rs.getString("FSourceEntityNumber"));
                    path.setSourceEntityName(rs.getString("fsourceentityname"));
                    path.setTargetBizAppName(rs.getString("ftbizappname"));
                    path.setTargetEntityNumber(rs.getString("FTargetEntityNumber"));
                    path.setTargetEntityName(rs.getString("ftargetentityname"));
                    paths.add(path);
                }
                return paths;
            }
        };
        Set convertPaths = (Set)DB.query((DBRoute)DBRoute.basedata, (String)sBuilder.toString(), null, (ResultSetHandler)action);
        return new ArrayList<CtConvertPath>(convertPaths);
    }

    public List<CtConvertRule> loadTargetConvertRule(String tenantId, String accountId, String entityNumber) {
        Set<String> numbers = CtConvertDataService.getTenantPathNumbers(tenantId, accountId);
        if (numbers == null) {
            return new ArrayList<CtConvertRule>(16);
        }
        String nums = StringUtils.join((Object[])numbers.toArray(), (String)"','");
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("SELECT t0.fsbizappname, t0.fsourcetenant, t0.fsourcedatacenter, t0.fsourceaccountnumber, t0.FSourceEntityNumber, t0.fsourceentityname, t0.ftbizappname, t0.FTargetEntityNumber, t0.ftargetentityname, t0.ftargettenant, t0.ftargetdatacenter, t0.ftargetaccountnumber, t0.fsynctype, t0.fid ");
        sBuilder.append(FROMBOTPCONVERTRULE);
        sBuilder.append("WHERE t0.FType <> '2' ");
        sBuilder.append("and FSourceEntityNumber = ? ");
        sBuilder.append("and FTenantPath in('");
        sBuilder.append(nums);
        sBuilder.append("') ");
        Object[] parameters = new SqlParameter[]{new SqlParameter(":FSourceEntityNumber", 12, (Object)entityNumber)};
        ResultSetHandler<Set<CtConvertRule>> action = new ResultSetHandler<Set<CtConvertRule>>(){

            public Set<CtConvertRule> handle(ResultSet rs) throws SQLException {
                HashSet<CtConvertRule> paths = new HashSet<CtConvertRule>(16);
                while (rs.next()) {
                    CtConvertRule path = new CtConvertRule();
                    path.setRuleId(rs.getString("fid"));
                    path.setSourceBizAppName(rs.getString("FSbizAppName"));
                    path.setSourceEntityNumber(rs.getString("FSourceEntityNumber"));
                    path.setSourceEntityName(rs.getString("fsourceentityname"));
                    path.setSourceTenant(rs.getString("fsourcetenant"));
                    path.setSourceAccountId(rs.getString("fsourcedatacenter"));
                    path.setSourceAccountNumber(rs.getString("fsourceaccountnumber"));
                    path.setTargetBizAppName(rs.getString("ftbizappname"));
                    path.setTargetEntityNumber(rs.getString("FTargetEntityNumber"));
                    path.setTargetEntityName(rs.getString("ftargetentityname"));
                    path.setTargetTenant(rs.getString("ftargettenant"));
                    path.setTargetAccountId(rs.getString("ftargetdatacenter"));
                    path.setTargetAccountNumber(rs.getString("ftargetaccountnumber"));
                    path.setSyncType(rs.getString("fsynctype"));
                    paths.add(path);
                }
                return paths;
            }
        };
        Set convertPaths = (Set)DB.query((DBRoute)DBRoute.basedata, (String)sBuilder.toString(), (Object[])parameters, (ResultSetHandler)action);
        return new ArrayList<CtConvertRule>(convertPaths);
    }

    public List<CtTenantData> loadTenantDatas(String tenantId, String accountId, String entityNumber) {
        List<CtConvertRule> ctConvertRules = this.loadTargetConvertRule(tenantId, accountId, entityNumber);
        if (CollectionUtils.isEmpty(ctConvertRules)) {
            return null;
        }
        List<String> ruleIds = ctConvertRules.stream().map(a -> a.getRuleId()).collect(Collectors.toList());
        List convertRuleElements = CtConvertRuleCache.loadRules((String[])ruleIds.toArray(new String[0]));
        if (CollectionUtils.isEmpty((Collection)convertRuleElements)) {
            return null;
        }
        HashMap<String, CtTenantData> tenantDataCollection = new HashMap<String, CtTenantData>(16);
        for (CtConvertRuleElement ctConvertRuleElement : convertRuleElements) {
            CtConvertBill bill;
            CtDataCenter dataCenter;
            CtTenantData tenantData;
            if (ctConvertRuleElement == null || !ctConvertRuleElement.isNormual()) continue;
            String tenant = ctConvertRuleElement.getTargetTenant();
            String dataCenterStr = ctConvertRuleElement.getTargetDataCenter();
            String dataCenterNumber = ctConvertRuleElement.getTargetAccountNumber();
            String number = ctConvertRuleElement.getTargetEntityNumber();
            String name = ctConvertRuleElement.getTargetEntityName().getLocaleValue();
            String syncType = ctConvertRuleElement.getSyncType();
            if (StringUtils.isBlank((CharSequence)name)) {
                name = number;
            }
            String ruleId = ctConvertRuleElement.getId();
            String ruleName = ctConvertRuleElement.getName().getLocaleValue();
            CtConvertOpRule rule = new CtConvertOpRule(ruleId, ruleName);
            rule.setSyncType(syncType);
            if (tenantDataCollection.containsKey(tenant)) {
                tenantData = (CtTenantData)tenantDataCollection.get(tenant);
                Map dataCenterCollection = tenantData.getDataCenter();
                if (dataCenterCollection.containsKey(dataCenterStr)) {
                    dataCenter = (CtDataCenter)dataCenterCollection.get(dataCenterStr);
                    Map billCollection = dataCenter.getBills();
                    if (billCollection.containsKey(number)) {
                        bill = (CtConvertBill)billCollection.get(number);
                    } else {
                        bill = new CtConvertBill();
                        bill.setEntityNumber(number);
                        bill.setEntityName(name);
                    }
                    bill.getRules().add(rule);
                } else {
                    dataCenter = new CtDataCenter();
                    bill = new CtConvertBill();
                    bill.setEntityNumber(number);
                    bill.setEntityName(name);
                    bill.getRules().add(rule);
                }
                dataCenter.getBills().put(number, bill);
            } else {
                tenantData = new CtTenantData();
                tenantData.setTenantNumber(tenant);
                tenantData.setTenantName(tenant);
                dataCenter = new CtDataCenter();
                dataCenter.setDataCenterNumber(dataCenterStr);
                dataCenter.setDataCenterName(dataCenterNumber);
                bill = new CtConvertBill();
                bill.setEntityNumber(number);
                bill.setEntityName(name);
                bill.getRules().add(rule);
                dataCenter.getBills().put(number, bill);
                tenantData.getDataCenter().put(dataCenterStr, dataCenter);
            }
            tenantDataCollection.put(tenant, tenantData);
        }
        ArrayList<CtTenantData> tenantDatas = new ArrayList<CtTenantData>(16);
        tenantDatas.addAll(tenantDataCollection.values());
        return tenantDatas;
    }

    public TableDefine loadTableDefine(String entityNumber, String entityKey) {
        return EntityMetadataCache.loadTableDefine((String)entityNumber, (String)entityKey);
    }

    public TableDefine loadTableDefine(Long tableId) {
        return EntityMetadataCache.loadTableDefine((Long)tableId);
    }

    @Deprecated
    public List<String> loadConvertRuleIdsAppId(String appId) {
        return this.loadConvertRuleIdsByAppId(appId);
    }

    public List<String> loadConvertRuleIdsByAppId(String appId) {
        String sql = "SELECT FID FROM T_BOTP_ConvertRule where fbizappid = ?";
        Object[] parameters = new SqlParameter[]{new SqlParameter(":fbizappid", 12, (Object)appId)};
        ResultSetHandler<List<String>> action = new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> paths = new ArrayList<String>(16);
                while (rs.next()) {
                    paths.add(rs.getString("FID"));
                }
                return paths;
            }
        };
        List convertPaths = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])parameters, (ResultSetHandler)action);
        return convertPaths;
    }

    private static Set<String> getTenantPathNumbers(String sourceTenantId, String sourceAccountId) {
        DynamicObject sourceTenant = CtConvertDataService.getTenantInfoById(sourceTenantId, sourceAccountId);
        if (sourceTenant == null) {
            return null;
        }
        QFilter[] filter = new QFilter[]{new QFilter("sourcetenant", "=", sourceTenant.getPkValue())};
        DynamicObject[] tenantPaths = BusinessDataServiceHelper.load((String)KEY_BOS_CTBOTP_TENANTPATH, (String)"id,number", (QFilter[])filter);
        HashSet<String> numbers = new HashSet<String>(tenantPaths.length);
        for (DynamicObject dynamicObject : tenantPaths) {
            numbers.add(dynamicObject.getString("number"));
        }
        return numbers;
    }

    private static DynamicObject getTenantInfoById(String tenantId, String accountId) {
        DynamicObject tenant = BusinessDataServiceHelper.loadSingle((String)CTSY_TENANT, (QFilter[])new QFilter[]{new QFilter("tenantid", "=", (Object)tenantId), new QFilter("accountid", "=", (Object)accountId)});
        return tenant;
    }
}

