/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ctbotp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.ctbotp.CtConvertDataService;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.ctbotp.constants.SyncModelEnum;
import kd.bos.entity.ctbotp.runtime.CtBFRow;
import kd.bos.entity.ctbotp.runtime.CtBFRowId;
import kd.bos.entity.ctbotp.runtime.CtBFRowLinkDownNode;
import kd.bos.entity.ctbotp.runtime.CtBFRowLinkUpNode;

public class CtLinkTreeBuilder {
    public List<CtBFRowLinkUpNode> buildLinkUpNodes(String tenantId, String accountId, List<CtBFRow> allEntryBFRows, Long myTableId, Long[] myEntryIds) {
        CtBFRowId rowId;
        HashMap<CtBFRowId, CtBFRowLinkUpNode> allNodes = new HashMap<CtBFRowId, CtBFRowLinkUpNode>(allEntryBFRows.size() * 2);
        HashMap<CtBFRowId, CtBFRowLinkUpNode> allBillNodes = new HashMap<CtBFRowId, CtBFRowLinkUpNode>(allEntryBFRows.size() * 2);
        for (CtBFRow ctBFRow : allEntryBFRows) {
            CtBFRowId sBillId;
            CtBFRowLinkUpNode sBillNode;
            CtBFRowId billId2;
            CtBFRowLinkUpNode billNode;
            CtBFRowId sRowId;
            CtBFRowLinkUpNode sNode;
            rowId = ctBFRow.getId();
            CtBFRowLinkUpNode ctBFRowLinkUpNode = (CtBFRowLinkUpNode)allNodes.get(rowId);
            if (ctBFRowLinkUpNode == null) {
                CtBFRowLinkUpNode ctBFRowLinkUpNode2 = new CtBFRowLinkUpNode(rowId);
                allNodes.put(rowId, ctBFRowLinkUpNode2);
            }
            if ((sNode = (CtBFRowLinkUpNode)allNodes.get(sRowId = ctBFRow.getSId())) == null) {
                sNode = new CtBFRowLinkUpNode(sRowId);
                allNodes.put(sRowId, sNode);
            }
            if ((billNode = (CtBFRowLinkUpNode)allBillNodes.get(billId2 = new CtBFRowId(rowId.getTenantId(), rowId.getAccountId(), rowId.getMainTableId(), rowId.getBillId(), rowId.getMainTableId(), rowId.getBillId()))) == null) {
                billNode = new CtBFRowLinkUpNode(billId2);
                allBillNodes.put(billId2, billNode);
            }
            if ((sBillNode = (CtBFRowLinkUpNode)allBillNodes.get(sBillId = new CtBFRowId(sRowId.getTenantId(), sRowId.getAccountId(), sRowId.getMainTableId(), sRowId.getBillId(), sRowId.getMainTableId(), sRowId.getBillId()))) != null) continue;
            sBillNode = new CtBFRowLinkUpNode(sBillId);
            allBillNodes.put(sBillId, sBillNode);
        }
        for (CtBFRow ctBFRow : allEntryBFRows) {
            CtBFRowLinkUpNode node = (CtBFRowLinkUpNode)allNodes.get(ctBFRow.getId());
            if (!node.getSNodes().containsKey(ctBFRow.getSId())) {
                CtBFRowLinkUpNode ctBFRowLinkUpNode = (CtBFRowLinkUpNode)allNodes.get(ctBFRow.getSId());
                node.getSNodes().put(ctBFRow.getSId(), ctBFRowLinkUpNode);
            }
            CtBFRowId ctBFRowId = new CtBFRowId(ctBFRow.getId().getTenantId(), ctBFRow.getId().getAccountId(), ctBFRow.getId().getMainTableId(), ctBFRow.getId().getBillId(), ctBFRow.getId().getMainTableId(), ctBFRow.getId().getBillId());
            CtBFRowId sBillId = new CtBFRowId(ctBFRow.getSId().getTenantId(), ctBFRow.getSId().getAccountId(), ctBFRow.getSId().getMainTableId(), ctBFRow.getSId().getBillId(), ctBFRow.getSId().getMainTableId(), ctBFRow.getSId().getBillId());
            CtBFRowLinkUpNode billNode = (CtBFRowLinkUpNode)allBillNodes.get(ctBFRowId);
            if (billNode.getSNodes().containsKey(sBillId)) continue;
            CtBFRowLinkUpNode sBillNode = (CtBFRowLinkUpNode)allBillNodes.get(sBillId);
            billNode.getSNodes().put(sBillId, sBillNode);
        }
        for (Map.Entry entry : allNodes.entrySet()) {
            CtBFRowId ctBFRowId;
            CtBFRowLinkUpNode billNode;
            if (!((CtBFRowLinkUpNode)entry.getValue()).getSNodes().isEmpty() || (billNode = (CtBFRowLinkUpNode)allBillNodes.get(ctBFRowId = new CtBFRowId((rowId = (CtBFRowId)entry.getKey()).getTenantId(), rowId.getAccountId(), rowId.getMainTableId(), rowId.getBillId(), rowId.getMainTableId(), rowId.getBillId()))) == null) continue;
            ((CtBFRowLinkUpNode)entry.getValue()).getSNodes().putAll(billNode.getSNodes());
        }
        ArrayList<CtBFRowLinkUpNode> myNodes = new ArrayList<CtBFRowLinkUpNode>(16);
        HashSet<Long> hashSet = new HashSet<Long>(myEntryIds.length);
        for (Long entryId : myEntryIds) {
            hashSet.add(entryId);
        }
        for (Map.Entry entry : allNodes.entrySet()) {
            CtBFRowId myRowId = (CtBFRowId)entry.getKey();
            if (!tenantId.equals(myRowId.getTenantId()) || !accountId.equals(myRowId.getAccountId()) || Long.compare(myRowId.getTableId(), myTableId) != 0 || !hashSet.contains(myRowId.getEntryId())) continue;
            myNodes.add((CtBFRowLinkUpNode)entry.getValue());
        }
        return myNodes;
    }

    public List<CtBFRowLinkUpNode> buildLinkUpNodes(List<CtBFRow> allEntryBFRows, List<CtBFRow> myEntryBFRows) {
        CtBFRowId billId;
        CtBFRowId rowId;
        HashMap<CtBFRowId, CtBFRowLinkUpNode> allNodes = new HashMap<CtBFRowId, CtBFRowLinkUpNode>(allEntryBFRows.size() * 2);
        HashMap<CtBFRowId, CtBFRowLinkUpNode> allBillNodes = new HashMap<CtBFRowId, CtBFRowLinkUpNode>(allEntryBFRows.size() * 2);
        for (CtBFRow ctBFRow : allEntryBFRows) {
            CtBFRowId sBillId;
            CtBFRowLinkUpNode sBillNode;
            CtBFRowId billId2;
            CtBFRowLinkUpNode billNode;
            CtBFRowId sRowId;
            CtBFRowLinkUpNode sNode;
            rowId = ctBFRow.getId();
            CtBFRowLinkUpNode node = (CtBFRowLinkUpNode)allNodes.get(rowId);
            if (node == null) {
                node = new CtBFRowLinkUpNode(rowId);
                allNodes.put(rowId, node);
            }
            if ((sNode = (CtBFRowLinkUpNode)allNodes.get(sRowId = ctBFRow.getSId())) == null) {
                sNode = new CtBFRowLinkUpNode(sRowId);
                allNodes.put(sRowId, sNode);
            }
            if ((billNode = (CtBFRowLinkUpNode)allBillNodes.get(billId2 = new CtBFRowId("", "", rowId.getMainTableId(), rowId.getBillId(), rowId.getMainTableId(), rowId.getBillId()))) == null) {
                billNode = new CtBFRowLinkUpNode(billId2);
                allBillNodes.put(billId2, billNode);
            }
            if ((sBillNode = (CtBFRowLinkUpNode)allBillNodes.get(sBillId = new CtBFRowId("", "", sRowId.getMainTableId(), sRowId.getBillId(), sRowId.getMainTableId(), sRowId.getBillId()))) != null) continue;
            sBillNode = new CtBFRowLinkUpNode(sBillId);
            allBillNodes.put(sBillId, sBillNode);
        }
        for (CtBFRow ctBFRow : allEntryBFRows) {
            CtBFRowLinkUpNode node = (CtBFRowLinkUpNode)allNodes.get(ctBFRow.getId());
            if (!node.getSNodes().containsKey(ctBFRow.getSId())) {
                CtBFRowLinkUpNode sNode = (CtBFRowLinkUpNode)allNodes.get(ctBFRow.getSId());
                node.getSNodes().put(ctBFRow.getSId(), sNode);
            }
            billId = new CtBFRowId("", "", ctBFRow.getId().getMainTableId(), ctBFRow.getId().getBillId(), ctBFRow.getId().getMainTableId(), ctBFRow.getId().getBillId());
            CtBFRowId sBillId = new CtBFRowId("", "", ctBFRow.getSId().getMainTableId(), ctBFRow.getSId().getBillId(), ctBFRow.getSId().getMainTableId(), ctBFRow.getSId().getBillId());
            CtBFRowLinkUpNode billNode = (CtBFRowLinkUpNode)allBillNodes.get(billId);
            if (billNode.getSNodes().containsKey(sBillId)) continue;
            CtBFRowLinkUpNode sBillNode = (CtBFRowLinkUpNode)allBillNodes.get(sBillId);
            billNode.getSNodes().put(sBillId, sBillNode);
        }
        for (Map.Entry entry : allNodes.entrySet()) {
            CtBFRowLinkUpNode billNode;
            if (!((CtBFRowLinkUpNode)entry.getValue()).getSNodes().isEmpty() || (billNode = (CtBFRowLinkUpNode)allBillNodes.get(billId = new CtBFRowId("", "", (rowId = (CtBFRowId)entry.getKey()).getMainTableId(), rowId.getBillId(), rowId.getMainTableId(), rowId.getBillId()))) == null) continue;
            ((CtBFRowLinkUpNode)entry.getValue()).getSNodes().putAll(billNode.getSNodes());
        }
        ArrayList<CtBFRowLinkUpNode> myNodes = new ArrayList<CtBFRowLinkUpNode>(16);
        for (CtBFRow myRow : myEntryBFRows) {
            CtBFRowId myRowId = myRow.getId();
            CtBFRowLinkUpNode myNode = new CtBFRowLinkUpNode(myRowId);
            CtBFRowId sRowId = myRow.getSId();
            CtBFRowLinkUpNode sNode = (CtBFRowLinkUpNode)allNodes.get(sRowId);
            if (sNode == null) {
                sNode = new CtBFRowLinkUpNode(sRowId);
                CtBFRowId sBillId = new CtBFRowId("", "", sRowId.getMainTableId(), sRowId.getBillId(), sRowId.getMainTableId(), sRowId.getBillId());
                CtBFRowLinkUpNode sBillNode = (CtBFRowLinkUpNode)allBillNodes.get(sBillId);
                if (sBillNode != null) {
                    sNode.getSNodes().putAll(sBillNode.getSNodes());
                }
            }
            if (!myNode.getSNodes().containsKey(sRowId)) {
                myNode.getSNodes().put(sRowId, sNode);
            }
            myNodes.add(myNode);
        }
        return myNodes;
    }

    public List<CtBFRowLinkUpNode> buildDirtLinkUpNodes(List<CtBFRow> bfRows) {
        ArrayList<CtBFRowLinkUpNode> nodes = new ArrayList<CtBFRowLinkUpNode>(16);
        for (CtBFRow myRow : bfRows) {
            CtBFRowId myRowId = myRow.getId();
            CtBFRowLinkUpNode myNode = new CtBFRowLinkUpNode(myRowId);
            CtBFRowId sRowId = myRow.getSId();
            CtBFRowLinkUpNode sNode = new CtBFRowLinkUpNode(sRowId);
            if (!myNode.getSNodes().containsKey(sRowId)) {
                myNode.getSNodes().put(sRowId, sNode);
            }
            nodes.add(myNode);
        }
        return nodes;
    }

    public Map<Long, CtBFRowLinkUpNode> buildBillLinkUpNodes(String tTenantCode, String tAccountId, String entityNumber, Long[] billIds, List<CtBFRow> allRows) {
        HashMap<CtBFRowId, CtBFRowLinkUpNode> allNodes = new HashMap<CtBFRowId, CtBFRowLinkUpNode>(allRows.size() * 2);
        HashSet<CtBFRowId> hideMap = new HashSet<CtBFRowId>(8);
        for (CtBFRow row : allRows) {
            CtBFRowId rowId;
            CtLinkTreeBuilder.setSyncModel(row);
            CtBFRowId sRowId = row.getSId();
            if (sRowId != null && sRowId.getSyncModel() != null && sRowId.getSyncModel().equals(SyncModelEnum.MIRROR.getValue())) {
                hideMap.add(sRowId);
            }
            if ((rowId = row.getId()) == null || rowId.getSyncModel() == null || !rowId.getSyncModel().equals(SyncModelEnum.MIRROR.getValue())) continue;
            hideMap.add(rowId);
        }
        for (CtBFRow row : allRows) {
            CtBFRowLinkUpNode sNode;
            CtBFRowId sRowId;
            CtBFRowLinkUpNode node;
            CtBFRowId rowId = row.getId();
            if (hideMap.contains(rowId)) {
                rowId.setSyncModel(SyncModelEnum.MIRROR.getValue());
            }
            if ((node = (CtBFRowLinkUpNode)allNodes.get(rowId)) == null) {
                node = new CtBFRowLinkUpNode(rowId);
                allNodes.put(rowId, node);
            }
            if (hideMap.contains(sRowId = row.getSId())) {
                sRowId.setSyncModel(SyncModelEnum.MIRROR.getValue());
            }
            if ((sNode = (CtBFRowLinkUpNode)allNodes.get(sRowId)) != null) continue;
            sNode = new CtBFRowLinkUpNode(sRowId);
            allNodes.put(sRowId, sNode);
        }
        for (CtBFRow row : allRows) {
            CtBFRowLinkUpNode node = (CtBFRowLinkUpNode)allNodes.get(row.getId());
            if (node.getSNodes().containsKey(row.getSId())) continue;
            if (hideMap.contains(row.getSId())) {
                row.getSId().setSyncModel(SyncModelEnum.MIRROR.getValue());
            }
            CtBFRowLinkUpNode sNode = (CtBFRowLinkUpNode)allNodes.get(row.getSId());
            node.getSNodes().put(row.getSId(), sNode);
        }
        CtConvertDataService reader = new CtConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(entityNumber, entityNumber);
        Long mainTableId = mainTableDefine.getTableId();
        HashMap<Long, CtBFRowLinkUpNode> myNodes = new HashMap<Long, CtBFRowLinkUpNode>(billIds.length);
        for (Long billId : billIds) {
            CtBFRowId myRowId = new CtBFRowId(tTenantCode, tAccountId, mainTableId, billId, mainTableId, billId);
            CtBFRowLinkUpNode myNode = (CtBFRowLinkUpNode)allNodes.get(myRowId);
            if (myNode == null) continue;
            myNodes.put(billId, myNode);
        }
        return myNodes;
    }

    public List<CtBFRowLinkDownNode> buildLinkDownNodes(String sTenantId, String sAccountId, String entityNumber, String entryKey, Long[] entryIds, List<CtBFRow> allEntryBFRows) {
        HashMap<CtBFRowId, CtBFRowLinkDownNode> allNodes = new HashMap<CtBFRowId, CtBFRowLinkDownNode>();
        for (CtBFRow entryRow : allEntryBFRows) {
            CtBFRowId rowId;
            CtBFRowId sRowId = entryRow.getSId();
            if (!allNodes.containsKey(sRowId)) {
                CtBFRowLinkDownNode node = new CtBFRowLinkDownNode(sRowId);
                allNodes.put(sRowId, node);
            }
            if (allNodes.containsKey(rowId = entryRow.getId())) continue;
            CtBFRowLinkDownNode node = new CtBFRowLinkDownNode(rowId);
            allNodes.put(rowId, node);
        }
        for (CtBFRow entryRow : allEntryBFRows) {
            CtBFRowLinkDownNode node = (CtBFRowLinkDownNode)allNodes.get(entryRow.getId());
            CtBFRowLinkDownNode sNode = (CtBFRowLinkDownNode)allNodes.get(entryRow.getSId());
            if (sNode.getTNodes().containsKey(entryRow.getId())) continue;
            sNode.getTNodes().put(entryRow.getId(), node);
        }
        CtConvertDataService reader = new CtConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(entityNumber, entityNumber);
        Long mainTableId = mainTableDefine.getTableId();
        TableDefine tableDefine = mainTableDefine;
        boolean checkEntryId = false;
        if (StringUtils.isNotBlank((CharSequence)entryKey)) {
            checkEntryId = true;
            tableDefine = reader.loadTableDefine(entityNumber, entryKey);
        }
        HashSet<Long> myEntryIds = new HashSet<Long>();
        for (Long entryId : entryIds) {
            myEntryIds.add(entryId);
        }
        ArrayList<CtBFRowLinkDownNode> myNodes = new ArrayList<CtBFRowLinkDownNode>();
        for (Map.Entry item : allNodes.entrySet()) {
            CtBFRowId rowId = (CtBFRowId)item.getKey();
            CtBFRowLinkDownNode node = (CtBFRowLinkDownNode)item.getValue();
            if (rowId.getMainTableId().compareTo(mainTableId) != 0) continue;
            if (!checkEntryId) {
                if (!myEntryIds.contains(rowId.getBillId())) continue;
                myNodes.add(node);
                continue;
            }
            if (!rowId.getTenantId().equals(sTenantId) || !rowId.getAccountId().equals(sAccountId) || rowId.getTableId().compareTo(tableDefine.getTableId()) != 0 || !myEntryIds.contains(rowId.getEntryId())) continue;
            myNodes.add(node);
        }
        return myNodes;
    }

    public List<CtBFRowLinkDownNode> buildLinkDownNodes(String entityNumber, String entryKey, Long[] entryIds, List<CtBFRow> allEntryBFRows) {
        HashMap<CtBFRowId, CtBFRowLinkDownNode> allNodes = new HashMap<CtBFRowId, CtBFRowLinkDownNode>();
        for (CtBFRow entryRow : allEntryBFRows) {
            CtBFRowId rowId;
            CtBFRowId sRowId = entryRow.getSId();
            if (!allNodes.containsKey(sRowId)) {
                CtBFRowLinkDownNode node = new CtBFRowLinkDownNode(sRowId);
                allNodes.put(sRowId, node);
            }
            if (allNodes.containsKey(rowId = entryRow.getId())) continue;
            CtBFRowLinkDownNode node = new CtBFRowLinkDownNode(rowId);
            allNodes.put(rowId, node);
        }
        for (CtBFRow entryRow : allEntryBFRows) {
            CtBFRowLinkDownNode node = (CtBFRowLinkDownNode)allNodes.get(entryRow.getId());
            CtBFRowLinkDownNode sNode = (CtBFRowLinkDownNode)allNodes.get(entryRow.getSId());
            if (sNode.getTNodes().containsKey(entryRow.getId())) continue;
            sNode.getTNodes().put(entryRow.getId(), node);
        }
        CtConvertDataService reader = new CtConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(entityNumber, entityNumber);
        Long mainTableId = mainTableDefine.getTableId();
        TableDefine tableDefine = mainTableDefine;
        boolean checkEntryId = false;
        if (StringUtils.isNotBlank((CharSequence)entryKey)) {
            checkEntryId = true;
            tableDefine = reader.loadTableDefine(entityNumber, entryKey);
        }
        HashSet<Long> myEntryIds = new HashSet<Long>();
        for (Long entryId : entryIds) {
            myEntryIds.add(entryId);
        }
        ArrayList<CtBFRowLinkDownNode> myNodes = new ArrayList<CtBFRowLinkDownNode>();
        for (Map.Entry item : allNodes.entrySet()) {
            CtBFRowId rowId = (CtBFRowId)item.getKey();
            CtBFRowLinkDownNode node = (CtBFRowLinkDownNode)item.getValue();
            if (rowId.getMainTableId().compareTo(mainTableId) != 0) continue;
            if (!checkEntryId) {
                if (!myEntryIds.contains(rowId.getBillId())) continue;
                myNodes.add(node);
                continue;
            }
            if (rowId.getTableId().compareTo(tableDefine.getTableId()) != 0 || !myEntryIds.contains(rowId.getEntryId())) continue;
            myNodes.add(node);
        }
        return myNodes;
    }

    public Map<Long, CtBFRowLinkDownNode> buildBillLinkDownNodes(String sTenantId, String sAccountId, String entityNumber, Long[] billIds, List<CtBFRow> allRows) {
        CtBFRowId sRowId;
        HashMap<CtBFRowId, CtBFRowLinkDownNode> allNodes = new HashMap<CtBFRowId, CtBFRowLinkDownNode>(allRows.size() * 2);
        HashSet<CtBFRowId> hideMap = new HashSet<CtBFRowId>(8);
        for (CtBFRow row : allRows) {
            CtBFRowId rowId;
            CtLinkTreeBuilder.setSyncModel(row);
            sRowId = row.getSId();
            if (sRowId != null && sRowId.getSyncModel() != null && sRowId.getSyncModel().equals(SyncModelEnum.MIRROR.getValue())) {
                hideMap.add(sRowId);
            }
            if ((rowId = row.getId()) == null || rowId.getSyncModel() == null || !rowId.getSyncModel().equals(SyncModelEnum.MIRROR.getValue())) continue;
            hideMap.add(rowId);
        }
        for (CtBFRow row : allRows) {
            CtBFRowLinkDownNode node;
            CtBFRowId rowId;
            CtBFRowLinkDownNode sNode;
            sRowId = row.getSId();
            if (hideMap.contains(sRowId)) {
                sRowId.setSyncModel(SyncModelEnum.MIRROR.getValue());
            }
            if ((sNode = (CtBFRowLinkDownNode)allNodes.get(sRowId)) == null) {
                sNode = new CtBFRowLinkDownNode(sRowId);
                allNodes.put(sRowId, sNode);
            }
            if (hideMap.contains(rowId = row.getId())) {
                rowId.setSyncModel(SyncModelEnum.MIRROR.getValue());
            }
            if ((node = (CtBFRowLinkDownNode)allNodes.get(rowId)) != null) continue;
            node = new CtBFRowLinkDownNode(rowId);
            allNodes.put(rowId, node);
        }
        for (CtBFRow row : allRows) {
            CtBFRowLinkDownNode node = (CtBFRowLinkDownNode)allNodes.get(row.getSId());
            if (node.getTNodes().containsKey(row.getId())) continue;
            CtBFRowLinkDownNode tNode = (CtBFRowLinkDownNode)allNodes.get(row.getId());
            if (hideMap.contains(row.getId())) {
                row.getId().setSyncModel(SyncModelEnum.MIRROR.getValue());
            }
            node.getTNodes().put(row.getId(), tNode);
        }
        CtConvertDataService reader = new CtConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(entityNumber, entityNumber);
        Long mainTableId = mainTableDefine.getTableId();
        HashMap<Long, CtBFRowLinkDownNode> myNodes = new HashMap<Long, CtBFRowLinkDownNode>(billIds.length);
        for (Long billId : billIds) {
            CtBFRowId myRowId = new CtBFRowId(sTenantId, sAccountId, mainTableId, billId, mainTableId, billId);
            CtBFRowLinkDownNode myNode = (CtBFRowLinkDownNode)allNodes.get(myRowId);
            if (myNode == null) continue;
            myNodes.put(billId, myNode);
        }
        return myNodes;
    }

    private static void setSyncModel(CtBFRow row) {
        if (StringUtils.isBlank((CharSequence)row.getSId().getSyncModel()) || StringUtils.isBlank((CharSequence)row.getId().getSyncModel())) {
            row.getId().setSyncModel(SyncModelEnum.NORMAL.getValue());
            row.getSId().setSyncModel(SyncModelEnum.NORMAL.getValue());
            return;
        }
        if (!row.getSId().getSyncModel().equals(SyncModelEnum.MIRROR.getValue()) || !row.getId().getSyncModel().equals(SyncModelEnum.MIRROR.getValue())) {
            return;
        }
        if (row.getSId().getTenantId().equals(RequestContext.get().getTenantId()) && row.getSId().getAccountId().equals(RequestContext.get().getAccountId()) && row.getId().getTenantId().equals(RequestContext.get().getTenantId()) && row.getId().getAccountId().equals(RequestContext.get().getAccountId())) {
            row.getSId().setSyncModel(SyncModelEnum.NORMAL.getValue());
            return;
        }
        if (row.getSId().getTenantId().equals(RequestContext.get().getTenantId()) && row.getSId().getAccountId().equals(RequestContext.get().getAccountId())) {
            row.getSId().setSyncModel(SyncModelEnum.NORMAL.getValue());
            return;
        }
        if (row.getId().getTenantId().equals(RequestContext.get().getTenantId()) && row.getId().getAccountId().equals(RequestContext.get().getAccountId())) {
            row.getId().setSyncModel(SyncModelEnum.NORMAL.getValue());
            return;
        }
        row.getSId().setSyncModel(SyncModelEnum.NORMAL.getValue());
    }
}

