/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ctbotp;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;
import kd.bos.dataentity.metadata.database.DbMetadataColumnCollection;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;

final class CtLogTable {
    private static final Log log = LogFactory.getLog(CtLogTable.class);
    private static final Map<String, Boolean> TABLE_EXIST = new ConcurrentHashMap<String, Boolean>();
    private static final Map<String, Boolean> FIELD_EXIST = new ConcurrentHashMap<String, Boolean>();
    private static final Map<String, Boolean> LOGDB_EXIST = new ConcurrentHashMap<String, Boolean>();
    private static final String FORMID_BOTP_LOGDB = "botp_logdb";
    private static final String KEY_NUMBER = "number";
    private static final String TABLE_NAME_LOG = "t_botp_log";
    private static final String SQL_TABLE_IS_EXISTED = "SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 't_botp_log' ";
    private static final String SQL_CREATE_TABLE_LOG = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 't_botp_log') create table t_botp_log (  fid               BIGINT DEFAULT(0)    not null,  fparentid         BIGINT DEFAULT(0)    not null,  ftaskid           BIGINT DEFAULT(0)    not null,  fsentitynumber    varchar(100) DEFAULT(' ') not null,  fstableid         BIGINT DEFAULT(0)    not null,  fsbillid          BIGINT DEFAULT(0)    not null,  fsbillno          varchar(200) DEFAULT(' ') not null,  ftentitynumber    varchar(100) DEFAULT(' ') not null,  fttableid         BIGINT DEFAULT(0)    not null,  ftbillid          BIGINT DEFAULT(0)    not null,  ftbillno          varchar(200) DEFAULT(' ') not null,  foptype           CHAR(1)              not null default '0',  fuserid           BIGINT DEFAULT(0)    not null,  fstarttime        DATETIME             not null,  fendtime          DATETIME             null,  flogtype          CHAR(1)              not null default '0',  fstatus           CHAR(1)              not null default '0',  fzipver           NVARCHAR(30)         not null default ' ',  fdata             NVARCHAR(255)        not null default ' ',  fdata_tag         NCLOB                null,  constraint pk_botp_log primary key (fid) ) ";
    private static final Map<String, String> TABLE_FIELDS_ADD_SQL = new HashMap<String, String>();
    private static final String SQL_CREATE_IDX_PARENTID = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'idx_botp_log_parentid') create index idx_botp_log_parentid on t_botp_log(fparentid ASC)";
    private static final String SQL_CREATE_IDX_SBILLID = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'idx_botp_log_sbillid') create index idx_botp_log_sbillid on t_botp_log(fsbillid ASC)";
    private static final String SQL_CREATE_IDX_SBILLNO = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'idx_botp_log_sbillno') create index idx_botp_log_sbillno on t_botp_log(fsbillno ASC)";
    private static final String SQL_CREATE_IDX_TBILLNO = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'idx_botp_log_tbillno') create index idx_botp_log_tbillno on t_botp_log(ftbillno ASC)";
    private static final String SQL_CREATE_IDX_STARTTIME = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'idx_botp_log_starttime') create index idx_botp_log_starttime on t_botp_log(fstarttime DESC)";

    CtLogTable() {
    }

    private static String buildCacheKey(String dbRouteKey) {
        return CacheKeyUtil.getAcctId() + "." + dbRouteKey;
    }

    public static synchronized void createTable(DBRoute dbRoute) {
        CtLogTable.createLogDB(dbRoute);
        Boolean isExisted = CtLogTable.existTable(dbRoute);
        if (!isExisted.booleanValue()) {
            try (TXHandle h = TX.requiresNew();){
                try {
                    DB.execute((DBRoute)dbRoute, (String)SQL_CREATE_TABLE_LOG);
                    DB.execute((DBRoute)dbRoute, (String)SQL_CREATE_IDX_PARENTID);
                    DB.execute((DBRoute)dbRoute, (String)SQL_CREATE_IDX_SBILLID);
                    DB.execute((DBRoute)dbRoute, (String)SQL_CREATE_IDX_SBILLNO);
                    DB.execute((DBRoute)dbRoute, (String)SQL_CREATE_IDX_TBILLNO);
                    DB.execute((DBRoute)dbRoute, (String)SQL_CREATE_IDX_STARTTIME);
                }
                catch (Throwable e) {
                    h.markRollback();
                    log.warn(e);
                }
            }
        } else {
            CtLogTable.alterTable(dbRoute);
        }
        String dbKey = CtLogTable.buildCacheKey(dbRoute.getRouteKey());
        TABLE_EXIST.put(dbKey, Boolean.TRUE);
    }

    public static synchronized Boolean existTable(DBRoute dbRoute) {
        String dbKey = CtLogTable.buildCacheKey(dbRoute.getRouteKey());
        Boolean isExisted = TABLE_EXIST.get(dbKey);
        if (isExisted != null && isExisted.booleanValue()) {
            return true;
        }
        isExisted = (Boolean)DB.query((DBRoute)dbRoute, (String)SQL_TABLE_IS_EXISTED, null, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                return rs.next();
            }
        });
        TABLE_EXIST.put(dbKey, isExisted);
        return isExisted;
    }

    private static void alterTable(DBRoute dbRoute) {
        HashSet<String> lostFields = new HashSet<String>(16);
        if (CtLogTable.existField(dbRoute, lostFields).booleanValue()) {
            return;
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                ArrayList<SqlObject> sqlList = new ArrayList<SqlObject>(10);
                for (String field : lostFields) {
                    String sql = TABLE_FIELDS_ADD_SQL.get(field);
                    if (!StringUtils.isNotBlank((CharSequence)sql)) continue;
                    sqlList.add(new SqlObject(sql, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
                }
                if (sqlList != null && sqlList.size() > 0) {
                    for (SqlObject list : sqlList) {
                        DB.execute((DBRoute)dbRoute, (String)list.getSql(), (Object[])list.getParams());
                    }
                }
                DB.execute((DBRoute)dbRoute, (String)SQL_CREATE_IDX_PARENTID);
                DB.execute((DBRoute)dbRoute, (String)SQL_CREATE_IDX_SBILLID);
                DB.execute((DBRoute)dbRoute, (String)SQL_CREATE_IDX_SBILLNO);
                DB.execute((DBRoute)dbRoute, (String)SQL_CREATE_IDX_TBILLNO);
                DB.execute((DBRoute)dbRoute, (String)SQL_CREATE_IDX_STARTTIME);
            }
            catch (Throwable e) {
                h.markRollback();
                log.warn(e);
            }
        }
        String dbKey = CtLogTable.buildCacheKey(dbRoute.getRouteKey());
        FIELD_EXIST.put(dbKey, Boolean.TRUE);
    }

    private static synchronized Boolean existField(DBRoute dbRoute, Set<String> lostFields) {
        String dbKey = CtLogTable.buildCacheKey(dbRoute.getRouteKey());
        Boolean isExisted = FIELD_EXIST.get(dbKey);
        if (isExisted != null && isExisted.booleanValue()) {
            return true;
        }
        DbMetadataTable dbTable = CtLogTable.loadTableSchema(dbRoute);
        if (dbTable == null) {
            return true;
        }
        Set<String> existFields = CtLogTable.getExistDbTableFields(dbTable);
        lostFields.clear();
        for (Map.Entry<String, String> entry : TABLE_FIELDS_ADD_SQL.entrySet()) {
            String field = entry.getKey();
            if (existFields.contains(field)) continue;
            lostFields.add(field);
        }
        FIELD_EXIST.put(dbKey, lostFields.isEmpty());
        return lostFields.isEmpty();
    }

    private static Set<String> getExistDbTableFields(DbMetadataTable dbTable) {
        DbMetadataColumnCollection collection = dbTable.getColumns();
        if (collection == null) {
            return new HashSet<String>(0);
        }
        HashSet<String> fields = new HashSet<String>(collection.size());
        for (DbMetadataColumn col : collection) {
            fields.add(col.getName());
        }
        return fields;
    }

    private static DbMetadataTable loadTableSchema(DBRoute dbRoute) {
        if (!DB.exitsTable((DBRoute)dbRoute, (String)TABLE_NAME_LOG)) {
            return null;
        }
        List columnNames = DB.getColumnNames((DBRoute)dbRoute, (String)TABLE_NAME_LOG);
        DbMetadataTable metadataTable = new DbMetadataTable();
        metadataTable.setName(TABLE_NAME_LOG);
        DbMetadataColumnCollection cols = new DbMetadataColumnCollection(metadataTable);
        for (String name : columnNames) {
            cols.add(new DbMetadataColumn(name));
        }
        metadataTable.setColumns(cols);
        return metadataTable;
    }

    private static synchronized void createLogDB(DBRoute dbRoute) {
        String dbKey = CtLogTable.buildCacheKey(dbRoute.getRouteKey());
        Boolean isExisted = LOGDB_EXIST.get(dbKey);
        if (isExisted != null && isExisted.booleanValue()) {
            return;
        }
        QFilter qFilter = new QFilter(KEY_NUMBER, "=", (Object)dbRoute.getRouteKey());
        Map objs = BusinessDataReader.loadFromCache((String)FORMID_BOTP_LOGDB, (QFilter[])new QFilter[]{qFilter});
        if (objs.isEmpty()) {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)FORMID_BOTP_LOGDB);
            DynamicObject obj = new DynamicObject((DynamicObjectType)mainType);
            obj.set(KEY_NUMBER, (Object)dbRoute.getRouteKey());
            obj.set("creator_id", (Object)RequestContext.get().getCurrUserId());
            obj.set("createtime", (Object)new Date());
            try (TXHandle h = TX.requiresNew();){
                try {
                    BusinessDataWriter.save((IDataEntityType)mainType, (Object[])new DynamicObject[]{obj});
                }
                catch (Throwable e) {
                    h.markRollback();
                    log.warn(e);
                }
            }
        }
        LOGDB_EXIST.put(dbKey, Boolean.TRUE);
    }

    static {
        TABLE_FIELDS_ADD_SQL.put("fparentid", "ALTER TABLE t_botp_log ADD fparentid         BIGINT DEFAULT(0)    not null;");
        TABLE_FIELDS_ADD_SQL.put("ftaskid", "ALTER TABLE t_botp_log ADD ftaskid           BIGINT DEFAULT(0)    not null");
        TABLE_FIELDS_ADD_SQL.put("fsentitynumber", "ALTER TABLE t_botp_log ADD fsentitynumber    varchar(100) DEFAULT(' ') not null");
        TABLE_FIELDS_ADD_SQL.put("fstableid", "ALTER TABLE t_botp_log ADD fstableid         BIGINT DEFAULT(0)    not null");
        TABLE_FIELDS_ADD_SQL.put("fsbillid", "ALTER TABLE t_botp_log ADD fsbillid          BIGINT DEFAULT(0)    not null");
        TABLE_FIELDS_ADD_SQL.put("fsbillno", "ALTER TABLE t_botp_log ADD fsbillno          varchar(200) DEFAULT(' ') not null");
        TABLE_FIELDS_ADD_SQL.put("ftentitynumber", "ALTER TABLE t_botp_log ADD ftentitynumber    varchar(100) DEFAULT(' ') not null");
        TABLE_FIELDS_ADD_SQL.put("fttableid", "ALTER TABLE t_botp_log ADD fttableid         BIGINT DEFAULT(0)    not null");
        TABLE_FIELDS_ADD_SQL.put("ftbillid", "ALTER TABLE t_botp_log ADD ftbillid          BIGINT DEFAULT(0)    not null");
        TABLE_FIELDS_ADD_SQL.put("ftbillno", "ALTER TABLE t_botp_log ADD ftbillno          varchar(200) DEFAULT(' ') not null");
        TABLE_FIELDS_ADD_SQL.put("foptype", "ALTER TABLE t_botp_log ADD foptype           CHAR(1)              not null default '0'");
        TABLE_FIELDS_ADD_SQL.put("fuserid", "ALTER TABLE t_botp_log ADD fuserid           BIGINT DEFAULT(0)    not null");
        TABLE_FIELDS_ADD_SQL.put("fstarttime", "ALTER TABLE t_botp_log ADD fstarttime        DATETIME             not null");
        TABLE_FIELDS_ADD_SQL.put("fendtime", "ALTER TABLE t_botp_log ADD fendtime          DATETIME             null");
        TABLE_FIELDS_ADD_SQL.put("flogtype", "ALTER TABLE t_botp_log ADD flogtype          CHAR(1)              not null default '0'");
        TABLE_FIELDS_ADD_SQL.put("fstatus", "ALTER TABLE t_botp_log ADD fstatus           CHAR(1)              not null default '0'");
        TABLE_FIELDS_ADD_SQL.put("fzipver", "ALTER TABLE t_botp_log ADD fzipver           NVARCHAR(30)         not null default ' '");
        TABLE_FIELDS_ADD_SQL.put("fdata", "ALTER TABLE t_botp_log ADD fdata             NVARCHAR(255)        not null default ' '");
        TABLE_FIELDS_ADD_SQL.put("fdata_tag", "ALTER TABLE t_botp_log ADD fdata_tag         NCLOB                null");
    }
}

