/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ctbotp.sync;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ctbotp.sync.SyncRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class CtSyncRouteService {
    private static final Log logger = LogFactory.getLog(CtSyncRouteService.class);
    private static final String BOS_MSERVICE_BOTP = "bos-mservice-ctbotp";
    private static final String FORMID_CTBOTP_SYNCROUTE = "bos_ctbotp_syncroute";
    private static String CTSY_TENANT = "ctsy_tenant";
    private static final String KEY_ID = "id";
    private static final String KEY_STENANTCODE = "stenantcode";
    private static final String KEY_SENTITYKEY = "sentitykey";
    private static final String KEY_TTENANTCODE = "ttenantcode";
    private static final String KEY_TENTITYKEY = "tentitykey";
    private static final String KEY_CREATETIME = "createtime";
    private static final String KEY_TACCOUNTID = "taccountid";
    private static final String KEY_SACCOUNTID = "saccountid";
    private static final String KEY_UNIQUEKEY = "uniquekey";

    public static void addSyncRoute(SyncRoute syncRoute) {
        String uniqueKey = CtSyncRouteService.getKey(syncRoute);
        if (StringUtils.isBlank((CharSequence)uniqueKey)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u52a0\u5bc6uniqueKey\u5f02\u5e38\u3002", (String)"CtSyncRouteService_0", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]));
        }
        QFilter[] qFilters = CtSyncRouteService.getQFilters(syncRoute);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)FORMID_CTBOTP_SYNCROUTE, (QFilter[])qFilters);
        if (dynamicObject != null) {
            return;
        }
        DLock lock = null;
        try {
            lock = DLock.create((String)uniqueKey);
            lock.lock();
            DynamicObject syncRouteDy = BusinessDataServiceHelper.loadSingle((String)FORMID_CTBOTP_SYNCROUTE, (QFilter[])qFilters);
            if (syncRouteDy != null) {
                return;
            }
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)FORMID_CTBOTP_SYNCROUTE);
            ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
            DynamicObject obj = CtSyncRouteService.buildDyObject(mainType, syncRoute);
            dynamicObjects.add(obj);
            try (TXHandle h = TX.requiresNew();){
                try {
                    BusinessDataWriter.save((IDataEntityType)mainType, (Object[])dynamicObjects.toArray());
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
        catch (Exception exception) {
            logger.error("\u4fdd\u5b58\u540c\u6b65\u8def\u7ebf\u5931\u8d25:", (Throwable)exception);
            throw exception;
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    public static List<SyncRoute> getSyncRouteDown(String stenantCode, String sAccountId, String sEntityKey) {
        ArrayList<SyncRoute> syncRoutes = new ArrayList<SyncRoute>(16);
        QFilter[] qFilters = new QFilter[]{new QFilter(KEY_SENTITYKEY, "=", (Object)sEntityKey), new QFilter(KEY_SACCOUNTID, "=", (Object)sAccountId), new QFilter(KEY_STENANTCODE, "=", (Object)stenantCode)};
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)FORMID_CTBOTP_SYNCROUTE, (QFilter[])qFilters);
        if (dynamicObjectMap == null || dynamicObjectMap.size() == 0) {
            return syncRoutes;
        }
        for (Map.Entry entry : dynamicObjectMap.entrySet()) {
            SyncRoute syncRoute;
            DynamicObject dynamicObject = (DynamicObject)entry.getValue();
            boolean exist = CtSyncRouteService.judeTenantExist(dynamicObject, KEY_TTENANTCODE, KEY_TACCOUNTID);
            if (!exist || syncRoutes.contains(syncRoute = CtSyncRouteService.buildSyncRoute(dynamicObject))) continue;
            syncRoutes.add(syncRoute);
        }
        return syncRoutes;
    }

    public static List<SyncRoute> getSyncRouteDown(String stenantCode, String sAccountId, List<String> sEntityKeys) {
        ArrayList<SyncRoute> syncRoutes = new ArrayList<SyncRoute>(16);
        QFilter[] qFilters = new QFilter[]{new QFilter(KEY_SENTITYKEY, "in", sEntityKeys), new QFilter(KEY_SACCOUNTID, "=", (Object)sAccountId), new QFilter(KEY_STENANTCODE, "=", (Object)stenantCode)};
        logger.error("\u8def\u7ebf:KEY_SENTITYKEY" + JSON.toJSONString(sEntityKeys));
        logger.error("accountid:" + sAccountId);
        logger.error("stenantCode:" + stenantCode);
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)FORMID_CTBOTP_SYNCROUTE, (QFilter[])qFilters);
        if (dynamicObjectMap == null || dynamicObjectMap.size() == 0) {
            return syncRoutes;
        }
        for (Map.Entry entry : dynamicObjectMap.entrySet()) {
            SyncRoute syncRoute;
            DynamicObject dynamicObject = (DynamicObject)entry.getValue();
            boolean exist = CtSyncRouteService.judeTenantExist(dynamicObject, KEY_TTENANTCODE, KEY_TACCOUNTID);
            if (!exist || syncRoutes.contains(syncRoute = CtSyncRouteService.buildSyncRoute(dynamicObject))) continue;
            syncRoutes.add(syncRoute);
        }
        return syncRoutes;
    }

    public static List<SyncRoute> getSyncRouteUp(String ttenantCode, String tAccountId, String tEntityKey) {
        ArrayList<SyncRoute> syncRoutes = new ArrayList<SyncRoute>(16);
        QFilter[] qFilters = new QFilter[]{new QFilter(KEY_TENTITYKEY, "=", (Object)tEntityKey), new QFilter(KEY_TACCOUNTID, "=", (Object)tAccountId), new QFilter(KEY_TTENANTCODE, "=", (Object)ttenantCode)};
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)FORMID_CTBOTP_SYNCROUTE, (QFilter[])qFilters);
        if (dynamicObjectMap == null || dynamicObjectMap.size() == 0) {
            return syncRoutes;
        }
        for (Map.Entry entry : dynamicObjectMap.entrySet()) {
            SyncRoute syncRoute;
            DynamicObject dynamicObject = (DynamicObject)entry.getValue();
            boolean exist = CtSyncRouteService.judeTenantExist(dynamicObject, KEY_STENANTCODE, KEY_SACCOUNTID);
            if (!exist || syncRoutes.contains(syncRoute = CtSyncRouteService.buildSyncRoute(dynamicObject))) continue;
            syncRoutes.add(syncRoute);
        }
        return syncRoutes;
    }

    public static List<SyncRoute> getSyncRouteUp(String ttenantCode, String tAccountId, List<String> tEntityKeys) {
        ArrayList<SyncRoute> syncRoutes = new ArrayList<SyncRoute>(16);
        QFilter[] qFilters = new QFilter[]{new QFilter(KEY_TENTITYKEY, "in", tEntityKeys), new QFilter(KEY_TACCOUNTID, "=", (Object)tAccountId), new QFilter(KEY_TTENANTCODE, "=", (Object)ttenantCode)};
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)FORMID_CTBOTP_SYNCROUTE, (QFilter[])qFilters);
        if (dynamicObjectMap == null || dynamicObjectMap.size() == 0) {
            return syncRoutes;
        }
        for (Map.Entry entry : dynamicObjectMap.entrySet()) {
            SyncRoute syncRoute;
            DynamicObject dynamicObject = (DynamicObject)entry.getValue();
            boolean exist = CtSyncRouteService.judeTenantExist(dynamicObject, KEY_STENANTCODE, KEY_SACCOUNTID);
            if (!exist || syncRoutes.contains(syncRoute = CtSyncRouteService.buildSyncRoute(dynamicObject))) continue;
            syncRoutes.add(syncRoute);
        }
        return syncRoutes;
    }

    private static QFilter[] getQFilters(SyncRoute syncRoute) {
        QFilter[] filters = new QFilter[]{new QFilter(KEY_SENTITYKEY, "=", (Object)syncRoute.getsEntityKey()), new QFilter(KEY_TENTITYKEY, "=", (Object)syncRoute.gettEntityKey()), new QFilter(KEY_STENANTCODE, "=", (Object)syncRoute.getStenantCode()), new QFilter(KEY_SACCOUNTID, "=", (Object)syncRoute.getsAccountId()), new QFilter(KEY_TTENANTCODE, "=", (Object)syncRoute.getTtenantCode()), new QFilter(KEY_TACCOUNTID, "=", (Object)syncRoute.gettAccountId())};
        return filters;
    }

    private static String getKey(SyncRoute syncRoute) {
        StringBuilder syncRouteKeyBuilder = new StringBuilder();
        syncRouteKeyBuilder.append(syncRoute.getStenantCode());
        syncRouteKeyBuilder.append(syncRoute.getsAccountId());
        syncRouteKeyBuilder.append(syncRoute.getsEntityKey());
        syncRouteKeyBuilder.append(syncRoute.getTtenantCode());
        syncRouteKeyBuilder.append(syncRoute.gettAccountId());
        syncRouteKeyBuilder.append(syncRoute.gettEntityKey());
        return syncRouteKeyBuilder.toString();
    }

    private static DynamicObject buildDyObject(MainEntityType mainType, SyncRoute syncRoute) {
        DynamicObject obj = new DynamicObject((DynamicObjectType)mainType);
        if (StringUtils.isNotBlank((Object)syncRoute.getId())) {
            obj.set(KEY_ID, (Object)syncRoute.getId());
        }
        if (StringUtils.isNotEmpty((CharSequence)syncRoute.getStenantCode())) {
            obj.set(KEY_STENANTCODE, (Object)syncRoute.getStenantCode());
        }
        if (StringUtils.isNotBlank((CharSequence)syncRoute.getsAccountId())) {
            obj.set(KEY_SACCOUNTID, (Object)syncRoute.getsAccountId());
        }
        if (StringUtils.isNotEmpty((CharSequence)syncRoute.getsEntityKey())) {
            obj.set(KEY_SENTITYKEY, (Object)syncRoute.getsEntityKey());
        }
        if (StringUtils.isNotBlank((CharSequence)syncRoute.getTtenantCode())) {
            obj.set(KEY_TTENANTCODE, (Object)syncRoute.getTtenantCode());
        }
        if (StringUtils.isNotBlank((CharSequence)syncRoute.gettAccountId())) {
            obj.set(KEY_TACCOUNTID, (Object)syncRoute.gettAccountId());
        }
        if (StringUtils.isNotBlank((CharSequence)syncRoute.gettEntityKey())) {
            obj.set(KEY_TENTITYKEY, (Object)syncRoute.gettEntityKey());
        }
        obj.set(KEY_CREATETIME, (Object)new Date());
        if (StringUtils.isNotBlank((CharSequence)syncRoute.getUniqueKey())) {
            obj.set(KEY_UNIQUEKEY, (Object)syncRoute.getUniqueKey());
        }
        return obj;
    }

    private static SyncRoute buildSyncRoute(DynamicObject obj) {
        SyncRoute syncRoute = new SyncRoute();
        syncRoute.setId(Long.valueOf(obj.getLong(KEY_ID)));
        syncRoute.setStenantCode(obj.getString(KEY_STENANTCODE));
        syncRoute.setsEntityKey(obj.getString(KEY_SENTITYKEY));
        syncRoute.setTtenantCode(obj.getString(KEY_TTENANTCODE));
        syncRoute.settEntityKey(obj.getString(KEY_TENTITYKEY));
        syncRoute.setCreateTime(obj.getDate(KEY_CREATETIME));
        syncRoute.setsAccountId(obj.getString(KEY_SACCOUNTID));
        syncRoute.settAccountId(obj.getString(KEY_TACCOUNTID));
        return syncRoute;
    }

    private static boolean judeTenantExist(DynamicObject dynamicObject, String tenantCodeKey, String accountIdKey) {
        boolean exist = true;
        String tenantId = dynamicObject.getString(tenantCodeKey);
        String accountId = dynamicObject.getString(accountIdKey);
        DynamicObject tenant = BusinessDataServiceHelper.loadSingle((String)CTSY_TENANT, (QFilter[])new QFilter[]{new QFilter("tenantid", "=", (Object)tenantId), new QFilter("accountid", "=", (Object)accountId)});
        if (tenant == null) {
            logger.info("tenant is null:" + tenantId + ":" + accountId);
            exist = false;
        }
        return exist;
    }
}

