/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ctbotp.table;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;
import kd.bos.dataentity.metadata.database.DbMetadataColumnCollection;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;

public final class CtUniqueTable {
    private static final Log log = LogFactory.getLog(CtUniqueTable.class);
    private static final Map<String, Boolean> TABLE_EXIST = new ConcurrentHashMap<String, Boolean>();
    private static final Map<String, Boolean> FIELD_EXIST = new ConcurrentHashMap<String, Boolean>();
    private static final Map<String, Boolean> UNIQUEDB_EXIST = new ConcurrentHashMap<String, Boolean>();
    private static final String FORMID_CTBOTP_UNIQUEDB = "ctbotp_uniquedb";
    private static final String KEY_NUMBER = "number";
    private static final String TABLE_NAME_LOG = "t_ctbotp_unique";
    private static final String SQL_TABLE_IS_EXISTED = "SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 't_ctbotp_unique' ";
    private static final String SQL_CREATE_TABLE_LOG = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 't_ctbotp_unique') create table t_ctbotp_unique (  fid               BIGINT DEFAULT(0)    not null,  fstenantcode      VARCHAR(50) DEFAULT ' ' NOT NULL,  fsaccountid       VARCHAR(50) DEFAULT ' ' NOT NULL,  fsentitykey       VARCHAR(36) DEFAULT ' ' NOT NULL,  fsbillid          BIGINT DEFAULT 0 NOT NULL,  ftentitykey       VARCHAR(36) DEFAULT ' ' NOT NULL,  ftbillid          BIGINT DEFAULT 0 NOT NULL,  fcreatetime       DATETIME             not null,  constraint pk_ctbotp_unique primary key (fid) ) ";
    private static final Map<String, String> TABLE_FIELDS_ADD_SQL = new HashMap<String, String>();
    private static final String SQL_CREATE_IDX_UNIQUEKEY = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_TABNAME = 'T_CTBOTP_UNIQUE' AND KSQL_INDNAME = 'IDX_CTBOTP_UNI_UNIQUEKEY') CREATE UNIQUE INDEX IDX_CTBOTP_UNI_UNIQUEKEY ON T_CTBOTP_UNIQUE (FSTENANTCODE ,FSACCOUNTID ,FSENTITYKEY ,FSBILLID ,FTENTITYKEY )";
    private static final String SQL_CREATE_IDX_TBILLID = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_TABNAME = 'T_CTBOTP_UNIQUE' AND KSQL_INDNAME = 'IDX_CTBOTP_UNI_TBILLID') CREATE INDEX IDX_CTBOTP_UNI_TBILLID ON T_CTBOTP_UNIQUE (FTBILLID )";
    private static final String SQL_CREATE_IDX_SBILLID = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_TABNAME = 'T_CTBOTP_UNIQUE' AND KSQL_INDNAME = 'IDX_CTBOTP_UNI_SBILLID') CREATE INDEX IDX_CTBOTP_UNI_SBILLID ON T_CTBOTP_UNIQUE (FSBILLID )";

    private static String buildCacheKey(String dbRouteKey) {
        return CacheKeyUtil.getAcctId() + "." + dbRouteKey;
    }

    public static synchronized void createTable(DBRoute dbRoute) {
        CtUniqueTable.createLogDB(dbRoute);
        Boolean isExisted = CtUniqueTable.existTable(dbRoute);
        if (!isExisted.booleanValue()) {
            try (TXHandle h = TX.requiresNew();){
                try {
                    DB.execute((DBRoute)dbRoute, (String)SQL_CREATE_TABLE_LOG);
                    DB.execute((DBRoute)dbRoute, (String)SQL_CREATE_IDX_UNIQUEKEY);
                    DB.execute((DBRoute)dbRoute, (String)SQL_CREATE_IDX_TBILLID);
                    DB.execute((DBRoute)dbRoute, (String)SQL_CREATE_IDX_SBILLID);
                }
                catch (Throwable e) {
                    h.markRollback();
                    log.warn(e);
                }
            }
        } else {
            CtUniqueTable.alterTable(dbRoute);
        }
        String dbKey = CtUniqueTable.buildCacheKey(dbRoute.getRouteKey());
        TABLE_EXIST.put(dbKey, Boolean.TRUE);
    }

    public static synchronized Boolean existTable(DBRoute dbRoute) {
        String dbKey = CtUniqueTable.buildCacheKey(dbRoute.getRouteKey());
        Boolean isExisted = TABLE_EXIST.get(dbKey);
        if (isExisted != null && isExisted.booleanValue()) {
            return true;
        }
        isExisted = (Boolean)DB.query((DBRoute)dbRoute, (String)SQL_TABLE_IS_EXISTED, null, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                return rs.next();
            }
        });
        TABLE_EXIST.put(dbKey, isExisted);
        return isExisted;
    }

    private static void alterTable(DBRoute dbRoute) {
        HashSet<String> lostFields = new HashSet<String>(16);
        if (CtUniqueTable.existField(dbRoute, lostFields).booleanValue()) {
            return;
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                ArrayList<SqlObject> sqlList = new ArrayList<SqlObject>(10);
                for (String field : lostFields) {
                    String sql = TABLE_FIELDS_ADD_SQL.get(field);
                    if (!StringUtils.isNotBlank((CharSequence)sql)) continue;
                    sqlList.add(new SqlObject(sql, (kd.bos.db.SqlParameter[])new SqlParameter[0]));
                }
                if (sqlList != null && sqlList.size() > 0) {
                    for (SqlObject list : sqlList) {
                        DB.execute((DBRoute)dbRoute, (String)list.getSql(), (Object[])list.getParams());
                    }
                }
                DB.execute((DBRoute)dbRoute, (String)SQL_CREATE_IDX_UNIQUEKEY);
            }
            catch (Throwable e) {
                h.markRollback();
                log.warn(e);
            }
        }
        String dbKey = CtUniqueTable.buildCacheKey(dbRoute.getRouteKey());
        FIELD_EXIST.put(dbKey, Boolean.TRUE);
    }

    private static synchronized Boolean existField(DBRoute dbRoute, Set<String> lostFields) {
        String dbKey = CtUniqueTable.buildCacheKey(dbRoute.getRouteKey());
        Boolean isExisted = FIELD_EXIST.get(dbKey);
        if (isExisted != null && isExisted.booleanValue()) {
            return true;
        }
        DbMetadataTable dbTable = CtUniqueTable.loadTableSchema(dbRoute);
        if (dbTable == null) {
            return true;
        }
        Set<String> existFields = CtUniqueTable.getExistDbTableFields(dbTable);
        lostFields.clear();
        for (Map.Entry<String, String> entry : TABLE_FIELDS_ADD_SQL.entrySet()) {
            String field = entry.getKey();
            if (existFields.contains(field)) continue;
            lostFields.add(field);
        }
        FIELD_EXIST.put(dbKey, lostFields.isEmpty());
        return lostFields.isEmpty();
    }

    private static Set<String> getExistDbTableFields(DbMetadataTable dbTable) {
        DbMetadataColumnCollection collection = dbTable.getColumns();
        if (collection == null) {
            return new HashSet<String>(0);
        }
        HashSet<String> fields = new HashSet<String>(collection.size());
        for (DbMetadataColumn col : collection) {
            fields.add(col.getName());
        }
        return fields;
    }

    private static DbMetadataTable loadTableSchema(DBRoute dbRoute) {
        if (!DB.exitsTable((DBRoute)dbRoute, (String)TABLE_NAME_LOG)) {
            return null;
        }
        List columnNames = DB.getColumnNames((DBRoute)dbRoute, (String)TABLE_NAME_LOG);
        DbMetadataTable metadataTable = new DbMetadataTable();
        metadataTable.setName(TABLE_NAME_LOG);
        DbMetadataColumnCollection cols = new DbMetadataColumnCollection(metadataTable);
        for (String name : columnNames) {
            cols.add(new DbMetadataColumn(name));
        }
        metadataTable.setColumns(cols);
        return metadataTable;
    }

    private static synchronized void createLogDB(DBRoute dbRoute) {
        String dbKey = CtUniqueTable.buildCacheKey(dbRoute.getRouteKey());
        Boolean isExisted = UNIQUEDB_EXIST.get(dbKey);
        if (isExisted != null && isExisted.booleanValue()) {
            return;
        }
        QFilter qFilter = new QFilter(KEY_NUMBER, "=", (Object)dbRoute.getRouteKey());
        Map objs = BusinessDataReader.loadFromCache((String)FORMID_CTBOTP_UNIQUEDB, (QFilter[])new QFilter[]{qFilter});
        if (objs.isEmpty()) {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)FORMID_CTBOTP_UNIQUEDB);
            DynamicObject obj = new DynamicObject((DynamicObjectType)mainType);
            obj.set(KEY_NUMBER, (Object)dbRoute.getRouteKey());
            obj.set("creator_id", (Object)RequestContext.get().getCurrUserId());
            obj.set("createtime", (Object)new Date());
            try (TXHandle h = TX.requiresNew();){
                try {
                    BusinessDataWriter.save((IDataEntityType)mainType, (Object[])new DynamicObject[]{obj});
                }
                catch (Throwable e) {
                    h.markRollback();
                    log.warn(e);
                }
            }
        }
        UNIQUEDB_EXIST.put(dbKey, Boolean.TRUE);
    }
}

