/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.botp.runtime.SourceRowReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.service.botp.convert.BillAndRule;
import kd.bos.service.botp.convert.group.SourceRowId;
import kd.bos.service.botp.convert.sort.ListSelectedRowComparator;

public class ConvertReportManager {
    private Map<Object, BillAndRule> billAndRules = new HashMap<Object, BillAndRule>();
    private Map<Object, SourceBillReport> billReports = new LinkedHashMap<Object, SourceBillReport>();
    private Set<SourceRowId> linkSourceRowIds = new HashSet<SourceRowId>();
    private Map<ConvertRuleElement, String> breakMessages = new HashMap<ConvertRuleElement, String>();

    public Collection<BillAndRule> getBillAndRules() {
        return this.billAndRules.values();
    }

    public List<Object> getNoRuleBillIds() {
        ArrayList<Object> billIds = new ArrayList<Object>();
        for (BillAndRule bill : this.billAndRules.values()) {
            if (!StringUtils.isBlank((CharSequence)bill.getRuleId())) continue;
            billIds.add(bill.getBillId());
        }
        return billIds;
    }

    public BillAndRule getOneBillIdByRule(String ruleId) {
        for (BillAndRule bill : this.billAndRules.values()) {
            if (!StringUtils.isNotEmpty((CharSequence)bill.getRuleId()) || !bill.getRuleId().equals(ruleId) || bill.getBillId() == null) continue;
            return bill;
        }
        return null;
    }

    public Collection<SourceBillReport> getBillReports() {
        return this.billReports.values();
    }

    public Map<ConvertRuleElement, String> getBreakMessages() {
        return this.breakMessages;
    }

    public void addBreakMessage(ConvertRuleElement rule, String failMessage) {
        this.breakMessages.put(rule, failMessage);
    }

    public void initBillAndRules(List<ListSelectedRow> selectedRows) {
        ArrayList<ListSelectedRow> sortRows = new ArrayList<ListSelectedRow>(selectedRows.size());
        sortRows.addAll(selectedRows);
        ListSelectedRowComparator comparator = new ListSelectedRowComparator();
        sortRows.sort(comparator);
        for (ListSelectedRow row : sortRows) {
            Object billId = row.getPrimaryKeyValue();
            if (this.billAndRules.containsKey(billId)) continue;
            BillAndRule billAndRule = new BillAndRule(billId, row.getBillNo());
            this.billAndRules.put(billId, billAndRule);
            this.createBillReport(billId, row.getBillNo());
        }
    }

    public void updateRuleId(Object billId, String ruleId, String ruleName) {
        BillAndRule billAndRule = this.billAndRules.get(billId);
        billAndRule.setRuleId(ruleId);
        billAndRule.setRuleName(ruleName);
        SourceBillReport billReport = this.billReports.get(billId);
        if (billReport == null) {
            billReport = new SourceBillReport();
            billReport.setBillId(billId);
            this.billReports.put(billId, billReport);
        }
        billReport.setRuleId(ruleId);
        billReport.setRuleName(ruleName);
    }

    private void createBillReport(Object billId, String billNo) {
        if (!this.billReports.containsKey(billId)) {
            SourceBillReport billReport = new SourceBillReport();
            billReport.setBillId(billId);
            billReport.setBillNo(billNo);
            this.billReports.put(billId, billReport);
        }
    }

    public void failBill(Object billId, String failMessage) {
        SourceBillReport billReport = this.billReports.get(billId);
        if (billReport != null) {
            billReport.addFailMessage(failMessage);
        }
    }

    public void addLinkRow(Object billId, String billNo, String linkEntityKey, String linkEntityName, String entryKey, String entryName, String subEntryKey, String subEntryName, SourceRowId sourceRowId) {
        if (this.linkSourceRowIds.add(sourceRowId)) {
            this.addLinkRow(billId, billNo, linkEntityKey, linkEntityName, entryKey, entryName, subEntryKey, subEntryName);
        }
    }

    public void addLinkRow(Object billId, String billNo, String linkEntityKey, String linkEntityName, String entryKey, String entryName, String subEntryKey, String subEntryName) {
        SourceBillReport billReport = this.billReports.get(billId);
        if (billReport == null) {
            billReport = new SourceBillReport();
            billReport.setBillId(billId);
            this.billReports.put(billId, billReport);
        }
        billReport.setBillNo(billNo);
        billReport.setLinkEntityKey(linkEntityKey);
        billReport.setLinkEntityName(linkEntityName);
        billReport.addRowCount(1);
        billReport.setEntryKey(entryKey);
        billReport.setEntryName(entryName);
        billReport.setSubEntryKey(subEntryKey);
        billReport.setSubEntryName(subEntryName);
    }

    public void addErrorReport(String entityKey, SourceRowId rowInfo, String failMessage) {
        SourceBillReport billReport = this.billReports.get(rowInfo.getBillId());
        if (billReport == null) {
            return;
        }
        SourceRowReport rowReport = new SourceRowReport();
        rowReport.setEntryId(rowInfo.getEntryId());
        rowReport.setEntrySeq(rowInfo.getEntrySeq());
        rowReport.setSubEntryId(rowInfo.getSubEntryId());
        rowReport.setSubEntrySeq(rowInfo.getSubEntrySeq());
        rowReport.getFailMessages().add(failMessage);
        billReport.addSourceRowReport(entityKey, rowReport);
    }
}

