/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.actions;

import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.ConvertResultManager;
import kd.bos.service.botp.convert.SingleBatchContext;
import kd.bos.service.botp.convert.SingleBatchResultManager;
import kd.bos.service.botp.convert.SingleRuleContext;
import kd.bos.service.botp.convert.SingleRuleResultManager;
import kd.bos.service.botp.convert.group.SourceRowsGroup;
import kd.bos.service.business.datamodel.DrawDataModel;

public abstract class AbstractConvertAction {
    protected ConvertContext context;
    protected SingleRuleContext ruleContext;
    protected SingleBatchContext batchContext;
    protected ConvertResultManager resultManager;
    protected SingleRuleResultManager ruleResultManager;
    protected SingleBatchResultManager batchResultManager;

    public AbstractConvertAction(ConvertContext context, ConvertResultManager resultManager) {
        this.context = context;
        this.resultManager = resultManager;
    }

    public ConvertContext getContext() {
        return this.context;
    }

    public void setContext(ConvertContext context) {
        this.context = context;
    }

    public SingleRuleContext getRuleContext() {
        return this.ruleContext;
    }

    public void setRuleContext(SingleRuleContext ruleContext) {
        this.ruleContext = ruleContext;
    }

    public SingleBatchContext getBatchContext() {
        return this.batchContext;
    }

    public void setBatchContext(SingleBatchContext batchContext) {
        this.batchContext = batchContext;
    }

    public ConvertResultManager getResultManager() {
        return this.resultManager;
    }

    public void setResultManager(ConvertResultManager resultManager) {
        this.resultManager = resultManager;
    }

    public SingleRuleResultManager getRuleResultManager() {
        return this.ruleResultManager;
    }

    public void setRuleResultManager(SingleRuleResultManager ruleResultManager) {
        this.ruleResultManager = ruleResultManager;
    }

    public SingleBatchResultManager getBatchResultManager() {
        return this.batchResultManager;
    }

    public void setBatchResultManager(SingleBatchResultManager batchResultManager) {
        this.batchResultManager = batchResultManager;
    }

    public DrawDataModel getModelProxy() {
        if (this.batchContext != null) {
            return this.batchContext.getModelProxy();
        }
        return this.ruleContext.getModelProxy();
    }

    public SourceRowsGroup getSourceRowsGroupRoot() {
        if (this.batchContext != null) {
            return this.batchContext.getSourceRowsGroupRoot();
        }
        return this.ruleContext.getRuleCompiler().getLinkEntityMap().getSourceRowsGroup();
    }

    public ExtendedDataEntitySet getTargetExtendedDataEntities() {
        if (this.batchResultManager != null) {
            return this.batchResultManager.getTargetExtendedDataEntities();
        }
        return this.ruleResultManager.getTargetExtendedDataEntities();
    }

    public void setTargetExtendedDataEntities(ExtendedDataEntitySet targetExtSet) {
        if (this.batchResultManager != null) {
            this.batchResultManager.setTargetExtendedDataEntities(targetExtSet);
        } else {
            this.ruleResultManager.setTargetExtendedDataEntities(targetExtSet);
        }
    }

    public boolean isSkipNextAction() {
        if (this.batchResultManager != null) {
            return this.batchResultManager.isSkipNextAction() && this.ruleResultManager.isSkipNextAction();
        }
        return this.ruleResultManager.isSkipNextAction();
    }

    public void setSkipNextAction(boolean skipNextAction) {
        if (this.batchResultManager != null) {
            this.batchResultManager.setSkipNextAction(skipNextAction);
        } else {
            this.ruleResultManager.setSkipNextAction(skipNextAction);
        }
    }

    public void action() {
        if (!this.isSkipNextAction()) {
            this.doAction();
        }
    }

    protected void doAction() {
    }
}

