/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.botp.plugin.args.AfterCreateTargetEventArgs;
import kd.bos.entity.property.BillTypeProp;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.ConvertResultManager;
import kd.bos.service.botp.convert.actions.AbstractConvertAction;
import kd.bos.service.botp.convert.compiler.LinkEntityMap;
import kd.bos.service.botp.convert.getvaluemode.IGetValueMode;
import kd.bos.service.botp.convert.group.SourceRowsGroup;
import kd.bos.service.botp.convert.group.SourceRowsGroupKey;
import kd.bos.service.botp.convert.mapping.IMappingField;
import kd.bos.service.business.datamodel.DrawDataModel;

public class CreateLinkEntityRowsAction
extends AbstractConvertAction {
    private DrawDataModel modelProxy = null;
    private LinkEntityMap linkEntityMap = null;
    private EntryType targetEntryEntity = null;
    private SubEntryType targetSubEntryEntity = null;

    public CreateLinkEntityRowsAction(ConvertContext context, ConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    protected void doAction() {
        super.doAction();
        this.modelProxy = this.getModelProxy();
        this.linkEntityMap = this.ruleContext.getRuleCompiler().getLinkEntityMap();
        ExtendedDataEntitySet targetExtSet = this.getTargetExtendedDataEntities();
        BillEntityType mainType = this.context.getTargetMainType();
        if (StringUtils.isNotBlank((CharSequence)this.linkEntityMap.getTargetEntryKey())) {
            this.targetEntryEntity = (EntryType)mainType.getAllEntities().get(this.linkEntityMap.getTargetEntryKey());
        }
        if (StringUtils.isNotBlank((CharSequence)this.linkEntityMap.getTargetSubEntryKey())) {
            this.targetSubEntryEntity = (SubEntryType)mainType.getAllEntities().get(this.linkEntityMap.getTargetSubEntryKey());
        }
        ExtendedDataEntity[] headExtEntitys = targetExtSet.FindByEntityKey(mainType.getName());
        HashMap<SourceRowsGroupKey, ExtendedDataEntity> headGroup = new HashMap<SourceRowsGroupKey, ExtendedDataEntity>();
        for (ExtendedDataEntity headExtEntity : headExtEntitys) {
            Object sourceRows = headExtEntity.getValue("ConvertSource");
            if (sourceRows == null) continue;
            SourceRowsGroupKey groupKey = (SourceRowsGroupKey)headExtEntity.getValue("SourceRowsGroupKey");
            headGroup.put(groupKey, headExtEntity);
        }
        SourceRowsGroup group = this.getSourceRowsGroupRoot();
        this.modelProxy.beginInit();
        for (SourceRowsGroup srcBillGroup : group.getChildGroupList()) {
            SourceRowsGroupKey srcBillGroupKey = srcBillGroup.getGroupKey();
            ExtendedDataEntity headExtEntity = (ExtendedDataEntity)headGroup.get(srcBillGroupKey);
            if (headExtEntity == null) continue;
            this.modelProxy.draw(headExtEntity.getDataEntity());
            boolean isNewBill = false;
            Object extNewEntityValue = headExtEntity.getValue("isNewEntity");
            if (extNewEntityValue != null) {
                isNewBill = (Boolean)extNewEntityValue;
            }
            this.createEntryEntity(targetExtSet, headExtEntity.getDataEntityIndex(), srcBillGroup, isNewBill);
        }
        this.modelProxy.endInit();
        AfterCreateTargetEventArgs eventArgs = new AfterCreateTargetEventArgs(targetExtSet, this.linkEntityMap.getSrcFldPropertys());
        this.ruleContext.getPlugInProxy().fireAfterCreateTarget(eventArgs);
        targetExtSet = eventArgs.getTargetExtDataEntitySet();
        this.setTargetExtendedDataEntities(targetExtSet);
        this.resultManager.getLogger().addConvertHistory(this.ruleContext, targetExtSet.FindByEntityKey(this.getContext().getTargetMainType().getName()));
    }

    private void setDefValueCalculatorBillType(DynamicObject sourceRow) {
        BillEntityType tgtMainType = this.context.getTargetMainType();
        BillTypeProp billTypeField = null;
        for (IDataEntityProperty property : tgtMainType.getAllFields().values()) {
            if (!(property instanceof BillTypeProp)) continue;
            billTypeField = (BillTypeProp)property;
            break;
        }
        String billTypeId = "";
    }

    private void createEntryEntity(ExtendedDataEntitySet targetExtSet, int dataEntityIndex, SourceRowsGroup srcBillRowsGroup, boolean isNewBill) {
        if (this.targetEntryEntity == null) {
            return;
        }
        IGetValueMode srcEntryIdReader = this.getSrcEntryIdReader(this.linkEntityMap.getTargetFields().get(this.targetEntryEntity));
        List<SourceRowsGroup> srcEntryRowsGroups = this.getNotEmptyRows(srcBillRowsGroup.getChildGroupList(), srcEntryIdReader);
        if (srcEntryRowsGroups.isEmpty()) {
            return;
        }
        String entryKey = this.targetEntryEntity.getName();
        int groupRowCount = srcEntryRowsGroups.size();
        int rowCount = this.modelProxy.getEntryRowCount(entryKey);
        int startRowIndex = srcBillRowsGroup.getStartEntrySeq();
        int rowIndex = 0;
        if (isNewBill) {
            if (groupRowCount > rowCount) {
                this.modelProxy.batchCreateNewEntryRow(entryKey, groupRowCount - rowCount);
            }
        } else {
            this.modelProxy.batchCreateNewEntryRow(entryKey, groupRowCount);
            rowIndex = rowCount;
        }
        ArrayList<ExtendedDataEntity> entryExtEntitys = new ArrayList<ExtendedDataEntity>(srcEntryRowsGroups.size());
        for (SourceRowsGroup srcEntryRowGroup : srcEntryRowsGroups) {
            this.modelProxy.setEntryCurrentRowIndex(entryKey, rowIndex);
            DynamicObject entryObj = this.modelProxy.getEntryEntity(entryKey, rowIndex);
            entryObj.getDataEntityState().setPushChanged(true);
            this.targetEntryEntity.getSeqProperty().setValueFast((Object)entryObj, (Object)(rowIndex + startRowIndex));
            ExtendedDataEntity entryExtEntity = new ExtendedDataEntity(entryObj, dataEntityIndex, rowIndex);
            entryExtEntity.setValue("ConvertSource", srcEntryRowGroup.getSourceRows());
            entryExtEntity.setValue("isNewEntity", (Object)Boolean.TRUE);
            entryExtEntitys.add(entryExtEntity);
            this.createSubEntryEntity(targetExtSet, dataEntityIndex, ++rowIndex, srcEntryRowGroup);
        }
        targetExtSet.AddExtendedDataEntities(entryKey, entryExtEntitys);
    }

    private void createSubEntryEntity(ExtendedDataEntitySet targetExtSet, int dataEntityIndex, int rowIndex, SourceRowsGroup srcEntryRowsGroup) {
        int rowCount;
        if (this.targetSubEntryEntity == null) {
            return;
        }
        String subEntryKey = this.targetSubEntryEntity.getName();
        IGetValueMode srcSubEntryIdReader = this.getSrcEntryIdReader(this.linkEntityMap.getTargetFields().get(this.targetSubEntryEntity));
        List<SourceRowsGroup> srcSubEntryRowsGroups = this.getNotEmptyRows(srcEntryRowsGroup.getChildGroupList(), srcSubEntryIdReader);
        if (srcSubEntryRowsGroups.isEmpty()) {
            return;
        }
        int groupRowCount = srcSubEntryRowsGroups.size();
        if (groupRowCount > (rowCount = this.modelProxy.getEntryRowCount(subEntryKey))) {
            this.modelProxy.batchCreateNewEntryRow(subEntryKey, groupRowCount - rowCount);
        }
        int subRowIndex = 0;
        ArrayList<ExtendedDataEntity> subEntryExtEntitys = new ArrayList<ExtendedDataEntity>(groupRowCount);
        for (SourceRowsGroup srcSubEntryRowsGroup : srcSubEntryRowsGroups) {
            this.modelProxy.setEntryCurrentRowIndex(subEntryKey, subRowIndex);
            DynamicObject subEntryObj = this.modelProxy.getEntryCurrentRow(subEntryKey);
            subEntryObj.getDataEntityState().setPushChanged(true);
            ExtendedDataEntity subEntryExtEntity = new ExtendedDataEntity(subEntryObj, dataEntityIndex, rowIndex, subRowIndex, "");
            subEntryExtEntity.setValue("ConvertSource", srcSubEntryRowsGroup.getSourceRows());
            subEntryExtEntity.setValue("isNewEntity", (Object)Boolean.TRUE);
            subEntryExtEntitys.add(subEntryExtEntity);
            ++subRowIndex;
        }
        targetExtSet.AddExtendedDataEntities(subEntryKey, subEntryExtEntitys);
    }

    private List<SourceRowsGroup> getNotEmptyRows(List<SourceRowsGroup> rowsGroups, IGetValueMode srcEntryIdReader) {
        ArrayList<SourceRowsGroup> notEmptyRowsGroups = new ArrayList<SourceRowsGroup>();
        block0: for (SourceRowsGroup rowsGroup : rowsGroups) {
            for (DynamicObject sourceRow : rowsGroup.getSourceRows()) {
                Long entryId = (Long)srcEntryIdReader.getValue(this.linkEntityMap.getSrcFldPropertys(), sourceRow);
                if (entryId == null || Long.compare(entryId, 0L) == 0) continue;
                notEmptyRowsGroups.add(rowsGroup);
                continue block0;
            }
        }
        return notEmptyRowsGroups;
    }

    private IGetValueMode getSrcEntryIdReader(List<IMappingField> mappingFields) {
        boolean isLinkSubEntry = false;
        boolean isLinkEntry = false;
        if (mappingFields != null) {
            for (IMappingField mappingField : mappingFields) {
                if (StringUtils.isNotBlank((CharSequence)mappingField.getSourceSubEntryKey())) {
                    isLinkSubEntry = true;
                    break;
                }
                if (!StringUtils.isNotBlank((CharSequence)mappingField.getSourceEntryKey())) continue;
                isLinkEntry = true;
            }
        }
        if (isLinkSubEntry) {
            return this.linkEntityMap.getSrcSubEntryIdReader();
        }
        if (isLinkEntry) {
            return this.linkEntityMap.getSrcEntryIdReader();
        }
        return this.linkEntityMap.getSrcBillIdReader();
    }
}

