/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillLayoutSchemeService;
import kd.bos.cache.CacheLoader;
import kd.bos.cache.ThreadCache;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.bill.BillLayoutParameter;
import kd.bos.entity.bill.BillLayoutSchemeAssignEntity;
import kd.bos.entity.botp.BillTypeMapParser;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IDefValueProvider;
import kd.bos.entity.formula.OutValue;
import kd.bos.entity.property.BillTypeProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.orm.query.QFilter;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.ConvertResultManager;
import kd.bos.service.botp.convert.actions.AbstractConvertAction;
import kd.bos.service.botp.convert.compiler.LinkEntityMap;
import kd.bos.service.botp.convert.getvaluemode.IGetValueMode;
import kd.bos.service.botp.convert.group.SourceRowsGroup;
import kd.bos.service.botp.convert.group.SourceRowsGroupKey;
import kd.bos.service.botp.convert.mapping.IMappingField;
import kd.bos.service.botp.convert.org.SetMainOrgManager;
import kd.bos.service.botp.convert.report.IBuildDetailReport;
import kd.bos.service.business.datamodel.BillDefValueProvider;
import kd.bos.service.business.datamodel.BillTypeDefValueProvider;
import kd.bos.service.business.datamodel.DrawDataModel;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class CreateTargetBillAction
extends AbstractConvertAction {
    private static final String DEFAULT_BILLTYPE_ID = "DEFAULT_BILLTYPE_ID";
    private static final String BOS_MSERVICE_BOTP = "bos-mservice-botp";
    private static final String THREAD_CACHE_KEY_BLANK_DATAENTITY = "botp_blank_dataentity";
    private DrawDataModel modelProxy;
    private Map<String, DynamicObject> blankDataEntitys = new HashMap<String, DynamicObject>();
    private LinkEntityMap linkEntityMap;
    private IBuildDetailReport buildReport = null;
    private BillEntityType targetMainType = null;
    private MainOrgProp mainOrgProp = null;
    private Long defOrgId = null;
    private IMappingField mappingBillType = null;
    private IGetValueMode srcBillTypeReader = null;
    private BillTypeProp billTypeProp = null;
    private Map<Object, DynamicObject> targetBillTypeObjs = null;
    private BillTypeMapParser billTypeMapParser = null;
    private SetMainOrgManager setMainOrgManager;

    private Object getBlankDataEntity(final IDataModel model) {
        Object billTypeId;
        Object mainOrgId = this.mainOrgProp == null ? null : model.getContextVariable(this.mainOrgProp.getName());
        String key = String.format("%s_%s", mainOrgId, billTypeId = this.billTypeProp == null ? null : model.getContextVariable(DEFAULT_BILLTYPE_ID));
        if (!this.blankDataEntitys.containsKey(key)) {
            String threadCacheKey = String.format("%s_%s_%s", THREAD_CACHE_KEY_BLANK_DATAENTITY, this.targetMainType.getName(), key);
            DynamicObject cacheObj = (DynamicObject)ThreadCache.get((Object)threadCacheKey, (CacheLoader)new CacheLoader<DynamicObject>(){

                public DynamicObject load() {
                    model.beginInit();
                    model.createNewData();
                    model.clearNoDataRow();
                    model.endInit();
                    return model.getDataEntity();
                }
            });
            this.blankDataEntitys.put(key, cacheObj);
        }
        return (DynamicObject)OrmUtils.clone((IDataEntityBase)((IDataEntityBase)this.blankDataEntitys.get(key)), (boolean)false, (boolean)true);
    }

    private void initVar() {
        this.modelProxy = this.getModelProxy();
        this.linkEntityMap = this.ruleContext.getRuleCompiler().getLinkEntityMap();
        EntityType srcLinkEntity = (EntityType)this.context.getSourceMainType().getAllEntities().get(this.linkEntityMap.getSourceLinkEntityKey());
        this.buildReport = this.ruleContext.getSrcRowReportBuilder(srcLinkEntity);
        this.targetMainType = this.context.getTargetMainType();
        if (StringUtils.isNotBlank((CharSequence)this.targetMainType.getMainOrg())) {
            this.mainOrgProp = (MainOrgProp)this.targetMainType.getProperty(this.targetMainType.getMainOrg());
        }
        this.mappingBillType = this.linkEntityMap.getMappingBillType();
        this.srcBillTypeReader = this.linkEntityMap.getSrcBillTypeReader();
        for (IDataEntityProperty property : this.targetMainType.getProperties()) {
            if (!(property instanceof BillTypeProp)) continue;
            this.billTypeProp = (BillTypeProp)property;
            break;
        }
        this.billTypeMapParser = new BillTypeMapParser();
        this.targetBillTypeObjs = this.loadBillTypeObjs();
        this.setMainOrgManager = new SetMainOrgManager(this.ruleContext, this.ruleResultManager, this.mainOrgProp, this.modelProxy, this.defOrgId, this.buildReport);
    }

    public CreateTargetBillAction(ConvertContext context, ConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    protected void doAction() {
        super.doAction();
        this.initVar();
        SourceRowsGroup group = this.getSourceRowsGroupRoot();
        ExtendedDataEntitySet targetExtSet = new ExtendedDataEntitySet();
        int dataEntityIndex = 0;
        this.modelProxy.beginInit();
        ArrayList<ExtendedDataEntity> headExtEntitys = new ArrayList<ExtendedDataEntity>(group.getChildGroupList().size());
        for (SourceRowsGroup srcBillGroup : group.getChildGroupList()) {
            SourceRowsGroupKey srcBillGroupKey = srcBillGroup.getGroupKey();
            StringBuilder errMessage = new StringBuilder();
            if (!this.createNewData(srcBillGroup, errMessage)) continue;
            DynamicObject headObj = this.modelProxy.getDataEntity();
            headObj.getDataEntityState().setPushChanged(true);
            ExtendedDataEntity headExtEntity = new ExtendedDataEntity(headObj, dataEntityIndex, 0);
            headExtEntity.setValue("ConvertSource", srcBillGroup.getSourceRows());
            headExtEntity.setValue("isNewEntity", (Object)Boolean.TRUE);
            headExtEntity.setValue("SourceRowsGroupKey", (Object)srcBillGroupKey);
            headExtEntitys.add(headExtEntity);
            ++dataEntityIndex;
        }
        this.modelProxy.endInit();
        targetExtSet.AddExtendedDataEntities(this.targetMainType.getName(), headExtEntitys);
        this.setTargetExtendedDataEntities(targetExtSet);
    }

    protected boolean createNewData(SourceRowsGroup srcBillGroup, StringBuilder errMessage) {
        boolean flagForMainOrg = this.setMainOrgManager.setMainOrgForModel(srcBillGroup.getSourceRows());
        if (!flagForMainOrg) {
            if (errMessage != null) {
                errMessage.append(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u4e3b\u7ec4\u7ec7\u8d4b\u503c\u5931\u8d25", (String)"CreateTargetBillAction_0", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]));
            }
            return false;
        }
        if (!this.setBillType(srcBillGroup.getSourceRows())) {
            this.resultManager.getReporter().addBreakMessage(this.ruleContext.getRule(), ResManager.loadKDString((String)"\u76ee\u6807\u5355\u5355\u636e\u7c7b\u578b\u8d4b\u503c\u5931\u8d25", (String)"CreateTargetBillAction_1", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]));
            if (errMessage != null) {
                errMessage.append(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u5355\u636e\u7c7b\u578b\u8d4b\u503c\u5931\u8d25", (String)"CreateTargetBillAction_1", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]));
            }
            return false;
        }
        this.modelProxy.createNewData(this.getBlankDataEntity((IDataModel)this.modelProxy));
        return true;
    }

    private boolean setBillType(List<DynamicObject> sourceRows) {
        if (this.billTypeProp == null) {
            this.setLayoutScheme(null);
            return true;
        }
        this.modelProxy.removeContextVariable(DEFAULT_BILLTYPE_ID);
        this.modelProxy.removeContextVariable(this.billTypeProp.getName());
        OutValue mappingId = new OutValue();
        OutValue mappingName = new OutValue();
        if (!this.execMappingBillType(sourceRows, (OutValue<Long>)mappingId, (OutValue<String>)mappingName)) {
            return false;
        }
        Long billTypeId = (Long)mappingId.get();
        Long srcBillTypeId = (Long)this.srcBillTypeReader.getValue(this.linkEntityMap.getSrcFldPropertys(), sourceRows.get(0));
        DynamicObject[] billTypeObjs = this.targetBillTypeObjs.values().toArray(new DynamicObject[0]);
        this.billTypeMapParser.tryGetTargetBillTypeIds(this.ruleContext.getRule().getBillTypeMapPolicy(), srcBillTypeId, billTypeObjs);
        if (this.billTypeMapParser.isCannotPushAnyOne()) {
            String failMessage = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u6620\u5c04\u7b56\u7565\uff0c\u7981\u6b62\u5f53\u524d\u6e90\u5355\u5355\u636e\u7c7b\u578b\uff0c\u4e0b\u63a8\u5230%s", (String)"CreateTargetBillAction_8", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), this.targetMainType.getDisplayName().toString());
            this.addErrorReport(sourceRows, failMessage);
            return false;
        }
        if (this.billTypeMapParser.getOutBillTypeIds().isEmpty()) {
            String failMessage = ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u6620\u5c04\u7b56\u7565\u914d\u7f6e\u6709\u8bef\uff0c\u5f53\u524d\u6e90\u5355\u7c7b\u578b\uff0c\u627e\u4e0d\u5230\u53ef\u8f6c\u6362\u7684\u76ee\u6807\u5355\u7c7b\u578b", (String)"CreateTargetBillAction_9", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]);
            this.addErrorReport(sourceRows, failMessage);
            return false;
        }
        if (billTypeId == null || Long.compare(0L, billTypeId) == 0) {
            if (!this.billTypeMapParser.getOutBillTypeIds().isEmpty() && (billTypeId = this.getEnabledBillTypeId(sourceRows, this.billTypeMapParser.getOutBillTypeIds())) == null) {
                return false;
            }
        } else {
            if (this.billTypeMapParser.getOutCannotPushBillTypeIds().contains(billTypeId)) {
                String failMessage = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u5b57\u6bb5\u503c\u8ba1\u7b97\u516c\u5f0f\uff0c\u8ba1\u7b97\u51fa\u7684\u5355\u636e\u7c7b\u578b\u3010%s\u3011\uff0c\u88ab\u5355\u636e\u7c7b\u578b\u6620\u5c04\u7b56\u7565\u9650\u5236\u4e0b\u63a8", (String)"CreateTargetBillAction_10", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), mappingName.get());
                this.addErrorReport(sourceRows, failMessage);
                return false;
            }
            if (!this.billTypeMapParser.getOutBillTypeIds().contains(billTypeId)) {
                String failMessage = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u5b57\u6bb5\u503c\u8ba1\u7b97\u516c\u5f0f\uff0c\u8ba1\u7b97\u51fa\u7684\u5355\u636e\u7c7b\u578b\u3010%s\u3011\uff0c\u4e0d\u5728\u5355\u636e\u7c7b\u578b\u6620\u5c04\u7b56\u7565\u5141\u8bb8\u4e0b\u63a8\u7684\u8303\u56f4", (String)"CreateTargetBillAction_11", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), mappingName.get());
                this.addErrorReport(sourceRows, failMessage);
                return false;
            }
        }
        if (billTypeId != null && Long.compare(0L, billTypeId) != 0) {
            this.modelProxy.putContextVariable(DEFAULT_BILLTYPE_ID, billTypeId);
            BillTypeDefValueProvider defValueProvider = new BillTypeDefValueProvider(billTypeId);
            this.modelProxy.addService(IDefValueProvider.class, (Object)defValueProvider);
            this.setLayoutScheme(billTypeId);
            return true;
        }
        String failMessage = String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u3010%2$s\u3011\u5b57\u6bb5\u503c\u8ba1\u7b97\u5931\u8d25", (String)"CreateTargetBillAction_29", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), this.targetMainType.getDisplayName().toString(), this.billTypeProp.getDisplayName().toString());
        for (DynamicObject sourceRow : sourceRows) {
            this.buildReport.addErrorReport(this.getResultManager().getReporter(), this.linkEntityMap.getSrcFldPropertys(), sourceRow, failMessage);
        }
        return false;
    }

    private void setLayoutScheme(Object billTypePkId) {
        Long layoutSchemeId = this.getLayoutSchemeId(billTypePkId);
        if (layoutSchemeId != null) {
            BillDefValueProvider billDefValueProvider = new BillDefValueProvider(layoutSchemeId);
            this.modelProxy.addService(IDefValueProvider.class, (Object)billDefValueProvider);
        }
    }

    private Long getLayoutSchemeId(Object billTypePkId) {
        BillLayoutParameter blp = new BillLayoutParameter();
        Long newOrgValue = this.defOrgId;
        long orgId = 0L;
        if (newOrgValue != null) {
            orgId = newOrgValue;
        }
        blp.setOrgId(orgId);
        long billTypeId = 0L;
        if (StringUtils.isNotBlank((Object)billTypePkId)) {
            billTypeId = Long.parseLong(billTypePkId.toString());
        }
        blp.setBillTypeId(billTypeId);
        BillLayoutSchemeAssignEntity layoutScheme = BillLayoutSchemeService.getLayoutScheme((String)this.targetMainType.getName(), (BillLayoutParameter)blp);
        Long layoutSchemeId = null;
        if (layoutScheme != null) {
            layoutSchemeId = layoutScheme.getId();
        }
        return layoutSchemeId;
    }

    private void addErrorReport(List<DynamicObject> sourceRows, String failMessage) {
        for (DynamicObject sourceRow : sourceRows) {
            this.buildReport.addErrorReport(this.getResultManager().getReporter(), this.linkEntityMap.getSrcFldPropertys(), sourceRow, failMessage);
        }
    }

    private boolean execMappingBillType(List<DynamicObject> sourceRows, OutValue<Long> mappingId, OutValue<String> mappingName) {
        Long billTypeId = null;
        if (this.mappingBillType == null) {
            return true;
        }
        billTypeId = (Long)this.mappingBillType.calcMapValue(this.linkEntityMap.getSrcFldPropertys(), sourceRows);
        if (billTypeId == null || Long.compare(0L, billTypeId) == 0) {
            return true;
        }
        mappingId.set((Object)billTypeId);
        if (!this.targetBillTypeObjs.containsKey(billTypeId)) {
            String failMessage = String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f\u7b97\u51fa\u7684\u5355\u636e\u7c7b\u578bId\u3010%s\u3011\u65e0\u6548", (String)"CreateTargetBillAction_13", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), billTypeId.toString());
            Object[] objs = BusinessDataReader.load((Object[])new Object[]{billTypeId}, (IDataEntityType)this.billTypeProp.getDynamicComplexPropertyType());
            if (objs != null && objs.length > 0) {
                DynamicObject obj = (DynamicObject)objs[0];
                failMessage = String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f\u7b97\u51fa\u7684\u5355\u636e\u7c7b\u578b\u3010%s\u3011\uff0c\u4e0d\u5c5e\u4e8e\u76ee\u6807\u5355\uff0c\u4e0d\u80fd\u7ed9\u5b57\u6bb5\u8d4b\u503c", (String)"CreateTargetBillAction_14", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), obj.get("name").toString());
            }
            this.addErrorReport(sourceRows, failMessage);
            return false;
        }
        DynamicObject billTypeObj = this.targetBillTypeObjs.get(billTypeId);
        String billTypeName = billTypeObj.get("name").toString();
        String status = billTypeObj.getString("status");
        String enable = billTypeObj.getString("enable");
        if (!StringUtils.equalsIgnoreCase((CharSequence)"1", (CharSequence)enable)) {
            String failMessage = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u5b57\u6bb5\u503c\u8ba1\u7b97\u516c\u5f0f\uff0c\u8ba1\u7b97\u51fa\u7684\u5355\u636e\u7c7b\u578b\u3010%s\u3011\u5df2\u7ecf\u7981\u7528", (String)"CreateTargetBillAction_15", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), billTypeName);
            this.addErrorReport(sourceRows, failMessage);
            return false;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)"C", (CharSequence)status)) {
            String failMessage = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u5b57\u6bb5\u503c\u8ba1\u7b97\u516c\u5f0f\uff0c\u8ba1\u7b97\u51fa\u7684\u5355\u636e\u7c7b\u578b\u3010%s\u3011\u672a\u5ba1\u6838", (String)"CreateTargetBillAction_16", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), billTypeName);
            this.addErrorReport(sourceRows, failMessage);
            return false;
        }
        mappingName.set((Object)billTypeName);
        return true;
    }

    private Long getEnabledBillTypeId(List<DynamicObject> sourceRows, List<Long> billTypeIds) {
        Long billTypeId = null;
        ArrayList<String> unAuditNames = new ArrayList<String>();
        ArrayList<String> disableNames = new ArrayList<String>();
        for (Long id : billTypeIds) {
            DynamicObject billTypeObj = this.targetBillTypeObjs.get(id);
            if (billTypeObj == null) continue;
            String billTypeName = billTypeObj.get("name").toString();
            if (!this.isEnabledBillType(billTypeObj)) {
                disableNames.add(billTypeName);
                continue;
            }
            if (!this.isAuditdBillType(billTypeObj)) {
                unAuditNames.add(billTypeName);
                continue;
            }
            billTypeId = id;
            break;
        }
        if (billTypeId == null) {
            String failMessage = null;
            failMessage = !disableNames.isEmpty() && !unAuditNames.isEmpty() ? String.format(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u636e\u7c7b\u578b\u3010%1$s\u3011\u672a\u5ba1\u6838\uff0c\u3010%2$s\u3011\u5df2\u7981\u7528", (String)"CreateTargetBillAction_30", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), StringUtils.join((Object[])unAuditNames.toArray(), (String)","), StringUtils.join((Object[])disableNames.toArray(), (String)",")) : (!unAuditNames.isEmpty() ? String.format(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u636e\u7c7b\u578b\u3010%s\u3011\u672a\u5ba1\u6838", (String)"CreateTargetBillAction_18", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), StringUtils.join((Object[])unAuditNames.toArray(), (String)",")) : (!disableNames.isEmpty() ? String.format(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u636e\u7c7b\u578b\u3010%s\u3011\u5df2\u7981\u7528", (String)"CreateTargetBillAction_19", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), StringUtils.join((Object[])disableNames.toArray(), (String)",")) : String.format(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u636e\u7c7b\u578b\u3010%s\u3011\u5df2\u88ab\u5220\u9664", (String)"CreateTargetBillAction_20", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), StringUtils.join((Object[])billTypeIds.toArray(), (String)","))));
            this.addErrorReport(sourceRows, failMessage);
        }
        return billTypeId;
    }

    private boolean isAuditdBillType(DynamicObject billTypeObj) {
        String status = billTypeObj.getString("status");
        return StringUtils.equalsIgnoreCase((CharSequence)"C", (CharSequence)status);
    }

    private boolean isEnabledBillType(DynamicObject billTypeObj) {
        String enable = billTypeObj.getString("enable");
        return StringUtils.equalsIgnoreCase((CharSequence)"1", (CharSequence)enable);
    }

    private Map<Object, DynamicObject> loadBillTypeObjs() {
        QFilter[] filters = new QFilter[]{new QFilter("billformid", "=", (Object)this.targetMainType.getName())};
        return BusinessDataServiceHelper.loadFromCache((String)"bos_billtype", (String)"id, number, name, status, enable, isdefault", (QFilter[])filters);
    }

    private Long getDefOrgId() {
        return this.defOrgId;
    }

    private void setDefOrgId(Long defOrgId) {
        this.defOrgId = defOrgId;
    }
}

