/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.BillTypeMapParser;
import kd.bos.entity.botp.runtime.DrawArgs;
import kd.bos.entity.property.BillTypeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.ConvertResultManager;
import kd.bos.service.botp.convert.actions.AbstractConvertAction;
import kd.bos.service.botp.convert.compiler.LinkEntityMap;
import kd.bos.service.botp.convert.getvaluemode.IGetValueMode;
import kd.bos.service.botp.convert.group.SourceRowsGroup;
import kd.bos.service.botp.convert.group.SourceRowsGroupKey;
import kd.bos.service.botp.convert.mapping.IMappingField;
import kd.bos.service.business.datamodel.DrawDataModel;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class CreateTargetBillDrawAction
extends AbstractConvertAction {
    private static final String BOS_MSERVICE_OPERATION = "bos-mservice-botp";
    private DrawDataModel modelProxy;
    private LinkEntityMap linkEntityMap;
    private BillEntityType mainType = null;
    private IMappingField mappingMainOrg = null;
    private MainOrgProp mainOrgProp = null;
    private IMappingField mappingBillType = null;
    private BillTypeProp billTypeProp = null;
    private IGetValueMode srcBillTypeReader = null;
    private BillTypeMapParser billTypeMapParser = null;

    private void initVar() {
        this.modelProxy = this.getModelProxy();
        this.linkEntityMap = this.ruleContext.getRuleCompiler().getLinkEntityMap();
        this.mainType = this.context.getTargetMainType();
        this.mappingMainOrg = this.linkEntityMap.getMappingMainOrg();
        if (StringUtils.isNotBlank((CharSequence)this.mainType.getMainOrg())) {
            this.mainOrgProp = (MainOrgProp)this.mainType.getProperty(this.mainType.getMainOrg());
        }
        this.mappingBillType = this.linkEntityMap.getMappingBillType();
        this.srcBillTypeReader = this.linkEntityMap.getSrcBillTypeReader();
        for (IDataEntityProperty property : this.mainType.getProperties()) {
            if (!(property instanceof BillTypeProp)) continue;
            this.billTypeProp = (BillTypeProp)property;
            break;
        }
        this.billTypeMapParser = new BillTypeMapParser();
    }

    public CreateTargetBillDrawAction(ConvertContext context, ConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    protected void doAction() {
        super.doAction();
        this.initVar();
        SourceRowsGroup group = this.linkEntityMap.getSourceRowsGroup();
        ExtendedDataEntitySet targetExtSet = new ExtendedDataEntitySet();
        int dataEntityIndex = 0;
        ArrayList<ExtendedDataEntity> headExtEntitys = new ArrayList<ExtendedDataEntity>();
        this.modelProxy.beginInit();
        if (group.getChildGroupList().size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u6e90\u5355\u4e0d\u6ee1\u8db3\u5355\u636e\u8f6c\u6362\u89c4\u5219\u4e2d\u7684\u5206\u5355\u7b56\u7565\uff0c\u4e0d\u80fd\u5408\u5e76\u751f\u62101\u5f20\u76ee\u6807\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6e90\u5355\u3002", (String)"CreateTargetBillDrawAction_0", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
        }
        SourceRowsGroup srcBillGroup = group.getChildGroupList().get(0);
        SourceRowsGroupKey srcBillGroupKey = srcBillGroup.getGroupKey();
        DynamicObject headObj = ((DrawArgs)this.context.getInputArgs()).getTargetDataEntity((objs, dt) -> BusinessDataReader.loadRefence((Object[])objs, (IDataEntityType)dt));
        this.coverEntryRows(headObj);
        this.modelProxy.draw(headObj);
        this.modelProxy.forceClearNoDataRow();
        this.checkMainOrg(srcBillGroup.getSourceRows());
        this.checkBillType(srcBillGroup.getSourceRows());
        ExtendedDataEntity headExtEntity = new ExtendedDataEntity(headObj, dataEntityIndex, 0);
        headExtEntity.setValue("ConvertSource", srcBillGroup.getSourceRows());
        headExtEntity.setValue("isNewEntity", (Object)Boolean.FALSE);
        headExtEntity.setValue("SourceRowsGroupKey", (Object)srcBillGroupKey);
        headExtEntitys.add(headExtEntity);
        this.modelProxy.endInit();
        targetExtSet.AddExtendedDataEntities(this.mainType.getName(), headExtEntitys);
        this.setTargetExtendedDataEntities(targetExtSet);
    }

    private void checkMainOrg(List<DynamicObject> sourceRows) {
        Map calcOrgs;
        if (this.mainOrgProp == null) {
            return;
        }
        if (this.mappingMainOrg == null) {
            return;
        }
        DynamicObject org = (DynamicObject)this.modelProxy.getValue(this.mainOrgProp.getName());
        if (org == null) {
            return;
        }
        this.context.getOption().setVariableValue("botp_firstrelationorgid", String.valueOf(org.getPkValue()));
        Long calcOrgId = (Long)this.mappingMainOrg.calcMapValue(this.linkEntityMap.getSrcFldPropertys(), sourceRows);
        if (calcOrgId != null && Long.compare(0L, calcOrgId) != 0 && Long.compare(calcOrgId, (Long)org.getPkValue()) != 0 && !(calcOrgs = BusinessDataReader.loadFromCache((Object[])new Object[]{calcOrgId}, (DynamicObjectType)this.mainOrgProp.getDynamicComplexPropertyType())).isEmpty()) {
            String currOrgName = org.get("name") != null ? org.get("name").toString() : org.getString("number");
            String errMsg = String.format(ResManager.loadKDString((String)"\u6240\u9009\u6e90\u5355\u4e0d\u5141\u8bb8\u751f\u6210\u3010%s\u3011\u7684\u5355\u636e", (String)"CreateTargetBillDrawAction_1", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), currOrgName);
            throw new KDBizException(errMsg);
        }
    }

    private void checkBillType(List<DynamicObject> sourceRows) {
        Long billTypeId;
        String currTypeName;
        if (this.billTypeProp == null) {
            return;
        }
        DynamicObject billTypeObj = (DynamicObject)this.modelProxy.getValue(this.billTypeProp.getName());
        if (billTypeObj == null) {
            Long billTypeId2;
            Map<Object, DynamicObject> targetBillTypeObjs;
            if (this.mappingBillType != null && !(targetBillTypeObjs = this.loadBillTypeObjs()).containsKey(billTypeId2 = (Long)this.mappingBillType.calcMapValue(this.linkEntityMap.getSrcFldPropertys(), sourceRows))) {
                String failMessage = String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f\u7b97\u51fa\u7684\u5355\u636e\u7c7b\u578bId\u3010%s\u3011\u65e0\u6548", (String)"CreateTargetBillDrawAction_7", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), billTypeId2.toString());
                Object[] objs = BusinessDataReader.load((Object[])new Object[]{billTypeId2}, (IDataEntityType)this.billTypeProp.getDynamicComplexPropertyType());
                if (objs != null && objs.length > 0) {
                    DynamicObject obj = (DynamicObject)objs[0];
                    failMessage = String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f\u7b97\u51fa\u7684\u5355\u636e\u7c7b\u578b\u3010%s\u3011\uff0c\u4e0d\u5c5e\u4e8e\u76ee\u6807\u5355\uff0c\u4e0d\u80fd\u7ed9\u5b57\u6bb5\u8d4b\u503c", (String)"CreateTargetBillDrawAction_8", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), obj.get("name").toString());
                }
                throw new KDBizException(failMessage);
            }
            return;
        }
        String string = currTypeName = billTypeObj.get("name") != null ? billTypeObj.get("name").toString() : billTypeObj.getString("number");
        if (this.mappingBillType != null && (billTypeId = (Long)this.mappingBillType.calcMapValue(this.linkEntityMap.getSrcFldPropertys(), sourceRows)) != null && Long.compare(billTypeId, 0L) != 0 && Long.compare(billTypeId, (Long)billTypeObj.getPkValue()) != 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6240\u9009\u6e90\u5355\uff0c\u6839\u636e\u5b57\u6bb5\u503c\u8ba1\u7b97\u516c\u5f0f\uff0c\u4e0d\u80fd\u751f\u6210\u3010%s\u3011\u7684\u5355\u636e", (String)"CreateTargetBillDrawAction_2", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), currTypeName));
        }
        Long srcBillTypeId = (Long)this.srcBillTypeReader.getValue(this.linkEntityMap.getSrcFldPropertys(), sourceRows.get(0));
        this.billTypeMapParser.tryGetSourceBillTypeIds(this.ruleContext.getRule().getBillTypeMapPolicy(), billTypeObj);
        if (this.billTypeMapParser.isCannotDrawAnyOne()) {
            String failMessage = String.format(ResManager.loadKDString((String)"\u53d7\u5355\u636e\u7c7b\u578b\u6620\u5c04\u7b56\u7565\u9650\u5236\uff0c\u3010%1$s\u3011\u4e0d\u5141\u8bb8\u9009\u62e9\u6e90\u5355\u3010%2$s\u3011", (String)"CreateTargetBillDrawAction_6", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), currTypeName, this.getContext().getSourceMainType().getDisplayName().toString());
            throw new KDBizException(failMessage);
        }
        if (this.billTypeMapParser.getOutCannotDrawBillTypeIds().contains(srcBillTypeId)) {
            String failMessage = String.format(ResManager.loadKDString((String)"\u53d7\u5355\u636e\u7c7b\u578b\u6620\u5c04\u7b56\u7565\u9650\u5236\uff0c\u6240\u9009\u6e90\u5355\u7c7b\u578b\u7981\u6b62\u8f6c\u6362\u5230\u3010%s\u3011", (String)"CreateTargetBillDrawAction_4", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), currTypeName);
            throw new KDBizException(failMessage);
        }
        if (!this.billTypeMapParser.isCanDrawAll() && !this.billTypeMapParser.getOutBillTypeIds().contains(srcBillTypeId)) {
            String failMessage = ResManager.loadKDString((String)"\u53d7\u5355\u636e\u7c7b\u578b\u6620\u5c04\u7b56\u7565\u9650\u5236\uff0c\u6240\u9009\u6e90\u5355\u7c7b\u578b\u4e0d\u5728\u5141\u8bb8\u751f\u6210\u3010%s\u3011\u7684\u8303\u56f4\u5185", (String)"CreateTargetBillDrawAction_5", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]);
            throw new KDBizException(failMessage);
        }
    }

    private void coverEntryRows(DynamicObject headObj) {
        for (String entryKey : ((DrawArgs)this.getContext().getInputArgs()).getClearEntrys()) {
            IDataEntityProperty prop = (IDataEntityProperty)headObj.getDataEntityType().getProperties().get((Object)entryKey);
            if (!(prop instanceof EntryProp)) continue;
            DynamicObjectCollection rows = (DynamicObjectCollection)prop.getValue((Object)headObj);
            rows.clear();
        }
    }

    private Map<Object, DynamicObject> loadBillTypeObjs() {
        QFilter[] filters = new QFilter[]{new QFilter("billformid", "=", (Object)this.mainType.getName())};
        return BusinessDataServiceHelper.loadFromCache((String)"bos_billtype", (String)"id, number, name, status, enable, isdefault", (QFilter[])filters);
    }
}

