/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.actions;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.botp.FieldConvertType;
import kd.bos.entity.botp.FieldMapItem;
import kd.bos.entity.botp.LinkRecordType;
import kd.bos.entity.botp.plugin.args.AfterCreateLinkEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeCreateLinkEventArgs;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.ConvertResultManager;
import kd.bos.service.botp.convert.actions.AbstractConvertAction;
import kd.bos.service.botp.convert.batchrequest.BatchRequestManager;
import kd.bos.service.botp.convert.batchrequest.BatchUnitConvert;
import kd.bos.service.botp.convert.compiler.ConvertRuleCompiler;
import kd.bos.service.botp.convert.compiler.LinkEntityMap;
import kd.bos.service.botp.convert.getvaluemode.IGetValueMode;
import kd.bos.service.botp.convert.mapping.MappingCtrlField;
import kd.bos.service.botp.convert.mapping.MappingSBillId;
import kd.bos.service.botp.convert.mapping.MappingSId;
import kd.bos.service.botp.convert.mapping.MappingSTableId;
import kd.bos.service.botp.convert.report.PushReport;

public class FillLinkInfoAction
extends AbstractConvertAction {
    private LinkEntityMap linkEntityMap;
    private LinkEntryProp linkEntryProp;
    private LinkEntryType linkEntryType;
    private MappingSTableId mappingSTableId;
    private MappingSBillId mappingSBillId;
    private MappingSId mappingSId;
    private Map<String, DynamicProperty> fldProperties;
    private Map<String, DynamicProperty> ctrlFieldProps = new HashMap<String, DynamicProperty>();
    private ExtendedDataEntitySet targetDataEntitySet;
    private IGetValueMode sIdGetHandler;
    private BatchRequestManager batchRequestManager;
    private static final Log log = LogFactory.getLog(FillLinkInfoAction.class);
    private static final String BOS_MSERVICE_BOTP = "bos-mservice-botp";

    public FillLinkInfoAction(ConvertContext context, ConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    protected void doAction() {
        super.doAction();
        ExtendedDataEntitySet targetDataEntitys = this.getTargetExtendedDataEntities();
        BeforeCreateLinkEventArgs beforeEventArgs = new BeforeCreateLinkEventArgs(targetDataEntitys, this.ruleContext.getRuleCompiler().getLinkEntityMap().getSrcFldPropertys());
        this.ruleContext.getPlugInProxy().fireBeforeCreateLink(beforeEventArgs);
        if (beforeEventArgs.isCancel()) {
            return;
        }
        if (this.ruleContext.getRule().getLinkEntityPolicy().getLinkRecordType() == LinkRecordType.OnlyCopy) {
            return;
        }
        if (this.ruleContext.getRuleCompiler().getLinkEntityMap().getLinkEntryProp() == null) {
            return;
        }
        this.initVars();
        BatchUnitConvert batchRequests = new BatchUnitConvert(this.getContext().getTargetMainType());
        this.batchRequestManager = new BatchRequestManager();
        this.batchRequestManager.setBatchUnitConvert(batchRequests);
        this.createLinkEntity();
        batchRequests.batchDo();
        AfterCreateLinkEventArgs afterEventArgs = new AfterCreateLinkEventArgs(this.getTargetExtendedDataEntities(), this.ruleContext.getRuleCompiler().getLinkEntityMap().getSrcFldPropertys());
        this.ruleContext.getPlugInProxy().fireAfterCreateLink(afterEventArgs);
    }

    private void initVars() {
        BillEntityType tgtMainType = this.context.getTargetMainType();
        ConvertRuleCompiler ruleCompiler = this.ruleContext.getRuleCompiler();
        this.linkEntityMap = ruleCompiler.getLinkEntityMap();
        this.linkEntryProp = this.linkEntityMap.getLinkEntryProp();
        this.linkEntryType = (LinkEntryType)this.linkEntryProp.getItemType();
        this.fldProperties = this.linkEntityMap.getSrcFldPropertys();
        this.targetDataEntitySet = this.getTargetExtendedDataEntities();
        this.mappingSTableId = this.linkEntityMap.getMappingSTableId();
        this.mappingSBillId = this.linkEntityMap.getMappingSBillId();
        this.mappingSId = this.linkEntityMap.getMappingSId();
        this.sIdGetHandler = this.mappingSId.getUnionMode().getValueMode();
        for (MappingCtrlField mappingCtrlField : this.linkEntityMap.getMappingCtrlFields()) {
            DynamicProperty property = (DynamicProperty)tgtMainType.findProperty(mappingCtrlField.getCtrlFieldKey());
            if (property == null) continue;
            this.ctrlFieldProps.put(mappingCtrlField.getCtrlFieldKey(), property);
        }
    }

    private void createLinkEntity() {
        ExtendedDataEntity[] targetEntityRows = this.targetDataEntitySet.FindByEntityKey(this.linkEntityMap.getTargetLinkEntityKey());
        if (targetEntityRows == null || targetEntityRows.length == 0) {
            return;
        }
        for (ExtendedDataEntity targetEntityRow : targetEntityRows) {
            this.createLinkEntityRow(targetEntityRow);
        }
    }

    private void createLinkEntityRow(ExtendedDataEntity targetEntityRow) {
        List sourceRows = (List)targetEntityRow.getValue("ConvertSource");
        if (sourceRows == null) {
            return;
        }
        DynamicObjectCollection linkRows = targetEntityRow.getDataEntity().getDynamicObjectCollection((IDataEntityProperty)this.linkEntryProp);
        linkRows.clear();
        HashMap<String, BigDecimal> dctCtrlFldSumValues = new HashMap<String, BigDecimal>();
        HashSet<Object> sIds = new HashSet<Object>(sourceRows.size());
        for (DynamicObject dynamicObject : sourceRows) {
            Object sId = this.sIdGetHandler.getValue(this.fldProperties, dynamicObject);
            if (sIds.contains(sId)) continue;
            sIds.add(sId);
            DynamicObject linkRow = new DynamicObject((DynamicObjectType)this.linkEntryType);
            linkRows.add((Object)linkRow);
            linkRow.set("seq", (Object)linkRows.size());
            this.fillLinkEntryRowObject(dynamicObject, linkRow, dctCtrlFldSumValues);
            PushReport.createLinkReportAutoSave(this.context, this.resultManager, this.ruleContext, dynamicObject, linkRow, targetEntityRow);
        }
        for (Map.Entry entry : dctCtrlFldSumValues.entrySet()) {
            DynamicProperty ctrlFldProp = this.ctrlFieldProps.get(entry.getKey());
            BigDecimal value = (BigDecimal)entry.getValue();
            ctrlFldProp.setValue((Object)targetEntityRow.getDataEntity(), (Object)value);
        }
    }

    private void fillLinkEntryRowObject(DynamicObject sourceRow, DynamicObject linkRow, Map<String, BigDecimal> dctCtrlFldSumValues) {
        ArrayList<DynamicObject> sourceRows = new ArrayList<DynamicObject>();
        sourceRows.add(sourceRow);
        this.mappingSTableId.calcAndMappingValue(this.fldProperties, sourceRows, linkRow, this.batchRequestManager);
        this.mappingSBillId.calcAndMappingValue(this.fldProperties, sourceRows, linkRow, this.batchRequestManager);
        this.mappingSId.calcAndMappingValue(this.fldProperties, sourceRows, linkRow, this.batchRequestManager);
        for (MappingCtrlField mappingCtrlField : this.linkEntityMap.getMappingCtrlFields()) {
            FieldMapItem fieldMap = mappingCtrlField.getFieldMap();
            if (fieldMap != null) {
                String sourceFieldKey = fieldMap.getSourceFieldKey();
                FieldConvertType fieldConvertType = fieldMap.getFieldConvertType();
                if (FieldConvertType.SourceField == fieldConvertType && StringUtils.isNotBlank((CharSequence)sourceFieldKey) && !this.fldProperties.containsKey(sourceFieldKey)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u53cd\u5199\u5b57\u6bb5\u7684\u6620\u5c04\u6e90\u5355\u5b57\u6bb5\u4e0d\u5c5e\u4e8e\u5173\u8054\u5b9e\u4f53\u3002", (String)"FillLinkInfoAction_4", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]));
                }
            }
            mappingCtrlField.calcAndMappingValue(this.fldProperties, sourceRows, linkRow, this.batchRequestManager);
            Object calcValue = mappingCtrlField.getOldCtrlProp().getValue((Object)linkRow);
            BigDecimal mapValue = calcValue == null ? BigDecimal.ZERO : new BigDecimal(calcValue.toString());
            String ctrlFieldKey = mappingCtrlField.getCtrlFieldKey();
            BigDecimal decimal = dctCtrlFldSumValues.get(ctrlFieldKey);
            if (decimal != null) {
                mapValue = mapValue.add(decimal);
            }
            dctCtrlFldSumValues.put(ctrlFieldKey, mapValue);
        }
    }
}

