/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.botp.FieldConvertType;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.ConvertResultManager;
import kd.bos.service.botp.convert.actions.AbstractConvertAction;
import kd.bos.service.botp.convert.compiler.LinkEntityMap;
import kd.bos.service.botp.convert.getvaluemode.GetConstValue;
import kd.bos.service.botp.convert.getvaluemode.GetFormulaValue;
import kd.bos.service.botp.convert.getvaluemode.GetSourceFieldValue;
import kd.bos.service.botp.convert.getvaluemode.GetValueByCondition;
import kd.bos.service.botp.convert.getvaluemode.IGetValueMode;
import kd.bos.service.botp.convert.mapping.IMappingField;
import kd.bos.service.botp.convert.var.IVariableMode;
import kd.bos.service.botp.convert.var.SourceFieldVariable;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class GetTargetOptionalOrgsAction
extends AbstractConvertAction {
    private static final String FUNC_NAME_GET_RELATION_ORG = "GetRelationOrg";
    private LinkEntityMap linkEntityMap;
    private BillEntityType targetMainType = null;
    private MainOrgProp targetMainOrgProp = null;
    private IMappingField mappingMainOrg = null;
    private BillEntityType sourceMainType = null;
    private MainOrgProp sourceMainOrgProp = null;
    private HasPermOrgResult permOrgResult = null;

    public GetTargetOptionalOrgsAction(ConvertContext context, ConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    protected void doAction() {
        super.doAction();
        this.initVar();
        this.getTargetOrgs();
    }

    private void initVar() {
        this.linkEntityMap = this.ruleContext.getRuleCompiler().getLinkEntityMap();
        this.linkEntityMap.compileQFilter(this.ruleContext, this.ruleContext.getSelectedRows());
        this.targetMainType = this.context.getTargetMainType();
        this.mappingMainOrg = this.linkEntityMap.getMappingMainOrg();
        if (StringUtils.isNotBlank((CharSequence)this.targetMainType.getMainOrg())) {
            this.targetMainOrgProp = (MainOrgProp)this.targetMainType.getProperty(this.targetMainType.getMainOrg());
        }
        this.sourceMainType = this.context.getSourceMainType();
        if (StringUtils.isNotBlank((CharSequence)this.sourceMainType.getMainOrg())) {
            this.sourceMainOrgProp = (MainOrgProp)this.sourceMainType.getProperty(this.sourceMainType.getMainOrg());
        }
    }

    private void getTargetOrgs() {
        if (this.targetMainOrgProp == null) {
            this.resultManager.getOptionalOrgs().setHasMainOrg(false);
            this.resultManager.setSkipNextRule(true);
            this.getRuleResultManager().setSkipNextAction(true);
            return;
        }
        if (this.mappingMainOrg == null) {
            if (this.sourceMainOrgProp == null) {
                this.getOrgByRight();
                this.resultManager.setSkipNextRule(true);
                this.getRuleResultManager().setSkipNextAction(true);
            } else {
                this.getOrgByBizRelation((OrgProp)this.sourceMainOrgProp);
            }
        } else if (this.mappingMainOrg.getFieldMap().getFieldConvertType() == FieldConvertType.SourceField) {
            if (this.mappingMainOrg.getUnionMode().getValueMode() instanceof GetSourceFieldValue) {
                this.getOrgBySourceField((GetSourceFieldValue)this.mappingMainOrg.getUnionMode().getValueMode());
            }
        } else if (this.mappingMainOrg.getFieldMap().getFieldConvertType() == FieldConvertType.CONSTANT) {
            if (this.mappingMainOrg.getUnionMode().getValueMode() instanceof GetConstValue) {
                this.getOrgByConstant((GetConstValue)this.mappingMainOrg.getUnionMode().getValueMode());
            }
        } else if (this.mappingMainOrg.getFieldMap().getFieldConvertType() == FieldConvertType.Formula) {
            if (this.mappingMainOrg.getUnionMode().getValueMode() instanceof GetFormulaValue) {
                this.getOrgByFormula((GetFormulaValue)this.mappingMainOrg.getUnionMode().getValueMode());
            }
        } else if (this.mappingMainOrg.getFieldMap().getFieldConvertType() == FieldConvertType.ByCondition && this.mappingMainOrg.getUnionMode().getValueMode() instanceof GetValueByCondition) {
            this.getOrgByCondition((GetValueByCondition)this.mappingMainOrg.getUnionMode().getValueMode());
        }
    }

    private void getOrgByRight() {
        HasPermOrgResult hasPermOrgResult = this.loadPermOrgResult();
        if (hasPermOrgResult.hasAllOrgPerm()) {
            this.resultManager.getOptionalOrgs().setHasAllOrgPerm(true);
        }
        this.addTargetOrgs(hasPermOrgResult.getHasPermOrgs());
    }

    private void getOrgByBizRelation(OrgProp srcOrgProp) {
        HashSet<Long> relationOrgs = new HashSet<Long>();
        Set<Long> srcOrgIds = this.loadSrcOrgIds(srcOrgProp);
        boolean hasNullOrg = srcOrgIds.remove(0L);
        if (this.getRelationOrg(srcOrgProp, srcOrgIds, relationOrgs)) {
            this.addTargetOrgs(relationOrgs);
        }
        if (hasNullOrg && this.sourceMainOrgProp != null && !StringUtils.equals((CharSequence)srcOrgProp.getName(), (CharSequence)this.sourceMainOrgProp.getName())) {
            this.getOrgByBizRelation((OrgProp)this.sourceMainOrgProp);
        }
    }

    private void getOrgByBizRelationFunc(GetFormulaValue getValueModel) {
        String formula = getValueModel.getFormula();
        int funcNameIndex = formula.indexOf(FUNC_NAME_GET_RELATION_ORG);
        if (funcNameIndex < 0) {
            return;
        }
        int left = formula.indexOf("(", funcNameIndex);
        int right = formula.indexOf(")", funcNameIndex);
        if (right < left) {
            return;
        }
        String funcParams = formula.substring(left + 1, right);
        if (StringUtils.isBlank((CharSequence)funcParams)) {
            return;
        }
        String[] params = funcParams.split(",");
        if (params.length != 4) {
            return;
        }
        String orgFldKey = params[0].trim();
        OrgProp srcOrgProp = (OrgProp)this.getContext().getSourceMainType().findProperty(orgFldKey);
        if (srcOrgProp == null) {
            return;
        }
        String direction = params[1].replace("'", "").trim();
        boolean isEntrust = StringUtils.equalsIgnoreCase((CharSequence)direction, (CharSequence)"0");
        String formViewType = params[2].replace("'", "").trim();
        String toViewType = params[3].replace("'", "").trim();
        if (StringUtils.isBlank((CharSequence)toViewType)) {
            return;
        }
        HashSet<Long> relationOrgs = new HashSet<Long>();
        Set<Long> srcOrgIds = this.loadSrcOrgIds(srcOrgProp);
        boolean hasNullOrg = srcOrgIds.remove(0L);
        for (Long srcOrgId : srcOrgIds) {
            if (isEntrust) {
                relationOrgs.addAll(OrgUnitServiceHelper.getAllToOrg((String)formViewType, (String)toViewType, (Long)srcOrgId));
                continue;
            }
            relationOrgs.addAll(OrgUnitServiceHelper.getFromOrgs((String)toViewType, (Long)srcOrgId, (String)formViewType));
        }
        if (!relationOrgs.isEmpty()) {
            this.addTargetOrgs(relationOrgs);
        }
        if (hasNullOrg && this.sourceMainOrgProp != null && !StringUtils.equals((CharSequence)srcOrgProp.getName(), (CharSequence)this.sourceMainOrgProp.getName())) {
            this.getOrgByBizRelation((OrgProp)this.sourceMainOrgProp);
        }
    }

    private void getOrgBySrcOrgProp(OrgProp srcOrgProp) {
        Set<Long> srcOrgIds = this.loadSrcOrgIds(srcOrgProp);
        this.addTargetOrgs(srcOrgIds);
        if (srcOrgIds.contains(0L) && this.sourceMainOrgProp != null) {
            this.getOrgByBizRelation((OrgProp)this.sourceMainOrgProp);
        }
    }

    private void getOrgBySourceField(GetSourceFieldValue getValueModel) {
        for (IVariableMode var : getValueModel.getVars()) {
            if (!(var instanceof SourceFieldVariable)) continue;
            if (!(((SourceFieldVariable)var).getSourceField() instanceof OrgProp)) break;
            this.getOrgBySrcOrgProp((OrgProp)((SourceFieldVariable)var).getSourceField());
            break;
        }
    }

    private void getOrgByConstant(GetConstValue getValueModel) {
        if (StringUtils.isBlank((Object)getValueModel.getConstValue())) {
            return;
        }
        if (!StringUtils.isNumeric((CharSequence)getValueModel.getConstValue().toString())) {
            return;
        }
        Long orgId = Long.valueOf(getValueModel.getConstValue().toString());
        this.addTargetOrg(orgId);
    }

    private void getOrgByFormula(GetFormulaValue getValueModel) {
        if (getValueModel.getFuncs().contains(FUNC_NAME_GET_RELATION_ORG)) {
            this.getOrgByBizRelationFunc(getValueModel);
        }
    }

    private void getOrgByCondition(GetValueByCondition getValueModel) {
        for (Tuple<IGetValueMode, IGetValueMode> item : getValueModel.getValueHandlers()) {
            if (item.item2 instanceof GetConstValue) {
                this.getOrgByConstant((GetConstValue)item.item2);
                continue;
            }
            if (item.item2 instanceof GetSourceFieldValue) {
                this.getOrgBySourceField((GetSourceFieldValue)item.item2);
                continue;
            }
            if (!(item.item2 instanceof GetFormulaValue)) continue;
            this.getOrgByFormula((GetFormulaValue)item.item2);
        }
    }

    private boolean getRelationOrg(OrgProp srcOrgProp, Set<Long> srcOrgIds, Set<Long> relationOrgs) {
        if (srcOrgIds.isEmpty()) {
            return false;
        }
        if (srcOrgProp == null || StringUtils.isBlank((CharSequence)srcOrgProp.getOrgFunc()) || this.targetMainOrgProp == null || StringUtils.isBlank((CharSequence)this.targetMainOrgProp.getOrgFunc())) {
            return false;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)srcOrgProp.getOrgFunc(), (CharSequence)this.targetMainOrgProp.getOrgFunc())) {
            relationOrgs.addAll(srcOrgIds);
        } else {
            try {
                for (Long srcOrgId : srcOrgIds) {
                    List targetOrgIds = OrgUnitServiceHelper.getAllToOrg((String)srcOrgProp.getOrgFunc(), (String)this.targetMainOrgProp.getOrgFunc(), (Long)srcOrgId);
                    relationOrgs.addAll(targetOrgIds);
                }
            }
            catch (Throwable exp) {
                return false;
            }
        }
        return !relationOrgs.isEmpty();
    }

    private HasPermOrgResult loadPermOrgResult() {
        if (this.permOrgResult != null) {
            return this.permOrgResult;
        }
        boolean isBindNewPerm = PermissionServiceHelper.isBindingAddNewPermission((String)this.targetMainType.getName());
        if (isBindNewPerm) {
            long userId = Long.parseLong(RequestContext.get().getUserId());
            this.permOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)this.context.getInputArgs().getAppId(), (String)this.targetMainType.getName(), (String)"47156aff000000ac");
        } else {
            this.permOrgResult = new HasPermOrgResult(){

                public boolean hasAllOrgPerm() {
                    return true;
                }

                public List<Long> getHasPermOrgs() {
                    return new ArrayList<Long>();
                }
            };
        }
        return this.permOrgResult;
    }

    private void addTargetOrg(Long orgId) {
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.add(orgId);
        this.addTargetOrgs(orgIds);
    }

    private void addTargetOrgs(Collection<Long> orgIds) {
        HasPermOrgResult hasPermOrgResult = this.loadPermOrgResult();
        boolean isBindingPerm = !hasPermOrgResult.hasAllOrgPerm();
        HashSet authOrgIds = new HashSet(hasPermOrgResult.getHasPermOrgs());
        for (Long orgId : orgIds) {
            if (orgId == null || Long.compare(orgId, 0L) == 0 || !this.targetMainOrgProp.canBeMainOrg(orgId.longValue(), isBindingPerm, authOrgIds)) continue;
            this.resultManager.getOptionalOrgs().getOrgIds().add(orgId);
        }
    }

    private Set<Long> loadSrcOrgIds(OrgProp srcOrgProp) {
        String orgPropFullName = srcOrgProp.getName();
        if (srcOrgProp.getParent() instanceof SubEntryType) {
            orgPropFullName = srcOrgProp.getParent().getParent().getName() + "." + srcOrgProp.getParent().getName() + "." + srcOrgProp.getName();
        } else if (srcOrgProp.getParent() instanceof EntryType) {
            orgPropFullName = srcOrgProp.getParent().getName() + "." + srcOrgProp.getName();
        }
        String selectSQLString = "id," + orgPropFullName + " org";
        QFilter[] qFilters = this.linkEntityMap.getQFilters().toArray(new QFilter[this.linkEntityMap.getQFilters().size()]);
        String entityNumber = this.ruleContext.getContext().getInputArgs().getSourceEntityNumber();
        HashSet<Long> srcOrgIds = new HashSet<Long>();
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet(this.getClass().getName(), entityNumber, selectSQLString, qFilters);){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long orgId = row.getLong("org");
                if (orgId == null) {
                    srcOrgIds.add(0L);
                    continue;
                }
                srcOrgIds.add(orgId);
            }
        }
        return srcOrgIds;
    }
}

