/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.actions;

import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.botp.FieldConvertType;
import kd.bos.entity.botp.FieldMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.orm.query.QFilter;
import kd.bos.service.botp.convert.actions.BaseDataFieldFilterBuilder;
import kd.bos.service.botp.convert.actions.BooleanFieldFilterBuilder;
import kd.bos.service.botp.convert.actions.BuildDrawFilterContext;
import kd.bos.service.botp.convert.actions.FieldFilterBuilder;

interface IFieldFilterBuilder {
    public QFilter buildQFilter(IDataEntityProperty var1, Object var2);

    public static QFilter buildQFilter(BuildDrawFilterContext filterContext, FieldMapItem fieldMapItem) {
        if (fieldMapItem.getFieldConvertType() != FieldConvertType.SourceField || StringUtils.isBlank((CharSequence)fieldMapItem.getSourceFieldKey())) {
            return null;
        }
        IDataEntityProperty sourceProp = filterContext.getSourceMainType().findProperty(fieldMapItem.getSourceFieldKey());
        if (sourceProp == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)fieldMapItem.getTargetFieldKey())) {
            return null;
        }
        IDataEntityProperty targetProp = filterContext.getTargetMainType().findProperty(fieldMapItem.getTargetFieldKey());
        if (targetProp == null) {
            return null;
        }
        if (!filterContext.getTargetEntityKeys().contains(targetProp.getParent().getName())) {
            return null;
        }
        Object fieldValue = IFieldFilterBuilder.getTargetFieldValue(filterContext.getTargetExtDataSet(), targetProp);
        if (fieldValue == null) {
            return null;
        }
        IFieldFilterBuilder fieldFilterBuilder = IFieldFilterBuilder.create(targetProp);
        return fieldFilterBuilder.buildQFilter(sourceProp, fieldValue);
    }

    public static IFieldFilterBuilder create(IDataEntityProperty property) {
        if (property instanceof BasedataProp) {
            return new BaseDataFieldFilterBuilder();
        }
        if (property instanceof BooleanProp) {
            return new BooleanFieldFilterBuilder();
        }
        return new FieldFilterBuilder();
    }

    public static Object getTargetFieldValue(ExtendedDataEntitySet targetExtDataSet, IDataEntityProperty property) {
        ExtendedDataEntity[] rows = targetExtDataSet.FindByEntityKey(property.getParent().getName());
        if (rows == null || rows.length == 0) {
            return null;
        }
        return property.getValueFast((Object)rows[0].getDataEntity());
    }

    public static String buildSrcFieldFullName(IDataEntityProperty property) {
        String fullName = property.getName();
        if (property.getParent() instanceof SubEntryType) {
            SubEntryType subEntryType = (SubEntryType)property.getParent();
            fullName = subEntryType.getParent().getName() + "." + subEntryType.getName() + "." + property.getName();
        } else if (property.getParent() instanceof EntryType) {
            fullName = property.getParent().getName() + "." + property.getName();
        }
        return fullName;
    }
}

