/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.actions;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.ConvertResultManager;
import kd.bos.service.botp.convert.actions.AbstractConvertAction;
import kd.bos.service.botp.convert.actions.MappingDependFieldValue;
import kd.bos.service.botp.convert.batchrequest.BatchRequestManager;
import kd.bos.service.botp.convert.compiler.DependEntityMap;
import kd.bos.service.botp.convert.mapping.IMappingField;

public class MappingDependFieldAction
extends AbstractConvertAction {
    private static final Log log = LogFactory.getLog(MappingDependFieldAction.class);
    private BatchRequestManager batchRequestManager;

    public MappingDependFieldAction(ConvertContext context, ConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    protected void doAction() {
        super.doAction();
        ExtendedDataEntitySet targetExtDataSet = this.getTargetExtendedDataEntities();
        for (DependEntityMap entityMap : this.ruleContext.getRuleCompiler().getDependEntityMaps().values()) {
            this.createBatchRequestHandlers(entityMap);
            Map<String, DynamicProperty> srcFldPropertys = entityMap.getSrcFldPropertys();
            for (Map.Entry<EntityType, List<IMappingField>> entityItem : entityMap.getTargetFields().entrySet()) {
                EntityType entityType = entityItem.getKey();
                List<IMappingField> mappingFields = entityItem.getValue();
                ExtendedDataEntity[] targetExtDataEntitys = targetExtDataSet.FindByEntityKey(entityType.getName());
                for (IMappingField mappingField : mappingFields) {
                    MappingDependFieldValue mappingDependFieldValue = new MappingDependFieldValue(targetExtDataEntitys, mappingField, srcFldPropertys, this.batchRequestManager, this.getContext(), entityMap);
                    mappingDependFieldValue.setBatchPreCall(true).prepBillAndCalc();
                    mappingDependFieldValue.setBatchPreCall(false).prepBillAndCalc();
                }
            }
            this.doBatchRequests();
        }
    }

    private void createBatchRequestHandlers(DependEntityMap entityMap) {
        this.batchRequestManager = new BatchRequestManager();
        this.batchRequestManager.initialize(this.ruleContext, this.ruleResultManager, entityMap);
    }

    private void doBatchRequests() {
        this.batchRequestManager.batchSetBasedataValue();
        if (this.batchRequestManager.getBatchOrgSepr().isFail()) {
            this.setSkipNextAction(true);
            this.resultManager.getReporter().addBreakMessage(this.ruleContext.getRule(), ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u672a\u5206\u914d\u7ed9\u76ee\u6807\u7ec4\u7ec7", (String)"MappingDependFieldAction_1", (String)"bos-mservice-botp", (Object[])new Object[0]));
        }
        this.batchRequestManager.batchAfterSetBasedataValue();
        this.batchRequestManager.batchSetRefBillValue();
    }
}

