/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.actions;

import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.ConvertResultManager;
import kd.bos.service.botp.convert.actions.AbstractConvertAction;
import kd.bos.service.botp.convert.actions.MappingFieldValue;
import kd.bos.service.botp.convert.batchrequest.BatchRequestManager;
import kd.bos.service.botp.convert.compiler.LinkEntityMap;
import kd.bos.service.botp.convert.mapping.IMappingField;

public class MappingFieldAction
extends AbstractConvertAction {
    private static final Log log = LogFactory.getLog(MappingFieldAction.class);
    private LinkEntityMap linkEntityMap = null;
    private BatchRequestManager batchRequestManager;

    public MappingFieldAction(ConvertContext context, ConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    protected void doAction() {
        super.doAction();
        this.linkEntityMap = this.ruleContext.getRuleCompiler().getLinkEntityMap();
        Map<String, DynamicProperty> srcFldPropertys = this.linkEntityMap.getSrcFldPropertys();
        ExtendedDataEntitySet targetExtDataSet = this.getTargetExtendedDataEntities();
        this.createBatchRequestHandlers();
        for (Map.Entry<EntityType, List<IMappingField>> entityItem : this.linkEntityMap.getTargetFields().entrySet()) {
            EntityType entityType = entityItem.getKey();
            List<IMappingField> mappingFields = entityItem.getValue();
            ExtendedDataEntity[] targetExtDataEntitys = targetExtDataSet.FindByEntityKey(entityType.getName());
            for (IMappingField mappingField : mappingFields) {
                MappingFieldValue mappingFieldValue = new MappingFieldValue(targetExtDataEntitys, mappingField, srcFldPropertys, this.batchRequestManager, this.getContext(), null);
                mappingFieldValue.setBatchPreCall(true).prepBillAndCalc();
                mappingFieldValue.setBatchPreCall(false).prepBillAndCalc();
            }
        }
        this.doBatchRequest();
        AfterFieldMappingEventArgs eventArgs = new AfterFieldMappingEventArgs(targetExtDataSet, srcFldPropertys);
        this.ruleContext.getPlugInProxy().fireAfterFieldMappingr(eventArgs);
    }

    private void createBatchRequestHandlers() {
        this.batchRequestManager = new BatchRequestManager();
        this.batchRequestManager.initialize(this.ruleContext, this.ruleResultManager, this.linkEntityMap);
    }

    private void doBatchRequest() {
        this.batchRequestManager.batchSetBasedataValue();
        if (this.batchRequestManager.getBatchOrgSepr().isFail()) {
            this.setSkipNextAction(true);
            this.resultManager.getReporter().addBreakMessage(this.ruleContext.getRule(), ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u672a\u5206\u914d\u7ed9\u76ee\u6807\u7ec4\u7ec7", (String)"MappingFieldAction_0", (String)"bos-mservice-botp", (Object[])new Object[0]));
        }
        this.batchRequestManager.batchSetRefBillValue();
        if (this.batchRequestManager.getBatchRefBill().isFail()) {
            this.setSkipNextAction(true);
            this.resultManager.getReporter().addBreakMessage(this.ruleContext.getRule(), ResManager.loadKDString((String)"\u5355\u636e\u672a\u5206\u914d\u7ed9\u76ee\u6807\u7ec4\u7ec7", (String)"MappingFieldAction_2", (String)"bos-mservice-botp", (Object[])new Object[0]));
        }
        this.loadReferenceObject();
        this.batchRequestManager.batchAfterSetBasedataValue();
    }

    private void loadReferenceObject() {
        ExtendedDataEntitySet targetExtDataSet = this.getTargetExtendedDataEntities();
        ExtendedDataEntity[] headObjs = targetExtDataSet.FindByEntityKey(this.context.getInputArgs().getTargetEntityNumber());
        Object[] objs = new DynamicObject[headObjs.length];
        for (int i = 0; i < headObjs.length; ++i) {
            objs[i] = headObjs[i].getDataEntity();
        }
        BusinessDataReader.loadRefence((Object[])objs, (IDataEntityType)this.context.getTargetMainType());
    }
}

