/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.actions;

import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.botp.runtime.args.MockArgs;
import kd.bos.orm.ORM;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.ConvertResultManager;
import kd.bos.service.botp.convert.actions.AbstractConvertAction;
import kd.bos.service.botp.convert.compiler.LinkEntityMap;

public class MockSourceDataAction
extends AbstractConvertAction {
    public MockSourceDataAction(ConvertContext context, ConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    protected void doAction() {
        super.doAction();
        if (this.context.getInputArgs() instanceof MockArgs) {
            this.mockSourceData();
        }
    }

    private void mockSourceData() {
        LinkEntityMap linkEntityMap = this.ruleContext.getRuleCompiler().getLinkEntityMap();
        String entityNumber = this.ruleContext.getContext().getInputArgs().getSourceEntityNumber();
        RowMeta rowMeta = ORM.create().createRowMeta(entityNumber, linkEntityMap.getSrcSelectString());
        DynamicObjectType dynamicObjectType = this.toDynamicObjectType(rowMeta, "PlainObject");
        Map<String, DynamicProperty> fldPropertys = this.buildSourceRowPropsDictory(dynamicObjectType, linkEntityMap.getSrcFldAlias());
        ((MockArgs)this.context.getInputArgs()).getSourceDataFunc().accept(dynamicObjectType, fldPropertys);
    }

    private DynamicObjectType toDynamicObjectType(RowMeta rowMeta, String entityName) {
        DynamicObjectType dt = new DynamicObjectType(entityName);
        int fieldCount = rowMeta.getFieldCount();
        for (int i = 0; i < fieldCount; ++i) {
            Field field = rowMeta.getField(i);
            String fieldName = field.getAlias();
            if (fieldName.isEmpty() || dt.getProperties().containsKey((Object)fieldName)) {
                fieldName = "Property" + i;
            }
            Class propertyType = field.getDataType().getJavaType();
            DynamicSimpleProperty property = new DynamicSimpleProperty(fieldName, propertyType, null);
            property.setEnableNull(field.isNullable());
            dt.registerSimpleProperty(property);
        }
        return dt;
    }

    private Map<String, DynamicProperty> buildSourceRowPropsDictory(DynamicObjectType dType, Map<String, String> fldAlias) {
        HashMap<String, DynamicProperty> fldPropertys = new HashMap<String, DynamicProperty>(fldAlias.size());
        for (Map.Entry<String, String> fldAliasItem : fldAlias.entrySet()) {
            String var = fldAliasItem.getKey();
            String alias = fldAliasItem.getValue();
            DynamicProperty property = dType.getProperty(alias);
            fldPropertys.put(var, property);
        }
        return fldPropertys;
    }
}

