/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.ConvertResultManager;
import kd.bos.service.botp.convert.actions.AbstractConvertAction;
import kd.bos.service.botp.convert.compiler.LinkEntityMap;
import kd.bos.service.botp.convert.sort.ISortKeyBuilder;
import kd.bos.service.botp.convert.sort.ListSelectedRowComparator;
import kd.bos.service.botp.convert.sort.SourceRowComparator;
import kd.bos.service.botp.convert.sort.SourceRowSortKey;

public class SortSourceRowsAction
extends AbstractConvertAction {
    public SortSourceRowsAction(ConvertContext context, ConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    protected void doAction() {
        super.doAction();
        LinkEntityMap linkEntityMap = this.ruleContext.getRuleCompiler().getLinkEntityMap();
        if (linkEntityMap.getSourceRows().size() <= 1) {
            return;
        }
        if (linkEntityMap.getSourceRows().size() > 10000) {
            return;
        }
        ISortKeyBuilder sortKeyBuilder = ISortKeyBuilder.create(this.ruleContext, linkEntityMap, this.ruleContext.getSelectedRows().get(0));
        SourceRowComparator sortByRowIndex = new SourceRowComparator(this.ruleContext, linkEntityMap);
        List<ListSelectedRow> sortListSelectedRows = this.sortListSelectedRows();
        List<SourceRowSortKey> sortKeys = this.buildSortKeys(sortListSelectedRows, sortKeyBuilder);
        Map<SourceRowSortKey, List<DynamicObject>> mapSourceRows = this.buildSourceRowsMap(linkEntityMap.getSrcFldPropertys(), linkEntityMap.getSourceRows(), sortKeyBuilder);
        ArrayList<DynamicObject> sortSourceRows = new ArrayList<DynamicObject>();
        for (SourceRowSortKey sourceRowSortKey : sortKeys) {
            List<DynamicObject> list = mapSourceRows.get(sourceRowSortKey);
            if (list == null) continue;
            list.sort(sortByRowIndex);
            sortSourceRows.addAll(list);
            mapSourceRows.remove(sourceRowSortKey);
        }
        for (Map.Entry entry : mapSourceRows.entrySet()) {
            sortSourceRows.addAll((Collection)entry.getValue());
        }
        linkEntityMap.getSourceRows().clear();
        linkEntityMap.getSourceRows().addAll(sortSourceRows);
    }

    private List<ListSelectedRow> sortListSelectedRows() {
        ArrayList<ListSelectedRow> sortRows = new ArrayList<ListSelectedRow>(this.ruleContext.getSelectedRows().size());
        sortRows.addAll(this.ruleContext.getSelectedRows());
        ListSelectedRowComparator comparator = new ListSelectedRowComparator();
        sortRows.sort(comparator);
        return sortRows;
    }

    private List<SourceRowSortKey> buildSortKeys(List<ListSelectedRow> selectedRows, ISortKeyBuilder sortKeyBuilder) {
        ArrayList<SourceRowSortKey> sortKeys = new ArrayList<SourceRowSortKey>(selectedRows.size());
        for (ListSelectedRow selectedRow : selectedRows) {
            SourceRowSortKey sortKey = sortKeyBuilder.buildSortKey(selectedRow);
            sortKeys.add(sortKey);
        }
        return sortKeys;
    }

    private Map<SourceRowSortKey, List<DynamicObject>> buildSourceRowsMap(Map<String, DynamicProperty> fldProperties, List<DynamicObject> sourceRows, ISortKeyBuilder sortKeyBuilder) {
        LinkedHashMap<SourceRowSortKey, List<DynamicObject>> mapSourceRows = new LinkedHashMap<SourceRowSortKey, List<DynamicObject>>();
        for (DynamicObject sourceRow : sourceRows) {
            SourceRowSortKey sortKey = sortKeyBuilder.buildSortKey(fldProperties, sourceRow);
            if (!mapSourceRows.containsKey(sortKey)) {
                mapSourceRows.put(sortKey, new ArrayList());
            }
            ((List)mapSourceRows.get(sortKey)).add(sourceRow);
        }
        return mapSourceRows;
    }
}

