/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.batchrequest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.service.botp.convert.SingleRuleContext;
import kd.bos.service.botp.convert.batchrequest.MulBasedataFieldSetValueRequest;

public class BatchMulBasedataFieldSetValue {
    private BillEntityType sourceMainType;
    private List<MulBasedataFieldSetValueRequest> requests = new ArrayList<MulBasedataFieldSetValueRequest>();

    public BatchMulBasedataFieldSetValue(SingleRuleContext ruleContext) {
        this.sourceMainType = ruleContext.getContext().getSourceMainType();
    }

    public List<MulBasedataFieldSetValueRequest> getRequests() {
        return this.requests;
    }

    public void batchDo() {
        Map<String, Map<Object, DynamicObject>> srcAllDataEntities = this.loadSourceEntityRows();
        for (MulBasedataFieldSetValueRequest request : this.requests) {
            ArrayList<Object> srcBasedataIds = new ArrayList<Object>(1);
            for (Object srcRowId : request.getSrcRowIds()) {
                DynamicObject srcRowDataEntity;
                String srcPropName = request.getSrcMulBasedataProp().getName();
                String entityName = request.getSrcMulBasedataProp().getParent().getName();
                Map<Object, DynamicObject> srcDataEntities = srcAllDataEntities.get(entityName);
                if (srcDataEntities == null || (srcRowDataEntity = srcDataEntities.get(srcRowId)) == null) continue;
                DynamicObjectCollection srcMulBasedataRows = srcRowDataEntity.getDynamicObjectCollection(srcPropName);
                for (DynamicObject srcMulBasedataRow : srcMulBasedataRows) {
                    Object srcBasedataId = srcMulBasedataRow.get("fbasedataid_id");
                    srcBasedataIds.add(srcBasedataId);
                }
            }
            request.setNewValue(srcBasedataIds);
            request.setValue();
        }
    }

    private Map<String, Map<Object, DynamicObject>> loadSourceEntityRows() {
        HashSet<String> allPropNames = new HashSet<String>(4);
        HashMap<String, HashSet<String>> srcMulBasedataPropNames = new HashMap<String, HashSet<String>>(4);
        HashMap<String, HashSet<Object>> srcRowIds = new HashMap<String, HashSet<Object>>(4);
        for (MulBasedataFieldSetValueRequest request : this.requests) {
            String entityKey = request.getSrcMulBasedataProp().getParent().getName();
            allPropNames.add(request.getSrcMulBasedataProp().getName());
            HashSet<String> propNames = (HashSet<String>)srcMulBasedataPropNames.get(entityKey);
            if (propNames == null) {
                propNames = new HashSet<String>(4);
                srcMulBasedataPropNames.put(entityKey, propNames);
            }
            propNames.add(request.getSrcMulBasedataProp().getName());
            HashSet<Object> rowIds = (HashSet<Object>)srcRowIds.get(entityKey);
            if (rowIds == null) {
                rowIds = new HashSet<Object>(this.requests.size());
                srcRowIds.put(entityKey, rowIds);
            }
            rowIds.addAll(request.getSrcRowIds());
        }
        HashMap<String, Map<Object, DynamicObject>> srcAllDataEntities = new HashMap<String, Map<Object, DynamicObject>>(4);
        BillEntityType subMainType = (BillEntityType)EntityMetadataCache.getSubDataEntityType((String)this.sourceMainType.getName(), allPropNames);
        Map<String, EntityType> localEntityTypes = this.buildSingleSubMainType(subMainType, allPropNames);
        for (Map.Entry entry : srcMulBasedataPropNames.entrySet()) {
            Object[] rowObjs;
            EntityType entityType = localEntityTypes.get(entry.getKey());
            Set rowIds = (Set)srcRowIds.get(entry.getKey());
            if (rowIds == null || entityType == null) continue;
            HashMap<Object, DynamicObject> srcRows = new HashMap<Object, DynamicObject>(rowIds.size());
            srcAllDataEntities.put((String)entry.getKey(), (Map<Object, DynamicObject>)srcRows);
            for (Object rowObj : rowObjs = BusinessDataReader.load((Object[])rowIds.toArray(), (IDataEntityType)entityType)) {
                Object rowId = ((DynamicObject)rowObj).getPkValue();
                srcRows.put(rowId, (DynamicObject)rowObj);
            }
        }
        return srcAllDataEntities;
    }

    private Map<String, EntityType> buildSingleSubMainType(BillEntityType subMainType, Set<String> allPropNames) {
        BillEntityType localSubMainType = null;
        try {
            localSubMainType = (BillEntityType)subMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("", exp.getMessage()), new Object[0]);
        }
        HashMap<String, EntityType> entityTypes = new HashMap<String, EntityType>(4);
        for (EntityType entityType : localSubMainType.getAllEntities().values()) {
            HashSet<String> propNames = new HashSet<String>(entityType.getProperties().size());
            ArrayList<IDataEntityProperty> subEntryProps = new ArrayList<IDataEntityProperty>(1);
            for (IDataEntityProperty prop : entityType.getProperties()) {
                if (prop instanceof EntryProp) {
                    subEntryProps.add(prop);
                    continue;
                }
                if (!allPropNames.contains(prop.getName())) continue;
                propNames.add(prop.getName());
            }
            if (propNames.isEmpty()) continue;
            if (!subEntryProps.isEmpty()) {
                EntityType subEntityType = entityType.getSubEntityType(propNames);
                entityTypes.put(entityType.getName(), subEntityType);
                continue;
            }
            entityTypes.put(entityType.getName(), entityType);
        }
        return entityTypes;
    }
}

