/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.batchrequest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.FieldConvertType;
import kd.bos.entity.botp.FieldMapItem;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.botp.convert.ConvertReportManager;
import kd.bos.service.botp.convert.SingleRuleContext;
import kd.bos.service.botp.convert.SingleRuleResultManager;
import kd.bos.service.botp.convert.batchrequest.BatchOrgSeprFieldSetValue;
import kd.bos.service.botp.convert.batchrequest.RefBillFieldGroupKey;
import kd.bos.service.botp.convert.batchrequest.RefBillFieldSetValueRequest;
import kd.bos.service.botp.convert.compiler.AbstractEntityMap;
import kd.bos.service.botp.convert.compiler.LinkEntityMap;
import kd.bos.service.botp.convert.getvaluemode.IGetValueMode;
import kd.bos.service.botp.convert.report.IBuildDetailReport;

public class BatchRefBillFieldSetValue {
    private static final Log log = LogFactory.getLog(BatchOrgSeprFieldSetValue.class);
    private static final String BOS_MSERVICE_OPERATION = "bos-mservice-botp";
    private SingleRuleContext ruleContext;
    private SingleRuleResultManager ruleResultManager;
    private ConvertReportManager reportManager;
    private IBuildDetailReport buildReporter;
    private boolean fail = false;
    private AbstractEntityMap linkEntityMap;
    private BillEntityType sourceMainType;
    private BillEntityType targetMainType;
    private List<RefBillFieldSetValueRequest> requests = new ArrayList<RefBillFieldSetValueRequest>();

    public BatchRefBillFieldSetValue(SingleRuleContext ruleContext, SingleRuleResultManager ruleResultManager, AbstractEntityMap linkEntityMap) {
        this.ruleContext = ruleContext;
        this.ruleResultManager = ruleResultManager;
        this.reportManager = ruleResultManager.getConvertResultManager().getReporter();
        this.linkEntityMap = linkEntityMap;
        this.sourceMainType = ruleContext.getContext().getSourceMainType();
        this.targetMainType = ruleContext.getContext().getTargetMainType();
        BillEntityType linkEntity = this.sourceMainType;
        if (linkEntityMap instanceof LinkEntityMap) {
            linkEntity = (EntityType)this.ruleContext.getContext().getSourceMainType().getAllEntities().get(((LinkEntityMap)linkEntityMap).getSourceLinkEntityKey());
        } else {
            if (StringUtils.isNotBlank((CharSequence)linkEntityMap.getSourceEntryKey())) {
                linkEntity = (EntityType)this.sourceMainType.getAllEntities().get(linkEntityMap.getSourceEntryKey());
            }
            if (StringUtils.isNotBlank((CharSequence)linkEntityMap.getSourceSubEntryKey())) {
                linkEntity = (EntityType)this.sourceMainType.getAllEntities().get(linkEntityMap.getSourceSubEntryKey());
            }
        }
        this.buildReporter = this.ruleContext.getSrcRowReportBuilder((EntityType)linkEntity);
        this.fail = false;
    }

    public BillEntityType getSourceMainType() {
        return this.sourceMainType;
    }

    public BillEntityType getTargetMainType() {
        return this.targetMainType;
    }

    public List<RefBillFieldSetValueRequest> getRequests() {
        return this.requests;
    }

    public boolean isFail() {
        return this.fail;
    }

    public void batchDo() {
        HashMap fields = new HashMap();
        for (RefBillFieldSetValueRequest refBillFieldSetValueRequest : this.requests) {
            BillEntityType refBDType;
            RefBillProp field = refBillFieldSetValueRequest.getTargetFieldProp();
            RefBillFieldGroupKey groupKey = new RefBillFieldGroupKey(field, refBDType = (BillEntityType)field.getComplexType((Object)refBillFieldSetValueRequest.getActiveRow()));
            if (!fields.containsKey(groupKey)) {
                if (refBillFieldSetValueRequest.getFieldMapItem().getFieldConvertType() == FieldConvertType.SourceField) {
                    IDataEntityProperty sourceFieldProp = this.sourceMainType.findProperty(refBillFieldSetValueRequest.getFieldMapItem().getSourceFieldKey());
                    groupKey.setSourceFieldProp(sourceFieldProp);
                }
                fields.put(groupKey, new ArrayList());
            }
            ((List)fields.get(groupKey)).add(refBillFieldSetValueRequest);
        }
        for (Map.Entry entry : fields.entrySet()) {
            this.setFieldValue((RefBillFieldGroupKey)entry.getKey(), (List)entry.getValue());
        }
    }

    private void setFieldValue(RefBillFieldGroupKey fldGroupKey, List<RefBillFieldSetValueRequest> fldRequests) {
        RefBillProp targetFieldProp = fldGroupKey.getTargetFieldProp();
        String useOrgPropName = this.getUseOrgFieldKey(targetFieldProp);
        if (StringUtils.isBlank((CharSequence)useOrgPropName)) {
            this.setSrcFieldValue(fldRequests);
            return;
        }
        List<RefBillFieldSetValueRequest> changeOrgRequests = this.findOrgChangedRequests(fldGroupKey, fldRequests, useOrgPropName);
        if (changeOrgRequests.isEmpty()) {
            return;
        }
        FieldMapItem fieldMapItem = changeOrgRequests.get(0).getFieldMapItem();
        Map<Long, List<RefBillFieldSetValueRequest>> dctByUseOrg = this.groupByOrg(targetFieldProp, useOrgPropName, changeOrgRequests);
        for (Map.Entry<Long, List<RefBillFieldSetValueRequest>> entry : dctByUseOrg.entrySet()) {
            Long useOrgId = entry.getKey();
            if (Long.compare(useOrgId, 0L) == 0) {
                this.setSrcFieldValue(entry.getValue());
                continue;
            }
            ArrayList<RefBillFieldSetValueRequest> orgRequests = new ArrayList<RefBillFieldSetValueRequest>(entry.getValue().size());
            for (RefBillFieldSetValueRequest request : entry.getValue()) {
                orgRequests.add(request);
            }
            for (RefBillFieldSetValueRequest request : orgRequests) {
                Object obj = request.getSourceRefId();
                if (obj != null) {
                    request.setTargetRefId(obj);
                    request.setValue();
                    continue;
                }
                this.addErrorMessage(fldGroupKey, useOrgPropName, useOrgId, request);
            }
        }
    }

    private List<RefBillFieldSetValueRequest> findOrgChangedRequests(RefBillFieldGroupKey fldGroupKey, List<RefBillFieldSetValueRequest> fldRequests, String useOrgFld) {
        ArrayList<RefBillFieldSetValueRequest> changeOrgRequests = new ArrayList<RefBillFieldSetValueRequest>(fldRequests);
        FieldMapItem fieldMapItem = fldRequests.get(0).getFieldMapItem();
        IGetValueMode srcOrg_GetHandler = ((RefBillFieldSetValueRequest)changeOrgRequests.get(0)).getSrcOrg_GetHandler();
        if (srcOrg_GetHandler == null) {
            return changeOrgRequests;
        }
        BillEntityType refBillType = this.getSrcFldRefType(fieldMapItem, fldGroupKey.getTargetFieldRefType());
        if (!StringUtils.equals((CharSequence)refBillType.getName(), (CharSequence)fldGroupKey.getTargetFieldRefType().getName())) {
            return changeOrgRequests;
        }
        RowDataModel rowDataModel = new RowDataModel(fldGroupKey.getTargetFieldProp().getParent().getName(), (MainEntityType)this.targetMainType);
        String useOrgFld_Id = useOrgFld + "_id";
        for (RefBillFieldSetValueRequest fldRequest : fldRequests) {
            Long srcOrgId = (Long)srcOrg_GetHandler.getValue(this.linkEntityMap.getSrcFldPropertys(), fldRequest.getSourceRows().get(0));
            if (srcOrgId == null) {
                srcOrgId = 0L;
            }
            rowDataModel.setRowContext(fldRequest.getActiveRow());
            Long targetOrgId = (Long)rowDataModel.getValue(useOrgFld_Id);
            if (targetOrgId == null) {
                targetOrgId = 0L;
            }
            if (Long.compare(srcOrgId, targetOrgId) != 0) continue;
            fldRequest.setTargetRefId(fldRequest.getSourceRefId());
            fldRequest.setValue();
            changeOrgRequests.remove(fldRequest);
        }
        return changeOrgRequests;
    }

    private BillEntityType getSrcFldRefType(FieldMapItem fieldMapItem, BillEntityType targetFldRefType) {
        BillEntityType refBDType = null;
        switch (fieldMapItem.getFieldConvertType()) {
            case CONSTANT: 
            case Formula: 
            case ByCondition: {
                refBDType = targetFldRefType;
                break;
            }
            default: {
                BillEntityType srcRefType;
                IDataEntityProperty srcFieldProp = this.sourceMainType.findProperty(fieldMapItem.getSourceFieldKey());
                refBDType = srcRefType = (BillEntityType)((RefBillProp)srcFieldProp).getComplexType();
            }
        }
        return refBDType;
    }

    private Map<Long, List<RefBillFieldSetValueRequest>> groupByOrg(RefBillProp targetFieldProp, String useOrgPropName, List<RefBillFieldSetValueRequest> requests) {
        HashMap<Long, List<RefBillFieldSetValueRequest>> dctByUseOrg = new HashMap<Long, List<RefBillFieldSetValueRequest>>();
        RowDataModel rowDataModel = new RowDataModel(targetFieldProp.getParent().getName(), (MainEntityType)this.targetMainType);
        for (RefBillFieldSetValueRequest request : requests) {
            rowDataModel.setRowContext(request.getActiveRow());
            DynamicObject useOrg = (DynamicObject)rowDataModel.getValue(useOrgPropName);
            Long useOrgId = 0L;
            if (useOrg != null) {
                useOrgId = (Long)useOrg.getPkValue();
            }
            if (!dctByUseOrg.containsKey(useOrgId)) {
                dctByUseOrg.put(useOrgId, new ArrayList());
            }
            ((List)dctByUseOrg.get(useOrgId)).add(request);
        }
        return dctByUseOrg;
    }

    private void setSrcFieldValue(List<RefBillFieldSetValueRequest> requests) {
        for (RefBillFieldSetValueRequest request : requests) {
            request.setTargetRefId(request.getSourceRefId());
            request.setValue();
        }
    }

    private String getUseOrgFieldKey(RefBillProp targetFieldProp) {
        if (StringUtils.isNotBlank((CharSequence)targetFieldProp.getOrgProp())) {
            return targetFieldProp.getOrgProp();
        }
        if (StringUtils.isNotBlank((CharSequence)this.targetMainType.getMainOrg())) {
            return this.targetMainType.getMainOrg();
        }
        return null;
    }

    private String getBDDisplayValue(BasedataProp bdProp, Object id) {
        if (id == null) {
            return null;
        }
        DynamicObjectType bdType = bdProp.getDynamicComplexPropertyType();
        Map objs = BusinessDataReader.loadFromCache((Object[])new Object[]{id}, (DynamicObjectType)bdType);
        if (objs.isEmpty() || !objs.containsKey(id)) {
            return String.valueOf(id);
        }
        return bdProp.getDisplayValue(objs.get(id));
    }

    private String getBillDisplayValue(RefBillProp refBillProp, Object id) {
        if (id == null) {
            return null;
        }
        DynamicObjectType bdType = refBillProp.getDynamicComplexPropertyType();
        Map objs = BusinessDataReader.loadFromCache((Object[])new Object[]{id}, (DynamicObjectType)bdType);
        if (objs.isEmpty() || !objs.containsKey(id)) {
            return String.valueOf(id);
        }
        return refBillProp.getDisplayValue(objs.get(id));
    }

    private void addErrorMessage(RefBillFieldGroupKey fldGroupKey, String useOrgPropName, Long useOrgId, RefBillFieldSetValueRequest request) {
        String bdDisplayValue = this.getBillDisplayValue(request.getTargetFieldProp(), request.getSourceRefId());
        OrgProp useOrgProp = (OrgProp)this.targetMainType.findProperty(useOrgPropName);
        String orgDisplayValue = this.getBDDisplayValue((BasedataProp)useOrgProp, useOrgId);
        String failMessage = null;
        BillEntityType srcFldRefType = this.getSrcFldRefType(request.getFieldMapItem(), fldGroupKey.getTargetFieldRefType());
        failMessage = srcFldRefType != null && !StringUtils.equals((CharSequence)srcFldRefType.getName(), (CharSequence)fldGroupKey.getTargetFieldRefType().getName()) ? String.format(ResManager.loadKDString((String)"\u8bf7\u4fee\u6539\u201c%1$s\u201d\u5b57\u6bb5\u7684\u53d6\u503c\u6620\u5c04\uff0c%2$s\u201c%3$s\u201d\u4e0d\u80fd\u76f4\u63a5\u8d4b\u503c\u7ed9%4$s", (String)"BatchRefBillFieldSetValue_0", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), request.getTargetFieldProp().getDisplayName().toString(), srcFldRefType.getDisplayName().toString(), bdDisplayValue, request.getTargetFieldProp().getDynamicComplexPropertyType().getDisplayName().toString()) : String.format(ResManager.loadKDString((String)"%1$s\u201c%2$s\u201d\u672a\u5206\u914d\u7ed9\u76ee\u6807\u7ec4\u7ec7\u201c%3$s\u201d\u4f7f\u7528", (String)"BatchRefBillFieldSetValue_1", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), request.getTargetFieldProp().getDynamicComplexPropertyType().getDisplayName().toString(), bdDisplayValue, orgDisplayValue);
        for (DynamicObject sourceRow : request.getSourceRows()) {
            this.buildReporter.addErrorReport(this.reportManager, this.linkEntityMap.getSrcFldPropertys(), sourceRow, failMessage);
            this.fail = true;
        }
    }
}

