/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.compiler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.property.BillTypeProp;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.orm.query.QFilter;
import kd.bos.service.botp.convert.SingleRuleContext;
import kd.bos.service.botp.convert.compiler.AbstractEntityMap;
import kd.bos.service.botp.convert.compiler.CRConditionCompiler;
import kd.bos.service.botp.convert.getvaluemode.IGetValueMode;
import kd.bos.service.botp.convert.group.SourceRowId;
import kd.bos.service.botp.convert.group.SourceRowsGroup;
import kd.bos.service.botp.convert.group.SourceRowsGroupKeyBuilder;
import kd.bos.service.botp.convert.mapping.IMappingField;
import kd.bos.service.botp.convert.mapping.IMappingLinkField;
import kd.bos.service.botp.convert.mapping.MappingCtrlField;
import kd.bos.service.botp.convert.mapping.MappingSBillId;
import kd.bos.service.botp.convert.mapping.MappingSId;
import kd.bos.service.botp.convert.mapping.MappingSTableId;
import kd.bos.service.botp.convert.var.IVariableMode;
import kd.bos.service.botp.convert.var.SourceFieldVariable;

public class LinkEntityMap
extends AbstractEntityMap {
    private String sourceLinkEntityKey;
    private String targetLinkEntityKey;
    private IGetValueMode srcMainOrgReader;
    private IGetValueMode srcBillTypeReader;
    private IMappingField mappingMainOrg;
    private IMappingField mappingBillType;
    private LinkEntryProp linkEntryProp;
    private MappingSTableId mappingSTableId;
    private MappingSBillId mappingSBillId;
    private MappingSId mappingSId;
    List<MappingCtrlField> mappingCtrlFields = new ArrayList<MappingCtrlField>();
    private String srcRowIdSelectString;

    public String getSourceLinkEntityKey() {
        return this.sourceLinkEntityKey;
    }

    public void setSourceLinkEntityKey(String sourceLinkEntityKey) {
        this.sourceLinkEntityKey = sourceLinkEntityKey;
    }

    public String getTargetLinkEntityKey() {
        return this.targetLinkEntityKey;
    }

    public void setTargetLinkEntityKey(String targetLinkEntityKey) {
        this.targetLinkEntityKey = targetLinkEntityKey;
    }

    public IGetValueMode getSrcMainOrgReader() {
        return this.srcMainOrgReader;
    }

    public void setSrcMainOrgReader(IGetValueMode srcMainOrgReader) {
        this.srcMainOrgReader = srcMainOrgReader;
    }

    public IGetValueMode getSrcBillTypeReader() {
        return this.srcBillTypeReader;
    }

    public void setSrcBillTypeReader(IGetValueMode srcBillTypeReader) {
        this.srcBillTypeReader = srcBillTypeReader;
    }

    public String getSrcRowIdSelectString() {
        return this.srcRowIdSelectString;
    }

    public IMappingField getMappingMainOrg() {
        return this.mappingMainOrg;
    }

    public IMappingField getMappingBillType() {
        return this.mappingBillType;
    }

    public LinkEntryProp getLinkEntryProp() {
        return this.linkEntryProp;
    }

    public void setLinkEntryProp(LinkEntryProp linkEntryProp) {
        this.linkEntryProp = linkEntryProp;
    }

    public MappingSTableId getMappingSTableId() {
        return this.mappingSTableId;
    }

    public void setMappingSTableId(MappingSTableId mappingSTableId) {
        this.mappingSTableId = mappingSTableId;
    }

    public MappingSBillId getMappingSBillId() {
        return this.mappingSBillId;
    }

    public void setMappingSBillId(MappingSBillId mappingSBillId) {
        this.mappingSBillId = mappingSBillId;
    }

    public MappingSId getMappingSId() {
        return this.mappingSId;
    }

    public void setMappingSId(MappingSId mappingSId) {
        this.mappingSId = mappingSId;
    }

    public List<MappingCtrlField> getMappingCtrlFields() {
        return this.mappingCtrlFields;
    }

    @Override
    public void addMappingField(IMappingField mappingField) {
        if (mappingField instanceof IMappingLinkField) {
            if (mappingField instanceof MappingSTableId) {
                this.mappingSTableId = (MappingSTableId)mappingField;
            } else if (mappingField instanceof MappingSBillId) {
                this.mappingSBillId = (MappingSBillId)mappingField;
            } else if (mappingField instanceof MappingSId) {
                this.mappingSId = (MappingSId)mappingField;
            } else {
                this.mappingCtrlFields.add((MappingCtrlField)mappingField);
            }
            for (SourceFieldVariable srcFieldVar : mappingField.getSrcFieldVars()) {
                this.addSourceField(srcFieldVar);
            }
        } else {
            if (mappingField.getTargetFieldProp() instanceof MainOrgProp) {
                this.mappingMainOrg = mappingField;
            } else if (mappingField.getTargetFieldProp() instanceof BillTypeProp) {
                this.mappingBillType = mappingField;
            }
            super.addMappingField(mappingField);
        }
    }

    @Override
    public void compileSelectString(SingleRuleContext ruleContext) {
        super.compileSelectString(ruleContext);
        this.compileRowIdSelectString(ruleContext);
    }

    private void compileRowIdSelectString(SingleRuleContext ruleContext) {
        String seqAlias;
        String alias;
        BillEntityType srcMainType = ruleContext.getContext().getSourceMainType();
        ArrayList<String> selectFldStrings = new ArrayList<String>(20);
        HashSet<String> selectFldAlias = new HashSet<String>(20);
        String pkPropName = srcMainType.getPrimaryKey().getName();
        selectFldStrings.add(pkPropName);
        selectFldAlias.add(pkPropName);
        if (StringUtils.isNotBlank((CharSequence)srcMainType.getBillNo()) && !selectFldAlias.contains(srcMainType.getBillNo())) {
            selectFldStrings.add(srcMainType.getBillNo());
            selectFldAlias.add(srcMainType.getBillNo());
        }
        if (StringUtils.isNotBlank((CharSequence)this.sourceEntryKey)) {
            String entryPKPropName = this.getSourceEntryPKFullName();
            alias = (String)this.srcFldAlias.get(entryPKPropName);
            selectFldStrings.add(entryPKPropName + " " + alias);
            selectFldAlias.add(alias);
            String string = this.getSourceEntrySeqFullName();
            if (srcMainType.findProperty(string) != null) {
                seqAlias = (String)this.srcFldAlias.get(string);
                selectFldStrings.add(string + " " + seqAlias);
                selectFldAlias.add(seqAlias);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.sourceSubEntryKey)) {
            String subEntryPKPropName = this.getSourceSubEntryPKFullName();
            alias = (String)this.srcFldAlias.get(subEntryPKPropName);
            selectFldStrings.add(subEntryPKPropName + " " + alias);
            selectFldAlias.add(alias);
            String string = this.sourceSubEntryKey + ".seq";
            if (srcMainType.findProperty(string) != null) {
                String string2 = this.getSourceSubEntrySeqFullName();
                seqAlias = (String)this.srcFldAlias.get(string2);
                selectFldStrings.add(string2 + " " + seqAlias);
                selectFldAlias.add(seqAlias);
            }
        }
        List<Object> vars = new ArrayList();
        if (!ruleContext.getRule().getFilterPolicy().getAdvCondition().booleanValue()) {
            CRConditionCompiler dataFilterCompiler = ruleContext.getRuleCompiler().getDataFilterCompiler();
            vars = dataFilterCompiler.getVars();
        } else {
            List<CRConditionCompiler> crConditionCompilers = ruleContext.getRuleCompiler().getDataFilterCompilers();
            for (CRConditionCompiler dataFilterCompiler : crConditionCompilers) {
                vars.addAll(dataFilterCompiler.getVars());
            }
        }
        for (IVariableMode iVariableMode : vars) {
            SourceFieldVariable srcField;
            String fldAlias;
            if (!(iVariableMode instanceof SourceFieldVariable) || selectFldAlias.contains(fldAlias = (String)this.srcFldAlias.get((srcField = (SourceFieldVariable)iVariableMode).getVar()))) continue;
            String selectFldString = srcField.getFullPropName() + " " + fldAlias;
            selectFldStrings.add(selectFldString);
            selectFldAlias.add(fldAlias);
        }
        for (SourceRowsGroupKeyBuilder sourceRowsGroupKeyBuilder : this.getSourceRowsGroupKeyBuilders()) {
            for (IVariableMode var : sourceRowsGroupKeyBuilder.getVars()) {
                SourceFieldVariable srcField;
                String fldAlias;
                if (!(var instanceof SourceFieldVariable) || selectFldAlias.contains(fldAlias = (String)this.srcFldAlias.get((srcField = (SourceFieldVariable)var).getVar()))) continue;
                String selectFldString = srcField.getFullPropName() + " " + fldAlias;
                selectFldStrings.add(selectFldString);
                selectFldAlias.add(fldAlias);
            }
        }
        this.srcRowIdSelectString = StringUtils.join((Object[])selectFldStrings.toArray(new Object[selectFldStrings.size()]), (String)",");
    }

    public void compileQFilter(SingleRuleContext ruleContext, List<ListSelectedRow> selectedRows) {
        Object paramValue = ruleContext.getContext().getInputArgs().getCustomParams().get("botp_pushByBill");
        boolean pushByBill = false;
        if (paramValue != null) {
            pushByBill = Boolean.parseBoolean(paramValue.toString());
        }
        Set<Object> pkValues = null;
        String pkPropName = "id";
        ListSelectedRow firstSelectedRow = selectedRows.get(0);
        if (!pushByBill && this.isGetRowBySubEntryId(firstSelectedRow)) {
            pkPropName = this.getSourceSubEntryPKFullName();
            pkValues = this.getSourceSubEntryPKValues(selectedRows);
        } else if (!pushByBill && this.isGetRowByEntryId(firstSelectedRow)) {
            pkPropName = this.getSourceEntryPKFullName();
            pkValues = this.getSourceEntryPKValues(selectedRows);
        } else {
            pkValues = this.getSourcePKValues(selectedRows);
        }
        if (!"id".equals(pkPropName)) {
            HashSet<Object> idSet = new HashSet<Object>(16);
            for (ListSelectedRow row : selectedRows) {
                idSet.add(row.getPrimaryKeyValue());
            }
            this.qFilters.add(new QFilter("id", "in", idSet));
        }
        this.qFilters.add(new QFilter(pkPropName, "in", pkValues));
    }

    public QFilter comileQFilter(SingleRuleContext ruleContext, SourceRowsGroup groupRoot) {
        String pkPropName = "id";
        HashSet<Object> pkValues = new HashSet<Object>();
        EntityType srcLinkEntity = (EntityType)ruleContext.getContext().getSourceMainType().getAllEntities().get(this.getSourceLinkEntityKey());
        if (srcLinkEntity instanceof SubEntryType) {
            pkPropName = this.getSourceSubEntryPKFullName();
            for (SourceRowId sourceRowId : groupRoot.getSourceRowIds()) {
                if (Long.compare((Long)sourceRowId.getSubEntryId(), 0L) == 0) continue;
                pkValues.add(sourceRowId.getSubEntryId());
            }
        } else if (srcLinkEntity instanceof EntryType) {
            pkPropName = this.getSourceEntryPKFullName();
            for (SourceRowId sourceRowId : groupRoot.getSourceRowIds()) {
                if (Long.compare((Long)sourceRowId.getEntryId(), 0L) == 0) continue;
                pkValues.add(sourceRowId.getEntryId());
            }
        }
        if (pkValues.isEmpty()) {
            pkPropName = "id";
            for (SourceRowId sourceRowId : groupRoot.getSourceRowIds()) {
                pkValues.add(sourceRowId.getBillId());
            }
        }
        QFilter ret = new QFilter(pkPropName, "in", pkValues);
        if (!"id".equals(pkPropName)) {
            HashSet<Object> idSet = new HashSet<Object>(16);
            for (SourceRowId sourceRowId : groupRoot.getSourceRowIds()) {
                idSet.add(sourceRowId.getBillId());
            }
            ret = new QFilter("id", "in", idSet).and(ret);
        }
        return ret;
    }

    public boolean isGetRowByEntryId(ListSelectedRow firstSelectedRow) {
        if (StringUtils.isBlank((CharSequence)this.sourceEntryKey)) {
            return false;
        }
        if (firstSelectedRow.getEntryPrimaryKeyValue() == null) {
            return false;
        }
        return this.sourceEntryKey.equals(firstSelectedRow.getEntryEntityKey());
    }

    public boolean isGetRowBySubEntryId(ListSelectedRow firstSelectedRow) {
        if (StringUtils.isBlank((CharSequence)this.sourceSubEntryKey)) {
            return false;
        }
        if (firstSelectedRow.getSubEntryPrimaryKeyValue() == null) {
            return false;
        }
        return this.sourceSubEntryKey.equals(firstSelectedRow.getSubEntryEntityKey());
    }

    private Set<Object> getSourcePKValues(List<ListSelectedRow> selectedRows) {
        HashSet<Object> pkValues = new HashSet<Object>(selectedRows.size());
        for (ListSelectedRow selectedRow : selectedRows) {
            Object pkValue = selectedRow.getPrimaryKeyValue();
            pkValues.add(pkValue);
        }
        return pkValues;
    }

    private Set<Object> getSourceEntryPKValues(List<ListSelectedRow> selectedRows) {
        HashSet<Object> pkValues = new HashSet<Object>(selectedRows.size());
        for (ListSelectedRow selectedRow : selectedRows) {
            Object pkValue = selectedRow.getEntryPrimaryKeyValue();
            pkValues.add(pkValue);
        }
        return pkValues;
    }

    private Set<Object> getSourceSubEntryPKValues(List<ListSelectedRow> selectedRows) {
        HashSet<Object> pkValues = new HashSet<Object>(selectedRows.size());
        for (ListSelectedRow selectedRow : selectedRows) {
            Object pkValue = selectedRow.getSubEntryPrimaryKeyValue();
            pkValues.add(pkValue);
        }
        return pkValues;
    }
}

