/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.func;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.DrawArgs;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.dataentity.ShardingHinter;
import kd.bos.orm.query.QFilter;
import kd.bos.service.botp.convert.func.AbstractBOTPFuncImpl;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.xdb.hint.ShardingHintContext;

public class GetSourceFldValue
extends AbstractBOTPFuncImpl {
    public BOSUDFunction getInstance(ExpressionContext context) {
        return new GetSourceFldValue(context);
    }

    public String getName() {
        return "GetSourceFldValue";
    }

    public GetSourceFldValue() {
    }

    public GetSourceFldValue(ExpressionContext context) {
        super(context);
    }

    public Object call(Object ... arg0) {
        String entityNumber = (String)arg0[0];
        String propertyName = (String)arg0[1];
        if (entityNumber == null || propertyName == null) {
            return null;
        }
        BFRowId rowId = this.findSourceRow(entityNumber);
        if (rowId == null) {
            return null;
        }
        return this.getFieldValue(entityNumber, rowId, propertyName);
    }

    private BFRowId findSourceRow(String sourceEntityNumber) {
        String linkEntryKey = this.getContext().getRule().getLinkEntityPolicy().getSourceEntryKey();
        EntityType linkEntryType = (EntityType)this.getContext().getSrcMainType().getAllEntities().get(linkEntryKey);
        String entryPKFieldName = "id";
        if (linkEntryType instanceof SubEntryType) {
            entryPKFieldName = linkEntryType.getParent().getName() + "." + linkEntryKey + ".id";
        } else if (linkEntryType instanceof EntryType) {
            entryPKFieldName = linkEntryType.getName() + ".id";
        }
        BFRowId bfRowId = null;
        if (this.getContext().getFldProperties().containsKey(entryPKFieldName)) {
            bfRowId = this.findSourceEntryRow(sourceEntityNumber, linkEntryKey, entryPKFieldName);
        }
        if (bfRowId == null) {
            bfRowId = this.findSourceBill(sourceEntityNumber);
        }
        return bfRowId;
    }

    private BFRowId findSourceEntryRow(String sourceEntityNumber, String linkEntryKey, String entryPKFieldName) {
        DynamicObject activeRow = this.getContext().getActiveRow();
        Long entryId = (Long)((DynamicProperty)this.getContext().getFldProperties().get(entryPKFieldName)).getValueFast((Object)activeRow);
        List<BFRowLinkUpNode> allLinkUpNodes = this.loadAllLinkUpNodeFromCache();
        if (allLinkUpNodes.isEmpty()) {
            return null;
        }
        TableDefine entryTable = this.loadTableDefineFromCache(this.getContext().getSrcMainType().getName(), linkEntryKey);
        Long entryTableId = entryTable.getTableId();
        ArrayList<BFRowLinkUpNode> linkUpNodes = new ArrayList<BFRowLinkUpNode>();
        for (BFRowLinkUpNode node : allLinkUpNodes) {
            if (Long.compare(node.getRowId().getEntryId(), entryId) != 0 || Long.compare(node.getRowId().getTableId(), entryTableId) != 0) continue;
            linkUpNodes.add(node);
        }
        if (linkUpNodes.isEmpty()) {
            return null;
        }
        TableDefine tableDefine = this.loadTableDefineFromCache(sourceEntityNumber, sourceEntityNumber);
        Long srcMainTableId = tableDefine.getTableId();
        ArrayList srcNodes = new ArrayList();
        for (BFRowLinkUpNode node : linkUpNodes) {
            srcNodes.addAll(node.findSourceNodes(srcMainTableId));
        }
        ArrayList<BFRowId> srcRowIds = new ArrayList<BFRowId>(srcNodes.size());
        for (BFRowLinkUpNode sNode : srcNodes) {
            srcRowIds.add(sNode.getRowId());
        }
        if (srcRowIds.isEmpty()) {
            return null;
        }
        return (BFRowId)srcRowIds.get(0);
    }

    private BFRowId findSourceBill(String sourceEntityNumber) {
        DynamicObject activeRow = this.getContext().getActiveRow();
        Long billId = (Long)((DynamicProperty)this.getContext().getFldProperties().get("id")).getValueFast((Object)activeRow);
        List<BFRowLinkUpNode> allLinkUpNodes = this.loadAllLinkUpNodeFromCache();
        if (allLinkUpNodes.isEmpty()) {
            return null;
        }
        TableDefine mainTable = this.loadTableDefineFromCache(this.getContext().getSrcMainType().getName(), this.getContext().getSrcMainType().getName());
        Long mainTableId = mainTable.getTableId();
        ArrayList<BFRowLinkUpNode> linkUpNodes = new ArrayList<BFRowLinkUpNode>();
        for (BFRowLinkUpNode node : allLinkUpNodes) {
            if (Long.compare(node.getRowId().getBillId(), billId) != 0 || Long.compare(node.getRowId().getMainTableId(), mainTableId) != 0) continue;
            linkUpNodes.add(node);
        }
        if (linkUpNodes.isEmpty()) {
            return null;
        }
        TableDefine tableDefine = this.loadTableDefineFromCache(sourceEntityNumber, sourceEntityNumber);
        Long srcMainTableId = tableDefine.getTableId();
        ArrayList srcNodes = new ArrayList();
        for (BFRowLinkUpNode node : linkUpNodes) {
            srcNodes.addAll(node.findSourceNodes(srcMainTableId));
        }
        ArrayList<BFRowId> srcRowIds = new ArrayList<BFRowId>(srcNodes.size());
        for (BFRowLinkUpNode sNode : srcNodes) {
            srcRowIds.add(sNode.getRowId());
        }
        if (srcRowIds.isEmpty()) {
            return null;
        }
        return (BFRowId)srcRowIds.get(0);
    }

    private Object getFieldValue(String entityNumber, BFRowId rowId, String propertyName) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (mainType == null) {
            return null;
        }
        Map<Long, Object> fldValues = this.loadSrcFieldValueFromCache(entityNumber, propertyName);
        if (fldValues.isEmpty()) {
            return null;
        }
        if (fldValues.containsKey(rowId.getEntryId())) {
            return fldValues.get(rowId.getEntryId());
        }
        if (fldValues.containsKey(rowId.getBillId())) {
            return fldValues.get(rowId.getBillId());
        }
        return null;
    }

    private List<BFRowLinkUpNode> loadAllLinkUpNodeFromCache() {
        String cacheKey = "GetSourceFldValue.SourceNodes";
        List cacheValue = (List)this.getContext().getLocalCache().getCacheVarValue(cacheKey);
        if (cacheValue != null) {
            return cacheValue;
        }
        List selectedRows = null;
        if (this.getContext().getConvertServiceArgs() instanceof PushArgs) {
            selectedRows = ((PushArgs)this.getContext().getConvertServiceArgs()).getSelectedRows();
        } else if (this.getContext().getConvertServiceArgs() instanceof DrawArgs) {
            selectedRows = ((DrawArgs)this.getContext().getConvertServiceArgs()).getSelectedRows();
        }
        if (selectedRows == null || selectedRows.isEmpty()) {
            return new ArrayList<BFRowLinkUpNode>();
        }
        HashSet<Long> srcIds = new HashSet<Long>(selectedRows.size());
        for (ListSelectedRow row : selectedRows) {
            srcIds.add((Long)row.getPrimaryKeyValue());
        }
        cacheValue = BFTrackerServiceHelper.loadLinkUpNodes((String)this.getContext().getSrcMainType().getName(), null, (Long[])srcIds.toArray(new Long[0]));
        this.getContext().getLocalCache().putCacheVarValue(cacheKey, (Object)cacheValue);
        return cacheValue;
    }

    private List<BFRowId> loadAllSrcRowIdsFromCache(String entityNumber) {
        List<BFRowLinkUpNode> allLinkUpNodes = this.loadAllLinkUpNodeFromCache();
        if (allLinkUpNodes.isEmpty()) {
            return new ArrayList<BFRowId>();
        }
        TableDefine tableDefine = this.loadTableDefineFromCache(entityNumber, entityNumber);
        Long srcMainTableId = tableDefine.getTableId();
        ArrayList srcNodes = new ArrayList();
        for (BFRowLinkUpNode node : allLinkUpNodes) {
            srcNodes.addAll(node.findSourceNodes(srcMainTableId));
        }
        ArrayList<BFRowId> srcRowIds = new ArrayList<BFRowId>(srcNodes.size());
        for (BFRowLinkUpNode sNode : srcNodes) {
            srcRowIds.add(sNode.getRowId());
        }
        return srcRowIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, Object> loadSrcFieldValueFromCache(String entityNumber, String propertyName) {
        String cacheKey = "GetSourceFldValue(" + entityNumber + "," + propertyName + ")";
        HashMap<Long, Object> cacheValue = (HashMap<Long, Object>)this.getContext().getLocalCache().getCacheVarValue(cacheKey);
        if (cacheValue != null) {
            return cacheValue;
        }
        cacheValue = new HashMap<Long, Object>();
        List<BFRowId> srcRowIds = this.loadAllSrcRowIdsFromCache(entityNumber);
        if (srcRowIds.isEmpty()) {
            return cacheValue;
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (mainType == null) {
            return cacheValue;
        }
        String fullPropName = this.buildFullPropName(mainType, propertyName);
        if (StringUtils.equalsIgnoreCase((CharSequence)"id", (CharSequence)fullPropName)) {
            for (BFRowId rowId : srcRowIds) {
                cacheValue.put(rowId.getEntryId(), rowId.getBillId());
            }
            this.getContext().getLocalCache().putCacheVarValue(cacheKey, cacheValue);
            return cacheValue;
        }
        ShardingHintContext ctx = null;
        QFilter[] filters = new QFilter[1];
        String selectFields = "";
        if (Long.compare(srcRowIds.get(0).getMainTableId(), srcRowIds.get(0).getTableId()) != 0) {
            TableDefine tableDefine = ConvertMetaServiceHelper.loadTableDefine((Long)srcRowIds.get(0).getTableId());
            String entryPKFieldName = this.buildFullPropName(mainType, tableDefine.getEntityKey() + ".id");
            if (StringUtils.equalsIgnoreCase((CharSequence)entryPKFieldName, (CharSequence)fullPropName)) {
                for (BFRowId rowId : srcRowIds) {
                    cacheValue.put(rowId.getEntryId(), rowId.getEntryId());
                }
                this.getContext().getLocalCache().putCacheVarValue(cacheKey, cacheValue);
                return cacheValue;
            }
            selectFields = "id," + (String)entryPKFieldName + " f0, ";
            HashSet<Long> entryIds = new HashSet<Long>(srcRowIds.size());
            for (BFRowId bFRowId : srcRowIds) {
                entryIds.add(bFRowId.getEntryId());
            }
            filters[0] = new QFilter(entryPKFieldName, "in", (Object)entryIds.toArray(new Long[0]));
            if (ShardingHinter.isSharding((String)mainType.getAlias())) {
                HashSet<Long> billIds = new HashSet<Long>(srcRowIds.size());
                for (BFRowId rowId : srcRowIds) {
                    billIds.add(rowId.getBillId());
                }
                ctx = ShardingHinter.tryHint((IDataEntityType)mainType, (Object[])billIds.toArray());
            }
        } else {
            selectFields = "id f0, ";
            HashSet<Long> billIds = new HashSet<Long>(srcRowIds.size());
            for (BFRowId rowId : srcRowIds) {
                billIds.add(rowId.getBillId());
            }
            filters[0] = new QFilter("id", "in", (Object)billIds.toArray(new Long[0]));
        }
        if (ctx != null) {
            ctx.set();
        }
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet("kd.bos.entity.function.GetSourceFldValue", entityNumber, selectFields + fullPropName + " f1", filters);){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long l = row.getLong("f0");
                if (cacheValue.containsKey(l)) continue;
                Object value = row.get("f1");
                if (value instanceof DynamicObject) {
                    value = ((DynamicObject)value).getPkValue();
                }
                cacheValue.put(l, value);
            }
        }
        finally {
            if (ctx != null) {
                ctx.close();
            }
        }
        this.getContext().getLocalCache().putCacheVarValue(cacheKey, cacheValue);
        return cacheValue;
    }

    private TableDefine loadTableDefineFromCache(String entityNumber, String entityKey) {
        TableDefine td;
        String cacheKey = "GetSourceFldValue.TableDefine";
        String tableDefineKey = entityNumber + "." + entityKey;
        HashMap<String, TableDefine> cacheValue = (HashMap<String, TableDefine>)this.getContext().getLocalCache().getCacheVarValue(cacheKey);
        if (cacheValue == null) {
            cacheValue = new HashMap<String, TableDefine>();
            this.getContext().getLocalCache().putCacheVarValue(cacheKey, cacheValue);
        }
        if ((td = (TableDefine)cacheValue.get(tableDefineKey)) != null) {
            return td;
        }
        TableDefine tableDefine = ConvertMetaServiceHelper.loadTableDefine((String)entityNumber, (String)entityKey);
        cacheValue.put(tableDefineKey, tableDefine);
        return tableDefine;
    }

    private String buildFullPropName(MainEntityType mainType, String propertyName) {
        String[] keys = propertyName.split("\\.");
        IDataEntityProperty property = mainType.findProperty(keys[0]);
        if (property == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5728\u5355\u636e\u3010%1$s\u3011\u4e0a\uff0c\u6ca1\u6709\u627e\u5230\u5c5e\u6027\u3010%2$s\u3011", (String)"GetSourceFldValue_0", (String)"bos-mservice-botp", (Object[])new Object[0]), mainType.getDisplayName().toString(), keys[0]));
        }
        String fullPropName = propertyName;
        for (IDataEntityType parent = property.getParent(); parent != null && !(parent instanceof MainEntityType); parent = parent.getParent()) {
            fullPropName = parent.getName() + "." + fullPropName;
        }
        return fullPropName;
    }
}

