/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.getvaluemode;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.service.botp.convert.SingleRuleContext;
import kd.bos.service.botp.convert.getvaluemode.GetFormulaValue;
import kd.bos.service.botp.convert.getvaluemode.Token;
import kd.bos.service.botp.convert.var.IVariableMode;

public class GetDynamicTextValue
extends GetFormulaValue {
    public GetDynamicTextValue(SingleRuleContext ruleContext, String dynamicText) {
        super(ruleContext, dynamicText);
    }

    @Override
    public String getValue(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow) {
        HashMap<String, Object> ctx = new HashMap<String, Object>(this.vars.size());
        for (IVariableMode var : this.vars) {
            ctx.put(var.getVar(), this.getSingleFieldValue(fldProperties, sourceRow, var));
        }
        return this.parse(ctx);
    }

    @Override
    public Object getValue(Map<String, String> fldAlias, Row row) {
        HashMap<String, Object> ctx = new HashMap<String, Object>(this.vars.size());
        for (IVariableMode var : this.vars) {
            ctx.put(var.getVar(), this.getSingleFieldValue(fldAlias, row, var));
        }
        return this.parse(ctx);
    }

    @Override
    protected void compileFormula(String formula) {
        this.formula = formula;
        String[] varStrings = this.extractVariables();
        BillEntityType mainEntityType = this.ruleContext.getContext().getSourceMainType();
        for (String varString : varStrings) {
            String[] keyItems = StringUtils.split((String)varString, (String)".");
            IVariableMode var = this.buildVarMode(mainEntityType, varString, keyItems);
            this.vars.add(var);
        }
    }

    private String[] extractVariables() {
        ArrayList<String> variables = new ArrayList<String>();
        int len = this.formula.length();
        Token token = Token.TEXT;
        for (int pos = 0; pos < len; ++pos) {
            if ((token = this.getCharToken(len, pos, token)) != Token.VARIABLE) continue;
            int endIndex = this.formula.indexOf(125, pos + 1);
            if (endIndex == -1) break;
            String variableName = this.formula.substring(pos + 1, endIndex);
            variables.add(variableName);
            pos = endIndex;
            token = Token.TEXT;
        }
        return variables.toArray(new String[variables.size()]);
    }

    private String parse(Map<String, Object> ctx) {
        int len = this.formula.length();
        StringBuilder sb = new StringBuilder(len + len / 2);
        Token token = Token.TEXT;
        block4: for (int pos = 0; pos < len; ++pos) {
            token = this.getCharToken(len, pos, token);
            switch (token) {
                case ESCAPE: {
                    sb.append('{');
                    token = Token.TEXT;
                    ++pos;
                    continue block4;
                }
                case VARIABLE: {
                    pos = this.appendVarValue(len, pos, sb, ctx);
                    token = Token.TEXT;
                    continue block4;
                }
                default: {
                    sb.append(this.formula.charAt(pos));
                }
            }
        }
        return sb.toString();
    }

    private int appendVarValue(int len, int pos, StringBuilder sb, Map<String, Object> ctx) {
        int endIndex = this.formula.indexOf(125, pos + 1);
        if (endIndex == -1) {
            sb.append(this.formula.substring(pos));
            return len + 1;
        }
        String variableName = this.formula.substring(pos + 1, endIndex);
        Object vName = ctx.get(variableName);
        if (vName != null) {
            String sValue = this.formatValue(vName);
            sb.append(sValue);
        } else {
            sb.append('{').append(variableName).append(']');
        }
        return endIndex;
    }

    private Token getCharToken(int len, int pos, Token t) {
        Token token = t;
        char c = this.formula.charAt(pos);
        if (c == '{') {
            boolean condition = pos + 1 < len && this.formula.charAt(pos + 1) == '{';
            token = condition ? Token.ESCAPE : Token.VARIABLE;
        }
        return token;
    }

    private String formatValue(Object variableValue) {
        String sValue;
        if (variableValue == null) {
            return "";
        }
        if (variableValue instanceof BigDecimal) {
            BigDecimal dValue = new BigDecimal(variableValue.toString());
            sValue = dValue.toString();
        } else {
            sValue = variableValue.toString();
        }
        return sValue;
    }
}

