/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.getvaluemode;

import java.util.List;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.FieldMapItem;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.service.botp.convert.SingleRuleContext;
import kd.bos.service.botp.convert.getvaluemode.AbstractGetValueMode;
import kd.bos.service.botp.convert.getvaluemode.GetConstValue;
import kd.bos.service.botp.convert.getvaluemode.GetFormulaValue;
import kd.bos.service.botp.convert.getvaluemode.GetSourceFieldValue;
import kd.bos.service.botp.convert.getvaluemode.GetValueByCondition;
import kd.bos.service.botp.convert.var.IVariableMode;

public interface IGetValueMode {
    public Object getValue(Map<String, DynamicProperty> var1, DynamicObject var2);

    public boolean batchPreCall(Map<String, DynamicProperty> var1, DynamicObject var2);

    public Object getValue(Map<String, String> var1, Row var2);

    public List<IVariableMode> getVars();

    public static IGetValueMode create(SingleRuleContext ruleContext, FieldMapItem fieldMapItem, DynamicProperty fieldProp) {
        AbstractGetValueMode valueMode = null;
        switch (fieldMapItem.getFieldConvertType()) {
            case SourceField: {
                if (StringUtils.isBlank((CharSequence)fieldMapItem.getSourceFieldKey())) {
                    valueMode = new GetConstValue(IFieldHandle.getFieldDefaultValue(null, (DynamicProperty)fieldProp));
                    break;
                }
                valueMode = new GetSourceFieldValue(ruleContext, fieldMapItem.getSourceFieldKey());
                break;
            }
            case Formula: {
                if (fieldMapItem.getFormula() == null || StringUtils.isBlank((CharSequence)fieldMapItem.getFormula().getExpression())) {
                    valueMode = new GetConstValue(IFieldHandle.getFieldDefaultValue(null, (DynamicProperty)fieldProp));
                    break;
                }
                valueMode = new GetFormulaValue(ruleContext, fieldMapItem.getFormula().getExpression());
                break;
            }
            case ByCondition: {
                if (fieldMapItem.getValByConditions() == null || fieldMapItem.getValByConditions().getItems().isEmpty()) {
                    valueMode = new GetConstValue(IFieldHandle.getFieldDefaultValue(null, (DynamicProperty)fieldProp));
                    break;
                }
                valueMode = new GetValueByCondition(ruleContext, fieldMapItem.getValByConditions(), IFieldHandle.getFieldDefaultValue(null, (DynamicProperty)fieldProp));
                break;
            }
            case CONSTANT: {
                if (fieldMapItem.getConstant() == null || StringUtils.isBlank((CharSequence)fieldMapItem.getConstant().getExpression())) {
                    valueMode = new GetConstValue(IFieldHandle.getFieldDefaultValue(null, (DynamicProperty)fieldProp));
                    break;
                }
                valueMode = new GetConstValue(fieldMapItem.getConstant().getExpression());
                break;
            }
            default: {
                valueMode = new GetConstValue(IFieldHandle.getFieldDefaultValue(null, (DynamicProperty)fieldProp));
            }
        }
        return valueMode;
    }
}

